'\"
'\" Copyright (c) 1998-2000 by Ajuba Solutions.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: javascript.n,v 1.1 2000/11/02 19:26:57 kuchler Exp $
'\" 
.so man.macros
.TH javascript n 1.0 JavaScript "HTML and Java Script Generation"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
::javascript \- Procedures to generate HTML and Java Script structures.
.SH SYNOPSIS
.BS
.sp
\fBjavascript::makeSelectorWidget\fR \fIid leftLabel leftValueList rightLabel rightValueList rightNameList length {minWidth 32}\fR
.sp
\fBjavascript::makeSubmitButton\fR \fIname value\fR
.sp
\fBjavascript::makeProtectedSubmitButton\fR \fIname value msg\fR
.sp
\fBjavascript::makeMasterButton\fR \fImaster value slaves boolean\fR
.sp
\fBjavascript::makeParentCheckbox\fR \fIparentName childName\fR
.sp
\fBjavascript::makeChildCheckbox\fR \fIparentName childName\fR
.BE
.SH DESCRIPTION
.PP
The \fB::javascript\fR package provides commands that generate HTML
and Java Script code.  These commands typically return an HTML string
as their result.  In particular, they do not output their result to
\fBstdout\fR.
.PP
.TP
\fBjavascript::makeSelectorWidget\fR \fIid leftLabel leftValueList
rightLabel rightValueList rightNameList length {minWidth 32}\fR
Construct HTML code to create a dual-multi-selection megawidget.  This
megawidget consists of two side-by-side multi-selection boxes
separated by a left arrow and a right arrow button.  The right arrow
button moves all items selected in the left box to the right box.  The
left arrow button moves all items selected in the right box to the
left box.  The id argument is the suffix of all HTML objects in this
megawidget.  The leftLabel argument is the text that appears above the
left selection box.  The leftValueList argument is the values of items
in the left selection box.  The leftNameList argument is the names to
appear in the left selection box.  The rightLabel argument is the text
that appears above the right selection box.  The rightValueList
argument is the values of items in the right selection box.  The
rightNameList argument is the names to appear in the right selection
box.  The length argument (optional) The number of elts to show before
adding a vertical scrollbar; it defaults to 8.  The minWidth argument
(optional) is the number of spaces to determin the minimum box width;
it defaults to 32.

.TP
\fBjavascript::\fR \fImakeSubmitButton\fR \fIname value\fR
Create an HTML submit button that resets a hidden field for each
registered multi-selection box.  The name argument is the name of the
HTML button object to create.  The value argument is the label of the
HTML button object to create.

.TP
\fBjavascript::makeProtectedSubmitButton\fR \fIname value msg\fR
Create an HTML submit button that prompts the user with a
continue/cancel shutdown warning before the form is submitted.  The
name argument is the name of the HTML button object to create.  The
value argument is the label of the HTML button object to create.  The
msg argument is the message to display when the button is pressed.

.TP
\fBjavascript::\fR \fImakeMasterButton\fR \fImaster value slavePattern
boolean\fR
Create an HTML button that sets it's slave checkboxs to the boolean
value.  The master argument is the name of the child's parent html
checkbox object.  The value argument is the value of the master.  The
slaves argument is the name of child html checkbox object to create.
The boolean argument is the java script boolean value that will be
given to all the slaves; it must be "true" or "false".

.TP
\fBjavascript::\fR \fImakeParentCheckbox\fR \fIparentName childName\fR
Create an HTML checkbox and tie its value to that of it's child
checkbox.  If the parent is unchecked, the child is automatically
unchecked.  The parentName argument is the name of parent html
checkbox object to create. The childName argument is the name of the
parent's child html checkbox object.

.TP
\fBjavascript::\fR \fImakeChildCheckbox\fR \fIparentName childName\fR
Create an HTML checkbox and tie its value to that of it's parent
checkbox.  If the child is checked, the parent is automatically
checked.  The parentName argument is the name of the child's parent
html checkbox object.  The childName argument is the name of child
html checkbox object to create.

.SH SEE ALSO
html ncgi

.SH KEYWORDS
javascript, html, checkbox, submitbutton, selectionbox
