'\"
'\" Copyright (c) 2001 by ActiveState Tool Corp.
'\" All rights reserved.
'\" 
'\" RCS: @(#) $Id: log.n,v 1.5 2002/03/01 05:28:28 andreas_kupries Exp $
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2000/03/06 21:34:53 ericm Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH log n 1.0.1 Log "Logging facility"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
::log \- Procedures to log messages of libraries and applications.
.SH SYNOPSIS
\fBpackage require Tcl 8\fR
.sp
\fBpackage require log ?1.0.1?\fR
.sp
\fB::log::levels\fR
.sp
\fB::log::lv2longform\fR \fIlevel\fR
.sp
\fB::log::lv2color\fR \fIlevel\fR
.sp
\fB::log::lv2priority\fR \fIlevel\fR
.sp
\fB::log::lv2cmd\fR \fIlevel\fR
.sp
\fB::log::lv2channel\fR \fIlevel\fR
.sp
\fB::log::lvCompare\fR \fIlevel1 level2\fR
.sp
\fB::log::lvSuppress\fR \fIlevel {suppress 1}\fR
.sp
\fB::log::lvSuppressLE\fR \fIlevel {suppress 1}\fR
.sp
\fB::log::lvIsSuppressed\fR \fIlevel\fR
.sp
\fB::log::lvCmd\fR \fIlevel cmd\fR
.sp
\fB::log::lvCmdForall\fR \fIcmd\fR
.sp
\fB::log::lvChannel\fR \fIlevel chan\fR
.sp
\fB::log::lvChannelForall\fR \fIchan\fR
.sp
\fB::log::lvColor\fR \fIlevel color\fR
.sp
\fB::log::lvColorForall\fR \fIcolor\fR
.sp
\fB::log::log\fR \fIlevel text\fR
.sp
\fB::log::logMsg\fR \fItext\fR
.sp
\fB::log::logError\fR \fItext\fR
.sp
\fB::log::Puts\fR \fIlevel text\fR
.sp
.BE
.SH DESCRIPTION
.PP
The \fB::log\fR package provides commands that allow libraries and
applications to selectively log information about their internal
operation and state.
.PP
To use the package just execute
.PP
.CS
 package require log
 log::log notice "Some message"
.CE
.PP
As can be seen above, each message given to the log facility is
associated with a \fIlevel\fR determining the importance of the
message. The user can then select which levels to log, what commands
to use for the logging of each level and the channel to write the
message to. In the following example the logging of all message with
level \fBdebug\fR is deactivated.
.PP
.CS
 package require log
 log::lvSupress debug
 log::log debug "Unseen message" ; # No output
.CE
.PP
By default all messages associated with an error-level
(\fBemergency\fR,\fBalert\fR, \fBcritical\fR, and \fBerror\fR) are
written to \fBstderr\fR. Messages with any other level are written to
\fBstdout\fR. In the following example the log module is reconfigured
to write \fBdebug\fR messages to \fBstderr\fR too.
.PP
.CS
 package require log
 log::lvChannel debug stderr
 log::log debug "Written to stderr"
.CE
.PP
Each message level is also associated with a command to use when
logging a message with that level. The behaviour above for example
relies on the fact that all message levels use by default the standard
command \fB::log::Puts\fR to log any message. In the following example
all messages of level \fBnotice\fR are given to the non-standard
command \fBtoText\fR for logging. This disables the channel setting for such
messages, assuming that \fBtoText\fR does not use it by itself.
.PP
.CS
 package require log
 log::lvCmd notice toText
 log::log notice "Handled by \"toText\""
.CE
.PP
Another database maintained by this facility is a map from message
levels to colors. The information in this database has \fBno\fR
influence on the behaviour of the module. It is merely provided as a
convenience and in anticipation of the usage of this facility in
\fBtk\fR-based application which may want to colorize message logs.
.SH API
.PP
The following commands are available:
.TP
\fB::log::levels\fR
Returns the names of all known levels, in alphabetical order.
.TP
\fB::log::lv2longform\fR \fIlevel\fR
Converts any unique abbreviation of a level name to the full level
name.
.TP
\fB::log::lv2color\fR \fIlevel\fR
Converts any level name including unique abbreviations to the
corresponding color.
.TP
\fB::log::lv2priority\fR \fIlevel\fR
Converts any level name including unique abbreviations to the
corresponding priority.
.TP
\fB::log::lv2cmd\fR \fIlevel\fR
Converts any level name including unique abbreviations to the command
prefix used to write messages with that level.
.TP
\fB::log::lv2channel\fR \fIlevel\fR
Converts any level name including unique abbreviations to the channel
used by \fB::log::Puts\fR to write messages with that level.
.TP
\fB::log::lvCompare\fR \fIlevel1 level2\fR
Compares two levels (including unique abbreviations) with respect to
their priority. This command can be used by the -command option of
lsort. The result is one of -1, 0 or 1 or an error. A result of -1
signals that level1 is of less priority than level2. 0 signals that
both levels have the same priority. 1 signals that level1 has higher
priority than level2.
.TP
\fB::log::lvSuppress\fR \fIlevel {suppress 1}\fR
(Un)suppresses the output of messages having the specified
level. Unique abbreviations for the level are allowed here too.
.TP
\fB::log::lvSuppressLE\fR \fIlevel {suppress 1}\fR
(Un)suppresses the output of messages having the specified level or
one of lesser priority. Unique abbreviations for the level are allowed
here too.
.TP
\fB::log::lvIsSuppressed\fR \fIlevel\fR
Asks the package whether the specified level is currently
suppressed. Unique abbreviations of level names are allowed.
.TP
\fB::log::lvCmd\fR \fIlevel cmd\fR
Defines for the specified level with which command to write the
messages having this level. Unique abbreviations of level names are
allowed. The command is actually a command prefix and this facility
will append 2 arguments before calling it, the level of the message
and the message itself, in this order.
.TP
\fB::log::lvCmdForall\fR \fIcmd\fR
Defines for all known levels with which command to write the messages
having this level. The command is actually a command prefix and this
facility will append 2 arguments before calling it, the level of the
message and the message itself, in this order.
.TP
\fB::log::lvChannel\fR \fIlevel chan\fR
Defines for the specified level into which channel \fB::log::Puts\fR
(the standard command) shall write the messages having this
level. Unique abbreviations of level names are allowed. The command is
actually a command prefix and this facility will append 2 arguments
before calling it, the level of the message and the message itself, in
this order.
.TP
\fB::log::lvChannelForall\fR \fIchan\fR
Defines for all known levels with which which channel
\fB::log::Puts\fR (the standard command) shall write the messages
having this level. The command is actually a command prefix and this
facility will append 2 arguments before calling it, the level of the
message and the message itself, in this order.
.TP
\fB::log::lvColor\fR \fIlevel color\fR
Defines for the specified level the color to return for it in a call
to \fB::log::lv2color\fR. Unique abbreviations of level names are
allowed.
.TP
\fB::log::lvColorForall\fR \fIcolor\fR
Defines for all known levels the color to return for it in a call to
\fB::log::lv2color\fR. Unique abbreviations of level names are
allowed.
.TP
\fB::log::log\fR \fIlevel text\fR
Log a message according to the specifications for commands, channels
and suppression. In other words: The command will do nothing if the
specified level is suppressed. If it is not suppressed the actual
logging is delegated to the specified command. If there is no command
specified for the level the message won't be logged. The standard
command \fB::log::Puts\fR will write the message to the channel
specified for the given level. If no channel is specified for the
level the message won't be logged. Unique abbreviations of level names
are allowed. Errors in the actual logging command are \fBnot\fR
caught, but propagated to the caller, as they may indicate
misconfigurations of the log facility or errors in the callers code
itself.
.TP
\fB::log::logMsg\fR \fItext\fR
Convenience wrapper around \fB::log::log\fR. Equivalent to
\fB::log::log info text\fR.
.TP
\fB::log::logError\fR \fItext\fR
Convenience wrapper around \fB::log::log\fR. Equivalent to
\fB::log::log error text\fR.
.TP
\fB::log::Puts\fR \fIlevel text\fR
The standard log command, it writes messages and their levels to
user-specified channels. Assumes that the suppression checks were done
by the caller. Expects full level names, abbreviations are \fBnot
allowed\fR.

.SH SEE ALSO
.SH KEYWORDS
log, log level, message level, message
