[comment {-*- tcl -*- doctools manpage}]
[manpage_begin doctools::changelog n 0.1]
[copyright {2003 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Documentation tools}]
[titledesc {Handle text in Emacs ChangeLog format}]
[require Tcl 8.2]
[require textutil]
[require doctools::changelog [opt 0.1]]
[description]

This package provides tcl commands which are able to process and
reformat text in the [file ChangeLog] format generated [syscmd emacs].

[section COMMANDS]


[list_begin definitions]

[call [cmd ::doctools::changelog::scan] [arg {text}]]

The command takes the [arg text], parses it under the assumption that
it contains a ChangeLog as generated by [syscmd emacs] and returns a
data structure describing this ChangeLog.

[nl]

This data structure is a list whose elements describe one entry in the
ChangeLog each. Each entry is a list of three elements describing date
of the entry, its author, and the comments made, in this order.  The
last element of each entry, the comments, is a list of sections. Each
section is described by two elements, a list of file names, and a
string containing the true comment associated with the files of the
section.


[call [cmd ::doctools::changelog::toDoctools] [arg {title module version entries}]]

This command converts the pre-parsed ChangeLog [arg entries] (as
generated by [cmd ::doctools::changelog::scan]) into a document in
[term doctools] format and returns it as the result of the command.

[nl]

The other three arguments supply information for the header of that
document which is not available from the changelog itself.


[call [cmd ::doctools::changelog::merge] [arg entries]...]

Each argument of the command is assumed to be a pre-parsed Changelog
as generated by [cmd ::doctools::changelog::scan]). The command merges
all of them into a single structure, collapsing multiple entries for
the same date and author into a single entry. The new structure is
returned as the result of the command.

[list_end]

[keywords changelog emacs doctools]
[manpage_end]
