
/*
 * bltPictureFormats.h --
 *
 * This module implements the various image format conversion routines for
 * picture in the BLT toolkit.
 *
 *	Copyright 2003-2004 George A Howlett.
 *
 *	Permission is hereby granted, free of charge, to any person
 *	obtaining a copy of this software and associated documentation
 *	files (the "Software"), to deal in the Software without
 *	restriction, including without limitation the rights to use,
 *	copy, modify, merge, publish, distribute, sublicense, and/or
 *	sell copies of the Software, and to permit persons to whom the
 *	Software is furnished to do so, subject to the following
 *	conditions:
 *
 *	The above copyright notice and this permission notice shall be
 *	included in all copies or substantial portions of the
 *	Software.
 *
 *	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 *	KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 *	WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 *	PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS
 *	OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 *	OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 *	OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 *	SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * The JPEG reader/writer is adapted from jdatasrc.c and jdatadst.c
 * in the Independent JPEG Group (version 6b) library distribution.
 *
 *	The authors make NO WARRANTY or representation, either express
 *	or implied, with respect to this software, its quality,
 *	accuracy, merchantability, or fitness for a particular
 *	purpose.  This software is provided "AS IS", and you, its
 *	user, assume the entire risk as to its quality and accuracy.
 *
 *	This software is copyright (C) 1991-1998, Thomas G. Lane.  All
 *	Rights Reserved except as specified below.
 *
 *	Permission is hereby granted to use, copy, modify, and
 *	distribute this software (or portions thereof) for any
 *	purpose, without fee, subject to these conditions: (1) If any
 *	part of the source code for this software is distributed, then
 *	this README file must be included, with this copyright and
 *	no-warranty notice unaltered; and any additions, deletions, or
 *	changes to the original files must be clearly indicated in
 *	accompanying documentation.  (2) If only executable code is
 *	distributed, then the accompanying documentation must state
 *	that "this software is based in part on the work of the
 *	Independent JPEG Group".  (3) Permission for use of this
 *	software is granted only if the user accepts full
 *	responsibility for any undesirable consequences; the authors
 *	accept NO LIABILITY for damages of any kind.
 *
 * The GIF reader is from converters/other/giftopnm.c in the netpbm
 * (version 10.19) distribution.
 *
 *	Copyright 1990, 1991, 1993, David Koblas.  (koblas@netcom.com)
 *	Permission to use, copy, modify, and distribute this software
 *	and its documentation for any purpose and without fee is
 *	hereby granted, provided that the above copyright notice
 *	appear in all copies and that both that copyright notice and
 *	this permission notice appear in supporting documentation.
 *	This software is provided "as is" without express or implied
 *	warranty.
 *
 */

#ifndef _BLT_IMAGE_FORMAT_H
#define _BLT_IMAGE_FORMAT_H

#define PICTURE_PROGRESSIVE	(1<<0)
#define PICTURE_NO_QUANTIZE	(1<<1)

typedef struct {
    Tcl_Obj *dataObjPtr;
    Tcl_Obj *fileObjPtr;
    Tcl_Obj *imageObjPtr;
    int quality;		/* Value 0..100 */
    int smoothing;		/* Value 0..100 */
    int compress;		/* Value 0..N */
    int flags;			/* Flag. */
    Pix32 bg;
} Blt_PictureExportSwitches;


typedef struct {
    Tcl_Obj *dataObjPtr;
    Tcl_Obj *fileObjPtr;
    Tcl_Obj *imageObjPtr;
    Pix32 bg, fg;		/* Colors for XBM image format. */
    int fast;
    int imageIndex;
} Blt_PictureImportSwitches;


#if HAVE_LIBJPEG

extern int Blt_IsJpg(Blt_DataSink srcData);

extern Blt_Picture Blt_JpgToPicture(Tcl_Interp *interp, char *fileName,
	Blt_DataSink srcData, Blt_PictureImportSwitches *switchesPtr);

extern int Blt_PictureToJpg(Tcl_Interp *interp, Blt_Picture picture, 
	Blt_DataSink destData, Blt_PictureExportSwitches *switchesPtr);

#endif /* HAVE_LIBJPEG */

#ifdef HAVE_LIBTIFF

extern int Blt_IsTif(Blt_DataSink srcData);

extern Blt_Picture Blt_TifToPicture(Tcl_Interp *interp, char *fileName,
	Blt_DataSink srcData);

extern int Blt_PictureToTif(Tcl_Interp *interp, Blt_Picture picture, 
	Blt_DataSink destData, int compression);

#endif /* HAVE_LIBTIFF */

#ifdef HAVE_LIBPNG

extern int Blt_IsPng(Blt_DataSink srcData);

extern Blt_Picture Blt_PngToPicture(Tcl_Interp *interp, char *fileName,
	Blt_DataSink srcData);

extern int Blt_PictureToPng(Tcl_Interp *interp, Blt_Picture picture, 
	Blt_DataSink destData);

#endif /* HAVE_LIBPNG */

#ifdef HAVE_LIBXPM

extern int Blt_IsXpm(Blt_DataSink srcData);

extern Blt_Picture Blt_XpmToPicture(Tcl_Interp *interp, char *fileName,
	Blt_DataSink srcData);

extern int Blt_PictureToXpm(Tcl_Interp *interp, Blt_Picture picture,
	Blt_DataSink destData, int quantize, Pix32 *bgColorPtr);

#endif /* HAVE_LIBXPM */

extern int Blt_IsGif(Blt_DataSink srcData);

extern Blt_Picture Blt_GifToPicture(Tcl_Interp *interp, char *fileName,
	Blt_DataSink srcData, int imageIndex);

extern int Blt_IsXbm(Blt_DataSink srcData);

extern Blt_Picture Blt_XbmToPicture(Tcl_Interp *interp, char *fileName,
	Blt_DataSink srcData, Pix32 *fgColorPtr, Pix32 *bgColorPtr);

extern int Blt_PictureToXbm(Tcl_Interp *interp, Blt_Picture picture,
	Blt_DataSink destData, Pix32 *bgColorPtr);

#endif /* _BLT_IMAGE_FORMAT_H */
