/*
 * Decompiled with CFR 0.152.
 */
package com.e4graph;

import com.e4graph.IncorrectVertexTypeException;
import com.e4graph.InvalidPositionException;
import com.e4graph.NoSuchNodeException;
import com.e4graph.NoSuchVertexException;
import com.e4graph.ParentIterator;
import com.e4graph.Storage;
import com.e4graph.StorageIsNotOpenException;
import com.e4graph.Value;
import com.e4graph.Vertex;
import com.e4graph.VertexIterator;

public final class Node {
    private static String version = Storage.version();
    public static final int INVALID = -1;
    public static final int IONONE = 0;
    public static final int IOAT = 1;
    public static final int IOFIRST = 2;
    public static final int IOLAST = 3;
    public static final int IOBEFORE = 4;
    public static final int IOAFTER = 5;
    private int nodeIndex;
    private int storageIndex;
    private int generation;

    private Node() {
        this.nodeIndex = -1;
        this.storageIndex = -1;
        this.generation = -1;
    }

    private Node(int n, int n2, int n3) {
        this.nodeIndex = n3;
        this.generation = n2;
        this.storageIndex = n;
    }

    public VertexIterator getIterator() {
        return new VertexIterator(this);
    }

    public VertexIterator getIterator(int n) {
        return new VertexIterator(this, n);
    }

    public VertexIterator getIterator(String string) {
        return new VertexIterator(this, string);
    }

    public VertexIterator getIterator(String string, int n) {
        return new VertexIterator(this, string, n);
    }

    public ParentIterator getParentIterator() {
        return new ParentIterator(this);
    }

    public int getIndex() {
        return this.nodeIndex;
    }

    public int getStorageIndex() {
        return this.storageIndex;
    }

    public int getGeneration() {
        return this.generation;
    }

    public boolean isValid() {
        if (this.nodeIndex == -1 || this.storageIndex == -1) {
            return false;
        }
        return this.isValid1(this.nodeIndex, this.storageIndex, this.generation);
    }

    private native boolean isValid1(int var1, int var2, int var3);

    public boolean equals(Node node) {
        return this.nodeIndex == node.nodeIndex && this.generation == node.generation && this.storageIndex == node.storageIndex;
    }

    public int vertexCount() {
        return this.vertexCount1(this.nodeIndex, this.storageIndex, this.generation);
    }

    private native int vertexCount1(int var1, int var2, int var3);

    public int vertexCountWithName(String string) {
        return this.vertexCountWithName1(this.nodeIndex, this.storageIndex, this.generation, string);
    }

    private native int vertexCountWithName1(int var1, int var2, int var3, String var4);

    public int vertexCountWithType(int n) {
        return this.vertexCountWithType1(this.nodeIndex, this.storageIndex, this.generation, n);
    }

    private native int vertexCountWithType1(int var1, int var2, int var3, int var4);

    public void setNthVertex(String string, int n, int n2) throws NoSuchVertexException {
        this.setIntNthVertex1(this.nodeIndex, this.storageIndex, this.generation, string, n, n2);
    }

    public void setNthVertex(String string, int n, double d) throws NoSuchVertexException {
        this.setDoubleNthVertex1(this.nodeIndex, this.storageIndex, this.generation, string, n, d);
    }

    public void setNthVertex(String string, int n, String string2) throws NoSuchVertexException {
        this.setStringNthVertex1(this.nodeIndex, this.storageIndex, this.generation, string, n, string2);
    }

    public void setNthVertex(String string, int n, byte[] byArray) throws NoSuchVertexException {
        this.setBytesNthVertex1(this.nodeIndex, this.storageIndex, this.generation, string, n, byArray);
    }

    public void setNthVertex(String string, int n, Node node) throws NoSuchVertexException {
        this.setNodeNthVertex1(this.nodeIndex, this.storageIndex, this.generation, string, n, node.nodeIndex, node.storageIndex, node.generation);
    }

    public Node setNthNode(String string, int n) throws NoSuchVertexException {
        return this.setNthNodeNode1(this.nodeIndex, this.storageIndex, this.generation, string, n);
    }

    private native void setIntNthVertex1(int var1, int var2, int var3, String var4, int var5, int var6) throws NoSuchVertexException;

    private native void setDoubleNthVertex1(int var1, int var2, int var3, String var4, int var5, double var6) throws NoSuchVertexException;

    private native void setStringNthVertex1(int var1, int var2, int var3, String var4, int var5, String var6) throws NoSuchVertexException;

    private native void setBytesNthVertex1(int var1, int var2, int var3, String var4, int var5, byte[] var6) throws NoSuchVertexException;

    private native void setNodeNthVertex1(int var1, int var2, int var3, String var4, int var5, int var6, int var7, int var8) throws NoSuchVertexException;

    private native Node setNthNodeNode1(int var1, int var2, int var3, String var4, int var5) throws NoSuchVertexException;

    public void setVertex(String string, int n) throws NoSuchVertexException {
        this.setNthVertex(string, 1, n);
    }

    public void setVertex(String string, double d) throws NoSuchVertexException {
        this.setNthVertex(string, 1, d);
    }

    public void setVertex(String string, String string2) throws NoSuchVertexException {
        this.setNthVertex(string, 1, string2);
    }

    public void setVertex(String string, byte[] byArray) throws NoSuchVertexException {
        this.setNthVertex(string, 1, byArray);
    }

    public void setVertex(String string, Node node) throws NoSuchVertexException {
        this.setNthVertex(string, 1, node);
    }

    public Node setNode(String string) throws NoSuchVertexException {
        return this.setNthNode(string, 1);
    }

    public void setVertexByRank(int n, int n2) throws NoSuchVertexException {
        this.setIntVertexByRank1(this.nodeIndex, this.storageIndex, this.generation, n, n2);
    }

    public void setVertexByRank(int n, double d) throws NoSuchVertexException {
        this.setDoubleVertexByRank1(this.nodeIndex, this.storageIndex, this.generation, n, d);
    }

    public void setVertexByRank(int n, String string) throws NoSuchVertexException {
        this.setStringVertexByRank1(this.nodeIndex, this.storageIndex, this.generation, n, string);
    }

    public void setVertexByRank(int n, byte[] byArray) throws NoSuchVertexException {
        this.setBytesVertexByRank1(this.nodeIndex, this.storageIndex, this.generation, n, byArray);
    }

    public void setVertexByRank(int n, Node node) throws NoSuchVertexException {
        this.setNodeVertexByRank1(this.nodeIndex, this.storageIndex, this.generation, n, node.nodeIndex, node.storageIndex, node.generation);
    }

    public Node setNodeByRank(int n) throws NoSuchVertexException {
        return this.setNodeByRankNode1(this.nodeIndex, this.storageIndex, this.generation, n);
    }

    private native void setIntVertexByRank1(int var1, int var2, int var3, int var4, int var5) throws NoSuchVertexException;

    private native void setDoubleVertexByRank1(int var1, int var2, int var3, int var4, double var5) throws NoSuchVertexException;

    private native void setStringVertexByRank1(int var1, int var2, int var3, int var4, String var5) throws NoSuchVertexException;

    private native void setBytesVertexByRank1(int var1, int var2, int var3, int var4, byte[] var5) throws NoSuchVertexException;

    private native void setNodeVertexByRank1(int var1, int var2, int var3, int var4, int var5, int var6, int var7) throws NoSuchVertexException;

    private native Node setNodeByRankNode1(int var1, int var2, int var3, int var4) throws NoSuchVertexException;

    public Vertex addVertex(String string, int n, int n2, Node node) throws InvalidPositionException {
        return this.addNodeVertex1(this.nodeIndex, this.storageIndex, this.generation, string, n, n2, node.nodeIndex, node.storageIndex, node.generation);
    }

    public Vertex addVertex(String string, int n, int n2, int n3) throws InvalidPositionException {
        return this.addIntVertex1(this.nodeIndex, this.storageIndex, this.generation, string, n, n2, n3);
    }

    public Vertex addVertex(String string, int n, int n2, double d) throws InvalidPositionException {
        return this.addDoubleVertex1(this.nodeIndex, this.storageIndex, this.generation, string, n, n2, d);
    }

    public Vertex addVertex(String string, int n, int n2, String string2) throws InvalidPositionException {
        return this.addStringVertex1(this.nodeIndex, this.storageIndex, this.generation, string, n, n2, string2);
    }

    public Vertex addVertex(String string, int n, int n2, byte[] byArray) throws InvalidPositionException {
        return this.addBytesVertex1(this.nodeIndex, this.storageIndex, this.generation, string, n, n2, byArray);
    }

    public Node addNode(String string, int n, int n2) throws InvalidPositionException {
        return this.addVertexNode1(this.nodeIndex, this.storageIndex, this.generation, string, n, n2);
    }

    private native Vertex addNodeVertex1(int var1, int var2, int var3, String var4, int var5, int var6, int var7, int var8, int var9) throws InvalidPositionException;

    private native Vertex addIntVertex1(int var1, int var2, int var3, String var4, int var5, int var6, int var7) throws InvalidPositionException;

    private native Vertex addDoubleVertex1(int var1, int var2, int var3, String var4, int var5, int var6, double var7) throws InvalidPositionException;

    private native Vertex addStringVertex1(int var1, int var2, int var3, String var4, int var5, int var6, String var7) throws InvalidPositionException;

    private native Vertex addBytesVertex1(int var1, int var2, int var3, String var4, int var5, int var6, byte[] var7) throws InvalidPositionException;

    private native Node addVertexNode1(int var1, int var2, int var3, String var4, int var5, int var6) throws InvalidPositionException;

    public void moveVertex(Vertex vertex, int n, int n2) throws InvalidPositionException {
        this.moveVertex1(this.nodeIndex, this.storageIndex, this.generation, vertex.getIndex(), vertex.getStorageIndex(), vertex.getGeneration(), n, n2);
    }

    private native void moveVertex1(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8) throws InvalidPositionException;

    public int getNthInt(String string, int n) throws NoSuchVertexException, IncorrectVertexTypeException {
        return this.getNthInt1(this.nodeIndex, this.storageIndex, this.generation, string, n);
    }

    public double getNthDouble(String string, int n) throws NoSuchVertexException, IncorrectVertexTypeException {
        return this.getNthDouble1(this.nodeIndex, this.storageIndex, this.generation, string, n);
    }

    public String getNthString(String string, int n) throws NoSuchVertexException, IncorrectVertexTypeException {
        return this.getNthString1(this.nodeIndex, this.storageIndex, this.generation, string, n);
    }

    public byte[] getNthBytes(String string, int n) throws NoSuchVertexException, IncorrectVertexTypeException {
        return this.getNthBytes1(this.nodeIndex, this.storageIndex, this.generation, string, n);
    }

    public Node getNthNode(String string, int n) throws NoSuchVertexException, IncorrectVertexTypeException {
        return this.getNthNode1(this.nodeIndex, this.storageIndex, this.generation, string, n);
    }

    public Value getNthValue(String string, int n) throws NoSuchVertexException, IncorrectVertexTypeException {
        return this.getNthValue1(this.nodeIndex, this.storageIndex, this.generation, string, n);
    }

    private native int getNthInt1(int var1, int var2, int var3, String var4, int var5) throws NoSuchVertexException, IncorrectVertexTypeException;

    private native double getNthDouble1(int var1, int var2, int var3, String var4, int var5) throws NoSuchVertexException, IncorrectVertexTypeException;

    private native String getNthString1(int var1, int var2, int var3, String var4, int var5) throws NoSuchVertexException, IncorrectVertexTypeException;

    private native byte[] getNthBytes1(int var1, int var2, int var3, String var4, int var5) throws NoSuchVertexException, IncorrectVertexTypeException;

    private native Node getNthNode1(int var1, int var2, int var3, String var4, int var5) throws NoSuchVertexException, IncorrectVertexTypeException;

    private native Value getNthValue1(int var1, int var2, int var3, String var4, int var5) throws NoSuchVertexException;

    public int getInt(String string) throws NoSuchVertexException, IncorrectVertexTypeException {
        return this.getNthInt(string, 1);
    }

    public double getDouble(String string) throws NoSuchVertexException, IncorrectVertexTypeException {
        return this.getNthDouble(string, 1);
    }

    public String getString(String string) throws NoSuchVertexException, IncorrectVertexTypeException {
        return this.getNthString(string, 1);
    }

    public byte[] getBytes(String string) throws NoSuchVertexException, IncorrectVertexTypeException {
        return this.getNthBytes(string, 1);
    }

    public Node getNode(String string) throws NoSuchVertexException, IncorrectVertexTypeException {
        return this.getNthNode(string, 1);
    }

    public Value getValue(String string) throws NoSuchVertexException, IncorrectVertexTypeException {
        return this.getNthValue(string, 1);
    }

    public int getIntByRank(int n) throws NoSuchVertexException, IncorrectVertexTypeException {
        return this.getIntByRank1(this.nodeIndex, this.storageIndex, this.generation, n);
    }

    public double getDoubleByRank(int n) throws NoSuchVertexException, IncorrectVertexTypeException {
        return this.getDoubleByRank1(this.nodeIndex, this.storageIndex, this.generation, n);
    }

    public String getStringByRank(int n) throws NoSuchVertexException, IncorrectVertexTypeException {
        return this.getStringByRank1(this.nodeIndex, this.storageIndex, this.generation, n);
    }

    public byte[] getBytesByRank(int n) throws NoSuchVertexException, IncorrectVertexTypeException {
        return this.getBytesByRank1(this.nodeIndex, this.storageIndex, this.generation, n);
    }

    public Node getNodeByRank(int n) throws NoSuchVertexException, IncorrectVertexTypeException {
        return this.getNodeByRank1(this.nodeIndex, this.storageIndex, this.generation, n);
    }

    public Value getValueByRank(int n) throws NoSuchVertexException, IncorrectVertexTypeException {
        return this.getValueByRank1(this.nodeIndex, this.storageIndex, this.generation, n);
    }

    private native int getIntByRank1(int var1, int var2, int var3, int var4) throws NoSuchVertexException, IncorrectVertexTypeException;

    private native double getDoubleByRank1(int var1, int var2, int var3, int var4) throws NoSuchVertexException, IncorrectVertexTypeException;

    private native String getStringByRank1(int var1, int var2, int var3, int var4) throws NoSuchVertexException, IncorrectVertexTypeException;

    private native byte[] getBytesByRank1(int var1, int var2, int var3, int var4) throws NoSuchVertexException, IncorrectVertexTypeException;

    private native Node getNodeByRank1(int var1, int var2, int var3, int var4) throws NoSuchVertexException, IncorrectVertexTypeException;

    private native Value getValueByRank1(int var1, int var2, int var3, int var4) throws NoSuchVertexException;

    public Vertex getVertex(String string, int n) throws NoSuchVertexException {
        return this.getVertex1(this.nodeIndex, this.storageIndex, this.generation, string, n);
    }

    public Vertex getVertex(String string) throws NoSuchVertexException {
        return this.getVertex(string, 1);
    }

    private native Vertex getVertex1(int var1, int var2, int var3, String var4, int var5) throws NoSuchVertexException;

    public Vertex getVertexByRank(int n) throws NoSuchVertexException {
        return this.getVertexByRank1(this.nodeIndex, this.storageIndex, this.generation, n);
    }

    private native Vertex getVertexByRank1(int var1, int var2, int var3, int var4) throws NoSuchVertexException;

    public int vertexType(String string, int n) throws NoSuchVertexException {
        return this.vertexType1(this.nodeIndex, this.storageIndex, this.generation, string, n);
    }

    public int vertexType(String string) throws NoSuchVertexException {
        return this.vertexType(string, 1);
    }

    private native int vertexType1(int var1, int var2, int var3, String var4, int var5) throws NoSuchVertexException;

    public int vertexTypeByRank(int n) throws NoSuchVertexException {
        return this.vertexTypeByRank1(this.nodeIndex, this.storageIndex, this.generation, n);
    }

    private native int vertexTypeByRank1(int var1, int var2, int var3, int var4) throws NoSuchVertexException;

    public String vertexName(int n) throws NoSuchVertexException {
        return this.vertexName1(this.nodeIndex, this.storageIndex, this.generation, n);
    }

    private native String vertexName1(int var1, int var2, int var3, int var4) throws NoSuchVertexException;

    public void renameVertex(int n, String string) throws NoSuchVertexException {
        this.renameVertex1(this.nodeIndex, this.storageIndex, this.generation, n, string);
    }

    private native void renameVertex1(int var1, int var2, int var3, int var4, String var5) throws NoSuchVertexException;

    public int vertexRank(String string) throws NoSuchVertexException {
        return this.vertexRank(string, 1);
    }

    public int vertexRank(String string, int n) throws NoSuchVertexException {
        return this.vertexRank1(this.nodeIndex, this.storageIndex, this.generation, string, n);
    }

    private native int vertexRank1(int var1, int var2, int var3, String var4, int var5) throws NoSuchVertexException;

    public boolean exists(String string) {
        return this.exists(string, 1);
    }

    public boolean exists(String string, int n) {
        return this.exists1(this.nodeIndex, this.storageIndex, this.generation, string, n);
    }

    private native boolean exists1(int var1, int var2, int var3, String var4, int var5);

    public Node parent(int n) throws NoSuchNodeException {
        return this.parent1(this.nodeIndex, this.storageIndex, this.generation, n);
    }

    public Node parent() throws NoSuchNodeException {
        return this.parent(1);
    }

    private native Node parent1(int var1, int var2, int var3, int var4) throws NoSuchNodeException;

    public int parentCount() {
        return this.parentCount1(this.nodeIndex, this.storageIndex, this.generation);
    }

    private native int parentCount1(int var1, int var2, int var3);

    public int occurrenceCount() {
        return this.occurrenceCount1(this.nodeIndex, this.storageIndex, this.generation);
    }

    private native int occurrenceCount1(int var1, int var2, int var3);

    public int occurrenceCount(Node node) {
        if (node == null) {
            return 0;
        }
        return this.nodeOccurrenceCount1(this.nodeIndex, this.storageIndex, this.generation, node.nodeIndex, node.storageIndex, node.generation);
    }

    private native int nodeOccurrenceCount1(int var1, int var2, int var3, int var4, int var5, int var6);

    public int parentRank(Node node) {
        if (node == null) {
            return -1;
        }
        return this.parentRank1(this.nodeIndex, this.storageIndex, this.generation, node.nodeIndex, node.storageIndex, node.generation);
    }

    private native int parentRank1(int var1, int var2, int var3, int var4, int var5, int var6);

    public int rankInParent() {
        return this.rankInParent(1);
    }

    public int rankInParent(int n) {
        return this.rankInParent1(this.nodeIndex, this.storageIndex, this.generation, n);
    }

    private native int rankInParent1(int var1, int var2, int var3, int var4);

    public String nameInParent() {
        return this.nameInParent(1);
    }

    public String nameInParent(int n) {
        return this.nameInParent1(this.nodeIndex, this.storageIndex, this.generation, n);
    }

    private native String nameInParent1(int var1, int var2, int var3, int var4);

    public boolean isRoot() {
        return this.isRoot1(this.nodeIndex, this.storageIndex, this.generation);
    }

    private native boolean isRoot1(int var1, int var2, int var3);

    public Node getRootNode() {
        return this.getRootNode1(this.nodeIndex, this.storageIndex, this.generation);
    }

    private native Node getRootNode1(int var1, int var2, int var3);

    public Storage getStorage() throws StorageIsNotOpenException {
        return Storage.getStorage(this.storageIndex, this.generation);
    }

    public void detach() {
        this.detach1(this.nodeIndex, this.storageIndex, this.generation);
    }

    private native void detach1(int var1, int var2, int var3);

    public boolean isDetached() {
        return this.isDetached1(this.nodeIndex, this.storageIndex, this.generation);
    }

    private native boolean isDetached1(int var1, int var2, int var3);

    public int getUserData() {
        return this.getUserData1(this.nodeIndex, this.storageIndex, this.generation);
    }

    private native int getUserData1(int var1, int var2, int var3);

    public void setUserData(int n) {
        this.setUserData1(this.nodeIndex, this.storageIndex, this.generation, n);
    }

    private native void setUserData1(int var1, int var2, int var3, int var4);
}

