/*
 * Decompiled with CFR 0.152.
 */
package com.e4graph;

import com.e4graph.IncorrectVertexTypeException;
import com.e4graph.InvalidPositionException;
import com.e4graph.NoSuchVertexException;
import com.e4graph.Node;
import com.e4graph.Storage;
import com.e4graph.StorageIsNotOpenException;
import com.e4graph.Value;

public final class Vertex {
    private static String version = Storage.version();
    public static final int INVALID = -1;
    public static final int ILLEGAL = -1;
    public static final int NODE = 0;
    public static final int INTEGER = 1;
    public static final int DOUBLE = 2;
    public static final int STRING = 3;
    public static final int BYTES = 4;
    private int vertexIndex;
    private int storageIndex;
    private int generation;

    public int getIndex() {
        return this.vertexIndex;
    }

    public int getStorageIndex() {
        return this.storageIndex;
    }

    public int getGeneration() {
        return this.generation;
    }

    private Vertex() {
        this.vertexIndex = -1;
        this.storageIndex = -1;
        this.generation = -1;
    }

    private Vertex(int n, int n2, int n3) {
        this.vertexIndex = n3;
        this.storageIndex = n;
        this.generation = n2;
    }

    public boolean isValid() {
        if (this.vertexIndex == -1 || this.storageIndex == -1) {
            return false;
        }
        return this.isValid1(this.vertexIndex, this.storageIndex, this.generation);
    }

    private native boolean isValid1(int var1, int var2, int var3);

    public int getInt() throws IncorrectVertexTypeException {
        return this.getInt1(this.vertexIndex, this.storageIndex, this.generation);
    }

    public double getDouble() throws IncorrectVertexTypeException {
        return this.getDouble1(this.vertexIndex, this.storageIndex, this.generation);
    }

    public String getString() throws IncorrectVertexTypeException {
        return this.getString1(this.vertexIndex, this.storageIndex, this.generation);
    }

    public byte[] getBytes() throws IncorrectVertexTypeException {
        return this.getBytes1(this.vertexIndex, this.storageIndex, this.generation);
    }

    public Node getNode() throws IncorrectVertexTypeException {
        return this.getNode1(this.vertexIndex, this.storageIndex, this.generation);
    }

    public Value getValue() throws IncorrectVertexTypeException {
        return this.getValue1(this.vertexIndex, this.storageIndex, this.generation);
    }

    private native int getInt1(int var1, int var2, int var3) throws IncorrectVertexTypeException;

    private native double getDouble1(int var1, int var2, int var3) throws IncorrectVertexTypeException;

    private native String getString1(int var1, int var2, int var3) throws IncorrectVertexTypeException;

    private native byte[] getBytes1(int var1, int var2, int var3) throws IncorrectVertexTypeException;

    private native Node getNode1(int var1, int var2, int var3) throws IncorrectVertexTypeException;

    private native Value getValue1(int var1, int var2, int var3);

    public void set(int n) {
        this.setInt1(this.vertexIndex, this.storageIndex, this.generation, n);
    }

    public void set(double d) {
        this.setDouble1(this.vertexIndex, this.storageIndex, this.generation, d);
    }

    public void set(String string) {
        this.setString1(this.vertexIndex, this.storageIndex, this.generation, string);
    }

    public void set(byte[] byArray) {
        this.setBytes1(this.vertexIndex, this.storageIndex, this.generation, byArray);
    }

    public void set(Node node) {
        this.setNode1(this.vertexIndex, this.storageIndex, this.generation, node.getIndex(), node.getStorageIndex(), node.getGeneration());
    }

    public Node setNode() {
        return this.setVertexNode1(this.vertexIndex, this.storageIndex, this.generation);
    }

    private native void setInt1(int var1, int var2, int var3, int var4);

    private native void setDouble1(int var1, int var2, int var3, double var4);

    private native void setString1(int var1, int var2, int var3, String var4);

    private native void setBytes1(int var1, int var2, int var3, byte[] var4);

    private native void setNode1(int var1, int var2, int var3, int var4, int var5, int var6);

    private native Node setVertexNode1(int var1, int var2, int var3);

    public int rank() {
        return this.rank1(this.vertexIndex, this.storageIndex, this.generation);
    }

    private native int rank1(int var1, int var2, int var3);

    public void detach() {
        this.detach1(this.vertexIndex, this.storageIndex, this.generation);
    }

    private native void detach1(int var1, int var2, int var3);

    public boolean isDetached() {
        return this.isDetached1(this.vertexIndex, this.storageIndex, this.generation);
    }

    private native boolean isDetached1(int var1, int var2, int var3);

    public int type() {
        return this.type1(this.vertexIndex, this.storageIndex, this.generation);
    }

    private native int type1(int var1, int var2, int var3);

    public String name() {
        return this.name1(this.vertexIndex, this.storageIndex, this.generation);
    }

    private native String name1(int var1, int var2, int var3);

    public String rename(String string) {
        return this.rename1(this.vertexIndex, this.storageIndex, this.generation, string);
    }

    private native String rename1(int var1, int var2, int var3, String var4);

    public Node getRootNode() {
        return this.getRootNode1(this.vertexIndex, this.storageIndex, this.generation);
    }

    private native Node getRootNode1(int var1, int var2, int var3);

    public Storage getStorage() throws StorageIsNotOpenException {
        return Storage.getStorage(this.storageIndex, this.generation);
    }

    public Node containingNode() {
        return this.containingNode1(this.vertexIndex, this.storageIndex, this.generation);
    }

    private native Node containingNode1(int var1, int var2, int var3);

    public void moveVertex(Vertex vertex, int n, int n2) throws InvalidPositionException {
        this.moveVertex1(this.vertexIndex, this.storageIndex, this.generation, vertex.vertexIndex, vertex.storageIndex, vertex.generation, n, n2);
    }

    private native void moveVertex1(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8) throws InvalidPositionException;

    public Vertex next(int n) throws NoSuchVertexException {
        return this.next1(this.vertexIndex, this.storageIndex, this.generation, n);
    }

    public Vertex prev(int n) throws NoSuchVertexException {
        return this.prev1(this.vertexIndex, this.storageIndex, this.generation, n);
    }

    private native Vertex next1(int var1, int var2, int var3, int var4) throws NoSuchVertexException;

    private native Vertex prev1(int var1, int var2, int var3, int var4) throws NoSuchVertexException;

    public int getUserData() {
        return this.getUserData1(this.vertexIndex, this.storageIndex, this.generation);
    }

    private native int getUserData1(int var1, int var2, int var3);

    public void setUserData(int n) {
        this.setUserData1(this.vertexIndex, this.storageIndex, this.generation, n);
    }

    private native void setUserData1(int var1, int var2, int var3, int var4);
}

