#!/bin/sh
#
# This shell script builds a distribution of e4Graph. It is mainly intended
# for use by the package maintainers (that's me! :)
#
# Run this with 'sh build_dist.sh' or simply 'build_dist.sh'
#
# Copyright (c) 2000-2001, JYL Software Inc.
# 
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
# 
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE, EVEN IF
# JYL SOFTWARE INC. IS MADE AWARE OF THE POSSIBILITY OF SUCH DAMAGE.

# E4GVERSION:
#
# The version of e4Graph we're distributing.

E4GVERSION=e4graph-1.0a8

# INSTALLCOMP:
#
# The directory where everything will be installed. Change it to where you
# want to install the products of building everything.

CURDIR=`pwd`
SRCCOMP=`(cd ../..; pwd)`
INSTALLCOMP=$SRCCOMP/install

# INSTALLDIST:
#
# The directory where we will build the e4Graph distribution.

SRCTREE=$SRCCOMP
INSTALLDIST=$SRCTREE/dist

# LOCALINSTALL:
#
# Where you built everything.

LOCALINSTALL=$SRCTREE/install

# BELOW THIS LINE you will probably not want to change things:

INCLUDES=$LOCALINSTALL/include
LIBS=$LOCALINSTALL/lib

E4GSRC=$SRCTREE/$E4GVERSION
E4GDIST=$INSTALLDIST/$E4GVERSION

# Ensure directory structure is set up:

/bin/rm -rf $E4GDIST
mkdir -p $E4GDIST/include $E4GDIST/lib $E4GDIST/docs

# Copy various things into the distribution:

cp $E4GSRC/changes $E4GSRC/Install $E4GSRC/readme \
   $E4GSRC/readme.html $E4GDIST
cp -r $E4GSRC/docs/* $E4GDIST/docs
cp $INCLUDES/e4graph.h $INCLUDES/t4graph.h $INCLUDES/t4graph_c.h \
   $INCLUDES/e4xml.h $INCLUDES/t4xml_c.h $E4GDIST/include
cd $E4GDIST/lib
cp $LIBS/libtxml.so.0.0.0 $LIBS/libtgraph.so.0.0.0 $LIBS/libe4xml.so.0.0.0 \
   $LIBS/libe4graph.so.0.0.0 .
if test -f $LIBS/libe4java.so.0.0.0 ; then
   cp $LIBS/libe4java.so.0.0.0 .
   cp $LIBS/e4java.jar .
   ln -s libe4java.so.0.0.0 libe4java.so
   ln -s libe4java.so.0.0.0 libe4java.so.0
fi
ln -s libtxml.so.0.0.0 libtxml.so
ln -s libtxml.so.0.0.0 libtxml.so.0
ln -s libtgraph.so.0.0.0 libtgraph.so
ln -s libtgraph.so.0.0.0 libtgraph.so.0
ln -s libe4xml.so.0.0.0 libe4xml.so
ln -s libe4xml.so.0.0.0 libe4xml.so.0
ln -s libe4graph.so.0.0.0 libe4graph.so
ln -s libe4graph.so.0.0.0 libe4graph.so.0
