tcltest::test 5.1.3-nan-1 { narrowing from float NaN to int produces 0 } {
    constant_expression T513nan1 {(int) Float.NaN == 0} {(int) -Float.NaN == 0}
} PASS

tcltest::test 5.1.3-nan-2 { narrowing from double NaN to int produces 0 } {
    constant_expression T513nan2 {(int) Double.NaN == 0} {(int) -Double.NaN == 0}
} PASS

tcltest::test 5.1.3-nan-3 { narrowing from float NaN to long produces 0 } {
    constant_expression T513nan3 {(long) Float.NaN == 0L} {(long) -Float.NaN == 0L}
} PASS

tcltest::test 5.1.3-nan-4 { narrowing from double NaN to long produces 0 } {
    constant_expression T513nan4 {(long) Double.NaN == 0L} {(long) -Double.NaN == 0L}
} PASS

tcltest::test 5.1.3-nan-5 { narrowing from double NaN to float produces NaN } {
    constant_expression T513nan5 {(float) Double.NaN != (float) Double.NaN}
} PASS

tcltest::test 5.1.3-dtf-1 { narrowing from double to float can overflow } {
    constant_expression T513dtf1 {(float) 1e100 == Float.POSITIVE_INFINITY}
} PASS

tcltest::test 5.1.3-dtf-2 { narrowing from double to float can underflow } {
    constant_expression T513dtf2 {(float) 1e-100 == 0.0f}
} PASS

tcltest::test 5.1.3-dtf-3 { narrowing from double to float rounds down if
        remainder < .5 } {
    constant_expression T513dtf3 {(float)(double)0x8000ff7ffffL == (float)0x8000ff00000L}
} PASS

tcltest::test 5.1.3-dtf-4 { narrowing from double to float rounds up if
        remainder > .5 } {
    constant_expression T513dtf4 {(float)(double)0x8000ff80001L == (float)0x80010000000L}
} PASS

tcltest::test 5.1.3-dtf-5 { narrowing from double to float rounds to lsb 0 if
        remainder == .5 } {
    constant_expression T513dtf5 {(float)(double)0x8000ff80000L == (float)0x80010000000L}
} PASS

tcltest::test 5.1.3-dtf-6 { narrowing from double to float rounds to lsb 0 if
        remainder == .5 } {
    constant_expression T513dtf6 {(float)(double)0x8000f080000L == (float)0x8000f000000L}
} PASS

tcltest::test 5.1.3-dtf-7 { narrowing from double to denorm float rounds to nearest } {
    constant_expression T513dtf7 \
            {(float)5.877475257357598E-39 == 5.877475e-39f} \
            {(float)5.8774752573576E-39 == 5.877476e-39f} \
            {(float)5.87747595800683E-39 == 5.877476e-39f} \
            {(float)5.877476658656061E-39 == 5.877476e-39f} \
            {(float)5.877476658656063E-39 == 5.877477e-39f}
} PASS

