[comment {-*- tcl -*- doctools manpage}]
[manpage_begin doctoc_api n 1.0]
[copyright {2003-2004 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Documentation tools}]
[titledesc {Specification of the Interface to ToC Formatting Engines}]
[description]
[para]

This document specifies version 1 of the interface an toc formatting
engine has to comply with to be usable by the package
[package doctools::toc].

The specification of the [term doctoc] format all toc formatting
engines have to process can be found in the companion document
[term doctoc_fmt].

[section API]

[subsection {EXPORTED COMMANDS}]

Each toc formatting engine has to provide a number of commands through
which objects created by the package [package doctools::toc] will upon
the functionality of the engine. These commands are described here.

[list_begin definitions]
[lst_item [emph {Management commands}]]

[list_begin definitions]

[call [cmd toc_numpasses]]

This command is called by a doctoc object immediately after it has
loaded the engine. No other command of the engine will be called
before it. It has to return the number of passes this engine requires
to fully process the input document. This value has to be an integer
number greater or equal to one.


[call [cmd toc_initialize]]

This command is called at the beginning of every conversion run, as
the first command of that run. Note that a run is not a pass, but may
consist of multiple passes. See [cmd toc_numpasses]. The command has
to initialize the general state of the toc formatting engine, beyond
the initialization done during the load.


[call [cmd toc_setup] [arg n]]

This command is called at the beginning of each pass over the input in
a run. Its argument is the number of the pass which has begun. Passes
are counted from [const 1] upward. The command has to set up the
internal state of the toc formatting engine for this particular pass.


[call [cmd toc_postprocess] [arg text]]

This command is called immediately after the last pass in a run. Its
argument is the result of the conversion generated by that pass. It is
provided to allow the engine to perform any global last-ditch
modifications of the generated document. The text returned by this
command will be the final result of the conversion.

[nl]

An engine for a format which requires no postprocessing can simply
return the argument without change.


[call [cmd toc_shutdown]]

This command is called at the end of every conversion run. It is the
last command called in a run. It has to clean up of all the
run-specific state in the toc formatting engine. After the call the
engine has to be in a state which allows the initiation of another run
without fear that information from the last run is leaked into this
new run.


[call [cmd toc_listvariables]]

This command is called by a doctoc object after it has loaded the
engine (after [cmd toc_numpasses]). It has to return a list containing
the names of the engine parameters provided by the engine. This list
can be empty.


[call [cmd toc_varset] [arg varname] [arg text]]

This command is called whenever the doctoc object wishes to set an
engine parameter to a particular value. The parameter to change is
specified by [arg varname], the value to set in [arg text].

[nl]

The command has to throw an error if an unknown [arg varname] is
used. Only the names returned by [cmd toc_listvariables] are
considered known.

[nl]

The values of all engine parameters have to persist between passes and
runs.

[list_end]
[nl]

[lst_item [emph {Formatting commands}]]

The commands listed in this section are responsible for the conversion
of the input into the wanted output.

Their names are the names of the associated markup command, with
prefix [const fmt_] added to them.

Not all markup commands have associated formatting commands. The two
exceptions are [cmd vset] and [cmd include]. These markup commands are
processed by the doctoc object itself.

[nl]

A detailed documentation of the markup commands can be found in the
companion document [term doctoc_fmt]. It is the formal specification
of the [term doctoc] format.

[nl]

[emph Note]: The formatting commands can expect that they are only
called in an order allowed by the format specification.


[list_begin definitions]

[call [cmd fmt_plain_text] [arg text]]

This command has no associated markup command. It is called for any
plain text encountered by the processor in the input. It has to
perform any special processing required for plain text. The text
returned as its result is added to the output. If no special
processing is required it has to simply return its argument without
change.


[call [cmd fmt_comment] [arg text]]

This command has to format the [arg text] as a comment and return the
formatted string. It has to return the empty string if the output
format has no way of formatting comments.


[call [cmd fmt_toc_begin] [arg text] [arg title]]

This command has to format the label [arg text] and the associated
[arg title] string as the start of the generated table of contents and
return the formatted string.


[call [cmd fmt_toc_end]]

This command has to generate the end of the generated table of contents and return
the formatted string.


[call [cmd fmt_division_start] [arg text] [opt [arg symfile]]]

This command has to open the beginning of a new section in the
generated table of contents and return the formatted string.

This opening may refer to another file, if supported by the format,
and specified through [arg symfile]. An possible application of this
would be to refer to a smaller table of contents just for the section.

The [arg text] argument is the title of the new section.


[call [cmd fmt_division_end]]

This command has to close a section in the generated table of contents
and return the formatted string.


[call [cmd fmt_item] [arg file] [arg text] [arg desc]]

This command has to format an individual toc element and return the
formatted string.

The document referenced by the element is specified through its
symbolic name [arg file], whereas the label to use for the link is
provided by [arg text].

Use the command [cmd dt_fmap] to convert the symbolic name to the
actual link.

It is described in section [sectref {IMPORTED ENVIRONMENT}].

The last argument, [arg desc], provides a short descriptive text for
the referenced document.

[list_end]
[list_end]

[para]


[subsection {IMPORTED ENVIRONMENT}]

The implementation of an toc formatting engine can make the
following assumptions about the environment it is executed in:

[list_begin enum]
[enum]

That it has full access to its own safe interpreter. In other words,
the engine cannot damage the other parts of the processor, nor can it
damage the filesystem.

[enum]

That the following commands are provided by the doctoc object
controlling the engine:

[list_begin definitions]
[lst_item {Doctools commands}]

[list_begin definitions]

[call [cmd dt_format]]

This command returns the name of the format currently executing.


[call [cmd dt_fmap] [arg symfname]]

This command returns the actual name to use in the output in place of
the symbolic filename [arg symfname]. It will return the unchanged
input if no mapping was found for [arg symfname].


[call [cmd dt_source] [arg file]]

This command allows the toc formatting engine to load additional tcl
code.

Only files which are either in the same directory as the file
containing the engine, or below it, can be loaded. Trying to load a
file outside of this directory causes an error.

[list_end]
[nl]


[lst_item {Expander commands}]

All of the commands below are methods of the expander object (without
the prefix [const ex_]) handling the current input. This gives the
engine limited access to the state of the expander.

Their arguments and results are described in the documentation for the
package [package expander].

[list_begin definitions]
[call [cmd ex_cappend]]
[call [cmd ex_cget]]
[call [cmd ex_cis]]
[call [cmd ex_cname]]
[call [cmd ex_cpop]]
[call [cmd ex_cpush]]
[call [cmd ex_cset]]
[call [cmd ex_lb]]
[call [cmd ex_rb]]
[list_end]
[nl]


[lst_item {Other commands}]

The file [file _toc_common.tcl] contains default implementations of
[cmd fmt_plaint_text] and all the [const toc_] commands listed in
section [sectref {EXPORTED COMMANDS}].

It resides in the subdirectory [file mpformats] containing all the
predefined formats. This means that all external formats (i.e. not
provided by the package [package doctools::toc]) cannot use it
immediately, but have to have a copy at their location.

[list_end]
[list_end]

[see_also doctoc_fmt doctoc]
[keywords markup {generic markup} toc {table of contents} TMML HTML nroff LaTeX]
[manpage_end]
