#!/bin/sh
# the next line restarts using wish \
	exec wish "$0" ${1+"$@"}

# pie.tcl
#
# Modified from original demo
#
# jeff at hobbs org
#
# RCS: @(#) $Id: pie.tcl,v 1.4 2005/07/12 23:17:07 hobbs Exp $
#

source [file join [file dirname [info script]] load.tcl]
eval destroy [winfo children .]
raise .

set p [pie .pie -label "My Revolving Budget"]
$p itemconfigure Welfare -value 3.004
$p itemconfigure Military -value 7.006
$p itemconfigure Transport -value 1.6 -explode 15
$p itemconfigure Parks -value 0.9
$p itemconfigure Schools -value 2
$p itemconfigure Debt -value 4 -explode 10

$p configure -angle 10 -origin 90 -shadow 10

frame .buttons
button .fast -text "Spin Faster" -command spin
button .slow -text "Spin Slower" -command stop
button .quit -text "Exit" -command exit

grid $p -sticky news
grid .buttons -sticky ew
pack .fast .slow .quit \
	-in .buttons -side left -fill both -expand 1 -padx 6 -pady 4
grid columnconfig . 0 -weight 1
grid rowconfigure . 0 -weight 1

proc spin {{w .pie} {delay 60}} {
    $w config -origin [expr {[$w cget -origin]+1}] 
    set ::SPIN [after $delay [info level 0]]
}

proc stop {} {
    if {[info exists ::SPIN]} { after cancel $::SPIN }
}

bind $p <ButtonPress-1> {
    array set ::vu::Priv "x %x y %y pieIn [expr {[winfo width %W]/1.8 > %x}]\
	    pieAngle [%W cget -angle] pieOrigin [%W cget -origin]"
}

bind $p <B1-Motion> {
    if {$::vu::Priv(pieIn)} {
	%W config -angle [expr {$::vu::Priv(pieAngle)+($::vu::Priv(y)-%y)/3}] \
		-origin [expr {($::vu::Priv(pieOrigin) + \
		(([winfo height %W]/2.2 > %y)?-1:1) \
		* ($::vu::Priv(x)-%x)/3) %% 360}]
    }
}
