# Commands covered:  ::dom::DOMimplementation parse
#
# This file contains a collection of tests for one or more of the 
# XercesSAXcommands.  Sourcing this file into Tcl runs the tests and
# generates output for errors.  No output means no errors were found.
#
# $Id: dom.test.tcl,v 1.2 2000/03/20 16:25:45 awb Exp $

package require tcldompro 1.1



# set ::tcltest::skip [list dom-2* dom-3* dom-4*]

if {[catch {package require xercessax 1.0}]} {
    catch {puts stderr "Cannot load xercessax 1.0 package"}
    return
}

set trivialXML "<?xml version='1.0' encoding='UTF-8'?><test a='abc'>xxx<? \
    Target Data?></test>"
set validatingXML {<?xml version='1.0'\
    encoding='UTF-8'?>\
    <!DOCTYPE test [\
    <!ELEMENT test (#PCDATA)>\
    <!ENTITY abc SYSTEM 'abc'>\
    <!ENTITY def PUBLIC 'def' 'xyz'>\
    ]><test>xxx&abc;zzz&def;</test>}

proc readUtfOrUnicode {name} {
    set f [open $name r]
    fconfigure $f -encoding binary
    set prefix [read $f 2]
    seek $f 0 start
    if {[string equal $prefix \u00ff\u00fe]} {
	fconfigure $f -encoding identity
    } else {
	fconfigure $f -encoding utf-8
    }
    set xml [read $f]
    close $f
    return $xml
}	

proc readBinary {name} {
    set f [open $name r]
    fconfigure $f -encoding binary
    set data [read $f]
    close $f
    return $data
}

proc makeUnicode {data} {
    return [encoding convertfrom identity [encoding convertto unicode $data]]
}
proc resetCallbacks {parser} {
    global valueList
    catch {unset valueList}
    foreach a [list \
	-elementstartcommand -elementendcommand \
	-characterdatacommand -processinginstructioncommand \
	-externalentitycommand -defaultcommand \
	-handlernamespace] {
	$parser configure $a {}
    }
}

proc genericCallback {args} {
    global valueList
    lappend valueList $args
}

proc entityResolver {args} {
    # puts stdout "entityResolver $args"
    return [string toupper [lindex $args 3]]
}

proc entityResolver2 {p1 args} {
    # puts stdout "entityResolver $args"
    return ${p1}[string toupper [lindex $args 3]]
}

proc cXMLResolver {name base publicId systemId} {
    set ext [file extension $systemId]
    if {$ext == ".mod" || $ext == ".dtd"} {
	set fname [file join . cXML $systemId]
	set fd [open $fname r]
	set stuff [read $fd]
	close $fd
	return $stuff
    }
    return ""
}

    set result [catch {::xercessax::createParser} parserHandle]
	list $result [string trimright $parserHandle "0123456789abcdef"]

puts stdout "1.1"

	$parserHandle configure -usedom 1
	$parserHandle parse $trivialXML
	set result [catch {$parserHandle cget -document} document]
	list $result [join [split [dom::DOMImplementation serialize \
	    $document] \n] {}]

puts stdout "2.1"

    $parserHandle reset
    $parserHandle configure -usedom 1 -validate 1 \
    	-externalentitycommand entityResolver
    $parserHandle parse $validatingXML
    set result [catch {$parserHandle cget -document} document]
    list $result [join [split [dom::DOMImplementation serialize \
	$document] \n] {}]

puts stdout "2.2"

    $parserHandle reset
    $parserHandle configure -usedom 1 -validate 1 -externalentitycommand \
    [list entityResolver2 prefix]
    $parserHandle parse $validatingXML
    set result [catch {$parserHandle cget -document} document]
    list $result [join [split [dom::DOMImplementation serialize \
	$document] \n] {}]

puts stdout "2.3"

    $parserHandle reset
    $parserHandle configure -usedom 1 -validate 1 -externalentitycommand \
    [list entityResolver2 prefix]
    $parserHandle parse $validatingXML
    set result [catch {$parserHandle cget -document} document]
    set docType [dom::document cget $document -doctype]
    list [dom::doctype cget $docType -nodeName] \
	    [dom::doctype cget $docType -systemId] \
	    [dom::doctype cget $docType -publicId]

puts stdout "3.1"

#
# It's not clear how to test for success here, short of 
# providing a way to generate canonical XML
# This is pretty much a test that parsing succeeds and that TclDomPro
# doesn't crash
#
    set totalResult {}
    resetCallbacks $parserHandle
    $parserHandle configure -validate 1 -externalentitycommand cXMLResolver \
	    -usedom 1 -ignorewhitespace 1
    foreach fname [glob cXML/*.xml] {
	set xml [readUtfOrUnicode $fname]
	$parserHandle reset
	set result [catch {$parserHandle parse $xml} err]
	if {$result == 0} {
	    set document [$parserHandle cget -document]
	    set xml2 [dom::DOMImplementation serialize $document]
	} else {
	    lappend totalResult [list $fname $err]
	}
    }
    set totalResult

puts stdout "3.2"

    set totalResult {}
    resetCallbacks $parserHandle
    set i [interp create]
    interp eval $i {
	package require xercessax 1.0
	package require tcldompro 1.1
	set slaveXML {<?xml version='1.0'\
	    encoding='UTF-8'?>\
	    <!DOCTYPE testsuite SYSTEM 'testsuite.dtd'>\
	    <testsuite><tests><flags></flags><eval>set x 3</eval></tests></testsuite>}
    	set iparserHandle [::xercessax::createParser]
    	package require tcltest
	namespace import ::tcltest::*
	# $iparserHandle configure -validate 1 -externalentitycommand cXMLResolver -usedom 1 -ignorewhitespace 1
	$iparserHandle configure -validate 1 -usedom 1 -ignorewhitespace 1
	set xml $slaveXML 
	$iparserHandle reset
	set result [catch {$iparserHandle parse $xml} err]
	if {$result == 0} {
	    set document [$iparserHandle cget -document]
	    set xml2 [dom::DOMImplementation serialize $document]
	    $iparserHandle free
	    list $err
	} else {
	    $iparserHandle free
	    list $err
	}
    }

puts stdout "1.1"


set locationXML [readUtfOrUnicode [file join . \
locationTest.xml]]

    resetCallbacks $parserHandle
    $parserHandle reset
    $parserHandle configure -validate 1 -usedom 1 -ignorewhitespace 1
    catch {$parserHandle parse $locationXML} err
    set doc [$parserHandle cget -document]
    set node1 [::dom::document cget $doc -documentElement]
    set node2 [::dom::node cget $node1 -firstChild]
    set node3 [::dom::node cget $node2 -nextSibling]
    set node4 [::dom::node cget $node3 -firstChild]

    set tag1 [::dom::node cget $node1 -nodeName]
    set line1 [::dom::node cget $node1 -startLine]
    set tag2 [::dom::node cget $node2 -nodeName]
    set line2 [::dom::node cget $node2 -startLine]
    set tag3 [::dom::node cget $node3 -nodeName]
    set line3 [::dom::node cget $node3 -startLine]
    set tag4 [::dom::node cget $node4 -nodeName]
    set line4 [::dom::node cget $node4 -startLine]
    list $tag1 $line1 $tag2 $line2 $tag3 $line3 $tag4 $line4

puts stdout "1.1"

    resetCallbacks $parserHandle
    $parserHandle reset
    $parserHandle configure -validate 1 -usedom 1 -ignorewhitespace 1
    $parserHandle parse $locationXML
    set doc [$parserHandle cget -document]
    set node1 [::dom::document cget $doc -documentElement]
    set node2 [::dom::node cget $node1 -firstChild]
    set node3 [::dom::node cget $node2 -nextSibling]
    set node4 [::dom::node cget $node3 -firstChild]

    set tag1 [::dom::node cget $node1 -nodeName]
    set line1 [::dom::node cget $node1 -endLine]
    set tag2 [::dom::node cget $node2 -nodeName]
    set line2 [::dom::node cget $node2 -endLine]
    set tag3 [::dom::node cget $node3 -nodeName]
    set line3 [::dom::node cget $node3 -endLine]
    set tag4 [::dom::node cget $node4 -nodeName]
    set line4 [::dom::node cget $node4 -endLine]
    list $tag1 $line1 $tag2 $line2 $tag3 $line3 $tag4 $line4

puts stdout "1.1"

    resetCallbacks $parserHandle
    $parserHandle reset
    $parserHandle configure -validate 1 -usedom 1 -ignorewhitespace 1
    $parserHandle parse $locationXML
    set doc [$parserHandle cget -document]
    set node1 [::dom::document cget $doc -documentElement]
    set node2 [::dom::node cget $node1 -firstChild]
    set node3 [::dom::node cget $node2 -nextSibling]
    set node4 [::dom::node cget $node3 -firstChild]

    set tag1 [::dom::node cget $node1 -nodeName]
    set line1 [::dom::node cget $node1 -startColumn]
    set tag2 [::dom::node cget $node2 -nodeName]
    set line2 [::dom::node cget $node2 -startColumn]
    set tag3 [::dom::node cget $node3 -nodeName]
    set line3 [::dom::node cget $node3 -startColumn]
    set tag4 [::dom::node cget $node4 -nodeName]
    set line4 [::dom::node cget $node4 -startColumn]
    list $tag1 $line1 $tag2 $line2 $tag3 $line3 $tag4 $line4

puts stdout "1.1"

    resetCallbacks $parserHandle
    $parserHandle reset
    $parserHandle configure -validate 1 -usedom 1 -ignorewhitespace 1
    $parserHandle parse $locationXML
    set doc [$parserHandle cget -document]
    set node1 [::dom::document cget $doc -documentElement]
    set node2 [::dom::node cget $node1 -firstChild]
    set node3 [::dom::node cget $node2 -nextSibling]
    set node4 [::dom::node cget $node3 -firstChild]

    set tag1 [::dom::node cget $node1 -nodeName]
    set line1 [::dom::node cget $node1 -endColumn]
    set tag2 [::dom::node cget $node2 -nodeName]
    set line2 [::dom::node cget $node2 -endColumn]
    set tag3 [::dom::node cget $node3 -nodeName]
    set line3 [::dom::node cget $node3 -endColumn]
    set tag4 [::dom::node cget $node4 -nodeName]
    set line4 [::dom::node cget $node4 -endColumn]
    list $tag1 $line1 $tag3 $line3

puts stdout "1.1"

    resetCallbacks $parserHandle
    $parserHandle reset
    $parserHandle configure -validate 1 -usedom 1 -ignorewhitespace 1
    $parserHandle parse $locationXML
    set doc [$parserHandle cget -document]
    set node1 [::dom::document cget $doc -documentElement]
    set node2 [::dom::node cget $node1 -firstChild]
    set node3 [::dom::node cget $node2 -nextSibling]
    set node4 [::dom::node cget $node3 -firstChild]

    set tag1 [::dom::node cget $node1 -nodeName]
    set value1 [::dom::node cget $node1 -startWidth]
    set tag2 [::dom::node cget $node2 -nodeName]
    set value2 [::dom::node cget $node2 -startWidth]
    set tag3 [::dom::node cget $node3 -nodeName]
    set value3 [::dom::node cget $node3 -startWidth]
    set tag4 [::dom::node cget $node4 -nodeName]
    set value4 [::dom::node cget $node4 -startWidth]
    list $tag1 $value1 $tag2 $value2 $tag3 $value3 $tag4 $value4

puts stdout "1.1"

    resetCallbacks $parserHandle
    $parserHandle reset
    $parserHandle configure -validate 1 -usedom 1 -ignorewhitespace 1
    $parserHandle parse $locationXML
    set doc [$parserHandle cget -document]
    set node1 [::dom::document cget $doc -documentElement]
    set node2 [::dom::node cget $node1 -firstChild]
    set node3 [::dom::node cget $node2 -nextSibling]
    set node4 [::dom::node cget $node3 -firstChild]

    set tag1 [::dom::node cget $node1 -nodeName]
    set value1 [::dom::node cget $node1 -endWidth]
    set tag2 [::dom::node cget $node2 -nodeName]
    set value2 [::dom::node cget $node2 -endWidth]
    set tag3 [::dom::node cget $node3 -nodeName]
    set value3 [::dom::node cget $node3 -endWidth]
    set tag4 [::dom::node cget $node4 -nodeName]
    set value4 [::dom::node cget $node4 -endWidth]
    list $tag1 $value1 $tag3 $value3

puts stdout "1.1"

    resetCallbacks $parserHandle
    $parserHandle reset
    $parserHandle configure -validate 1 -usedom 1 -ignorewhitespace 1
    $parserHandle parse $locationXML
    set doc [$parserHandle cget -document]
    set node1 [::dom::document cget $doc -documentElement]
    set node2 [::dom::node cget $node1 -firstChild]
    set node3 [::dom::node cget $node2 -nextSibling]
    set node4 [::dom::node cget $node3 -firstChild]

    set tag1 [::dom::node cget $node1 -nodeName]
    set line1 [::dom::node cget $node1 -startCloseLine]
    set tag2 [::dom::node cget $node2 -nodeName]
    set line2 [::dom::node cget $node2 -startCloseLine]
    set tag3 [::dom::node cget $node3 -nodeName]
    set line3 [::dom::node cget $node3 -startCloseLine]
    set tag4 [::dom::node cget $node4 -nodeName]
    set line4 [::dom::node cget $node4 -startCloseLine]
    list $tag1 $line1 $tag2 $line2 $tag3 $line3 $tag4 $line4

puts stdout "1.1"

    resetCallbacks $parserHandle
    $parserHandle reset
    $parserHandle configure -validate 1 -usedom 1 -ignorewhitespace 1
    $parserHandle parse $locationXML
    set doc [$parserHandle cget -document]
    set node1 [::dom::document cget $doc -documentElement]
    set node2 [::dom::node cget $node1 -firstChild]
    set node3 [::dom::node cget $node2 -nextSibling]
    set node4 [::dom::node cget $node3 -firstChild]

    set tag1 [::dom::node cget $node1 -nodeName]
    set line1 [::dom::node cget $node1 -startCloseColumn]
    set tag2 [::dom::node cget $node2 -nodeName]
    set line2 [::dom::node cget $node2 -startCloseColumn]
    set tag3 [::dom::node cget $node3 -nodeName]
    set line3 [::dom::node cget $node3 -startCloseColumn]
    set tag4 [::dom::node cget $node4 -nodeName]
    set line4 [::dom::node cget $node4 -startCloseColumn]
    list $tag1 $line1 $tag2 $line2 $tag3 $line3 $tag4 $line4

puts stdout "1.1"

    resetCallbacks $parserHandle
    $parserHandle reset
    $parserHandle configure -validate 1 -usedom 1 -ignorewhitespace 1
    $parserHandle parse $locationXML
    set doc [$parserHandle cget -document]
    set node1 [::dom::document cget $doc -documentElement]
    set node2 [::dom::node cget $node1 -firstChild]
    set node3 [::dom::node cget $node2 -nextSibling]
    set node4 [::dom::node cget $node3 -firstChild]

    set tag1 [::dom::node cget $node1 -nodeName]
    set line1 [::dom::node cget $node1 -endCloseLine]
    set tag2 [::dom::node cget $node2 -nodeName]
    set line2 [::dom::node cget $node2 -endCloseLine]
    set tag3 [::dom::node cget $node3 -nodeName]
    set line3 [::dom::node cget $node3 -endCloseLine]
    set tag4 [::dom::node cget $node4 -nodeName]
    set line4 [::dom::node cget $node4 -endCloseLine]
    list $tag1 $line1 $tag3 $line3

puts stdout "1.1"

    resetCallbacks $parserHandle
    $parserHandle reset
    $parserHandle configure -validate 1 -usedom 1 -ignorewhitespace 1
    $parserHandle parse $locationXML
    set doc [$parserHandle cget -document]
    set node1 [::dom::document cget $doc -documentElement]
    set node2 [::dom::node cget $node1 -firstChild]
    set node3 [::dom::node cget $node2 -nextSibling]
    set node4 [::dom::node cget $node3 -firstChild]

    set tag1 [::dom::node cget $node1 -nodeName]
    set line1 [::dom::node cget $node1 -endCloseColumn]
    set tag2 [::dom::node cget $node2 -nodeName]
    set line2 [::dom::node cget $node2 -endCloseColumn]
    set tag3 [::dom::node cget $node3 -nodeName]
    set line3 [::dom::node cget $node3 -endCloseColumn]
    set tag4 [::dom::node cget $node4 -nodeName]
    set line4 [::dom::node cget $node4 -endCloseColumn]
    list $tag1 $line1 $tag3 $line3

puts stdout "1.1"

$parserHandle free

return
