/*
 * AUTHOR: Andrew Lister <lister@bain.oz.au>
 *
 * Simple example of the draw cell, write cell routines
 */

#include "../../src/Matrix.h"
#include <Xm/Text.h>
#include <Xm/Form.h>
#include <stdio.h>
#if HAVE_XPM
#include <X11/xpm.h>
#include <X11/extensions/shape.h>
#else
#include "xbae.xbm"
#endif

#define ROWS 10000
#define COLUMNS 20
#define WIDTH 8

static char cells[ ROWS ][ COLUMNS ][ WIDTH ];
static Pixmap pixmap, mask;
static Widget text;
static int lastRow;

static void DrawCB(), WriteCB(), EnterCB(), LeaveCB();
static void LoadMatrix();

#ifdef HAVE_XPM
static Pixmap readPixmap();

static Pixmap
readPixmap(Widget w, const char *pixmapName)
{
    XpmAttributes attrib;
    XpmColorSymbol XpmTransparentColor[1] = {{ NULL, "None", 0 }};
    Pixel bg;
    
    
    if( pixmapName && strstr( (char *)pixmapName, ".xpm" ) != NULL )
    {
	XtVaGetValues(w, XmNbackground, &bg, NULL);

	XpmTransparentColor[0].pixel = bg;

	attrib.valuemask = XpmReturnPixels | XpmExactColors | XpmCloseness |
	    XpmColorSymbols;
	attrib.colorsymbols = XpmTransparentColor;
	attrib.numsymbols = 1;
	attrib.width = 0;
	attrib.height = 0;
	attrib.depth = DefaultDepthOfScreen( XtScreen(w) );
	attrib.visual = DefaultVisual( XtDisplay(w),
				       DefaultScreen(XtDisplay(w)) );
	attrib.colormap = XDefaultColormapOfScreen( XtScreen(w) );
	attrib.exactColors = 0;
	attrib.closeness = 40000;

	if( XpmReadFileToPixmap(
	    XtDisplay(w), XRootWindowOfScreen(XtScreen(w)),
	    (char *)pixmapName, &pixmap, &mask, &attrib ) != XpmSuccess )
	{
	    pixmap = XmUNSPECIFIED_PIXMAP;
	    mask = XmUNSPECIFIED_PIXMAP;
	}
	
	XpmFreeAttributes(&attrib);
    }
    return(pixmap);
    
}
#endif

static void
LoadMatrix()
{
    int i, j;

    printf( "Creating very large data array...." );
    fflush( stdout );

    for( i = 0; i < ROWS; i++ )
	for( j = 0; j < COLUMNS; j++ )
	    ( void )sprintf( cells[ i ][ j ], "%d %d", i, j );
    printf( "Done\n" );
}

static void
DrawCB( w, cd, cbs )
Widget w;
XtPointer cd;
XbaeMatrixDrawCellCallbackStruct *cbs;
{
    if( cbs->column == 0 )
    {
	/* Assign it a pixmap */
	cbs->type = XbaePixmap;
	cbs->pixmap = pixmap;
	cbs->mask = mask;

	/* Set height and width to that of the bitmap's to ensure correct
	   positioning and drawing */

/* 	This is no longer necessary as it is calculated on the fly */
/* 	cbs->height = xbae_height; */
/* 	cbs->width = xbae_width; */
    }
    else
    {
	cbs->type = XbaeString;
	cbs->string = cells[ cbs->row ][ cbs->column ];
    }
    return;
}

static void
WriteCB( w, cd, cbs )
Widget w;
XtPointer cd;
XbaeMatrixWriteCellCallbackStruct *cbs;
{
    char buf[ 128 ];
    
    if( cbs->column == 0 )
	strcpy( buf, "Cells containing Pixmaps cannot change" );
    else
    {
	if( strcmp( cells[ cbs->row ][ cbs->column ], cbs->string ) == 0 )
	    sprintf( buf, "No change made to cell [%d, %d]", cbs->row,
		     cbs->column );
	else
	{
	    sprintf( buf, "Changing value in [%d, %d] from %s to %s",
		     cbs->row, cbs->column, cells[ cbs->row ][ cbs->column ],
		     cbs->string );

	    strcpy( cells[ cbs->row ][ cbs->column ], cbs->string );
	}
    }
    XmTextSetString( text, buf );
}

static void
EnterCB( w, cd, cbs )
Widget w;
XtPointer cd;
XbaeMatrixEnterCellCallbackStruct *cbs;
{
    if( lastRow == cbs->row )
	return;

    if( lastRow >= 0 )
	XbaeMatrixDeselectRow( w, lastRow );

    XbaeMatrixSelectRow( w, cbs->row );

    lastRow = cbs->row;
}

static void
LeaveCB( w, cd, cbs )
Widget w;
XtPointer cd;
XbaeMatrixLeaveCellCallbackStruct *cbs;
{
}

int
main(argc, argv)
int argc;
char *argv[];
{
    Widget toplevel, mw, form;
    XtAppContext app;
    int i;
#ifdef USE_EDITRES
    extern void _XEditResCheckMessages();
#endif
    short widths[ COLUMNS ];
    char buf[ 128 ];

    LoadMatrix();
    
    toplevel = XtVaAppInitialize(&app, "Draw",
				 NULL, 0,
				 &argc, argv,
				 NULL,
				 NULL);
#ifdef USE_EDITRES
    XtAddEventHandler( toplevel, (EventMask)0, True,
                       _XEditResCheckMessages, NULL);
#endif

    for( i = 0; i < COLUMNS; i++ )
	widths[ i ] = WIDTH;
    
    form = XtVaCreateManagedWidget(
	"form", xmFormWidgetClass, toplevel,
	NULL );
    
    mw = XtVaCreateManagedWidget(
	"mw", xbaeMatrixWidgetClass, form,
	XmNrows, ROWS,
	XmNcolumns, COLUMNS,
	XmNcolumnWidths, widths,
	XmNvisibleRows, 8,
	XmNvisibleColumns, 10,
	NULL);
    XtAddCallback( mw, XmNdrawCellCallback, DrawCB, NULL );
    XtAddCallback( mw, XmNwriteCellCallback, WriteCB, NULL );
    XtAddCallback( mw, XmNenterCellCallback, EnterCB, NULL );
    XtAddCallback( mw, XmNleaveCellCallback, LeaveCB, NULL );

#ifdef HAVE_XPM
    pixmap = readPixmap(mw, "xbae.xpm");
#else    
    pixmap = XCreateBitmapFromData(
        XtDisplay( mw ), RootWindowOfScreen( XtScreen( mw ) ),
        ( char * )xbae_bits, xbae_width, xbae_height );
#endif

    sprintf( buf,
	     "A matrix widget with %d rows and %d columns - That's %d cells!",
	     ROWS, COLUMNS, ROWS * COLUMNS );
    
    text = XtVaCreateManagedWidget(
	"text", xmTextWidgetClass, form,
	XmNeditable, False,
	XmNcursorPositionVisible, False,
	XmNtopAttachment, XmATTACH_WIDGET,
	XmNtopWidget, mw,
	XmNleftAttachment, XmATTACH_FORM,
	XmNrightAttachment, XmATTACH_FORM,
	XmNbottomAttachment, XmATTACH_FORM,
	XmNvalue, buf,
	NULL );
	
    XtRealizeWidget(toplevel);
    XtAppMainLoop(app);
    
    /*NOTREACHED*/
    return 0;
}

