/*
** Support
**
**	A module containing miscellanous support functions to be
**	used from application programs.
**
** Copyright 1992, 1993, 1994 by Markku Savela and
**	Technical Research Centre of Finland
*/
#include <stdio.h>
#include <string.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xew/Basic.h>
#include <X11/Xew/Support.h>

/*
** Mapping from known content formats to the content class
*/
static struct FormatClass
    {
	XeContentFormat format;
	XeContentClass class;
    }
format_class[] =
    {
	{XeContentFormat_ISO2022,	XeContentClass_TEXT},
	{XeContentFormat_TIFF,		XeContentClass_RASTER},
	{XeContentFormat_JPEG,		XeContentClass_RASTER},
	{XeContentFormat_GIF,		XeContentClass_RASTER},
	{XeContentFormat_CGM,		XeContentClass_GEOMETRIC},
	{XeContentFormat_H261,		XeContentClass_VIDEO},
	{XeContentFormat_AUDIO,		XeContentClass_AUDIO},
	{XeContentFormat_ODIF,		XeContentClass_UNKNOWN},
	{XeContentFormat_MPEG,		XeContentClass_VIDEO},
	{XeContentFormat_PBM,		XeContentClass_RASTER},
/* Start of addition made by barberjd (Jim Barber) 15th March 1994 */
	{XeContentFormat_RLE,		XeContentClass_RASTER},
/* End of addition made by barberjd */
    };

/*
** XeFindContentClass
**	Return the major content class that supports the specified
**	content format.
*/
XeContentClass XeFindContentClass(format)
XeContentFormat format;
    {
	struct FormatClass *map = format_class;

	while (map < &format_class[XtNumber(format_class)])
		if (map->format == format)
			return map->class;
		else
			map += 1;
	return XeContentClass_UNKNOWN;
    }

/*
** XeFindContentFormat
**	An utility function that tries to guess the content format
**	and returns the XeContentFormat type guessed. A failure to
**	guess or any error results a value XeContentFormat_UNKNOWN
**	to be returned.
**
**	The current implementation only works for Raster Images.
**	(Enchance this later --msa)
**
**	This code is partially based on the similar stuff in 'xv' program.
*/
XeContentFormat XeFindContentFormat(name)
char *name;
    {
	unsigned char magicno[8];    /* first 8 bytes of file */
	FILE *f = fopen(name,"rb");

	if (f == NULL)
		return XeContentFormat_UNKNOWN;

	fread(magicno,8,1,f);
	fclose(f);
	if (strncmp((char *)magicno, "GIF87a", 6) == 0 ||
	    strncmp((char *)magicno, "GIF89a", 6) == 0)
		return XeContentFormat_GIF;

	if (magicno[0] == 0xff && magicno[1] == 0xd8 &&  magicno[2] == 0xff)
		return XeContentFormat_JPEG;
	if ((magicno[0]=='M' && magicno[1]=='M') ||
	    (magicno[0]=='I' && magicno[1]=='I'))
		return XeContentFormat_TIFF;
	if (strncmp((char *)magicno, ".snd", 4) == 0)
		return XeContentFormat_AUDIO;

	if (magicno[0] == 'P' && magicno[1] >= '1' && magicno[1] <= '6')
		return XeContentFormat_PBM;

	/* The following is just a very crude guess, find out if this really
	   works or invent a better .. --msa */
	if (magicno[0] == 0x0 && magicno[1] == 0x0 &&
	    magicno[2] == 0x1 && magicno[3] == 0xb3)
		return XeContentFormat_MPEG;
/* Start of addition made by barberjd (Jim Barber) 15th March 1994 */
	if (magicno[0] == 0x52 && magicno[1] == 0xcc) 
		return XeContentFormat_RLE;
/* End of addition made by barberjd */
	return XeContentFormat_UNKNOWN;
    }

