/*
** Copyright 1993-1995 by Markku Savela and
**	Technical Research Centre of Finland
*/

/*
** I have used Athena Text Widget as a source for useful code snippets
** in many places as a starting point.  --msa
*/

/*
** IM_XCIN
**	by defining a symbol IM_XCIN a support for one BIG5 Chinese input
**	server for X Window System is compiled in. This requires that
**	the client code (cli_xcin.o) from 'xcin' package is linked with
**	the client. The patch has been provided by You Shung-I
**	<daniel@info1.csie.nctu.edu.tw> and I have no way of testing it
**	properly. --msa
*/

/*
Copyright 1989 by the Massachusetts Institute of Technology,
Cambridge, Massachusetts.

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSpEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/


#include <stdio.h>
#if SYSV_INCLUDES
#	include <memory.h>

extern int atoi( /* No header for this in SYSV */
#if NeedFunctionPrototypes
		char *
#endif
		);

#endif
#if ANSI_INCLUDES
#	include <stddef.h>
#	include <stdlib.h>
#endif
#include <ctype.h>
#include <string.h>
#if ANSI_INCLUDES || SYSV_INCLUDES
#	include <limits.h>
#endif
/*
** If still undefined, "invent" missing constants as needed here
*/
#ifndef LONG_MAX
#define LONG_MAX (~((unsigned long)0L) >> 1)
#endif

#include <X11/Xlib.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xatom.h>
#include <X11/Xmu/Atoms.h>
#include <X11/Xmu/CharSet.h>
#include <X11/Xmu/StdSel.h>
#include <X11/Xew/XewInit.h>
#include <X11/Xew/TextEdP.h>
#include "TextLayout.h"
#include "TextImport.h"
#include "TextExport.h"

#define TEXT_SET_WIDTH(t) (int)\
	((t)->text.column_width > 0 ? (t)->text.column_width : (t)->core.width)

/*
** This is a slightly modified copy of the corresponding file from
** the Athena Widget Set.
*/
static char translations1[] =
"\
Ctrl<Key>A:	beginning-of-line() \n\
Ctrl<Key>B:	backward-character() \n\
Ctrl<Key>D:	delete-next-character() \n\
Ctrl<Key>E:	end-of-line() \n\
Ctrl<Key>F:	forward-character() \n\
Ctrl<Key>G:     multiply(Reset) \n\
Ctrl<Key>H:	delete-previous-character() \n\
Ctrl<Key>K:	kill-to-end-of-line() \n\
Ctrl<Key>L:	redraw-display() \n\
Ctrl<Key>M:	newline() \n\
Ctrl<Key>N:	next-line() \n\
Ctrl<Key>O:	newline-and-backup() \n\
Ctrl<Key>P:	previous-line() \n\
Ctrl<Key>T:     transpose-characters() \n\
Ctrl<Key>U:	multiply(4) \n\
Ctrl<Key>W:	kill-selection() \n\
Ctrl<Key>Y:	insert-selection(CUT_BUFFER1) \n\
", translations2[] = "\
Meta<Key>B:	backward-word() \n\
Meta<Key>F:	forward-word() \n\
Meta<Key>K:	kill-to-end-of-paragraph() \n\
Meta<Key>Y:	insert-selection(PRIMARY, CUT_BUFFER0) \n\
:Meta<Key>d:	delete-next-word() \n\
:Meta<Key>D:	kill-word() \n\
:Meta<Key>h:	delete-previous-word() \n\
:Meta<Key>H:	backward-kill-word() \n\
:Meta<Key>\\<:	beginning-of-file() \n\
:Meta<Key>\\>:	end-of-file() \n\
:Meta<Key>]:	forward-paragraph() \n\
:Meta<Key>[:	backward-paragraph() \n\
~Shift Meta<Key>Delete:		delete-previous-word() \n\
 Shift Meta<Key>Delete:		backward-kill-word() \n\
~Shift Meta<Key>BackSpace:	delete-previous-word() \n\
 Shift Meta<Key>BackSpace:	backward-kill-word() \n\
", translations3[] = "\
<Key>Right:	forward-character() \n\
<Key>Left:	backward-character() \n\
<Key>Down:	next-line() \n\
<Key>Up:	previous-line() \n\
<Key>Delete:	delete-previous-character() \n\
<Key>BackSpace:	delete-previous-character() \n\
<Key>Return:	newline() \n\
<Key>:		insert-char() \n\
<FocusIn>:	focus-in() \n\
<FocusOut>:	focus-out() \n\
<Reparent>:	reparent-notify() \n\
<Configure>:	configure-notify() \n\
<Btn1Down>:	select-start() \n\
<Btn1Motion>:	extend-adjust() \n\
<Btn1Up>:	extend-end(PRIMARY, CUT_BUFFER0) \n\
<Btn2Down>:	insert-selection(PRIMARY, CUT_BUFFER0) \n\
<Btn3Down>:	extend-start() \n\
<Btn3Motion>:	extend-adjust() \n\
<Btn3Up>:	extend-end(PRIMARY, CUT_BUFFER0) \
";

/*
** The default actions follow mostly the Athena Text Widget model
*/
static void
	MoveToPointer(), MoveForwardChar(), MoveBackwardChar(),
	MoveForwardWord(), MoveBackwardWord(), MoveForwardParagraph(),
	MoveBackwardParagraph(), MoveToLineStart(), MoveToLineEnd(),
	MoveNextLine(),MovePreviousLine(), MoveBeginningOfFile(),
	MoveEndOfFile(), DeleteForwardChar(),
	DeleteBackwardChar(), DeleteForwardWord(), DeleteBackwardWord(),
	DeleteCurrentSelection(), KillForwardWord(), KillBackwardWord(),
	KillCurrentSelection(), KillToEndOfLine(), KillToEndOfParagraph(),
	InsertNewLineAndBackup(), InsertNewLine(),
	SelectWord(), SelectAll(), SelectStart(), SelectAdjust(), SelectEnd(),
	ExtendStart(), ExtendAdjust(), ExtendEnd(),
	InsertSelection(), RedrawDisplay(),
	InsertChar(), InsertString(), TextFocusIn(), TextFocusOut(),
	TextReparented(), TextConfigured(),
	DisplayCaret(), Multiply(), TransposeCharacters(),
	NoOp();

static XtActionsRec actions[] =
    {
	/* motion bindings */
	{"pointer",		MoveToPointer},
	{"forward-character",	MoveForwardChar},
	{"backward-character",	MoveBackwardChar},
	{"forward-word", 	MoveForwardWord},
	{"backward-word", 	MoveBackwardWord},
	{"forward-paragraph", 	MoveForwardParagraph},
	{"backward-paragraph", 	MoveBackwardParagraph},
	{"beginning-of-line", 	MoveToLineStart},
	{"end-of-line", 	MoveToLineEnd},
	{"next-line", 		MoveNextLine},
	{"previous-line", 	MovePreviousLine},
	{"beginning-of-file", 	MoveBeginningOfFile},
	{"end-of-file", 	MoveEndOfFile},
	/* delete bindings */
	{"delete-next-character", DeleteForwardChar},
	{"delete-previous-character", DeleteBackwardChar},
	{"delete-next-word", 	DeleteForwardWord},
	{"delete-previous-word", DeleteBackwardWord},
	{"delete-selection",	DeleteCurrentSelection},
	/* kill bindings */
	{"kill-word", 		KillForwardWord},
	{"backward-kill-word", 	KillBackwardWord},
	{"kill-selection", 	KillCurrentSelection},
	{"kill-to-end-of-line", KillToEndOfLine},
	{"kill-to-end-of-paragraph", KillToEndOfParagraph},
	/* new line stuff */
	{"newline-and-backup", 	InsertNewLineAndBackup},
	{"newline", 		InsertNewLine},
	/* Selection stuff */
	{"select-word", 	SelectWord},
	{"select-all", 		SelectAll},
	{"select-start", 	SelectStart},
	{"select-adjust", 	SelectAdjust},
	{"select-end", 		SelectEnd},
	{"extend-start", 	ExtendStart},
	{"extend-adjust", 	ExtendAdjust},
	{"extend-end", 		ExtendEnd},
	{"insert-selection",	InsertSelection},
	/* Miscellaneous */
	{"redraw-display", 	RedrawDisplay},
	{"insert-char", 	InsertChar},
	{"insert-string",	InsertString},
	{"focus-in", 	 	TextFocusIn},
	{"focus-out", 		TextFocusOut},
	{"reparent-notify",	TextReparented},
	{"configure-notify",	TextConfigured},
	{"display-caret",	DisplayCaret},
	{"multiply",		Multiply},
	{"transpose-characters",TransposeCharacters},
	{"no-op",               NoOp},
    };

#define offset(field) XtOffsetOf(XeTextEdRec, texted.field)

static XtResource resources[] =
    {
	{XtNallowEdit, XtCAllowEdit, XtRBoolean, sizeof(Boolean),
	     offset(allow_edit), XtRImmediate, (XtPointer)True},
	{XtNcursorPosition, XtCCursorPosition, XtRLong, sizeof(long),
	     offset(cursor_position), XtRImmediate, (XtPointer)0},
	{XtNdisplayCaret, XtCOutput, XtRBoolean, sizeof(Boolean),
	     offset(display_caret), XtRImmediate, (XtPointer)True},
	{XtNmodifyCallback, XtCModifyCallback, XtRCallback, sizeof(XtPointer),
		 offset(modify_callbacks), XtRCallback, (XtPointer)NULL},
    };
#undef offset

static void ClassPartInitialize(), ClassInitialize();
static void Initialize(), Destroy(), Resize(), Redisplay(), InsertChild();
static Boolean SetValues(), FrameSetValues();

#ifdef USING_MOTIF_122
static XmNavigability WidgetNavigable() ;

/*******************************************/
/*  Declaration of class extension records */

XmBaseClassExtRec _XeTextEdbaseClassExtRec = {
    NULL,
    NULLQUARK,
    XmBaseClassExtVersion,
    sizeof(XmBaseClassExtRec),
    NULL,				/* InitializePrehook	*/
    NULL,				/* SetValuesPrehook	*/
    NULL,				/* InitializePosthook	*/
    NULL,				/* SetValuesPosthook	*/
    NULL,				/* secondaryObjectClass	*/
    NULL,				/* secondaryCreate	*/
    NULL,		                /* getSecRes data	*/
    { 0 },				/* fastSubclass flags	*/
    NULL,				/* get_values_prehook	*/
    NULL,				/* get_values_posthook	*/
    NULL,                               /* classPartInitPrehook */
    NULL,                               /* classPartInitPosthook*/
    NULL,                               /* ext_resources        */
    NULL,                               /* compiled_ext_resources*/
    0,                                  /* num_ext_resources    */
    FALSE,                              /* use_sub_resources    */
    WidgetNavigable,                    /* widgetNavigable      */
    NULL,                               /* focusChange          */
};
#endif

#define superclass	(&xeTextClassRec)

XeTextEdClassRec xeTextEdClassRec = {
  { /* core fields */
    /* superclass		*/	(WidgetClass) superclass,
    /* class_name		*/	"XeTextEd",
    /* widget_size		*/	sizeof(XeTextEdRec),
    /* class_initialize		*/	ClassInitialize,
    /* class_part_initialize	*/	ClassPartInitialize,
    /* class_inited		*/	FALSE,
    /* initialize		*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize			*/	XtInheritRealize,
    /* actions			*/	actions,
    /* num_actions		*/	XtNumber(actions),
    /* resources		*/	resources,
    /* num_resources		*/	XtNumber(resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	XtExposeCompressMultiple,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	Destroy,
    /* resize			*/	Resize,
    /* expose			*/	Redisplay,
    /* set_values		*/	SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	NULL,
    /* query_geometry		*/	XtInheritQueryGeometry,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
#ifdef USING_MOTIF_122
    /* extension		*/	(XtPointer)&_XeTextEdbaseClassExtRec,
#else
    /* extension		*/	NULL,
#endif
  },
  { /* composite class fields */
    /* geometry_manager		*/   XtInheritGeometryManager,
    /* change_managed		*/   XtInheritChangeManaged,
    /* insert_child		*/   InsertChild,
    /* delete_child		*/   XtInheritDeleteChild,
    /* extension		*/   NULL
  },
  { /* constraint class fields */
    /* subresources		*/   NULL,
    /* subresource_count	*/   0,
    /* constraint_size		*/   sizeof(XeTextConstraintsRec),
    /* initialize		*/   NULL,
    /* destroy			*/   NULL,
    /* set_values		*/   FrameSetValues,
    /* extension		*/   NULL
   },
#ifdef USING_MOTIF_122
    {  /* manager class record */
       /* translations */                 XtInheritTranslations,
       /* syn_resources */                NULL,
       /* num_syn_resources */            0,
       /* syn_constraint_resources */     NULL,
       /* num_syn_constraint_resources */ 0,
       /* parent_process */               XmInheritParentProcess,
       /* extension */                    NULL  
    },
#endif
  { /* XeBasic fields */
    /* not used			*/	0
  },
  { /* XeText fields */
    /* not used			*/	0
  },
  { /* XeTextEd fields */
    /* not used			*/	0
  }
};

WidgetClass xeTextEdWidgetClass = (WidgetClass)&xeTextEdClassRec;

static void ClassInitialize()
    {
	int len1 = strlen(translations1);
	int len2 = strlen(translations2);
	int len3 = strlen(translations3);
	char *buf = XtMalloc ((unsigned)(len1 + len2 + len3 + 1));
	char *cp = buf;

	XewInitializeWidgetSet();

	(void) strcpy (cp, translations1); cp += len1;
	(void) strcpy (cp, translations2); cp += len2;
	(void) strcpy (cp, translations3);
	xeTextEdWidgetClass->core_class.tm_table = buf;

#ifdef USING_MOTIF_122
        _XeTextEdbaseClassExtRec.record_type = XmQmotif;
#endif
        
    }

static void ClassPartInitialize(class)
WidgetClass class;
    {
    }

#define insertCursor_width 6
#define insertCursor_height 3
static char insertCursor_bits[] = {0x0c, 0x1e, 0x33};

static Pixmap CreateInsertCursor(s)
Screen *s;
    {
	return (XCreateBitmapFromData
		(DisplayOfScreen(s), RootWindowOfScreen(s), insertCursor_bits,
		 insertCursor_width, insertCursor_height));
    }

static void GetCursorBounds(w, rect)
XeTextEdWidget w;
XRectangle * rect;
    {
	rect->width = (unsigned short) insertCursor_width;
	rect->height = (unsigned short) insertCursor_height;
	rect->x = w->texted.cursor_x - (short)(rect->width / 2);
	rect->y = w->texted.cursor_y - (short)rect->height;
    }

static void InsertCursor(w)
XeTextEdWidget w;
    {
	XRectangle rect;

	GetCursorBounds(w, &rect);
	XCopyPlane(XtDisplay(w), w->texted.cursor, XtWindow(w),
		   w->text.mygcXOR, 0, 0, (unsigned int)rect.width,
		   (unsigned int)rect.height,
		   (int) rect.x, (int) rect.y, 1);
	}

static void Initialize(request, target)
Widget request, target;
    {
	XeTextEdWidget w = (XeTextEdWidget)target;

	w->texted.cursor_position = 0;
	w->texted.mult = 1;
	w->texted.num_regions = 1;
	w->texted.max_regions = 1;
	w->texted.regions = (XeTextRegion *)XtCalloc(1, sizeof(XeTextRegion));
	w->texted.regions[0].mode = XeTextHighlight_REVERSE;
	w->texted.s.selections = NULL;
	w->texted.s.atom_count = 0;
	w->texted.s.array_size = 0;
	w->texted.cursor = CreateInsertCursor(XtScreenOfObject(target));
	w->texted.cursor_x = w->texted.cursor_y = 0;
	w->texted.need_layout = False; /* Empty content does not need it! */
	w->texted.full_layout = False;
	w->texted.cursor_location.snip = NULL;
	w->texted.cursor_location.offset = 0;
	w->texted.refresh = 0;
	w->texted.insert_prefix = NULL;
	w->texted.insert_prefix_length = 0;
	w->texted.parent = 0;
	w->texted.parent_width = 0;
	w->texted.parent_height = 0;
	w->texted.window_x = 0;
	w->texted.window_y = 0;
    }

static Time NoteTime(event)
XEvent *event;
    {
	if (event != NULL)
	    {
		switch (event->type)
		    {
		    case ButtonPress:
		    case ButtonRelease:
			return event->xbutton.time;
			break;
		    case KeyPress:
		    case KeyRelease:
			return event->xkey.time;
			break;
		    case MotionNotify:
			return event->xmotion.time;
			break;
		    case EnterNotify:
		    case LeaveNotify:
			return event->xcrossing.time;
		    }
	    }
	return CurrentTime; /* A kludge, should probably give warning --msa */
    }	    

static void NotePosition(w, event, p)
XeTextEdWidget w;
XEvent *event;
XPoint *p;
    {
	switch (event->type)
	    {
	    case ButtonPress:
	    case ButtonRelease:
		p->x = event->xbutton.x;
		p->y = event->xbutton.y;
		break;
	    case KeyPress:
	    case KeyRelease:
		    {
			XRectangle cursor;
			GetCursorBounds(w, &cursor);
			p->x = cursor.x + cursor.width / 2;;
			p->y = cursor.y + cursor.height / 2;;
		    }
		break;
	    case MotionNotify:
		p->x = event->xmotion.x;
		p->y = event->xmotion.y;
		break;
	    case EnterNotify:
	    case LeaveNotify:
		p->x = event->xcrossing.x;
		p->y = event->xcrossing.y;
		break;
	    default:
		p->x = 0;
		p->y = 0;
		break;
	    }
    }

/*
** XeLocation2Coordinates
**	Return (x,y) coordinates matching the given (Snip, Offset)
**	This function uses some ad hoc rules in deciding the actual
**	position. The reasons for them are somewhat obscure, but they
**	have been arrived by trial and error and do give out least
**	surprises to the user...
**
**	If Snip == NULL, default to the first Snip in content, or
**	origin, if empty content.
**
**	* THIS WORKS ONLY IF THE CONTENT HAS BEEN LAID OUT *
*/
#if NeedFunctionPrototypes
static void XeLocation2Coordinates(XeTextEdWidget, Snip *, int, XPoint *);
#endif
static void XeLocation2Coordinates(t, s, o, xy)
XeTextEdWidget t;
Snip *s;
int o;
XPoint *xy;
    {
	if (s == NULL)
	    {
		/*
		** No Snip specified, default to position of the first
		** editable Snip, if any exists
		*/
		o = 0;
		for (s = t->text.first; ; s = s->next)
			if (s == NULL)
			    {
				/*
				** No Snip and empty content, default to
				** (text.x, text.y)
				*/
				xy->x = t->text.x;
				xy->y = t->text.y;
				return;	/* <<<<<<<<<<<< *** RETURN!! *** */
			    }
			else if (IsEditableContent(s->mode.bits))
				break;
	    }
	xy->x = s->x;
	xy->y = s->y;
	/*
	** If this snip is a space and point would be in front of it,
	** then use the end of previous editable Snip instead, if that
	** snip exists and is not endseq. [This trickery is because
	** of the way adjustable spaces are treated in the layout
	** process: within line the extra space is added in *front* of
	** the space by adjusting the (x) of the space Snip, and soft
	** line breaks are added *after* the space and the spaces are
	** zero width elements before soft break.]
	*/
	if (o == 0 && (s->space || (s->endseq && s->length == 0)))
	    {
		if (&t->text.first != s->back)
		    {
			s = PreviousSnip(s);
			if (!s->endseq &&
			    IsEditableContent(s->mode.bits))
			    {
				xy->x = s->x + s->xWidth;
				xy->y = s->y;
			    }
		    }
	    }
	else if (o < s->length)
		xy->x += XeTextSnipWidth((XeTextWidget)t,s,s->data,o);
	else if (s->xWidth == 0 || o > s->length)
	    {
		/*
		** If the point would be *after* visually empty
		** (zero width) element or point is after endseq
		** (o > length), then use the position from the next
		** editable element. If there is no editable next
		** element, then use the end of widget for position or
		** last position from layout snips.
		*/
		Snip *r;
		if (HasEndLine(s))
		    {
			xy->x = t->text.x;
			xy->y += s->descent + s->ascent;
		    }
		else
			xy->x += s->xWidth;
		for (r = s; (r = r->next) != NULL; )
		    {
			xy->x = r->x;
			xy->y = r->y;
			if (IsEditableContent(r->mode.bits))
				break;
		    }
	    }
	else
		xy->x += s->xWidth;
    }

/*
** XeOffset2Locations
**	Convert virtual offsets into XeTextLocations and matching
**	(x,y) coordinates.
**
**	NOTE:	The offsets will be rearranged to ascending order,
**		if they are not.
**
**	NOTE:	In the returned (snip, offset), it is always true
**		that "offset < VirtualLength(snip)", except when the
**		converted offset was beyond the end of the file, this
**		is the only case when "offset == VirtualLength(snip)".
*/
#if NeedFunctionPrototypes
static void XeOffset2Locations
	(XeTextEdWidget, long *, int, XeTextLocation *, XPoint *);
#endif
static void XeOffset2Locations(t, v, n, p, xy)
XeTextEdWidget t;	/* Text Widget */
long *v;		/* Virtual offsets (points to convert) */
int n;			/* Number of points to convert */
XeTextLocation *p;	/* Return matching (Snip, offset) here */
XPoint *xy;		/* Return matching (x,y) here */
    {
	int done = 0;			/* # of converted virtual offsets */
	long voffset = 0;		/* Cumulative Virtual offset */
	Snip *last_editable = NULL;	/* Last Editable Snip in content */
	long vlength = 0;		/* Virtual Lenght of the last snip */
	Snip *s;
	int x, y, i, j;

	/*
	** First, ensure that the offsets are given in ascending
	** order. Rearrange them if this is not the case. Use brute
	** bubble sort. Never call this with more than 1-4 offsets!
	*/
	for (i = 0; i < n-1; ++i)
		for (j = i + 1; j < n; ++j)
			if (v[i] > v[j])
			    {
				register long temp = v[j];

				v[j] = v[i];
				v[i] = temp;
			    }
	/*
	** Find the matching (Snip,Offset) and (x,y) information for
	** the each virtual offset.
	*/
	y = t->text.y;
	x = t->text.x;
	for (s = t->text.first; done < n && s; s = s->next)
	    {
		if (IsEditableContent(s->mode.bits))
		    {
			last_editable = s;
			x = s->x + s->xWidth;
			y = s->y;
			voffset += (vlength = VirtualLength(s));
			while (done < n && v[done] < voffset)
			    {
				int l = v[done] - voffset + vlength;

				p[done].snip = s;
				p[done].offset = l;
				XeLocation2Coordinates(t, s, l, &xy[done]);
				done += 1;
			    }
		    }
	    }
	/*
	** The remaining un-done virtual offsets point past end of
	** content. Adjust them to point after the last editable
	** Snip.
	*/
	while (done < n)
	    {
		v[done] = voffset;
		xy[done].x = x;
		xy[done].y = y;
		p[done].snip = last_editable;
		p[done].offset = vlength;
		done += 1;
	    }
    }

#ifdef not_used_but_left_as_reference_for_future_need
/*
** XeLocation2Offset
**	Convert location identified by (Snip,offset) tuple into
**	virtual offset.
*/
#if NeedFunctionPrototypes
static long XeLocation2Offset(XeTextEdWidget, XeTextLocation *);
#endif
static long XeLocation2Offset(t, dot)
XeTextEdWidget t;
XeTextLocation *dot;
    {
	Snip *s;
	long voffset = 0;

	if (dot->snip == NULL)
		return 0;
	for (s = t->text.first; s; s = s->next)
		if (dot->snip == s)
		    {
			voffset += dot->offset;
			break;
		    }
		else if (IsEditableContent(s->mode.bits))
			voffset += VirtualLength(s);
	if (s == NULL)
		XeWidgetWarningMsg
			((Widget)t, "bugTextEdExistingSnip",
			 "Non-Existing or bad Snip pointer (BUG)",
			 (String *)NULL, (Cardinal)0);
	return voffset;
    }
#endif

#ifdef not_used_but_left_as_reference_for_future_need
/*
** XeMoveLocation
**	Move the dot forward or backward the specified amount of virtual
**	positions. (amount < 0 ==> backward, amount > 0 ==> forward). dot
**	must initially point to editable content.
**
**	Returns the amount that didn't get processed (0 means success).
*/
#if NeedFunctionPrototypes
static long XeMoveLocation(XeTextEdWidget, XeTextLocation *, long);
#endif
static long XeMoveLocation(t, dot, amount)
XeTextEdWidget t;
XeTextLocation *dot;
long amount;
    {
	Snip *s = dot->snip;
	Snip *last_editable = NULL;
	long vlength = 0;

	if (s == NULL && (s = t->text.first) == NULL)
		return amount;
	if (amount >= 0)
	    {
		amount += dot->offset;
		do
		    {
			if (IsEditableContent(s->mode.bits))
			    {
				last_editable = s;
				amount -= (vlength = VirtualLength(s));
				if (amount < 0)
				    {
					dot->offset = amount + vlength;
					dot->snip = s;
					return 0;
				    }
			    }
			
		    }
		while ((s = s->next) != NULL);
		dot->snip = last_editable;
		dot->offset = vlength;
	    }
	else if (amount < 0)
	    {
		amount -= (VirtualLength(s) - dot->offset);
		for (;; s = PreviousSnip(s))
		    {
			if (IsEditableContent(s->mode.bits))
			    {
				last_editable = s;
				amount += (vlength = VirtualLength(s));
				if (amount >= 0)
				    {
					dot->offset = amount;
					dot->snip = s;
					return 0;
				    }
			    }
			if (s->back == &t->text.first)
				break;
		    }
		dot->snip = last_editable;
		dot->offset = 0;
	    }
	return amount;
    }
#endif

/*
** FindPosition
**	Return virtual length of the content starting from the specified
**	TextLocation up to the position defined by goal.
**
**	NOTE 1)	The code assumes that the starting point is Editable!
**
**	Returns the virtual length.
*/
#if NeedFunctionPrototypes
static long FindPosition(XeTextEdWidget, XPoint *, XeTextLocation *);
#endif
static long FindPosition(w, goal, dot)
XeTextEdWidget w;
XPoint *goal;
XeTextLocation *dot;
    {
	int x, y;
	Snip *r, *s;
	long position = 0;
	int end_line = 0;

	s = r = dot->snip;
	if (s == NULL)
		return 0;
	position -= dot->offset;
	dot->offset = 0;
	/*
	** At head of loop, the following are true:
	**
	** r		current Snip.
	**
	** position	virtual offset difference from the beginning of
	**		the search to the beginning the current Snip
	**		being examined (r).
	*/
	/* ..it should not be this cryptic! Something is real messy here!!
	   Look into below someday.. --msa */
	while (r && !end_line)
	    {
		x = r->x;
		y = r->y;
		if (y >= goal->y)
		    {
			if (x >= goal->x)
				break;	/* Before current snip (r) */
			else if (!r->floating && x + r->xWidth >= goal->x)
			    {
				int n = 0;

				if (!IsEditableContent(r->mode.bits))
					break; /* Non-Editable */

				while (++n <= r->length)
					if (x + XeTextSnipWidth
					    ((XeTextWidget)w, r, r->data, n)
					    > goal->x)
						break;
				/*
				** Point within editable Snip, easy out...
				*/
				dot->snip = r;
				dot->offset = n - 1;
				position += dot->offset;
				return position;
			    }
			else if (HasEndLine(r))
				end_line = 1; /* Break after this Snip */
		    }
		if (IsEditableContent(r->mode.bits))
		    {
			position += VirtualLength(r);
			s = r;
		    }
		r = r->next;
	    }
	/*
	** If the loop exits, it means that requested position lies
	** between Snips, before the one indicated by 'r' (if non-NULL).
	** Locate the two possible points (next and previous editable Snips)
	** and select the one that is closer to the goal point horizontally!
	*/
	if (r == s)
		return position; /* messy!! */
	x = s->x - goal->x;
	if (!s->floating)
		x += (int)s->xWidth;
	if (x < 0)
		x = -x;
	for ( ;r; r = r->next)
		if (IsEditableContent(r->mode.bits))
		    {
			y = r->x - goal->x;
			if (y < 0)
				y = -y;
			if (y < x)
			    {
				dot->snip = r;
				dot->offset = 0;
				return position;
			    }
			break;
		    }
	/* The snip pointed by 's' is chosen, do some final "adjustements" */
	dot->snip = s;
	dot->offset = s->length;
	if (HasEndPosition(s))
		position -= 1;
	else if ((s->xWidth == 0 || s->floating) && dot->offset > 0)
	    {
		position -= 1;
		dot->offset -= 1;
	    }
	return position;
    }

#ifdef not_used_but_left_as_reference_for_future_need
/*
** RectanglesOverlap (copied from Athena Text.c)
**	Returns TRUE if two rectangles overlap.
*/
static Boolean RectanglesOverlap(rect1, rect2)
XRectangle *rect1, *rect2;
    {
	return ((rect1->x < rect2->x + (short) rect2->width) &&
		(rect2->x < rect1->x + (short) rect1->width) &&
		(rect1->y < rect2->y + (short) rect2->height) &&
		(rect2->y < rect1->y + (short) rect1->height));
    }
#endif

/*
** RectangleWithin
**	Returns TRUE if rect2 is completely within rect2.
*/
static Boolean RectangleWithin(rect1, rect2)
XRectangle *rect1, *rect2;
    {
	return ((rect1->x <= rect2->x) &&
		(rect1->x + rect1->width >= rect2->x + rect2->width) &&
		(rect1->y <= rect2->y) &&
		(rect1->y + rect1->height >= rect2->y + rect2->height));
    }

/*
** QueryParentDimensions
**	finds out the real dimensions of the actual parent window
*/
static void QueryParentDimensions(t)
XeTextEdWidget t;
    {
	Window root, *children;
	unsigned int nchildren;
	XWindowAttributes attribs;

	if (!t->texted.parent)
	    {
		/*
		** Tracking variables are uninitialized, load info
		*/
		if (!XQueryTree(XtDisplay(t), XtWindow(t),
				&root, &t->texted.parent,
				&children, &nchildren))
			return;
		XtFree((char *)children);
		XGetWindowAttributes(XtDisplay(t), XtWindow(t), &attribs);
		t->texted.window_x = attribs.x;
		t->texted.window_y = attribs.y;
	    }
	XGetWindowAttributes(XtDisplay(t), t->texted.parent, &attribs);
	t->texted.parent_width = attribs.width;
	t->texted.parent_height = attribs.height;
    }

/*
** TextReparented
**	This action routine tracks the real window parent for the
**	CheckBounds function (so that it does not need to do the
**	round trip XQueryTree for every call).
*/
static void TextReparented(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	XeTextEdWidget t = (XeTextEdWidget)w;

	if (e && e->type == ReparentNotify)
	    {
		t->texted.parent = e->xreparent.parent;
		t->texted.window_x = e->xreparent.x;
		t->texted.window_y = e->xreparent.y;
	    }
    }

/*
** TextConfigured
**	This action routine tracks the real window position and size
**	relative to the real parent window for the CheckBounds function
**	(so that it does not need to do the roundtrip XGetWindowAttributes)
*/
static void TextConfigured(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	XeTextEdWidget t = (XeTextEdWidget)w;

	if (e && e->type == ConfigureNotify)
	    {
		t->texted.window_x = e->xconfigure.x;
		t->texted.window_y = e->xconfigure.y;
	    }
    }

/*
** CheckBounds
**	Check if insert cursor was moved outside parent window
**	(Not really completely thought out, first crack...). If
**	outside, then call notifyCallback with XeCR_NOTIFY_AREA.
*/
#if NeedFunctionPrototypes
static void CheckBounds(XeTextEdWidget, XRectangle *);
#endif
static void CheckBounds(t, r)
XeTextEdWidget t;
XRectangle *r;
    {
	int x, y, w, h;
	
	XeNotifyAreaCallbackData data;
	data.reason = XeCR_NOTIFY_AREA;
	data.area = *r;
	data.visible.x = 0;
	data.visible.y = 0;
	data.visible.width = t->core.width;
	data.visible.height = t->core.height;
	/*
	** Compute intersection rectangle between parent window and
	** widget window in widget coordinate space. (unfortunately,
	** cannot use core geometry fields here, the real parent window
	** is not necessarily the same as the parent widget window!)
	*/
	QueryParentDimensions(t); /* Have to do this, might have changed! */
	x = - t->texted.window_x;
	y = - t->texted.window_y;
	w = t->texted.parent_width;
	h = t->texted.parent_height;
	if (x > data.visible.x)
	    {
		data.visible.width -= x - data.visible.x;
		data.visible.x = x;
	    }
	if (x + w < data.visible.x + data.visible.width)
		data.visible.width = x + w - data.visible.x;
	
	if (y > data.visible.y)
	    {
		data.visible.height -= y - data.visible.y;
		data.visible.y = y;
	    }
	if (y + h < data.visible.y + data.visible.height)
		data.visible.height = y + h - data.visible.y;
	/*
	** Generate XtNnotifyCallback, if the cursor block is outside.
	*/
	if (!RectangleWithin(&data.visible, &data.area))
		XtCallCallbackList((Widget)t, t->basic.notify_callbacks,
				   (XtPointer)&data);
    }


/*
** GetCutBufferNumber (from Xaw)
**	Returns the number of the cut buffer (>= 0)identified by the atom,
**	or -1, if atom is not a cut buffer.
*/
static int GetCutBufferNumber(atom)
register Atom atom;
    {
	if (atom == XA_CUT_BUFFER0)
		return 0;
	else if (atom == XA_CUT_BUFFER1)
		return 1;
	else if (atom == XA_CUT_BUFFER2)
		return 2;
	else if (atom == XA_CUT_BUFFER3)
		return 3;
	else if (atom == XA_CUT_BUFFER4)
		return 4;
	else if (atom == XA_CUT_BUFFER5)
		return 5;
	else if (atom == XA_CUT_BUFFER6)
		return 6;
	else if (atom == XA_CUT_BUFFER7)
		return 7;
	return -1;
    }

static void DrawPolygon(t, nrect, rect)
XeTextEdWidget t;
int nrect;
XRectangle *rect;
    {
	XPoint p[13];
	int i;
	register int x, y;

	x = rect[0].x;
	y = rect[0].y;

	p[0].x = x;
	p[0].y = y;
	x += (p[1].x = rect[0].width - 1);
	p[1].y = 0;
	p[2].x = 0;
	y += (p[2].y = rect[0].height);
	i = 3;
	if (nrect > 1)
	    {
		x += (p[3].x = rect[1].x + rect[1].width - 1 - x);
		if (p[3].x < 0)
			p[2].y -= 1, y -= 1;
		p[3].y = 0;
		p[4].x = 0;
		y += (p[4].y = rect[1].height);
		i = 5;
		if (nrect > 2)
		    {
			x += (p[5].x = rect[2].x + rect[2].width - 1 - x);
			if (p[5].x < 0)
				p[4].y -= 1, y -= 1;
			p[5].y = 0;
			p[6].x = 0;
			y += (p[6].y = rect[2].height - 1);
			x += (p[7].x = - rect[2].width + 1);
			p[7].y = 0;
			p[8].x = 0;
			y += (p[8].y = - rect[2].height + 1);
			i = 9;
		    }
		x += (p[i].x = rect[1].x - x);
		if (p[i].x < 0)
			p[i-1].y -= 1, y -= 1;
		p[i].y = 0;
		i++;
		p[i].x = 0;
		y += (p[i].y = rect[1].y - y);
		i++;
	    }
	x += (p[i].x = rect[0].x - x);
	if (p[i].x < 0)
		p[i-1].y -= 1, y -= 1;
	p[i].y = 0;
	i++;
	p[i].x = 0;
	y += (p[i].y = p[0].y - y);
	i++;
	XDrawLines(XtDisplay(t), XtWindow(t), t->text.mygc,
		   p, i, CoordModePrevious);
    }

static void MarkSelection(t)
XeTextEdWidget t;
    {
	int n;

	for (n = t->texted.num_regions; --n >= 0;)
	    {
		XeTextRegion *r = &t->texted.regions[n];

		if (r->nrect > 0)
			switch (r->mode)
			    {
			    case XeTextHighlight_REVERSE:
				XFillRectangles
					(XtDisplay(t), XtWindow(t),
					 t->text.mygcXOR, r->rect, r->nrect);
				break;
			    case XeTextHighlight_FRAME:
				DrawPolygon(t, r->nrect, r->rect);
				break;
			    default:
				break;
			    }
		r->delayed = False;
	    }
    }

static void Redisplay(w, e, r)
Widget w;
XExposeEvent *e;
Region r;
    {
	XeTextEdWidget t = (XeTextEdWidget)w;
	Region my_r = r;

	if (!XtIsRealized(w))
		return;
	if (my_r == NULL && e != NULL)
	    {
		XRectangle clip;
		/*
		** No Region, make one from exposed area. This should be
		** exceptional, widgets should have the compress exposures
		** mode set and always have a region!
		*/
		clip.x = e->x;
		clip.y = e->y;
		clip.width = e->width;
		clip.height = e->height;
		my_r = XCreateRegion();
		XUnionRectWithRegion(&clip, my_r, my_r); 
	    }
	/*
	** TextEd calls Redisplay Internally, shortcutting the server
	** roundtrip that would be cause by XClearArea. This means that
	** the expose method cannot trust the exposed area to be cleared
	** initially. Call Text expose method without XEvent, which makes
	** it explicitly clear the region.
	*/
	(*superclass->core_class.expose)(w, (XEvent *)NULL, my_r);
	/* Warning: This assumes that clipmask is left active from the
	   Text expose method, thus if cursor position was not exposed
	   it will not be affected either. --msa */
	MarkSelection(t);
	if (t->texted.display_caret)
		InsertCursor(t);
	if (t->basic.expose_callbacks &&
	    t->core.widget_class == xeTextEdWidgetClass)
	    {
		XeExposeCallbackData data;
		data.reason = XeCR_EXPOSE;
		data.event = e;
		data.region = r;
		XtCallCallbackList
			(w, t->basic.expose_callbacks, (XtPointer)&data);
	    }
	if (r != my_r && my_r)
		XDestroyRegion(my_r);
    }

static void InitRefreshRegion(w)
XeTextEdWidget w;
    {
	if (!w->texted.refresh)
		w->texted.refresh = XCreateRegion();
    }

static void DoRefreshRegion(w)
XeTextEdWidget w;
    {
	Region r = w->texted.refresh;

	if (r && !XEmptyRegion(r))
	    {
		w->texted.refresh = 0;
		Redisplay((Widget)w, (XExposeEvent *)NULL, r);
		XDestroyRegion(r);
	    }
    }

/*
** UpdateCursorPosition
**	Change the cursor into a new location and/or refresh cursor.
**
**	if goal, then reset horizontal goal position.
**
**	if expose, then request expose events
**
**	if bounds, then request that cursor is in visible window
*/
#if NeedFunctionPrototypes
static void UpdateCursorPosition(XeTextEdWidget, int, int, int);
#endif
static void UpdateCursorPosition(t, goal, expose, bounds)
XeTextEdWidget t;
int goal, expose, bounds;
    {
	XPoint xy;
	XRectangle rect;
	XeTextLocation *location = &t->texted.cursor_location;

	if (t->text.enable_display < 0)
		return;
	expose = expose && XtIsRealized((Widget)t);
	if (expose)
	    {
		GetCursorBounds(t, &rect); /* to clear out old cursor mark */
		XUnionRectWithRegion
			(&rect, t->texted.refresh, t->texted.refresh);
	    }
	XeLocation2Coordinates(t, location->snip, location->offset, &xy);
	t->texted.cursor_x = xy.x;
	t->texted.cursor_y = xy.y + insertCursor_height + 1;
	if (goal)
		t->texted.cursor_goal = t->texted.cursor_x;
	GetCursorBounds(t, &rect);
	if (expose)
		XUnionRectWithRegion
			(&rect, t->texted.refresh, t->texted.refresh);
	if (location->snip)
	    {
		rect.y -= location->snip->ascent;
		rect.height += location->snip->ascent+location->snip->descent;
	    }
	if (rect.x < 0)
	    {
		/*
		** Because the caret extends to the left of the current
		** point, it would generate this notify on every beginning
		** line. Clip area to positive side of x.
		*/
		if ((int)rect.width + rect.x < 0)
			rect.width = 0;
		else
			rect.width += rect.x;
		rect.x = 0;
	    }
	if (bounds && XtIsRealized((Widget)t))
		CheckBounds(t, &rect);
    }

/*
** XeUpdateTextRegion
**	Recompute the rectangles covering the specified Text Region, and
**	update the area requiring refresh/expose.
*/
#if NeedFunctionPrototypes
static void XeUpdateTextRegion(XeTextEdWidget, XeTextRegion *, int);
#endif
static void XeUpdateTextRegion(t, region, bounds)
XeTextEdWidget t;
XeTextRegion *region;
int bounds;		/* Call Check bounds, if non-zero */
    {
	XRectangle rect[3];
	int nrect, i, ascent1, descent1, ascent2, descent2, ascent3, base, adj;
	int in_one_line;
	XeTextLocation dot[2];
	XPoint xy[2];
	long range[2];
	Snip *s;

	if (t->text.enable_display < 0 ||
	    /*
	    ** Have to do the refresh for regions marked UNUSED, if they
	    ** have remaining nrect's (due to having been destroyed while
	    ** display was disabled)
	    */
	    (region->mode == XeTextHighlight_UNUSED && region->nrect == 0) ||
	    region->mode == XeTextHighlight_NONE)
	    {
		region->delayed = True;
		return;
	    }
	nrect = 0;
	if (region->range[0] != region->range[1])
	    {
		range[0] = region->range[0];
		range[1] = region->range[1];
		XeOffset2Locations(t, range, 2, dot, xy);
		if (dot[0].snip == NULL || dot[1].snip == NULL)
			goto no_editable_content;
		/*
		** Find the extents of the first (partial) line included into
		** the region (ascent1, descent1). Scan FORWARD from the
		** region start Snip until first end line or end of region,
		** whichever is reached first.
		*/
		in_one_line = False;
		for (s = dot[0].snip, ascent1 = descent1 = 0, base = s->y;
		     s; s = s->next)
		    {
			if (!s->floating)
			    {
				adj = base - s->y;
				if (s->ascent + adj > ascent1)
					ascent1 = s->ascent + adj;
				if (s->descent - adj > descent1)
					descent1 = s->descent - adj;
			    }
			if (s == dot[1].snip)
			    {
				in_one_line = True;
				break;
			    }
			if (HasEndLine(s))
				break;
		    }
		rect[0].x = xy[0].x;
		rect[0].y = xy[0].y - ascent1;
		rect[0].height = ascent1 + descent1;
		if (in_one_line)
		    {
			nrect = 1;
			if (xy[0].x < xy[1].x)
				rect[0].width = xy[1].x - xy[0].x;
			else if (xy[0].x > xy[1].x)
				rect[0].width = xy[0].x - xy[1].x;
			else
				nrect = 0;
		    }
		else
		    {
			/*
			** A minor detail: in multiline region, if the
			** region starts from the beginning of the line,
			** then extend the area to the left margin. This
			** removes one "extra angle" from the ared, when
			** text happens to be indented.
			** (A tidier solution would be to scan all snips
			** included into the region and record the min and
			** max x, but that might be too heavy for large
			** regions).
			*/
			s = dot[0].snip;
			if (dot[0].offset == 0 && s->back != &t->text.first)
			    {
				s = PreviousSnip(s);
				if (HasEndLine(s))
					rect[0].x = 0;
			    }
			/*
			** Find the extents of the last (partial) line
			** included into the region (ascent2, descent2).
			** Scan BACKWARD from the region end Snip until
			** first end line or start of region, whichever
			** is reached first. And, because !in_one_line,
			** it is guaranteed that HasEndLine(s) exists.
			*/
			s = dot[1].snip;
			if (dot[1].offset == 0)
				s = PreviousSnip(s);
			for (ascent2 = descent2 = 0, base = s->y; s;
			     s = PreviousSnip(s))
			    {
				if (!s->floating)
				    {
					adj = base - s->y;
					if (s->ascent + adj > ascent2)
						ascent2 = s->ascent + adj;
					if (s->descent - adj > descent2)
						descent2 = s->descent - adj;
				    }
				if (HasEndLine(s))
					break;
			    }
			/*
			** Find the ascent of the partial line AFTER
			** the region.
			*/
			for (s = dot[1].snip, ascent3 = 0, base = s->y; s;
			     s = s->next)
			    {
				if (!s->floating &&
				    s->ascent + base - s->y > ascent3)
					ascent3 = s->ascent + base - s->y;
				if (HasEndLine(s))
					break;
			    }
			if (t->text.w <= (int)rect[0].x)
				rect[0].width = 0;
			else
				rect[0].width = t->text.w - rect[0].x;
			rect[2].x = 0;
			rect[2].y = xy[1].y - ascent3;
			if (xy[1].x > 0)
				rect[2].width = xy[1].x;
			else
				rect[2].width = 0;
			rect[2].height = ascent3 + descent2;
			rect[1].x = 0;
			rect[1].y = rect[0].y + rect[0].height;
			rect[1].width = t->text.w;
			i = rect[2].y - rect[0].y - rect[0].height;
			if (i >=  0)
				rect[1].height = i;
			else
			    {
				i = rect[2].y - rect[0].y;
				rect[0].height = i > 0 ? i : 0;
			    }
			nrect = 3;
		    }
		/*
		** Sometimes truncated rectangles are generated,
		** remove rectangles of zero width and/or zero height.
		*/
		for (adj = i = 0; i < nrect; ++i)
			if (rect[i].width > 0 && rect[i].height > 0)
			    {
				if (adj != i)
					rect[adj] = rect[i];
				adj++;
			    }
		nrect = adj;
	    }
    no_editable_content:
	if (XtIsRealized((Widget)t))
	    {
		Region r_old = XCreateRegion();
		Region r_new = XCreateRegion();
		Region r_xor = XCreateRegion();
		
		for (i = 0; i < region->nrect; ++i)
			XUnionRectWithRegion(&region->rect[i], r_old, r_old);
		for (i = 0; i < nrect; ++i)
		    {
			XUnionRectWithRegion(&rect[i], r_new, r_new);
			region->rect[i] = rect[i];
		    }
		region->nrect = nrect;
		if (region->delayed)
			XUnionRegion(r_new, r_old, r_xor);
		else
			XXorRegion(r_new, r_old, r_xor);
		region->delayed = False;
		if (t->texted.refresh)
			XUnionRegion
				(r_xor, t->texted.refresh, t->texted.refresh);
		XDestroyRegion(r_old);
		XDestroyRegion(r_new);
		XDestroyRegion(r_xor);
		if (bounds && nrect > 0)
		    {
			XRectangle area;
			i = range[1] == region->range[1] ? 1 : 0;
			area.x = xy[i].x;
			area.y = xy[i].y;
			area.width = area.height = 1;
			if ((s = dot[i].snip) != NULL)
			    {
				area.y -= s->ascent;
				area.height += s->ascent + s->descent;
			    }
			CheckBounds(t, &area);
		    }
	    }
	region->nrect = nrect;
    }

/*
** UpdateTextRegions
**	Recompute the areas that must be highlighted from the
**	virtual offsets of the text regions
*/
#if NeedFunctionPrototypes
static void UpdateTextRegions(XeTextEdWidget, int);
#endif
static void UpdateTextRegions(t, bounds)
XeTextEdWidget t;
int bounds;	/* Call Check bounds, if non-zero */
    {
	int n;

	/*
	** Because display may have been disabled while region was unset,
	** one has to use max_regions here to get things refreshed for
	** those too.
	*/
	for (n = t->texted.max_regions; --n >= 0; )
		XeUpdateTextRegion(t, &t->texted.regions[n], bounds);
    }

static Boolean SetValues(current, request, set, args, num_args)
Widget current, request, set;
ArgList args;
Cardinal *num_args;
    {
	XeTextEdWidget c = (XeTextEdWidget)current;
	XeTextEdWidget r = (XeTextEdWidget)request;
	XeTextEdWidget t = (XeTextEdWidget)set;
	int bounds = False;
	
	InitRefreshRegion(t);
	if (!r->basic.content_loaded) /* Note! *request* tested here!! */
	    {
		/*
		** Content emptied!
		*/
		int n = t->texted.max_regions;

		while (--n >= 0)
			t->texted.regions[n].range[0] =
				t->texted.regions[n].range[1] = 0;
		t->texted.cursor_position = 0;
		t->texted.cursor_location.snip = NULL;
		t->texted.cursor_location.offset = 0;
		t->texted.need_layout = True;
		t->texted.full_layout = True;
	    }
	else if (t->texted.cursor_position != c->texted.cursor_position)
	    {
		/*
		** Application moved the cursor. Need to recompute the
		** location from the virtual offset. and close any insert
		** state, if opened.
		*/
		XPoint xy;
		bounds = True;	/* Request window to show cursor pos. */
		if (t->text.inserting)
		    {
			_XeTextEndContent(t->text.inserting,
					  t->texted.refresh, (long *)NULL);
			t->text.inserting = NULL;
		    }
		XeOffset2Locations(t, &t->texted.cursor_position,
				   1, &t->texted.cursor_location, &xy);
	    }
	UpdateCursorPosition(t, False, True, bounds);
	UpdateTextRegions(t, False);
	DoRefreshRegion(t);
	return False;
    }

/*
** FrameSetValues
**	A contraint set values (most of the work is done in XeText).
*/
static Boolean FrameSetValues(old, request, set, args, num_args)
Widget old, request, set;
ArgList args;
Cardinal *num_args;
    {
	XeTextEdWidget t = (XeTextEdWidget)XtParent(set);
	/*
	** Should really know whether anything changed. For now, just
	** unconditionally refresh cursor and text regions
	*/
	InitRefreshRegion(t);
	UpdateCursorPosition(t, False, True, False);
	UpdateTextRegions(t, False);
	DoRefreshRegion(t);
	return False;
    }

static void Resize(w)
Widget w;
    {
	(*superclass->core_class.resize)(w);
	/* Assume Expose is coming up for everything, just prepare for it */
	UpdateCursorPosition((XeTextEdWidget)w, False, False, False);
	UpdateTextRegions((XeTextEdWidget)w, False);
    }

static void Destroy(w)
Widget w;
    {
	XeTextEdWidget t = (XeTextEdWidget)w;

	if (t->texted.refresh)
		XDestroyRegion(t->texted.refresh);
	XtFree(t->texted.insert_prefix);
	XFreePixmap(XtDisplay(w), t->texted.cursor);
	XFree((char *)t->texted.s.selections);
	XtFree((char *)t->texted.regions);
    }

/*
**
*/
typedef struct TextSelectionStruct
    {
	XeTextEdWidget w;/* Associated Widget */
	int size;	/* Current Size of data buffer */
	int length;	/* Bytes in the data buffer */
	char *data;	/* Allocated data buffer */
    } TextSelectionStruct;

#if NeedFunctionPrototypes
static int FeedSelect(char *, int, XeTextTag, XtPointer);
#endif
static int FeedSelect(data, length, tag, client_data)
char *data;
int length;
XeTextTag tag;
XtPointer client_data;
    {
	TextSelectionStruct *select = (TextSelectionStruct *)client_data;

	if (length <= 0)
		return 0;
	if (select->size - select->length < length)
	    {
		select->size += ((length + 511) / 512) * 512;
		select->data = XtRealloc(select->data, select->size);
	    }
	memcpy(&select->data[select->length], data, length);
	select->length += length;
	return length;
    }

static void ExtractSelectedContent(t, s, format)
XeTextEdWidget t;
TextSelectionStruct *s;	/* Will be initialized and filled */
XeTextExport format;	/* Defines the format of selection */
    {
	XeTextLocation dot[2];
	XPoint xy[2];
	long range[2];

	s->w = t;
	s->length = 0;
	s->size = 0;
	s->data = 0;
	range[0] = t->texted.regions[0].range[0];/* To prevent reordering */
	range[1] = t->texted.regions[0].range[1];/*  in the widgets data. */
	XeOffset2Locations(t, range, 2, dot, xy);
	if (range[0] < range[1])
		XeTextExtractContent((XeTextWidget)t, &dot[0], &dot[1], format,
				     FeedSelect, (XtPointer)s);
    }

static Boolean ConvertSelection
	(w, selection, target, type, value, length, format)
Widget w;
Atom *selection, *target, *type;
XtPointer *value;
unsigned long *length;
int *format;
    {
	Display* d = XtDisplay(w);
	XeTextEdWidget t = (XeTextEdWidget)w;
	XSelectionRequestEvent *req =
		XtGetSelectionRequest(w, *selection, (XtRequestId)NULL);
	XeExportCallbackData data;
	Boolean success = False;

	/*
	** Put initial defaults into callback structure
	*/
	data.reason = XeCR_EXPORT;
	data.time = req->time;
	data.selection = *selection;
	data.target = *target;
	data.type = 0;
	data.value = NULL;
	data.length = 0;
	data.format = 0;
	if (data.target == XA_TARGETS(d))
	    {
		Atom* targetP;

		success = XmuConvertStandardSelection
			(w, data.time, &data.selection, 
			 &data.target, &data.type, (caddr_t *)&data.value,
			 &data.length, &data.format);
		if (!success)
		    {
			data.value = NULL;
			data.length = 0;
		    }
		data.value = (XtPointer)XtRealloc
			((char *)data.value, sizeof(Atom) * (data.length+3));
		targetP = ((Atom *)data.value) + data.length;
		data.length += 2;
		*targetP++ = XA_STRING;
		*targetP++ = XA_TEXT(d);
		if (t->text.export_format >= XeTextExport_ODIF)
		    {
			*targetP++ = XA_COMPOUND_TEXT(d);
			data.length += 1;
		    }
		data.type = XA_ATOM;
		data.format = 32;
		success = True;
	    }
	if (t->basic.export_callbacks)
	    {
		XtCallCallbackList
			(w, t->basic.export_callbacks, (XtPointer)&data);
		success = data.length > 0 && data.format > 0;
	    }
	/*
	** Do default conversion, if no conversion has not yet been made
	*/
	if (!success)
	    {
		if (data.target == XA_STRING || data.target == XA_TEXT(d) ||
		    data.target == XA_COMPOUND_TEXT(d))
		    {
			TextSelectionStruct select;
			XeTextExport ef = t->text.export_format;

			if (data.target != XA_STRING && ef>=XeTextExport_ODIF)
				data.type = XA_COMPOUND_TEXT(d);
			else
			    {
				data.type = XA_STRING;
				ef = XeTextExportFormatted(ef) ?
					XeTextExport_STRING_F :
						XeTextExport_STRING;
			    }
			ExtractSelectedContent(t, &select, ef);
			data.value = (XtPointer)select.data;
			data.length = select.length;
			data.format = 8;
			success = select.data != NULL;
		    }
		else
			success = XmuConvertStandardSelection
				(w, data.time, &data.selection, 
				 &data.target, &data.type,
				 (caddr_t *)&data.value,
				 &data.length, &data.format);
	    }
	*type = data.type;
	*value = data.value;
	*length = data.length;
	*format = data.format;
	return success;
    }

static void LoseSelection(w, selection)
Widget w;
Atom *selection;
    {
	XeTextEdWidget t = (XeTextEdWidget)w;
	Atom *p, *r;
	int i;

	InitRefreshRegion(t);
	p = r = t->texted.s.selections;
	for (i = 0; i < t->texted.s.atom_count; i++, r++)
		if (*r != *selection && GetCutBufferNumber(*r) < 0)
			*p++ = *r;
	if ((t->texted.s.atom_count = p - t->texted.s.selections) == 0)
	    {
		t->texted.regions[0].range[1] = t->texted.regions[0].range[0];
		XeUpdateTextRegion(t, &t->texted.regions[0], False);
	    }
	DoRefreshRegion(t);
    }

/*
** CreateCutBuffers
**	(copied from Xaw)
*/
static void CreateCutBuffers(d)
Display *d;
    {
	static struct _DisplayRec
	    {
		struct _DisplayRec *next;
		Display *dpy;
	    } *dpy_list = NULL;
	struct _DisplayRec *dpy_ptr;

	for (dpy_ptr = dpy_list; dpy_ptr != NULL; dpy_ptr = dpy_ptr->next)
		if (dpy_ptr->dpy == d)
			return;

	dpy_ptr = XtNew(struct _DisplayRec);
	dpy_ptr->next = dpy_list;
	dpy_ptr->dpy = d;
	dpy_list = dpy_ptr;

#define Create(buffer) \
	XChangeProperty(d, RootWindow(d, 0), buffer, XA_STRING, 8, \
			PropModeAppend, NULL, 0 );

	Create( XA_CUT_BUFFER0 );
	Create( XA_CUT_BUFFER1 );
	Create( XA_CUT_BUFFER2 );
	Create( XA_CUT_BUFFER3 );
	Create( XA_CUT_BUFFER4 );
	Create( XA_CUT_BUFFER5 );
	Create( XA_CUT_BUFFER6 );
	Create( XA_CUT_BUFFER7 );
#undef Create
    }


#define MAX_CUT_LEN(dpy)  (XMaxRequestSize(dpy) - 64)

#if NeedFunctionPrototypes
static void PostSelections(XeTextEdWidget, Atom *, Cardinal);
#endif

static void PostSelections(t, selections, count)
XeTextEdWidget t;
Atom *selections;
Cardinal count;
    {
	int buffer;
  
	while (count)
	    {
		Atom selection = selections[--count];

		if ((buffer = GetCutBufferNumber(selection)) >= 0)
		    {
			/* This is a cut buffer. */

			unsigned int amount;
			unsigned int max_len = MAX_CUT_LEN(XtDisplay(t));
			TextSelectionStruct s;
			unsigned char *ptr;
			XeTextExport format =
				XeTextExportFormatted(t->text.export_format) ?
					XeTextExport_STRING_F :
						XeTextExport_STRING;
			if (t->basic.export_callbacks)
			    {
				/*
				** Application wants to take a peek into
				** export conversions. Give it a chance..
				*/
				XeExportCallbackData data;

				data.reason = XeCR_EXPORT;
				data.time = t->texted.time;
				data.selection = selection;
				data.target = XA_STRING;
				data.type = XA_STRING;
				data.value = NULL;
				data.length = 0;
				data.format = 8;
				XtCallCallbackList((Widget)t,
						   t->basic.export_callbacks,
						   (XtPointer)&data);
				/* NOTE! Callback may decide to do nothing,
				   in which case the default processing will
				   be done by ExtractSelectedContent.
				   */
				s.length = data.length;
				s.data = data.value;
			    }
			else
				s.data = NULL;
			if (s.data == NULL)
				ExtractSelectedContent(t, &s, format);
			if (buffer == 0)
			    {
				CreateCutBuffers(XtDisplay(t));
				XRotateBuffers(XtDisplay(t), 1);
			    }
			amount = s.length < max_len ? s.length : max_len;
			ptr = (unsigned char *)s.data;
			XChangeProperty
				(XtDisplay(t), RootWindow(XtDisplay(t), 0),
				 selection, XA_STRING, 8, PropModeReplace,
				 ptr, amount);
			while (s.length > max_len)
			    {
				s.length -= max_len;
				ptr += max_len;
				amount = s.length<max_len ? s.length : max_len;
				XChangeProperty
					(XtDisplay(t),
					 RootWindow(XtDisplay(t), 0), 
					 selection, XA_STRING, 8,
					 PropModeAppend, 
					 ptr, amount);
			    }
			XtFree ((char *)s.data);
		    }
		else  if (!XtOwnSelection((Widget)t, selection, t->texted.time,
					  ConvertSelection, LoseSelection,
					  (XtSelectionDoneProc)NULL))
			XeWidgetWarningMsg
				((Widget)t, "noteTextEdSelectFail",
				 "Could not become selection owner",
				 (String *)NULL, (Cardinal)0);
	    }
    }

/*
** TextSelectionList
**	Converts (params, num_params) to a list of atoms & caches the
**	list in the TextWidget instance. (modified from Xaw)
*/
static Atom *TextSelectionList(t, list, nelems)
XeTextEdWidget t;
String *list;
Cardinal nelems;
    {
	Atom *sel = t->texted.s.selections;
	Display *dpy = XtDisplay((Widget)t);
	int n;

	if (nelems > t->texted.s.array_size)
	    {
		sel = (Atom *)XtRealloc((char *)sel, sizeof(Atom) * nelems);
		t->texted.s.array_size = nelems;
		t->texted.s.selections = sel;
	    }
	for (n = nelems; --n >= 0; sel++, list++)
		*sel = XInternAtom(dpy, *list, False);
	t->texted.s.atom_count = nelems;
	return t->texted.s.selections;
    }

/*
** TextSetSelection
**	Sets the current selection. (modified from Xaw)
*/
#if NeedFunctionPrototypes
static void TextSetSelection(XeTextEdWidget, String *, Cardinal);
#endif
static void TextSetSelection(t, list, nelems)
XeTextEdWidget t;
String *list;
Cardinal nelems;
    {
	String defaultSel = "PRIMARY";

	if (nelems == 1 && !strcmp (list[0], "none"))
		return;
	if (nelems == 0)
	    {
		list = &defaultSel;
		nelems = 1;
	    }
	PostSelections(t, TextSelectionList(t,list,nelems), nelems);
    }

#if NeedFunctionPrototypes
static void StartMoving(XeTextEdWidget);
#endif
static void StartMoving(w)
XeTextEdWidget w;
    {
	InitRefreshRegion(w);
	if (w->text.inserting)
	    {
		Snip *s;
		long delta;

		s = _XeTextEndContent
			(w->text.inserting, w->texted.refresh, &delta);
		w->texted.cursor_location.snip = s;
		w->texted.cursor_location.offset = s ? VirtualLength(s) : 0;
		w->texted.cursor_position += delta;
		w->text.inserting = NULL;
		/*
		** If there were changes that require relayout, we now need
		** the full layout, as the position of changes has been lost
		*/
		if (w->texted.need_layout)
			w->texted.full_layout = True;
	    }
    }

#if NeedFunctionPrototypes
static void EndMoving(XeTextEdWidget);
#endif
static void EndMoving(w)
XeTextEdWidget w;
    {
	w->texted.mult = 1;
	DoRefreshRegion(w);
    }

/*
** AdjustSnipBeginning
**	adjusts the location to point the beginning of the equivalent
**	editable snip, if the current location is beyond the current Snip.
**	(Skip over empty snips, if any).
*/
static void AdjustSnipBeginning(dot)
XeTextLocation *dot;
    {
	Snip *s = dot->snip;

	if (s && dot->offset >= VirtualLength(s))
	    {
		while ((s = s->next) != NULL)
			if (IsEditableContent(s->mode.bits))
			    {
				dot->snip = s;
				dot->offset = 0;
				if (VirtualLength(s) > 0)
					break;
			    }
	    }
    }
/*
** AdjustSnipEnding
**	adjusts the location to point the end of the previous editable
**	snip, if the current location is at beginning of a Snip.
**	(Skip over empty snips, if any).
*/
static void AdjustSnipEnding(t, dot)
XeTextEdWidget t;
XeTextLocation *dot;
    {
	Snip *s = dot->snip;

	while (s && dot->offset == 0)
	    {
		if (s->back == &t->text.first)
		    {
			dot->snip = NULL;
			break;
		    }
		s = PreviousSnip(s);
		if (IsEditableContent(s->mode.bits))
		    {
			dot->snip = s;
			dot->offset = VirtualLength(s);
		    }
	    }
    }
/*
** AdjustSnipFirst
**	adjust the location to point the first editable Snip in the
**	content, if location is pointing to the beginning of the content.
*/
static void AdjustSnipFirst(t, dot)
XeTextEdWidget t;
XeTextLocation *dot;
    {
	Snip *s = dot->snip;

	if (s != NULL)
		return;
	dot->offset = 0;
	for (s = t->text.first; s; s = s->next)
		if (IsEditableContent(s->mode.bits))
		    {
			dot->snip = s;
			break;
		    }
    }
/*
** Scan
**	Find a new location within content starting from the current
**	cursor location.
*/
#if NeedFunctionPrototypes
static long Scan(XeTextEdWidget, XeTextUnit, int, XeTextLocation *);
#endif
static long Scan(w, move, dir, dot)
XeTextEdWidget w;	/* TextEd widget being operated */
XeTextUnit move;	/* Moving type */
int dir;		/* Moving amount and direction */
XeTextLocation *dot;	/* New Location after the scan */
    {
	Snip *s;
	XeTextTag tag;
	XPoint xy;
	int n, prev_space;
	long position;
	int amount = dir;

	if (w->text.inserting)
	    {
		long delta;

		_XeTextInsertLocation(w->text.inserting,dot,(Region)0, &delta);
		w->texted.cursor_position += delta;
	    }
	else
		*dot = w->texted.cursor_location;
	AdjustSnipFirst(w, dot);
	XeLocation2Coordinates(w, dot->snip, dot->offset, &xy);
	position = w->texted.cursor_position;	
	if ((s = dot->snip) == NULL)
		return position; /* No real content */
	AdjustSnipBeginning(dot);
	s = dot->snip;
	switch (move)
	    {
	    case XeTextUnit_POSITION:
		position -= dot->offset;
		amount += dot->offset;
		dot->offset = 0;
		/*
		** Move backwards one whole Snip at time until the position
		** requested is passed.
		*/
		while (amount < 0 && s->back != &w->text.first)
		    {
			s = PreviousSnip(s);
			if (IsEditableContent(s->mode.bits))
			    {
				n = VirtualLength(s);
				amount += n;
				position -= n;
				dot->snip = s;
			    }
		    }
		/*
		** Move forwards whole Snip at time until the position
		** requested is within current snip.
		*/
		while (amount > 0 && s)
		    {
			if (IsEditableContent(s->mode.bits))
			    {
				dot->snip = s;
				dot->offset = n = VirtualLength(s);
				if ((amount -= n) <= 0)
				    {
					dot->offset += amount;
					position += dot->offset;
					break;
				    }
				position += n;
			    }
			s = s->next;
		    }
		break;
	    case XeTextUnit_LINE_END:
		/*
		** Scan location to the end of line. End of line can either
		** be real or just result of the line breaking algorithm.
		*/
		position -= dot->offset;
		dot->offset = 0;
		for (prev_space = 0; s ; s = s->next)
		    {
			if (IsEditableContent(s->mode.bits))
			    {
				n = VirtualLength(s);
				position += n;
				dot->snip = s;
				dot->offset = n;
				prev_space = s->space;
			    }
			if (HasEndLine(s))
			    {
				if (IsEditableContent(s->mode.bits) ||
				    prev_space)
				    {
					/* Back over the NL or SPACE */
					position -= 1;
					dot->offset -= 1;
				    }
				break;
			    }
		    }
		break;
	    case XeTextUnit_LINE_BEGIN:
		position -= dot->offset;
		dot->offset = 0;
		while (s->back != &w->text.first)
		    {
			s = PreviousSnip(s);
			if (HasEndLine(s))
				break;
			if (IsEditableContent(s->mode.bits))
			    {
				position -= VirtualLength(s);
				dot->snip = s;
			    }
		    }
		break;
	    case XeTextUnit_ALL:
		position -= dot->offset;
		dot->offset = 0;
		if (amount < 0)
		    {
			position = 0;
			dot->snip = NULL;
		    }
		else while (s)
		    {
			if (IsEditableContent(s->mode.bits))
			    {
				n = VirtualLength(s);
				position += n;
				dot->offset = n;
				dot->snip = s;
			    }
			s = s->next;
		    }
		break;
	    case XeTextUnit_WORD:
#define IsWhiteSpace(s,o) ((s)->space || ((s)->endseq && (o) == (s)->length))
		if (amount >= 0)
		    {
			do
			    {
				/*
				** Skip white space
				*/
				while (s)
				    {
					if (!IsEditableContent(s->mode.bits))
					    {
						s = s->next;
						continue;
					    }
					dot->snip = s;
					if (!IsWhiteSpace(s, dot->offset))
						break;
					if (dot->offset == s->length)
					    {
						position += HasEndPosition(s);
						dot->offset = 0;
						s = s->next;
					    }
					else
					    {
						position += s->length -
							dot->offset;
						dot->offset = s->length;
					    }
				    }
				while (s)
				    {
					if (!IsEditableContent(s->mode.bits))
					    {
						s = s->next;
						continue;
					    }
					dot->snip = s;
					if (IsWhiteSpace(s, dot->offset))
						break;
					if (dot->offset == s->length)
					    {
						position += HasEndPosition(s);
						dot->offset = 0;
						s = s->next;
					    }
					else
					    {
						position += s->length
							- dot->offset;
						dot->offset = s->length;
					    }
				    }
			    } while (--amount > 0);
		    }
		else if (amount < 0)
		    {
			do
			    {
				/*
				** Skip white space backwards
				*/
				while (s)
				    {
					if (dot->offset == 0 || s->space)
					    {
						position -= dot->offset;
						dot->offset = 0;
						AdjustSnipEnding(w, dot);
						s = dot->snip;
						continue;
					    }
					if (s->endseq && s->length<dot->offset)
					    {
						position -= 1;
						dot->offset = s->length;
					    }
					else
						break;
				    }
				/*
				** Skip non-white space backwards
				*/
				while (s)
				    {
					if (dot->offset == 0)
					    {
						AdjustSnipEnding(w, dot);
						s = dot->snip;
						continue;
					    }
					if (s->space||(s->endseq &&
						       s->length<dot->offset))
						break;
					position -= dot->offset;
					dot->offset = 0;
				    }
			    } while (++amount < 0);
		    }
		/*
		** Finetune the location (does not affect the virtual
		** offset).
		*/
		if (dir > 0)
			AdjustSnipEnding(w, dot);
		else
			AdjustSnipBeginning(dot);
		break;
	    case XeTextUnit_LINE:
		/*
		** Pass over as many Snip_EndLine's as indicated by
		** amount.
		*/
		position -= dot->offset;
		dot->offset = 0;
		if (amount > 0)
			do
			    {
				if (IsEditableContent(s->mode.bits))
				    {
					n = VirtualLength(s);
					position += n;
					dot->snip = s;
					dot->offset = n;
				    }
				if (HasEndLine(s))
					amount -= 1;
				s = s->next;
			    }
			while (s && amount > 0);
		else if (amount < 0)
			while (s->back != &w->text.first)
			    {
				s = PreviousSnip(s);
				if (HasEndLine(s))
				    {
					amount += 1;
					if (amount > 0)
					    {
						s = s->next;
						break;
					    }
				    }
				if (IsEditableContent(s->mode.bits))
				    {
					n = VirtualLength(s);
					position -= n;
					dot->snip = s;
					dot->offset = 0;
				    }
			    }
		xy.x = w->texted.cursor_goal;
		xy.y = 0;
		/* ..following is brute force, check sometime! --msa */
		AdjustSnipBeginning(dot);
		position += FindPosition(w, &xy, dot);
		break;
	    case XeTextUnit_TAG:
		position -= dot->offset;
		tag = s->mode.tag;
		if (amount > 0)
			do
				if (IsEditableContent(s->mode.bits))
				    {
					if (s->mode.tag != tag)
					    {
						tag = s->mode.tag;
						if (--amount == 0)
							break;
					    }
					n = VirtualLength(s);
					position += n;
					dot->snip = s;
					dot->offset = n;
				    }
			while ((s = s->next) != NULL);
		else if (amount < 0)
		    {
			while (s->back != &w->text.first)
			    {
				s = PreviousSnip(s);
				if (IsEditableContent(s->mode.bits))
				    {
					if (s->mode.tag != tag)
					    {
						tag = s->mode.tag;
						if (++amount == 0)
							break;
					    }
					n = VirtualLength(s);
					position -= n;
					dot->snip = s;
					dot->offset = 0;
				    }
			    }
		    }
		break;
	    default:
		break;
	    }
	return position;
    }

static void Move(w, event, move, amount)
XeTextEdWidget w;
XEvent *event;
XeTextUnit move;
int amount;
    {
	long position;

	w->texted.time = NoteTime(event);
	StartMoving(w);
	amount *= w->texted.mult;
	if (move ==  XeTextUnit_POINT)
	    {
		XPoint p;

		NotePosition(w, event, &p);
		w->texted.cursor_location.snip = NULL;
		w->texted.cursor_location.offset = 0;
		AdjustSnipFirst(w, &w->texted.cursor_location);
		position = FindPosition(w, &p, &w->texted.cursor_location);
	    }
	else
		position = Scan(w, move, amount, &w->texted.cursor_location);
	if (position < 0)
	    {
		position = 0;
		w->texted.cursor_location.snip = NULL;
		w->texted.cursor_location.offset = 0;
		XBell(XtDisplay(w), 0);
	    }
	w->texted.cursor_position = position;
	UpdateCursorPosition(w, move != XeTextUnit_LINE, True, True);
	EndMoving(w);
    }

static void MoveForwardChar(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	Move((XeTextEdWidget)w, e, XeTextUnit_POSITION, 1);
    }

static void MoveBackwardChar(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	Move((XeTextEdWidget)w, e, XeTextUnit_POSITION, -1);
    }

static void MoveForwardWord(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	Move((XeTextEdWidget)w, e, XeTextUnit_WORD, 1);
    }

static void MoveBackwardWord(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	Move((XeTextEdWidget)w, e, XeTextUnit_WORD, -1);
    }

static void MoveToPointer(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	Move((XeTextEdWidget) w, e, XeTextUnit_POINT, 0);
    }

static void MoveToLineEnd(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	Move((XeTextEdWidget) w, e, XeTextUnit_LINE_END, 1);
    }

static void MoveToLineStart(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	Move((XeTextEdWidget) w, e, XeTextUnit_LINE_BEGIN, 1);
    }

static void MoveNextLine(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	Move((XeTextEdWidget) w, e, XeTextUnit_LINE, 1);
    }

static void MovePreviousLine(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	Move((XeTextEdWidget) w, e, XeTextUnit_LINE, -1);
    }

static void MoveBeginningOfFile(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	Move((XeTextEdWidget) w, e, XeTextUnit_ALL, -1);
    }

static void MoveEndOfFile(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	Move((XeTextEdWidget) w, e, XeTextUnit_ALL, 1);
    }

/*
** StartEditing
**	Prepare for editing the content.
**
**	Assumption: XEvent (e) is always NULL for programmatic modifications
**	and non-NULL for direct keyboard/mouse actions. If the allowEdit
**	resource has been set to False, keyboard/mouse modifying actions
**	are disabled.
**
**	Returns 0, if editing not started.
**	Returns 1, if editing started
*/
#if NeedFunctionPrototypes
static int StartEditing(XeTextEdWidget, int, XEvent *);
#endif
static int StartEditing(w, mode, e)
XeTextEdWidget w;
int mode;	/* Initial state mode */
XEvent *e;
    {
	XeTextModifyCallbackData data;
	data.reason = XeCR_MODIFY_TEXT;
	data.cancel = False;
	XtCallCallbackList
		((Widget)w, w->texted.modify_callbacks, (XtPointer)&data);
	if (data.cancel)
		return 0;	/* Callback cancelled start edit! */
	InitRefreshRegion(w);
	if (e)
		if (!w->texted.allow_edit)
		    {
			XBell(XtDisplay(w), 0);
			return 0;
		    }
		else
			w->texted.time = NoteTime(e);
	w->texted.need_layout = True;
	if (!w->text.inserting)
	    {
		AdjustSnipFirst(w, &w->texted.cursor_location);
		w->text.inserting = _XeTextInsertContent
			((XeTextWidget)w,
			 w->texted.cursor_location.snip,
			 w->texted.cursor_location.offset,
			 mode);
		if (w->texted.insert_prefix != NULL)
		    {
			_XeTextLock(w->text.inserting, FALSE);
			_XeTextFeedContent(w->text.inserting,
					   w->texted.insert_prefix,
					   w->texted.insert_prefix_length);
			_XeTextLock(w->text.inserting, TRUE);
		    }
	    }
	return 1;
    }

/*
** ChangeWidgetSize
**	Request resize of if the basic resize resource is set. However,
**	if grow = True, then request change only if size is larger.
*/
static void ChangeWidgetSize(w, grow)
XeTextEdWidget w;
int grow;
    {
	Dimension rw = w->text.w;
	Dimension rh = w->text.h;
	int do_almost = 1;

	if (w->basic.resize &&
	    (!grow || w->core.width < w->text.w || w->core.height < w->text.h))
	    {
		while (XtMakeResizeRequest((Widget)w, rw, rh, &rw, &rh)
		       == XtGeometryAlmost && do_almost)
			do_almost = 0;
	    }
    }

/*
** EndEditing
**	Is called after any operation that changes the content.
**	The deleted parameter
*/
#if NeedFunctionPrototypes
static void EndEditing(XeTextEdWidget, int);
#endif
static void EndEditing(w, deleted)
XeTextEdWidget w;
int deleted;
    {
	long ref, position;
	int i, n;
	
	w->texted.mult = 1;
	ref = w->texted.cursor_position;
	if (w->text.inserting)
	    {
		long delta;

		if (w->text.enable_display >= 0)
		    {
			_XeTextInsertLocation(w->text.inserting,
					      &w->texted.cursor_location,
					      w->texted.refresh, &delta);
			_XeTextLayout((XeTextWidget)w,
				      TEXT_SET_WIDTH(w),
				      /*
				      ** The beginning of text often gets
				      ** marked by NULL location pointer. Use
				      ** 'first' in that case to prevent
				      ** unnecessary total relayout...
				      */
				      w->texted.cursor_location.snip ?
				      w->texted.cursor_location.snip :
				      w->text.first,
				      w->texted.refresh);
			w->texted.need_layout = False;
			w->texted.full_layout = False;
			if (w->composite.num_children > 0)
				_XeTextConfigureChildren((XeTextWidget)w);
		    }
		else
			_XeTextInsertLocation(w->text.inserting,
					      &w->texted.cursor_location,
					      (Region)0, &delta);
		w->texted.cursor_position += delta;
	    }
	position = w->texted.cursor_position;
	/*
	** Do a feeble attempt to update text regions
	*/
	if (deleted < 0)
	    {
		deleted = -deleted;
		ref = position;
	    }
	for (n = w->texted.num_regions; --n >= 0;)
	    {
		XeTextRegion *r = &w->texted.regions[n];
		if (r->mode == XeTextHighlight_UNUSED)
			continue;
		for (i = 0; i < XtNumber(r->range); ++i)
			if (ref <= r->range[i])
				if (deleted == 0)
					r->range[i] +=
						w->texted.cursor_position-ref;
				else if (ref + deleted > r->range[i])
					r->range[i] = ref;
				else
					r->range[i] -= deleted;
		XeUpdateTextRegion(w, r, False); /* Should fine tune? --msa */
	    }
	ChangeWidgetSize(w, True); /* ..only if larger! */
	UpdateCursorPosition(w, True, True, True);
	DoRefreshRegion(w);
    }

/************************************************************
 *
 * Delete Routines.
 *
 ************************************************************/
#if NeedFunctionPrototypes
static void DeleteOrKill(XeTextEdWidget, XEvent *, XeTextUnit, int, int);
#endif

#define TEXT_KILL True		/* Used in function calls just for clarity */
#define TEXT_DELETE False

/*
** FreeSnipsAndReturnLength
**	Release a snip chain and return virtual length of the
**	released section.
*/
static int FreeSnipsAndReturnLength(s)
Snip *s;
    {
	int length = 0;
	while (s)
	    {
		if (IsEditableContent(s->mode.bits))
			length += VirtualLength(s);
		_XeDeleteSnip(&s);
	    }
	return length;
    }

/*
** DeleteOrKillRange
**	Remove a number of virtual chacters from the content.
**	Returns the *actual* number deleted (negative or positive
**	depending on the original direction of delete).
*/
static int DeleteOrKillRange(w, amount, kill)
XeTextEdWidget w;
int amount, kill;
    {
	Snip *s;
	XeTextLocation dot[2];
	TextSelectionStruct sel;

	s = _XeTextDeleteContent(w->text.inserting, amount);
	if (kill)
	    {
		sel.w = w;
		sel.length = 0;
		sel.size = 0;
		sel.data = 0;
		dot[0].snip = s;
		dot[0].offset = 0;
		dot[1].snip = NULL;
		dot[1].offset = 0;
		XeTextExtractContent((XeTextWidget)w, &dot[0], &dot[1],
				     w->text.export_format, FeedSelect,
				     (XtPointer)&sel);
		if (sel.length > 0)
			XStoreBuffer(XtDisplay(w), sel.data, sel.length, 1);
		XtFree(sel.data);
	    }
	kill = FreeSnipsAndReturnLength(s);
	return amount > 0 ? kill : -kill;
    }

static void DeleteOrKill(w, event, move, amount, kill)
XeTextEdWidget w;
XEvent *event;
XeTextUnit move;
int amount, kill;
    {
	long end;
	XeTextLocation dot;

	if (!StartEditing(w, XeTextInsertMode_CURRENT, event))
		return;
	amount *= w->texted.mult;
	end = Scan(w, move, amount, &dot);
	if (move == XeTextUnit_LINE_END && end == w->texted.cursor_position)
		end += 1;	/* Special handling for KILL to END LINE */
	amount = DeleteOrKillRange(w, end - w->texted.cursor_position, kill);
	EndEditing(w, amount);
    }

static void DeleteForwardChar(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	DeleteOrKill((XeTextEdWidget)w, e, XeTextUnit_POSITION,1,TEXT_DELETE);
    }

static void DeleteBackwardChar(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
#if IM_XCIN
	char chstr[80];
	if (send_key(XtDisplay(w), XtWindowOfObject(w), &e->xkey, chstr))
		return;
#endif
	DeleteOrKill((XeTextEdWidget)w, e, XeTextUnit_POSITION,-1,TEXT_DELETE);
    }

static void DeleteForwardWord(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	DeleteOrKill((XeTextEdWidget)w, e, XeTextUnit_WORD, 1, TEXT_DELETE);
    }

static void DeleteBackwardWord(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	DeleteOrKill((XeTextEdWidget)w, e, XeTextUnit_WORD, -1, TEXT_DELETE);
    }

static void KillForwardWord(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	DeleteOrKill((XeTextEdWidget) w, e, XeTextUnit_WORD, 1, TEXT_KILL);
    }

static void KillBackwardWord(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	DeleteOrKill((XeTextEdWidget)w, e, XeTextUnit_WORD, -1, TEXT_KILL);
    }

static void KillToEndOfLine(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	DeleteOrKill((XeTextEdWidget)w, e, XeTextUnit_LINE_END, 1, TEXT_KILL);
    }

static void KillToEndOfParagraph(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	DeleteOrKill((XeTextEdWidget)w, e, XeTextUnit_PARAGRAPH, 1, TEXT_KILL);
    }

#if NeedFunctionPrototypes
static void TextZapSelection(XeTextEdWidget, XEvent *, int);
#endif

static void TextZapSelection(w, event, kill)
XeTextEdWidget w;
XEvent *event;
int kill;
    {
	int amount;
	XPoint xy;

	w->texted.time = NoteTime(event);
	if (w->texted.regions[0].range[0] == w->texted.regions[0].range[1])
		return;
	/*
	** Move current insertion point to one end of the selection range
	*/
	StartMoving(w);
	w->texted.cursor_position = w->texted.regions[0].range[0];
	XeOffset2Locations(w, &w->texted.cursor_position, 1,
			   &w->texted.cursor_location, &xy);
	EndMoving(w);
	if (!StartEditing(w, XeTextInsertMode_CURRENT, event))
		return;
	amount = w->texted.regions[0].range[1] - w->texted.cursor_position;
	amount = DeleteOrKillRange(w, amount, kill);
	w->texted.regions[0].range[0] = w->texted.regions[0].range[1] = 0;
	XeUpdateTextRegion(w, &w->texted.regions[0], False);
	EndEditing(w, amount);
    }

static void KillCurrentSelection(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	TextZapSelection((XeTextEdWidget)w, e, TEXT_KILL);
    }

static void DeleteCurrentSelection(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	TextZapSelection((XeTextEdWidget)w, e, TEXT_DELETE);
    }

/************************************************************
 *
 * Insertion Routines.
 *
 ************************************************************/

static void InsertNewLineAndBackup(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	XeTextEdWidget t = (XeTextEdWidget)w;
	XPoint xy;
	int count;
	long save;

	if (!StartEditing(t, XeTextInsertMode_CURRENT, e))
		return;
	save = t->texted.cursor_position;
	for (count = 0 ; count < t->texted.mult ; count++)
		_XeTextFeedContent(t->text.inserting, "\r\n", 2);
	EndEditing(t, 0);
	/*
	** Must simulate cursor movement action (basicly, must
	** close the insert state).
	*/
	StartMoving(t);
	XeOffset2Locations(t, &save, 1, &t->texted.cursor_location, &xy);
	t->texted.cursor_position = save;
	UpdateCursorPosition(t, True, True, True);
	EndMoving(t);
    }

static void InsertNewLine(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	XeTextEdWidget t = (XeTextEdWidget)w;
	int count;

	if (!StartEditing(t, XeTextInsertMode_CURRENT, e))
		return;
	for (count = 0 ; count < t->texted.mult ; count++)
		_XeTextFeedContent(t->text.inserting, "\r\n", 2);
	EndEditing(t, 0);
    }

/************************************************************
 *
 * Selection Routines.
 *
 *************************************************************/

typedef enum
    {
	XeSelectionStart,
	XeSelectionEnd,
	XeSelectionExtendStart,
	XeSelectionMove
    } XeSelectionType;

static void SelectWord(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	XeTextEdWidget t = (XeTextEdWidget) w;

	t->texted.time = NoteTime(e);
	StartMoving(t);
	EndMoving(t);
    }

static void SelectAll(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	XeTextEdWidget t = (XeTextEdWidget)w;
	
	t->texted.time = NoteTime(e);
	StartMoving(t);
	t->texted.regions[0].range[0] = 0;
	t->texted.regions[0].range[1] = LONG_MAX;
	XeUpdateTextRegion(t, &t->texted.regions[0], False);
	EndMoving(t);
    }

static void ModifySelection(t, event, mode, par, num_par)
XeTextEdWidget t;
XEvent *event;
int mode;
String *par;
Cardinal *num_par;
    {
	XPoint p;
	long position;
	long a, b;
	XeTextLocation dot;

	t->texted.time = NoteTime(event);
	InitRefreshRegion(t);
	NotePosition(t, event, &p);
	dot.snip = NULL;
	dot.offset = 0;
	AdjustSnipFirst(t, &dot);
	position = FindPosition(t, &p, &dot);
	switch (mode)
	    {
	    case XeSelectionStart:
		XeTextUnsetSelection((Widget)t);
		t->texted.regions[0].range[0] = t->texted.regions[0].range[1] =
			position;
		break;
	    case XeSelectionExtendStart:
		a = position - t->texted.regions[0].range[0];
		b = position - t->texted.regions[0].range[1];
		if (abs(b) > abs(a))
			t->texted.regions[0].range[0] =
				t->texted.regions[0].range[1];
		t->texted.regions[0].range[1] = position;
		break;
	    case XeSelectionMove:
		t->texted.regions[0].range[1] = position;
		break;
	    case XeSelectionEnd:
		t->texted.regions[0].range[1] = position;
		if (t->texted.regions[0].range[0] == position)
		    {
			if (position != t->texted.cursor_position ||
			    t->texted.cursor_location.snip != dot.snip)
			    {
				/* ..because StartMoving actually closes
				   the insertion point, this is done only
				   if position has really changed. This is
				   a kludge that doesn't really work, because
				   insert point gets closed in so many other
				   ways too, even if cursor is not moved!!!
				   Need to re-think the concept --msa */
				StartMoving(t);
				t->texted.cursor_position = position;
				t->texted.cursor_location = dot;
				UpdateCursorPosition(t, True, True, True);
				EndMoving(t);
			    }
		    }
		else
			TextSetSelection(t, par, *num_par);
		break;
	    default:
		break;
	    }
	XeUpdateTextRegion(t, &t->texted.regions[0], True);
	DoRefreshRegion(t);
    }

static void SelectStart(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	ModifySelection((XeTextEdWidget)w, e, XeSelectionStart, p, n);
    }

static void SelectAdjust(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	ModifySelection((XeTextEdWidget)w, e, XeSelectionMove, p, n);
    }

static void SelectEnd(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	ModifySelection((XeTextEdWidget)w, e, XeSelectionEnd, p, n);
    }

static void ExtendStart(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	ModifySelection((XeTextEdWidget)w, e, XeSelectionExtendStart, p, n);
    }

static void ExtendAdjust(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	ModifySelection((XeTextEdWidget)w, e, XeSelectionMove, p, n);
    }

static void ExtendEnd(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	ModifySelection((XeTextEdWidget)w, e, XeSelectionEnd, p, n);
    }

/************************************************************
 *
 * Misc. Routines.
 *
 ************************************************************/

static void RedrawDisplay(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	XeTextDisplay(w);
    }

static void TextFocusIn (w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
#if IM_XCIN
	send_FocusIn(XtDisplay(w), XtWindowOfObject(w));
#endif
    }

static void TextFocusOut(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
    }

static XComposeStatus compose_status = {NULL, 0};

static void InsertChar(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	XeTextEdWidget ctx = (XeTextEdWidget) w;
	char strbuf[BUFSIZ];
	int count;
	KeySym keysym;
	int length;

	if ((length = XLookupString (&e->xkey, strbuf, BUFSIZ,
				     &keysym, &compose_status)) == 0)
		return;
#if IM_XCIN
	    {
		unsigned char chstr[BUFSIZ];

		if (send_key(XtDisplay(w),XtWindowOfObject(w),&e->xkey,chstr))
			if  (chstr[0])
			    {
				strcpy(strbuf, (char *)chstr);
				length = strlen((char *)chstr);
			    }
			else
				return;
	    }
#endif
	if (!StartEditing(ctx, XeTextInsertMode_CURRENT, e))
		return;
	for (count = 0 ; count < ctx->texted.mult ; count++)
		_XeTextFeedContent(ctx->text.inserting, strbuf, length);
	EndEditing(ctx, 0);
    }

static void InsertString(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	XeTextEdWidget ctx = (XeTextEdWidget) w;
	int i;

	if (!StartEditing(ctx, XeTextInsertMode_CURRENT, e))
		return;
	for (i = *n; i; i--, p++)
	    {
		unsigned char hexval;
		if ((*p)[0] == '0' &&
		    (*p)[1] == 'x' && (*p)[2] != '\0')
		    {
			char c, *s;
			hexval = 0;
			for (s = *p+2; (c = *s); s++)
			    {
				hexval *= 16;
				if (c >= '0' && c <= '9')
					hexval += c - '0';
				else if (c >= 'a' && c <= 'f')
					hexval += c - 'a' + 10;
				else if (c >= 'A' && c <= 'F')
					hexval += c - 'A' + 10;
				else break;
			    }
			if (c == '\0')
				_XeTextFeedContent(ctx->text.inserting,
						   (char *)&hexval, 1L);
			else
				_XeTextFeedContent(ctx->text.inserting,
						   *p, strlen(*p));
		    }
		else
			_XeTextFeedContent(ctx->text.inserting,*p,strlen(*p));
	    }
	EndEditing(ctx, 0);
    }

static void DisplayCaret(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	XeTextEdWidget ctx = (XeTextEdWidget)w;
	Boolean display_caret = True;
	
	if (e->type == EnterNotify || e->type == LeaveNotify)
	    {
		/* for Crossing events, the default case is to check the focus
		** field and only change the caret when focus==True.  A second
		** argument of "always" will cause the focus field to be
		** ignored.
		*/
		Boolean check_focus = True;
		if (*n == 2 && strcmp(p[1], "always") == 0)
			check_focus = False;
		if (check_focus && !e->xcrossing.focus)
			return;
	    }
	
	if (*n > 0)
	    {
		/* default arg is "True" */
		XrmValue from, to;
		from.size = strlen(from.addr = p[0]);
		XtConvert(w, XtRString, &from, XtRBoolean, &to);
		if (to.addr != NULL)
			display_caret = *(Boolean*)to.addr;
		if (ctx->texted.display_caret == display_caret)
			return;
	    }
	if (ctx->texted.display_caret != display_caret)
	    {
		/* State has really changed */
		InitRefreshRegion(ctx);
		ctx->texted.display_caret = display_caret;
		UpdateCursorPosition(ctx, False, True, False);
		DoRefreshRegion(ctx);
	    }
    }

/*
** Multiply (from MIT Athena TextAction.c)
**	Multiplies the current action by the number passed.
**
**	The parameter list may contain either a number or the string 'Reset'.
**
**	A number will multiply the current multiplication factor by that
**	number. Many of the text widget actions will will perform n actions,
**	 where n is the multiplication factor.
**
**	The string reset will reset the mutiplication factor to 1.
*/
static void Multiply(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	XeTextEdWidget ctx = (XeTextEdWidget) w;
	int mult;
	
	if (*n != 1)
	    {
		XeWidgetWarningMsg
			(w, "bugTextEdActionError",
			 "The multiply action takes exactly one argument.",
			 (String *)NULL, 0);
		XBell(XtDisplay(w), 0);
		return;
	    }
	
	if ( (p[0][0] == 'r') || (p[0][0] == 'R') ) 
	    {
		XBell(XtDisplay(w), 0);
		ctx->texted.mult = 1;
		return;
	    }
	
	if ( (mult = atoi(p[0])) == 0 )
	    {
		XeWidgetWarningMsg
			(w, "bugTextEdActionError",
"The multiply action's argument must be a number greater than zero, or 'Reset'.",
			 (String *)NULL, 0);
		XBell(XtDisplay(w), 0);
		return;
	    }
	
	ctx->texted.mult *= mult;
    }

/*	Function Name: TransposeCharacters
 *	Description: Swaps the character to the left of the mark with
 *                   the character to the right of the mark.
 *	Arguments: w - the text widget.
 *                 event - the event that cause this action.
 *                 params, num_params *** NOT USED ***.
 *	Returns: none.
 */

static void TransposeCharacters(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	XeTextEdWidget t = (XeTextEdWidget)w;

	t->texted.time = NoteTime(e);
	StartMoving(t);
	EndMoving(t);
    }

static void MoveForwardParagraph(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
    }

static void MoveBackwardParagraph(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
    }

/*
** *************************************************************
** First cract at..
** Selection/paste processing modified from Athena Xaw3d sources..
** *************************************************************
*/
struct SelectionList
    {
	String *params;
	Cardinal count;
	Time time;
    };

static void GetSelection();

/*
** (XtSelectionCallbackProc)
*/
static void SelectionReceived(w,client_data,selection,type,value,length,format)
Widget w;
XtPointer client_data;
Atom *selection, *type;
XtPointer value;
unsigned long *length;
int *format;
    {
	XeTextEdWidget t = (XeTextEdWidget)w;

	if (*type == 0 /*XT_CONVERT_FAIL*/ || *length == 0)
	    {
		struct SelectionList* list =
			(struct SelectionList *)client_data;
		if (list != NULL)
			GetSelection(w, list->time, list->params, list->count);
	    }
	else
	    {
		XeImportCallbackData data;

		data.reason = XeCR_IMPORT;
		data.selection = *selection;
		data.type = *type;
		data.value = value;
		data.length = *length;
		data.format = *format;
		if (t->basic.import_callbacks)
		    {
			/*
			** If the import callback decides to deal with the
			** content, it *must* modify the callback data
			** and set data.value to NULL (and it must take
			** care of releasing the value with XFree when it
			** doesn't need it anymore).
			*/
			XtCallCallbackList
				(w,t->basic.import_callbacks,(XtPointer)&data);
			value = data.value;
		    }
		if (data.value != NULL && data.length > 0 &&
		    StartEditing(t, XeTextInsertMode_CURRENT, (XEvent *)NULL))
		    {
			_XeTextFeedContent(t->text.inserting,
					   (char *)data.value,
					   (int)((data.length*data.format)/8));
			EndEditing(t, 0);
		    }
	    }
	XtFree(client_data);
	XFree(value);	/* the selection value should be freed with XFree */
    }

static void GetSelection(w, time, params, num_params)
Widget w;
Time time;
String *params;			/* selections in precedence order */
Cardinal num_params;
    {
	Atom selection;
	int buffer =  0;
	
	selection = XInternAtom(XtDisplay(w), *params, False);
	switch (selection)
	    {
	    case XA_CUT_BUFFER7: ++buffer;
	    case XA_CUT_BUFFER6: ++buffer;
	    case XA_CUT_BUFFER5: ++buffer;
	    case XA_CUT_BUFFER4: ++buffer;
	    case XA_CUT_BUFFER3: ++buffer;
	    case XA_CUT_BUFFER2: ++buffer;
	    case XA_CUT_BUFFER1: ++buffer;
	    case XA_CUT_BUFFER0:
		    {
			int nbytes;
			unsigned long length;
			Atom type = XA_STRING;
			int fmt8 = 8;
			char *line = XFetchBuffer(XtDisplay(w),&nbytes,buffer);

			if ((length = nbytes))
				SelectionReceived(w, (XtPointer)NULL,
						  &selection, &type,
						  (XtPointer)line, &length,
						  &fmt8);
			else if (num_params > 1)
				GetSelection(w, time, params+1, num_params-1);
		    }
		break;
	    default:
		    {
			Display *d = XtDisplay(w);
			struct SelectionList* list;
			if (--num_params)
			    {
				list = XtNew(struct SelectionList);
				list->params = params + 1;
				list->count = num_params;
				list->time = time;
			    }
			else
				list = NULL;
			XtGetSelectionValue(w, selection, XA_TEXT(d),
					    SelectionReceived,
					    (XtPointer)list, time);
		    }
		break;
	    }
    }

static void InsertSelection(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	if (((XeTextEdWidget)w)->texted.allow_edit)
		GetSelection(w, NoteTime(e), p, *n);
	else
		XBell(XtDisplay(w), 0);
    }

/*
** NoOp (from MIT Athena Xaw)
**
**	This action performs no action, and allows the user or
**	application programmer to unbind a translation.
**
** Note: If the parameter list contains the string "RingBell" then
**       this action will ring the bell.
*/
static void NoOp(w, e, p, n)
Widget w; XEvent *e; String *p; Cardinal *n;
    {
	if (*n != 1)
		return;
	
	switch(p[0][0])
	    {
	    case 'R':
	    case 'r':
		XBell(XtDisplay(w), 0);
	    default:			/* Fall Through */
		break;
	    }
    }

/*
** *************************
** COMPOSITE WIDGET HANDLING
** *************************
*/
/*
** InsertChild
**	this function is here so that the current position can be utilized.
**	(the superclass (XeText) does not know about current position. This
**	InsertChild first makes insert state is open and then calls the
**	superclass function.).
*/
static void InsertChild(w)
register Widget w;
    {
	XeTextEdWidget t = (XeTextEdWidget)XtParent(w);

	StartEditing(t, XeTextInsertMode_RESET, (XEvent *)NULL);
	/*
	** insert the child widget in the composite children list with the
	** superclass insert_child routine.
	*/
	(*superclass->composite_class.insert_child)(w);
	EndEditing(t, 0);
    }

/*
** User callable convenience function support
** ==========================================
*/

/*
** IsTextEdWidget
**	Returns True, if the widget is of class xeTextEd and
**	False otherwise (also, a warning message is generated).
*/
static int IsTextEdWidget(w)
Widget w;
    {
	String params[2];

	if (XtIsSubclass(w, xeTextEdWidgetClass))
		return True;
	params[0] = w->core.name;
	params[1] = w->core.widget_class->core_class.class_name;
	XeWidgetWarningMsg
		(w, "bugTextEdNotTextEd",
		 "Widget %s is class %s, and not xeTextEdWidget",
		 (String *)params, (Cardinal)2);
	return False;
    }

/*
** XeTextDisplay
**	Redo all layout and force redisplay of the content
*/
void XeTextDisplay(w)
Widget w;
    {
	XeTextEdWidget t = (XeTextEdWidget)w;

	if (t->text.inserting)
	    {
		/*
		** Discard cumulated expose area from the insert point
		** (to prevent unnecessary refreshes at some later point).
		*/
		Region tmp = XCreateRegion();
		_XeTextInsertLocation(t->text.inserting,
				      &t->texted.cursor_location,
				      tmp, (long *)NULL);
		XDestroyRegion(tmp);
	    }
	_XeTextLayout((XeTextWidget)t, TEXT_SET_WIDTH(t),
		      (Snip *)NULL, (Region)NULL);
	ChangeWidgetSize(t, False);
	_XeTextConfigureChildren((XeTextWidget)t);
	t->texted.need_layout = False;
	t->texted.full_layout = False;
	UpdateCursorPosition(t, False, False, False);
	UpdateTextRegions(t, False);
	Redisplay(w, (XExposeEvent *)NULL, (Region)0);
    }

/*
** XeTextDisableDisplay
**	Disable all display updates and layout while the content is
**	being changed (expose events are processed, possibly using
**	out of date information).
**
**	This function can be called multiple times and updates and
**	layout starts to happen only when matching number of
**	XeTextEnableDisplay calls have been made.
*/
void XeTextDisableDisplay(w)
Widget w;
    {
	if (IsTextEdWidget(w))
		((XeTextEdWidget)w)->text.enable_display -= 1;
    }

/*
** XeTextEnableDisplay
**	Re-enable layout and display update processing.
*/
void XeTextEnableDisplay(w)
Widget w;
    {
	XeTextEdWidget t = (XeTextEdWidget)w;

	if (IsTextEdWidget(w) && (t->text.enable_display += 1) == 0)
		if (t->texted.full_layout)
			XeTextDisplay(w);
		else
		    {
			/*
			** This branch does what has been left undone
			** in EndEditing due to disabled display.
			*/
			InitRefreshRegion(t);
			if (t->text.inserting)
				/*
				** Need to pull the refresh area from the
				** insert point too (should not cause any
				** change to the cursor the location!!)
				*/
				_XeTextInsertLocation
					(t->text.inserting,
					 &t->texted.cursor_location,
					 t->texted.refresh, (long *)NULL);
			_XeTextLayout((XeTextWidget)t, TEXT_SET_WIDTH(t),
				      t->texted.cursor_location.snip ?
				      t->texted.cursor_location.snip :
				      t->text.first,
				      t->texted.refresh);
			t->texted.need_layout = False;
			t->texted.full_layout = False;
			if (t->composite.num_children > 0)
				_XeTextConfigureChildren((XeTextWidget)t);
			ChangeWidgetSize(t, True); /* ..only if larger! */
			UpdateCursorPosition(t, False, True, False);
			UpdateTextRegions(t, False);
			DoRefreshRegion(t);
		    }
    }

/*
** FeedFile
**	Routine to write exported data to file.
*/
#if NeedFunctionPrototypes
static int FeedFile(char *, int, XeTextTag, XtPointer);
#endif
static int FeedFile(data, length, tag, client_data)
char *data;
int length;
XeTextTag tag;
XtPointer client_data;
    {
	return length > 0 ? fwrite(data, 1, length, (FILE *)client_data) : 0;
    }

/*
** XeTextSaveAsFile
**	Save the current content of the Text widget into a file. The format
**	of the exported file is determined from by the 'exportFormat'
**	resource (text.export_format). Returns True, if save succeeds
**	and False otherwise.
*/
Boolean XeTextSaveAsFile(w, name)
Widget w;
String name;
    {
	XeTextEdWidget t = (XeTextEdWidget)w;
	XeTextLocation dot[2];
	FILE *fp;

	if (!IsTextEdWidget(w))
		return False;
	if (name == NULL)
	    {
		XeWidgetWarningMsg
			((Widget)t, "noteTextEdNoFilename",
			 "No filename given",
			 (String *)NULL, (Cardinal)0);
		return False;
	    }
	if ((fp = fopen(name, "wb")) == NULL)
	    {
		XeWidgetWarningMsg
			((Widget)t, "noteTextEdCannotWrite",
			 "Cannot write to file %s",
			 (String *)&name, (Cardinal)1);
		return False;
	    }
	dot[0].snip = t->text.first;
	dot[0].offset = 0;
	dot[1].snip = NULL;
	dot[1].offset = 0;
	XeTextExtractContent((XeTextWidget)t, &dot[0], &dot[1],
			     t->text.export_format, FeedFile, (XtPointer)fp);
	fclose(fp);
	return True;
    }

/*
** XeTextGetString
**	Save the current content of the Text widget into a String. The format
**	of the exported data is determined from by the 'exportFormat'
**	resource (text.export_format). Returns a pointer to the allocated
**	String. The actual length of the string is returned into long
**	integer 'length' (if non-NULL).
**
**	Application must release the returned string with XtFree.
**
**	For convenience, the actual memory allocation is 'length+1' and this
**	extra byte is set to NUL. In simple applications, the returned value
**	can often be treated as NUL terminated string and the length return
**	ignored.
*/
String XeTextGetString(w, length)
Widget w;
long *length;
    {
	XeTextEdWidget t = (XeTextEdWidget)w;
	XeTextLocation dot[2];
	TextSelectionStruct s;

	if (!IsTextEdWidget(w))
		return NULL;
	s.w = t;
	s.length = 0;
	s.size = 0;
	s.data = 0;
	dot[0].snip = t->text.first;
	dot[0].offset = 0;
	dot[1].snip = NULL;
	dot[1].offset = 0;
	XeTextExtractContent((XeTextWidget)t, &dot[0], &dot[1],
			     t->text.export_format, FeedSelect, (XtPointer)&s);
	if (length)
		*length = s.length;
	if (s.length)
	    {
		s.data = XtRealloc(s.data, s.length + 1);
		*((char *)s.data + s.length) = 0;
	    }
	return (String)s.data;
    }

/*
** XeTextGetSubstring
**	Same as XeTextGetString, except only characters between the given
**	character positions are returned.
*/
String XeTextGetSubstring(w, length, start, end)
Widget w;
long *length, start, end;
    {
	XeTextEdWidget t = (XeTextEdWidget)w;
	XeTextLocation dot[2];
	XPoint xy[2];
	long range[2];
	TextSelectionStruct s;

	if (!IsTextEdWidget(w))
		return NULL;
	s.w = t;
	s.length = 0;
	s.size = 0;
	s.data = 0;
	range[0] = start;
	range[1] = end;
	XeOffset2Locations(t, range, 2, dot, xy);
	XeTextExtractContent((XeTextWidget)t, &dot[0], &dot[1],
			     t->text.export_format, FeedSelect, (XtPointer)&s);
	if (length)
		*length = s.length;
	if (s.length)
	    {
		s.data = XtRealloc(s.data, s.length + 1);
		*((char *)s.data + s.length) = 0;
	    }
	return (String)s.data;
    }

/*
** XeTextExtract
**	Extract a range of characters from the content using the supplied
**	callback function.
*/
void XeTextExtract(w, start, end, feed, client_data)
Widget w;
long start, end;
XeTextExtractFeed feed;
XtPointer client_data;
    {
	XeTextEdWidget t = (XeTextEdWidget)w;
	XeTextLocation dot[2];
	XPoint xy[2];
	long range[2];

	if (!IsTextEdWidget(w))
		return;
	range[0] = start;
	range[1] = end;
	XeOffset2Locations(t, range, 2, dot, xy);
	XeTextExtractContent((XeTextWidget)t, &dot[0], &dot[1],
			     t->text.export_format, feed, client_data);
    }

/*
** XeTextReplaceTagged
**	Replace content of the text widget between positions (start, end)
**	with new the content. This can be used inserting text by having
**	start == end. The new content will have the specified tag value.
**
**	Insert position will be at the end of the inserted text.
**
**	This function will unconditionally open a new insert context (it
**	will terminate any old one first) and leave it open.
**
*/
void XeTextReplaceTagged(w, start, end, value, length, tag)
Widget w;
long start, end;
char *value;
long length;
XeTextTag tag;
    {
	XeTextEdWidget t = (XeTextEdWidget)w;
	int amount;
	XPoint xy[2];
	XeTextLocation dot[2];
	long range[2];

	if (!IsTextEdWidget(w))
		return;
	/*
	** Simulate a move to the replace position
	*/
	StartMoving(t);
	/*
	** Set new cursor position from 'start'
	*/
	range[0] = start;
	range[1] = end;
	XeOffset2Locations(t, range, 2, dot, xy);
	t->texted.cursor_location = dot[0];
	t->texted.cursor_position = range[0];
	EndMoving(t);
	/*
	** Do the actual replace/insert
	*/
	if (!StartEditing(t, XeTextInsertMode_RESET, (XEvent *)NULL))
		return;
	amount = range[1] - t->texted.cursor_position;
	if (amount > 0)
	    {
		Snip *s;

		s = _XeTextDeleteContent(t->text.inserting, amount);
		amount = FreeSnipsAndReturnLength(s);
	    }
	else
		amount = 0;
	(void)_XeTextSetTag(t->text.inserting, tag);
	if (length > 0 && value)
		_XeTextFeedContent(t->text.inserting, value, length);
	EndEditing(t, amount);
    }

/*
** XeTextInsert
**	inserts a string into current insertion point (an insertion state is
**	opened with defaults, if none is previously open. This function can
**	be used to add more input to the insertion point opened earlier, it
**	does not cause the input state being reset from the initial state
**	like XeTextReplace[Tagged] does.
*/
void XeTextInsert(w, value, length)
Widget w;
char *value;
long length;
    {
	XeTextEdWidget t = (XeTextEdWidget)w;
	if (!IsTextEdWidget(w))
		return;
	if (!StartEditing(t, XeTextInsertMode_CURRENT, (XEvent *)NULL))
		return;
	if (length > 0 && value)
		_XeTextFeedContent(t->text.inserting, value, length);
	EndEditing(t, 0);
    }
/*
** XeTextSetInsertionPosition
**	move the current insert (cursor) position to the specified
**	position. Current insert point is closed, if it is open.
*/
void XeTextSetInsertionPosition(w, position)
Widget w;
long position;
    {
	XeTextEdWidget t = (XeTextEdWidget)w;
	XPoint xy;

	if (!IsTextEdWidget(w))
		return;

	StartMoving(t);
	XeOffset2Locations(t, &position, 1, &t->texted.cursor_location, &xy);
	UpdateCursorPosition(t, False, True, True);
	EndMoving(t);
    }

/*
** XeTextSetInsertionTag
**	changes the current Tag at insertion point (an insertion state is
**	opened with defaults, if non is previously open. This function can
**	can be used to change the Tag on insertion point openened earlier,
**	it does not cause the input state being reset from the initial state
**	like XeTextReplace[Tagged] does. (This is companion function to the
**	XeTextInsert).
*/
void XeTextSetInsertionTag(w, tag)
Widget w;
XeTextTag tag;
    {
	XeTextEdWidget t = (XeTextEdWidget)w;
	if (!IsTextEdWidget(w))
		return;
	if (!StartEditing(t, XeTextInsertMode_CURRENT, (XEvent *)NULL))
		return;
	(void)_XeTextSetTag(t->text.inserting, tag);
	EndEditing(t, 0);
    }

/*
** XeTextReplace
**	Replace content of the text widget between positions (start, end)
**	with new the content. This can be used inserting text by having
**	start == end.
**
**	Insert position will be at the end of the inserted text.
**
*/
void XeTextReplace(w, start, end, value, length)
Widget w;
long start, end;
char *value;
long length;
    {
	XeTextReplaceTagged(w, start, end, value, length, (XeTextTag)0);
    }

/*
** XeTextInsertPrefix
**	defines a control string that will be executed every time
**	an insert point is opened, before any other data is inserted.
**	The graphic rendition modes set by this sequence will be locked
**	in same way as initialState modes (insertPrefix can be used to
**	override initialState).
*/
void XeTextInsertPrefix(w, value, length)
Widget w;
char *value;
long length;
    {
	XeTextEdWidget t = (XeTextEdWidget)w;
	if (!IsTextEdWidget(w))
		return;
	/*
	** Need to close the insert point to make the change effective
	** immediate.
	*/
	StartMoving(t);
	EndMoving(t);
	XtFree(t->texted.insert_prefix);
	if (value && length > 0)
	    {
		t->texted.insert_prefix = (char *)XtMalloc((int)length);
		t->texted.insert_prefix_length = length;
		memcpy(t->texted.insert_prefix, value, (int)length);
	    }
	else
	    {
		t->texted.insert_prefix = NULL;
		t->texted.insert_prefix_length = 0;
	    }
    }

/*
** XeTextGetInsertionPoint
**	Return the current insert position.
*/
long XeTextGetInsertionPoint(w)
Widget w;
    {
	if (!IsTextEdWidget(w))
		return 0;
	return ((XeTextEdWidget)w)->texted.cursor_position;
    }

/*
** XeTextGetInsertionTag
**	Return the current value of tag at insertion point.
*/
XeTextTag XeTextGetInsertionTag(w)
Widget w;
    {
	XeTextEdWidget t = (XeTextEdWidget)w;

	if (!IsTextEdWidget(w))
		return 0;
	if (t->text.inserting)
		return _XeTextGetTag(t->text.inserting);
	else if (t->texted.cursor_location.snip)
		return t->texted.cursor_location.snip->mode.tag;
	return 0;
    }
/*
** XeTextScan
**	scans forward or backward an amount of text units starting from 
**	the current insert point. Returns the virtual offset value. Does
**	not move or change the state of the current insertion point.
*/
long XeTextScan(w, unit, amount)
Widget w;
XeTextUnit unit;	/* What kind of things to scan */
int amount;		/* Number of units to scan and direction */
    {
	XeTextEdWidget t = (XeTextEdWidget)w;
	XeTextLocation dot;

	if (!IsTextEdWidget(w))
		return -1;
	return Scan(t, unit, amount, &dot);
    }
/*
** XeTextLocateTag
**	Starting from the specified position, search for a specified
**	Tag (or a Tag different from it). This function does not change
**	the current insert point.
**
**	mode == 1,	search matching tag
**	mode == 0,	search non-matching tag
**
**	Returns offset, or -1 if search fails.
*/
long XeTextLocateTag(w, position, tag, mode)
Widget w;
long position;	/* Start point of the search. */
XeTextTag tag;	/* Tag to be tested */
int mode;	/* Test type: equal or not-equal */
    {
	XeTextEdWidget t = (XeTextEdWidget)w;
	XeTextLocation dot;
	XPoint xy;
	Snip *s;

	if (position < 0 || !IsTextEdWidget(w))
		return -1;

	XeOffset2Locations(t, &position, 1, &dot, &xy);
	s = dot.snip;
	if (s == NULL || dot.offset >= VirtualLength(s))
		return -1;
	/*
	** Only the starting point can be in the middle of the Snip,
	** make special case for it..
	*/
	if (dot.offset > 0)
	    {
		if ((s->mode.tag == tag) == mode)
			return position;
		position -= dot.offset;
	    }
	/*
	** Look for the matching tag condition
	*/
	for (; s ; s = s->next)
		if (IsEditableContent(s->mode.bits))
		    {
			if ((s->mode.tag == tag) == mode)
				return position;
			position += VirtualLength(s);
		    }
	/*
	** If was for looking equal match, then search failed. If was looking
	** for non-match, then search is successful at the end of the content
	*/
	return mode ? -1 : position;
    }

/*
** XeTextGetSelectionPosition
**	Return currently selected text range. If the returned start and
**	end are equal, no selection is currently active. The returned
**	'start' will alway be less or equal to the returned 'end'.
*/
void XeTextGetSelectionPosition(w, start, end)
Widget w;
long *start, *end;
    {
	XeTextEdWidget t = (XeTextEdWidget)w;

	if (!IsTextEdWidget(w))
		*start = *end = 0;
	else if (t->texted.regions[0].range[0] > t->texted.regions[0].range[1])
	    {
		*start = t->texted.regions[0].range[1];
		*end = t->texted.regions[0].range[0];
	    }
	else
	    {
		*start = t->texted.regions[0].range[0];
		*end = t->texted.regions[0].range[1];
	    }
    }	

/*
** XeTextSetSelection
**	Set/Change current selection to (start,end).
*/
void XeTextSetSelection(w, start, end)
Widget w;
long start, end;
    {
	XeTextEdWidget t = (XeTextEdWidget)w;

	if (!IsTextEdWidget(w))
		return;
	t->texted.time = XtLastTimestampProcessed(XtDisplay(w));
	t->texted.regions[0].range[0] = start;
	t->texted.regions[0].range[1] = end;
	InitRefreshRegion(t);
	TextSetSelection(t, (String *)NULL, 0);
	XeUpdateTextRegion(t, &t->texted.regions[0], False);
	DoRefreshRegion(t);
    }

/*
** XeTextUnsetSelection
**	Clear current selection.
*/
void XeTextUnsetSelection(w)
Widget w;
    {
	XeTextEdWidget t = (XeTextEdWidget)w;

	if (!IsTextEdWidget(w))
		return;
	InitRefreshRegion(t);
	while (t->texted.s.atom_count > 0)
	    {
		Atom sel = t->texted.s.selections[0];
		if (GetCutBufferNumber(sel) < 0)
			XtDisownSelection(w, sel, t->texted.time);
		LoseSelection(w, &sel);
	    }
	DoRefreshRegion(t);
    }

/*
** XeTextGetRegionPosition
**	Return the speicified text range. If the returned start and
**	end are equal, the text regison is not in used. The returned
**	'start' will alway be less or equal to the returned 'end'.
*/
void XeTextGetRegionPosition(w, id, start, end)
Widget w;
int id;
long *start, *end;
    {
	XeTextEdWidget t = (XeTextEdWidget)w;

	if (!IsTextEdWidget(w) || id < 1 || id >= t->texted.num_regions ||
	    t->texted.regions[id].mode == XeTextHighlight_UNUSED)
		*start = *end = 0;
	else if (t->texted.regions[id].range[0] >
		 t->texted.regions[id].range[1])
	    {
		*start = t->texted.regions[id].range[1];
		*end = t->texted.regions[id].range[0];
	    }
	else
	    {
		*start = t->texted.regions[id].range[0];
		*end = t->texted.regions[id].range[1];
	    }
    }	
/*
** XeTextSetRegion
**	Create a new text region with (start,end) and return region Id.
**	(Returns ZERO on invalid call or any error).
*/
int XeTextSetRegion(w, start, end, mode)
Widget w;
long start, end;
XeTextHighlight mode;
    {
	XeTextEdWidget t = (XeTextEdWidget)w;
	int n;

	if (start < 0 || end < 0 || !IsTextEdWidget(w))
		return 0;
	/*
	** Any unused entries available? (NOTE: skip selection region by
	** starting the search from 1!)
	*/
	for (n = 1; ; ++n)
		if (t->texted.max_regions == n)
		    {
			t->texted.regions = (XeTextRegion *)
				XtRealloc((char *)t->texted.regions,
					  (n + 1) * sizeof(XeTextRegion));
			t->texted.num_regions = n + 1;
			t->texted.max_regions = n + 1;
			t->texted.regions[n].nrect = 0;
			t->texted.regions[n].delayed = False;
			break;
		    }
		else if (t->texted.regions[n].mode == XeTextHighlight_UNUSED)
		    {
			if (t->texted.num_regions <= n)
				t->texted.num_regions = n + 1;
			break;
		    }
	/*
	** WARNING: If reusing an old entry, it may still have nrect > 0.
	** This means that the region was released while display was
	** disabled and refresh is *still* pending. Do not touch 'nrect'
	** or delayed fields here!
	*/
	t->texted.regions[n].mode = mode;
	t->texted.regions[n].range[0] = start;
	t->texted.regions[n].range[1] = end;
	InitRefreshRegion(t);
	XeUpdateTextRegion(t, &t->texted.regions[n], False);
	DoRefreshRegion(t);
	return n;
    }


/*
** XeTextUnsetRegion
**	Release the specified text region and return the Id of the highest
**	active application region (or ZERO, if none left).
*/
int XeTextUnsetRegion(w, id)
Widget w;
int id;
    {
	XeTextEdWidget t = (XeTextEdWidget)w;

	if (!IsTextEdWidget(w))
		return 0;
	if (id > 0 && id < t->texted.num_regions &&
	    t->texted.regions[id].mode != XeTextHighlight_UNUSED)
	    {
		InitRefreshRegion(t);
		t->texted.regions[id].range[0] = 0;
		t->texted.regions[id].range[1] = 0;
		XeUpdateTextRegion(t, &t->texted.regions[id], False);
		t->texted.regions[id].mode = XeTextHighlight_UNUSED;
		if (t->texted.num_regions == id + 1)
			t->texted.num_regions -= 1;
		DoRefreshRegion(t);
	    }
	return t->texted.num_regions - 1; /* Highest index */
    }


#ifdef USING_MOTIF_122
/*
** WidgetNavigable
**	routine to handle traversal to children of this widget, if
**	there are any, or else the widget itself, if no children. 
*/
static XmNavigability WidgetNavigable(wid)
Widget wid;
    {   
	if(wid->core.sensitive && wid->core.ancestor_sensitive &&
	   ((XmManagerWidget) wid)->manager.traversal_on)
	    {
		XmNavigationType nav_type =
			((XmManagerWidget) wid)->manager.navigation_type;

		if(nav_type == XmSTICKY_TAB_GROUP ||
		   nav_type == XmEXCLUSIVE_TAB_GROUP ||
		   (nav_type == XmTAB_GROUP && !_XmShellIsExclusive( wid)))
			return XmTAB_NAVIGABLE;
		return XmCONTROL_NAVIGABLE;
	    }
	return XmNOT_NAVIGABLE;
    }

/*
 ** Convenience routine to make a text editor that also
 ** reinstalls the translation table for the keys that the Motif
 ** manager class grabs.

 */

Widget XeCreateMotifTextEd
   (name, parent, args, num_args)
    String      name;
    Widget      parent;
    ArgList     args;
    Cardinal    num_args;
{


   Widget w;
   static char override_translations[] =
      "<Key>Return:     newline() \n\
            <Key>osfRight:        forward-character() \n\
            <Key>osfLeft: backward-character() \n\
            <Key>osfDown: next-line() \n\
            <Key>osfUp:   previous-line() \n\
            <Key>osfDelete:       delete-previous-character() \n\
            <Key>osfBackSpace:    delete-previous-character() \n\
           ";
   XtTranslations ttab;
   int override_table_len;

   w = XtCreateManagedWidget(name, xeTextEdWidgetClass,
                             parent, args, num_args);

   /* install the override translation table */
   override_table_len = strlen(override_translations);
   ttab = XtParseTranslationTable(override_translations);
   XtOverrideTranslations(w, ttab);
   
   return w;

}
#endif
