/*
 *      PlotterPS.c
 *
 *      The AthenaTools Plotter Widget Set - Version 6.0
 *
 *      klin, Tue Jul  7 13:59:47 1992
 *      klin, Fri Jul 24 15:07:46 1992, patchlevel 1
 *                                      Bug in star marker fixed.
 *      klin, Mon Jul 27 14:17:53 1992, patchlevel 2
 *                                      Resource XtNlegendLeft added.
 *                                      When generating PostScript for a
 *                                      plotter widget check if it is realized.
 *                                      Otherwise a core dump is written.
 *                                      Bug reported by Gustaf Neumann
 *                                      (neumann@dec4.wu-wien.ac.at).
 *                                      Busy cursor added.
 */
static char SCCSid[] = "@(#) Plotter V6.0  92/07/27  PlotterPS.c";

/*

Copyright 1992 by University of Paderborn
Copyright 1990,1991 by the Massachusetts Institute of Technology

All rights reserved.

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of the firms, institutes
or employers of the authors not be used in advertising or publicity
pertaining to distribution of the software without specific, written
prior permission.

THE AUTHORS AND THEIR FIRMS, INSTITUTES OR EMPLOYERS DISCLAIM ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL THE AUTHORS AND THEIR FIRMS,
INSTITUTES OR EMPLOYERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

*/

#ifdef _AtDevelopment_
# include "Text.h"
# include "PlotterP.h"
# include "AxisCore.h"
# include "Plot.h"
#else
# include <At/Text.h>
# include <At/PlotterP.h>
# include <At/AxisCore.h>
# include <At/Plot.h>
#endif

#define NUMCHILDREN(w) (w->composite.num_children)
#define CHILD(w,i) ((AtPlotWidget)(w->composite.children[i]))
#define CONSTRAINT(w,i) \
     ((AtPlotterConstraints)(((Widget)CHILD(w,i))->core.constraints))
#define CONSTRAINTS(cw) \
     ((AtPlotterConstraints)((Widget)cw)->core.constraints)

#define NTHCHILDISDISPLAYED(w, i) (CONSTRAINT(w, i)->plotter.displayed)
#define ISDISPLAYED(cw) (CONSTRAINTS(cw)->plotter.displayed)

#define height(x) AtTextPSAscent(x) + AtTextPSDescent(x)

/*
 *   Calculate the width of the legend FOR THE POSTSCRIPT VERSION!
 */

static int CalcLegendWidth P((AtPlotterWidget pw));
static int CalcLegendWidth(pw)
AtPlotterWidget pw;
{
     int i, w, mw = 0;
     AtText *t;

     for(i=0; i < NUMCHILDREN(pw); i++) {
	  if (NTHCHILDISDISPLAYED(pw, i)) {
	       t = CONSTRAINT(pw,i)->plotter.legend_text;
	       if (t != NULL) {
		    w = AtTextPSWidth(t);
		    if (w > mw) mw = w;
	       }
	  }
     }
     return mw + 16 + pw->plotter.margin_width;
}

/*
 *   Print out the legend
 */

static void drawlegend P((FILE *f, AtPlotterWidget w,
			  int x1, int y1, int x2, int y2));
static void drawlegend(f, w, x1, y1, x2, y2)
FILE *f;
AtPlotterWidget w;
int x1, y1, x2, y2;
{
     int x, y, h;
     int i;
     AtText *t;

     fprintf(f, "%%%% BeginObject: AtPlotter legend\nGS\n");

     h = height(w->plotter.legend_title_text) + w->plotter.margin_height;
     for(i=0; i < NUMCHILDREN(w); i++) {
	  if (NTHCHILDISDISPLAYED(w, i)) {
	       t = CONSTRAINT(w,i)->plotter.legend_text;
	       if (t != NULL) h += height(t) + w->plotter.legend_spacing;
	  }
     }

     y = y2 - ((y2 - y1) - h)/2;
     x = x1 + ((x2 - x1) - AtTextPSWidth(w->plotter.legend_title_text))/2;
     AtTextPSDraw(f, w->plotter.legend_title_text, x,
		  y - AtTextPSAscent(w->plotter.legend_title_text));
     y -= height(w->plotter.legend_title_text) + w->plotter.margin_height;

     for(i = 0; i < NUMCHILDREN(w); i++ ) {
	  t = CONSTRAINT(w,i)->plotter.legend_text;
	  if (NTHCHILDISDISPLAYED(w, i) && t != NULL) {
	       h = height(t);
	       AtPlotDrawIconPS(CHILD(w, i), f, x1, y, 16, h);
	       AtTextPSDraw(f, t, x1 + 16 + w->plotter.margin_width,
			    y - AtTextPSAscent(t));
	       y -= h + w->plotter.legend_spacing;
	  }
     }

     fprintf(f, "GR\n%%%% EndObject AtPlotter legend\n");
}
#undef height

void AtPlotterDrawPS(f, w, xll, yll, xur, yur)
FILE *f;
AtPlotterWidget w;
int xll, yll, xur, yur;
{
     int height, width, i;
     int xaxiswidth, x2axiswidth, yaxiswidth, y2axiswidth;
     int x1, y1, x2, y2;
     int title_x, title_y, legend_x, legend_width;
     AtScale *xscale, *x2scale, *yscale, *y2scale;
     AtPlotterPart *pp = &w->plotter;
     double min, max;
     AtScale *xs, *ys;

     fprintf(f, "%%%% BeginObject: AtPlotter\nGS\n");

     x1 = xll;
     y1 = yll;
     x2 = xur;
     y2 = yur;

     /* Set up clipping */
     /* Since this is right before a grestore, we don't need to gsave here. */
     fprintf(f, "%d %d M %d %d L %d %d L %d %d L CP clip newpath\n",
	     x1, y1, x1, y2, x2, y2, x2, y1);

     if (pp->show_legend) {
	  legend_width = CalcLegendWidth(w);
	  if (pp->legend_left) {
	       legend_x = x1 + pp->margin_width;
	       x1 += legend_width + pp->margin_width;
	  }
	  else {
	       x2 -= legend_width + pp->margin_width;
	       legend_x = x2 + pp->margin_width;
	  }
     }

     if (pp->title_text != NULL) {
	  title_y = y2 - AtTextPSAscent(pp->title_text);
	  y2 -= AtTextPSAscent(pp->title_text) +
	       AtTextPSDescent(pp->title_text) + pp->margin_height;
     }

     xaxiswidth = x2axiswidth = yaxiswidth = y2axiswidth = 0;

     if (pp->xaxis && ISDISPLAYED(pp->xaxis))
	  xaxiswidth = AtAxisWidthPS(pp->xaxis);
     if (pp->x2axis && ISDISPLAYED(pp->x2axis))
	  x2axiswidth = AtAxisWidthPS(pp->x2axis);
     if (pp->yaxis && ISDISPLAYED(pp->yaxis))
	  yaxiswidth = AtAxisWidthPS(pp->yaxis);
     if (pp->y2axis && ISDISPLAYED(pp->y2axis))
	  y2axiswidth = AtAxisWidthPS(pp->y2axis);

     x2 -= y2axiswidth;
     x1 += yaxiswidth;
     y1 += xaxiswidth;
     y2 -= x2axiswidth;

     width = x2 - x1;
     height = y2 - y1;

     if (pp->title_text != NULL)  {
	  title_x = x1 + (width - AtTextPSWidth(pp->title_text))/2;
	  AtTextPSDraw(f, pp->title_text, title_x, title_y);
     }

     if (pp->show_legend)
	  drawlegend(f, w, legend_x, yll, legend_x + legend_width, yur);

     /* Set up scales */
     if (pp->xaxis) {
	  AtAxisGetBounds(pp->xaxis, &min, &max);
	  xscale = AtScaleCreate(min, max, x1, x2,
				 AtAxisGetTransform(pp->xaxis));
     }

     if (pp->x2axis) {
	  AtAxisGetBounds(pp->x2axis, &min, &max);
	  x2scale = AtScaleCreate(min, max, x1, x2,
				  AtAxisGetTransform(pp->x2axis));
     }

     if (pp->yaxis) {
	  AtAxisGetBounds(pp->yaxis, &min, &max);
	  yscale = AtScaleCreate(min, max, y1, y2,
				 AtAxisGetTransform(pp->yaxis));
     }

     if (pp->y2axis) {
	  AtAxisGetBounds(pp->y2axis, &min, &max);
	  y2scale = AtScaleCreate(min, max, y1, y2,
				  AtAxisGetTransform(pp->y2axis));
     }

     /* Draw each of the plots */
     if (pp->rank_children) {
	  Rank *tmp;
	  for (tmp = pp->ordered_children; tmp; tmp = tmp->next) {
	       if (!ISDISPLAYED(tmp->child))
		    continue;
	       if ((AtAxisCoreWidget) tmp->child == pp->xaxis)
		    AtAxisDrawPS((AtAxisCoreWidget) tmp->child, f,
				 xscale, x1, y1, x2, y1, y2 - y1);
	       else if ((AtAxisCoreWidget) tmp->child == pp->x2axis)
		    AtAxisDrawPS((AtAxisCoreWidget) tmp->child, f,
				 x2scale, x1, y2, x2, y2, y2 - y1);
	       else if ((AtAxisCoreWidget) tmp->child ==  pp->yaxis)
		    AtAxisDrawPS((AtAxisCoreWidget) tmp->child, f,
				 yscale, x1, y1, x1, y2, x2 - x1);
	       else if ((AtAxisCoreWidget) tmp->child == pp->y2axis)
		    AtAxisDrawPS((AtAxisCoreWidget) tmp->child, f,
				 y2scale, x2, y1, x2, y2, x2 - x1);
	       else {
		    xs = CONSTRAINTS(tmp->child)->plotter.use_x2_axis ?
			 x2scale : xscale;
		    ys = CONSTRAINTS(tmp->child)->plotter.use_y2_axis ?
			 y2scale : yscale;
		    AtPlotDrawPS(tmp->child, f, xs, ys);
	       }
	  }
     } else {
	  for(i = 0; i < NUMCHILDREN(w); i++) {
	       if (!NTHCHILDISDISPLAYED(w, i))
		    continue;
	       if ((AtAxisCoreWidget) CHILD(w, i) == pp->xaxis)
		    AtAxisDrawPS((AtAxisCoreWidget) CHILD(w, i), f,
				 xscale, x1, y1, x2, y1, y2 - y1);
	       else if ((AtAxisCoreWidget) CHILD(w, i) == pp->x2axis)
		    AtAxisDrawPS((AtAxisCoreWidget) CHILD(w, i), f,
				 x2scale, x1, y2, x2, y2, y2 - y1);
	       else if ((AtAxisCoreWidget) CHILD(w, i) == pp->yaxis)
		    AtAxisDrawPS((AtAxisCoreWidget) CHILD(w, i), f,
				 yscale, x1, y1, x1, y2, x2 - x1);
	       else if ((AtAxisCoreWidget) CHILD(w, i) == pp->y2axis)
		    AtAxisDrawPS((AtAxisCoreWidget) CHILD(w, i), f,
				 y2scale, x2, y1, x2, y2, x2 - x1);
	       else {
		    xs = CONSTRAINT(w, i)->plotter.use_x2_axis ?
			 x2scale : xscale;
		    ys = CONSTRAINT(w, i)->plotter.use_y2_axis ?
			 y2scale : yscale;
		    AtPlotDrawPS(CHILD(w, i), f, xs, ys);
	       }
	  }
     }

     /* Finish up */
     fprintf(f, "GR\n%%%% EndObject AtPlotter\n");
}

static char prolog[] =
"/F   { findfont exch scalefont setfont } bind def\n\
/S   {moveto show } bind def\n\
/L   { lineto } bind def\n\
/M   { moveto } bind def\n\
/RM  { rmoveto } bind def\n\
/RL  { rlineto } bind def\n\
/CP  { closepath } bind def\n\
/ST  { stroke } bind def\n\
/GS  { gsave } bind def\n\
/GR  { grestore } bind def\n\
/SG  { setgray } bind def\n\
/RECT { M -2 -2 RM 0 4 RL 4 0 RL 0 -4 RL -4 0 RL} bind def\n\
/PLUS { M -2 0 RM 4 0 RL -2 -2 RM 0 4 RL } bind def\n\
/XMRK { M -2 -2 RM 4 4 RL 0 -4 RM -4 4 RL } bind def\n\
/STAR { M -2 -2 RM 4 4 RL 0 -4 RM -4 4 RL 2 0 RM 0 -4 RL -2 2 RM 4 0 RL } bind def\n\
/DIAM { M -2 -0 RM 2 2 RL 2 -2 RL -2 -2 RL -2 2 RL } bind def\n\
/TRI1 { M -2 -2 RM 4 0 RL -2 4 RL -2 -4 RL } bind def\n\
/TRI2 { M -2 2 RM 4 0 RL -2 -4 RL -2 4 RL } bind def\n\
/TRI3 { M 2 2 RM 0 -4 RL -4 2 RL 4 2 RL } bind def\n\
/TRI4 { M -2 2 RM 0 -4 RL 4 2 RL -4 -2 RL } bind def\n";

#include <sys/types.h>
#ifndef VMS
# include <pwd.h>
#endif

#ifdef VMS
# include <time.h>
#endif

void AtPlotterGeneratePostscript(filename, pw, title, x1, y1, x2, y2, landscape)
char *filename;
AtPlotterWidget pw;
char *title;
int x1, y1, x2, y2;
int landscape;
{
     FILE *f;
     char *asctime();
#ifndef VMS
     time_t now = time(NULL);
#else
     char *user_name;
     time_t now;

     time((time_t *) *now);
#endif

     /* Generate PostScript for a realized plotter widget only! */
     if ( !XtIsRealized((Widget) pw)) {
	  XtAppWarning(XtWidgetToApplicationContext((Widget) pw),
		       "Plotter widget is not realized");
	  return;
     }

     if((f = fopen(filename, "w+")) == NULL) {
	  XtAppWarning(XtWidgetToApplicationContext((Widget) pw),
		       "Cannot open for write PostScript output file");
	  return;
     }

     /* Set the busy cursor */
     if (pw->plotter.use_cursors)
	  XDefineCursor(XtDisplay(pw), XtWindow(pw), pw->plotter.busy_cursor);

     /* Do header info */
     fprintf(f,"%%!PS-Adobe-2.0\n");
     fprintf(f,"%%%%Title: %s\n", title);
     fprintf(f,"%%%%Creator: The Athena Tools Plotter Widget Set\n");
     fprintf(f,"%%%%CreationDate: %s",asctime(localtime(&now)));
#ifndef VMS
     fprintf(f,"%%%%For: %s\n", ((struct passwd *) getpwuid(getuid()))->pw_name);
#else
     fprintf(f, "%%%%For: %s\n", cuserid(user_name));
#endif
     fprintf(f,"%%%%BoundingBox: %d %d %d %d\n", x1, y1, x2, y2);
     fprintf(f,"%%%%Pages: 1\n");
     fprintf(f,"%%%%EndComments\n");

     /* Do prolog */
     fprintf(f, prolog);
     fprintf(f, "%%%%EndProlog\n");

     if (landscape) {
	  fprintf(f, "90 rotate\n");
	  fprintf(f, "0 -612 translate\n");
     }
     /* Do the body of the postscript */
     AtPlotterDrawPS(f, pw, x1, y1, x2, y2);

     /* Finish up */
     fprintf(f, "showpage\n");

     fclose(f);

     /* Reset busy cursor */
     if (pw->plotter.use_cursors) {
	  XDefineCursor(XtDisplay(pw), XtWindow(pw), pw->plotter.current_cursor);
     }

     *SCCSid = *SCCSid;       /* Keep gcc quiet */
}
