/*
 * Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser
 *
 *      Wirtschaftsuniversitaet Wien,
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6,
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.
 *
 * Date: Mon, Apr 13 1992
 * Author: Stefan Nusser
 * Version: 0.9
 */

/*
 *       BASIC.C      
 *       
 *       This file contains not generated basic Xt commands:      
 *
 *       com_mergeResources
 *       com_setValues
 *       com_getValues
 *      
 */


#include<stdio.h>
#include <signal.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include<X11/Xaw/List.h>
#include<X11/Xaw/Scrollbar.h>
#include<X11/Xaw/AsciiText.h>

#include "wafe.h"                             


int
com_mergeResources(client_data, comInterpreter, argc, argv)
ClientData    client_data;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     XrmDatabase    dispDb;
     XrmDatabase    newDb = NULL;
     int            i;

     DBUG_ENTER("mergeResources");

     if ((argc < 3) || (!(argc % 2)))
          {
          fprintf(stderr, "Wafe(putResources): Wrong # of args\n");
          DBUG_RETURN(TCL_ERROR);
          }
     
     dispDb = XtDatabase(XtDisplay(topLevel));

     for (i = 1; i < argc; i+=2)
          XrmPutStringResource(&newDb, argv[i], argv[i+1]);

     XrmMergeDatabases(newDb, &dispDb);

     DBUG_RETURN(TCL_OK);
     }
     

int
com_setValues(client_data, comInterpreter, argc, argv)
ClientData   client_data;
Tcl_Interp  *comInterpreter;
int          argc;
char       **argv;
     {
     Widget            w;
     ArgList           args;
     int               numArgs;
     char             *name;

     DBUG_ENTER ("setValues");
 
     if (argc % 2)
          {
          fprintf(stderr, "Wafe(setValues): Wrong # of args");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(w = name2Widget(*(++argv))))
          DBUG_RETURN (TCL_ERROR);
   
     argc-=2;
     argv++;

     if (convert(ParentWidget(w), XtClass(w), argv, argc, &args, &numArgs))
          {
          XtSetValues(w, args, numArgs);
          checkArgs4String(w, args, numArgs); 
          XtFree((char *)args);
          DBUG_RETURN(TCL_OK);
	  }
     }


int
com_getValues(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget   w;
     char     result[500];
     char    *type;

     DBUG_ENTER("getValues");

     if (argc != 3)
            {
            fprintf(stderr, "Wafe(getValues): Wrong # of Args or old-style arguments");
            }

     if (!(w = name2Widget(argv[1])))
          DBUG_RETURN (TCL_ERROR);

     if (!(type = getTypeOfAttribute(XtClass(w), ParentWidget(w), argv[2])))
           {
           Tcl_SetResult(interpreter, "Wafe(getValues): Unknown Attribute", TCL_STATIC);
           DBUG_RETURN(TCL_ERROR);
           }

     if (!strcmp(type, "String"))
           {
           char    *valueString;
           XtVaGetValues(w, argv[2], &valueString, NULL);
           strcpy(result, valueString);
           }
     else
     if (!strcmp(type, "Int"))
           {
           int    valueInt = 0;
           XtVaGetValues(w, argv[2], &valueInt, NULL);
           sprintf(result, "%d", valueInt);        
           }
     else
     if (!strcmp(type, "Dimension"))
           {
           Dimension   valueDimension = 0;
           XtVaGetValues(w, argv[2], &valueDimension, NULL);
           sprintf(result, "%d", valueDimension);        
           }
     else
     if (!strcmp(type, "WidgetList"))
           {
           Widget    *children;
           int        numChildren;
           int        i;

           XtVaGetValues(w, XtNnumChildren, &numChildren,
                            XtNchildren,    &children,    NULL);
 
           Tcl_SetResult(interpreter, "", TCL_VOLATILE);

           for (i = 0; i < numChildren; i++)
               Tcl_AppendElement(interpreter, XtName(children[i]), 0);

           DBUG_RETURN(TCL_OK); 
           }
     else
     if (!strcmp(type, "Position"))
           {
           Position   valuePosition = 0;

           XtVaGetValues(w, argv[2], &valuePosition, NULL);                      
           sprintf(result, "%d", valuePosition);        
           }
     else
     if (!strcmp(type, "Float"))
           {
           float    valueFloat; 

           XtVaGetValues(w, argv[2], &valueFloat, NULL);                      
           sprintf(result, "%f", valueFloat);        
           }
     else
     if (!strcmp(type, "Double"))
           {
           double    valueDouble; 

           XtVaGetValues(w, argv[2], &valueDouble, NULL);                      
           sprintf(result, "%f", valueDouble);        
           }
     else
     if (!strcmp(type, "Boolean"))
           {
           Boolean    valueBool; 

           XtVaGetValues(w, argv[2], &valueBool, NULL);                      
           sprintf(result, "%s", valueBool ? "true" : "false");        
           }
     else
           {
           Tcl_SetResult(interpreter, "Wafe(getValues): Couldn't convert value\n", TCL_STATIC);
           DBUG_RETURN(TCL_ERROR);
           }

     Tcl_SetResult(interpreter, result, TCL_VOLATILE);   
     DBUG_RETURN(TCL_OK);
     }

int
getResourceList(w, resultPtr)
char    ***resultPtr; 
Widget   w;
     {
     int numTotal, count;
     char **result;
     int rNum = 0;
     int cNum = 0;
     int tsoNum = 0;
     int tsiNum = 0;
     XtResourceList rList, cList, tsoList, tsiList;

     rNum = getResOfClass(XtClass(w), &rList);

     if (XtIsConstraint(ParentWidget(w)))   /* If parentWidget is constrain widget => fetch constraints */
          cNum =  getConOfClass(XtClass(ParentWidget(w)), &cList);

     if (XtClass(w) == asciiTextWidgetClass)  /* Fetch asciiText subpart resources... */
          {
          tsiNum = getResOfClass((asciiSinkObjectClass), &tsiList);
          tsoNum = getResOfClass((asciiSrcObjectClass), &tsoList);
	  }

     numTotal = rNum + cNum + tsiNum + tsoNum;
     *resultPtr = result = (char **)XtMalloc(numTotal *sizeof(char *));       


     for ( count = 0; count < rNum; count++)
          *result++ = rList[count].resource_name;

     for ( count = 0; count < cNum; count++)
          *result++ = cList[count].resource_name;

     for ( count = 0; count < tsiNum; count++)
          *result++ = tsiList[count].resource_name;

     for ( count = 0; count < tsoNum; count++)
          *result++ = tsoList[count].resource_name;
    return(numTotal);
    }
          
int
com_getResourceList(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget  w;
     int  numResult;
     char  **result;
     char *list;
     char conversionBuffer[30];

     DBUG_ENTER("getresourceList");  

     if (argc != 3) 
	 {
	 argcError("getResourceList","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(w = name2Widget(argv[1])))
          {
          convError("getResourceList","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     numResult = getResourceList(w, &result);
     list = Tcl_Merge(numResult, result);
     XtFree((char *)result);

     Tcl_SetVar(interpreter, argv[2], list, 0);

     sprintf(conversionBuffer, "%d", numResult);
     Tcl_SetResult(interpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN(TCL_OK);
     }

