/*
 * Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser
 *
 *      Wirtschaftsuniversitaet Wien,
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6,
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.
 *
 * Date: Mon, Apr 13 1992
 * Author: Stefan Nusser
 * Version: 0.9
 */

/* 
 *            Code fuer List -  Widget
 *
 */

#include <stdio.h>
#include <string.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/List.h>

#include "wafe.h"

#define MAX_ITEM_LENGTH 200


int
com_listChange(client_data, comInterpreter, argc, argv)
ClientData    client_data;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     int      nitems, longest, resize, index;
     Widget   w;
     FILE    *fp;
     char   **list, **count, **oldList;
     char     buffer [MAX_ITEM_LENGTH] ;         

     DBUG_ENTER("listChange");

     if (argc < 6)
          {
          fprintf(stderr, "Wafe(listChange): Wrong # of args");
          DBUG_RETURN(TCL_ERROR);
          }
     
     if (!(w = name2Widget(argv[1])))
          DBUG_RETURN(TCL_ERROR);


     (void)sscanf(argv[2], "%d", &nitems);
     (void)sscanf(argv[3], "%d", &longest);
     (void)sscanf(argv[4], "%d", &resize);

     if (!strcmp(argv[5], "Arg"))
          {                      
          list = count = (char **)XtMalloc((argc-5)*sizeof(char *)); 

          for (index = 6; index < argc; index++)
	      {
              *count = XtNewString(argv[index]);
              count++;
	      }

          *count = NULL;
	  }

     if (!strcmp(argv[5], "File"))
          {
          if (argc != 7)
	      {
              fprintf(stderr, "Wafe(listChange): Wrong # of Args");
              DBUG_RETURN(TCL_ERROR);
	      }

          if (!(fp = fopen(argv[6], "r")))
              {
              fprintf(stderr, "Wafe(listChange): Couldn't open File");
              DBUG_RETURN(TCL_ERROR);
	      }

          list = count = (char **)XtMalloc(10*sizeof(char *));
          index = 0;

          while (fgets(buffer, 200, fp))
              {
              *count = XtNewString(buffer);
              *(*count + strlen(buffer)-1) = '\0';
              count++; index++;
              if (!(index % 10))
                  {
		  DBUG_PRINT("list", ("Realloc\n"));
                  list = (char**)XtRealloc((char *)list, (index + 10)
                                                      * sizeof(char *));
                  count = list + index;
   	          }
	      }
          *count = NULL;
	  }

     XtVaGetValues(w, XtNlist, &oldList, NULL);
     XawListChange(w, list, nitems, longest, resize);

     if (strcmp(argv[1],*oldList))
          {
          count = oldList;
          while (*count)
               {
               XtFree(*count);
               count++;
	       }

          if (*oldList)
               XtFree(*oldList);
          }

     DBUG_RETURN(TCL_OK);
     }
  
void
listCallbackProc(w, clientData, callData)
Widget     w;
XtPointer  clientData, callData;
     {
     char     command[MESSAGE_COMMAND_LENGTH];       
     char     buffer[INT_AS_STRING];  
     char    *input = (char *) clientData;
     char    *output = command;

     DBUG_ENTER("listCallbackProc");

     while (*input != '\0')
          {
          if (*input == '%')
               {
               input++;
               if (*input == 'w')
                    {
                    strcpy (output, XtName(w));
                    output += strlen(XtName(w));
                    }
               else
               if (*input == 's')
                    {
                    strcpy (output, ((XawListReturnStruct *)callData)->string);
                    output += strlen(((XawListReturnStruct *)callData)->string);
                    }
               else
               if (*input == 'i')
                    {
                    sprintf(buffer, "%d", 
                          ((XawListReturnStruct *)callData)->list_index);
                    strcpy(output, buffer);
                    output += strlen(buffer);                    
                    }
               else
		    {
                    *output = '%';
                    output++;
                    input--;
		    }
	       }
          else 
               {
               *output = *input;
               output++;
	       }
          input++;
	  }

     *output = '\0';
  
     DBUG_PRINT("list", (">%s<", command));
             
     if (Tcl_Eval(interpreter, command, 0, NULL) == TCL_ERROR)
          fprintf(stderr, "%s\n", interpreter->result);

     DBUG_VOID_RETURN;
     }


int
com_listAppend(client_data, comInterpreter, argc, argv)
ClientData    client_data;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget   list;
     char   **srcPtr, **trgtPtr;
     char   **newArray, **oldArray;
     int      nitems = 0;
     int      count;
     Boolean  resize;
     DBUG_ENTER("listAppend");
 
     if (argc < 3)
          {
          fprintf(stderr, "changeList: Falsche # an Argumenten");
          DBUG_RETURN(TCL_ERROR);
          }
     
     if (!(list = name2Widget(argv[1])))
          DBUG_RETURN(TCL_ERROR);

     XtVaGetValues(list, XtNlist, &oldArray, NULL);
     XtVaGetValues(list, XtNresize, &resize, NULL);
     
     for (srcPtr = oldArray; *srcPtr != NULL; srcPtr++)
          {
          nitems++;
          DBUG_PRINT("list", ("Checking %d", nitems));
	  }

     newArray = (char **)XtMalloc((nitems * sizeof(char*)) + argc - 1);

     for(srcPtr = oldArray, trgtPtr = newArray; *srcPtr != NULL; 
     srcPtr++, trgtPtr++)
          {          
          *trgtPtr = XtNewString(*srcPtr);
	  DBUG_PRINT("list", ("Copied: >%s<\n", *trgtPtr));
          XtFree(*srcPtr);
	  }

     XtFree((char *)oldArray);

     for (count = 2; count < argc; count++)
          {
          *trgtPtr = XtNewString(argv[count]);
          DBUG_PRINT("list", ("Added: >%s<", *trgtPtr));
          trgtPtr++;
          }

     *trgtPtr = NULL;

     XawListChange(list, newArray, 0, 0, resize);

     DBUG_RETURN(TCL_OK);
     }




