/*                               -*- Mode: C -*- 
 * rdd.h
 * 
 * Description     :  Roger's Drag 'n Drop Library.
 * 					  A drag-n-drop library for Xt programs.
 * 
 * Author          : Roger Reynolds	 - 	rogerr@netcom.com
 * Created On      : Sun Apr 26 14:14:01 1992
 * 
 * Configuration Management
 * 
 * @(#)rdd.h	1.3	5/1/92
 * 
 * VERSION   SPR   MODIFIER   DATE AND TIME
 * 
 */

#ifndef RDD_LIB_H
#define RDD_LIB_H

#include <X11/Intrinsic.h>

#ifdef __STDC__
#define PROTO_ARGS(args) args
#else
#define PROTO_ARGS(args) ()
#endif


void rddInit PROTO_ARGS((Widget, XtAppContext));
void rddAppMainLoop PROTO_ARGS((XtAppContext));
void rddAddDropHandler PROTO_ARGS((Widget, XtCallbackProc, caddr_t));
void rddSendDropEvent PROTO_ARGS((Widget));
void rddSetDropData PROTO_ARGS((caddr_t, int));

void rddStartAction PROTO_ARGS((Widget, XButtonEvent*, String*, int*));
void rddDragAction PROTO_ARGS((Widget, XButtonEvent*, String*, int*));
void rddDropAction PROTO_ARGS((Widget, XButtonEvent*, String*, int*));

typedef struct _rddCallbackStruct
{
	caddr_t data;		/* pointer to dropped data	*/
	int  len;			/* length of data			*/
} RddCallbackStruct;

#undef PROTO_ARGS

#endif


#ifndef LIST_H
#define LIST_H

typedef unsigned long ListId;

ListId listNew();

#define LIST_ITERATE_BEGINNING 0
#define LIST_ITERATE_NEXT 1
#define LIST_ITERATE_PREV 2

char *listIterate();
#endif
