/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Sun Jul 26 17:05:14 MET DST 1992 on dec4.wu-wien.ac.at
 * Author: genc
 * Version: 0.9
 */
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "wafe.h"

/* 
 * void
 * rddSetDropData
 * 	in: XtNewString(char *)
 * 	const: strlen(argv[1])
 */

int 
com_rddSetDropData(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     char * localVar1;

     DBUG_ENTER("rddSetDropData");  

     if (argc != 2) 
	 {
	 argcError("rddSetDropData","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     localVar1 = argv[1];
     rddSetDropData(XtNewString(localVar1),strlen(argv[1]));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * hint: prototype
 * void
 * rddAddDropHandler
 * 	in: Widget
 * 	const: (XtCallbackProc)rddDropCallbackProc
 * 	in: XtNewString(char *)
 */
extern void rddAddDropHandler(
#if NeedFunctionPrototypes
     Widget, char *
#endif
);

int 
com_rddAddDropHandler(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     char * localVar2;

     DBUG_ENTER("rddAddDropHandler");  

     if (argc != 3) 
	 {
	 argcError("rddAddDropHandler","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("rddAddDropHandler","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     localVar2 = argv[2];
     rddAddDropHandler(localVar1,(XtCallbackProc)rddDropCallbackProc,XtNewString(localVar2));

     DBUG_RETURN (TCL_OK);
     }     


