/*
 * Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser
 *
 *      Wirtschaftsuniversitaet Wien,
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6,
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.
 *
 * Date: Mon, Apr 13 1992
 * Author: Stefan Nusser
 * Version: 0.9
 */

/* 
 *            Code fuer Scrollbar Widget
 *
 */

#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/Scrollbar.h>

#include "wafe.h"

void
scrollbarScrollCallbackProc(w, clientData, callData)
Widget     w;
XtPointer  clientData, callData;
     {
     char     command[MESSAGE_COMMAND_LENGTH];       
     char     buffer[INT_AS_STRING];  
     char    *input = (char *) clientData;
     char    *output = command;

     DBUG_ENTER("scrollbarScrollCallbackProc");

     while (*input != '\0')
          {
          if (*input == '%')
               {
               input++;
               if (*input == 'w')
                    {
                    strcpy (output, XtName(w));
                    output += strlen(XtName(w));
                    }
               else
               if (*input == 'p')
                    {
                    sprintf(buffer, "%d", (int) callData);
                    strcpy (output, buffer);
                    output += strlen(buffer);    
                    }
               else
		    {
                    *output = '%';
                    output++;
                    input--;
		    }
               }
          else 
               {
               *output = *input;
               output++;
               }
          input++;
          }

     *output = '\0';
  
     DBUG_PRINT("scrollbar", (">%s<", command));
             
     (void)Tcl_Eval(interpreter, command, 0, NULL);

     DBUG_VOID_RETURN;
     }


void
scrollbarJumpCallbackProc(w, clientData, callData)
Widget     w;
XtPointer  clientData, callData;
     {
     char     command[MESSAGE_COMMAND_LENGTH];       
     char     buffer[INT_AS_STRING];  
     char    *input = (char *) clientData;
     char    *output = command;

     DBUG_ENTER("scrollbarJumpCallbackProc");

     while (*input != '\0')
          {
          if (*input == '%')
               {
               input++;
               if (*input == 'w')
                    {
                    strcpy (output, XtName(w));
                    output += strlen(XtName(w));
                    }
               else
               if (*input == 'p')
                    {
                    sprintf(buffer, "%f", *(float *) callData);
                    strcpy (output, buffer);
                    output += strlen(buffer);    
                    }
               else
		    {
                    *output = '%';
                    output++; input--;
		    }
               }
          else 
               {
               *output = *input;
               output++;
               }
          input++;
          }

     *output = '\0';
  
     DBUG_PRINT("scrollbar", (">%s<", command));
             
     (void)Tcl_Eval(interpreter, command, 0, NULL);

     DBUG_VOID_RETURN;
     }
