/* treat me like a -*- c -*- program */

#define MAX_ITEM_LENGTH 200

int
listChange(w, widgetName, nitems, longest, resize, argc, argv)
Widget     w;
String     widgetName;
int        nitems;
int        longest;
int        resize;
int           argc;
char        **argv;
    {
    FILE    *fp;
    int      index;
    char   **list, **count, **oldList;
    char     buffer [MAX_ITEM_LENGTH] ;         

    DBUG_ENTER("listChange");
    
    if (!strcmp(argv[0], "Arg"))
	{                      
	list = count = (char **)XtMalloc(argc*sizeof(char *)); 
	for (index = 1; index < argc; index++)
	    {
	    *count = XtNewString(argv[index]);
	    count++;
	    }

	*count = NULL;
	}

    if (!strcmp(argv[0], "File"))
	{
	if (argc != 2)
	    {
	    fprintf(stderr, "Wafe(listChange): Wrong # of Args");
	    DBUG_RETURN(TCL_ERROR);
	    }

	if (!(fp = fopen(argv[1], "r")))
	    {
	    fprintf(stderr, "Wafe(listChange): Couldn't open File %s",
		    argv[1]);
	    DBUG_RETURN(TCL_ERROR);
	    }

	list = count = (char **)XtMalloc(10*sizeof(char *));
	index = 0;

	while (fgets(buffer, 200, fp))
	    {
	    *count = XtNewString(buffer);
	    *(*count + strlen(buffer)-1) = '\0';
	    count++; index++;
	    if (!(index % 10))
		{
		DBUG_PRINT("list", ("Realloc\n"));
		list = (char**)XtRealloc((char *)list, (index + 10)
					 * sizeof(char *));
		count = list + index;
		}
	    }
	*count = NULL;
	}

    XtVaGetValues(w, XtNlist, &oldList, NULL);
    XawListChange(w, list, nitems, longest, resize);

    if (strcmp(widgetName,*oldList))
	{
	count = oldList;
	while (*count)
	    {
	    XtFree(*count);
	    count++;
	    }

	if (*oldList)
	    XtFree(*oldList);
	}

    DBUG_RETURN(TCL_OK);
    }

  
void
listAppend(list, argc, argv)
Widget        list;
int           argc;
char        **argv;
    {
    char   **srcPtr, **trgtPtr;
    char   **newArray, **oldArray;
    int      nitems = 0;
    int      count;
    Boolean  resize;
    DBUG_ENTER("listAppend");
 
    XtVaGetValues(list, XtNlist, &oldArray, NULL);
    XtVaGetValues(list, XtNresize, &resize, NULL);
     
    for (srcPtr = oldArray; *srcPtr != NULL; srcPtr++)
	{
	nitems++;
	DBUG_PRINT("list", ("Checking %d", nitems));
	}

    newArray = (char **)XtMalloc((nitems * sizeof(char*)) + argc + 1);

    for(srcPtr = oldArray, trgtPtr = newArray; 
	*srcPtr != NULL; 
	srcPtr++, trgtPtr++)
	{          
	*trgtPtr = XtNewString(*srcPtr);
	DBUG_PRINT("list", ("Copied: >%s<\n", *trgtPtr));
	XtFree(*srcPtr);
	}

    XtFree((char *)oldArray);

    for (count = 0; count < argc; count++)
	{
	*trgtPtr = XtNewString(argv[count]);
	DBUG_PRINT("list", ("Added: >%s<", *trgtPtr));
	trgtPtr++;
	}

    *trgtPtr = NULL;

    XawListChange(list, newArray, 0, 0, resize);
    }

