/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Tue Jun 15 04:24:35 MET DST 1993 on dec4.wu-wien.ac.at
 * Author: genc
 * Version: 0.92
 */
#ifdef ATHENA
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "wafe.h"

#include <X11/Xaw/AsciiText.h>
#define asciiTextAppend(w,text) { String string, newString;XtVaGetValues(w, XtNstring, &string, NULL); if (string) { newString = XtMalloc(strlen(string) + strlen(text) +2);strcpy(newString, string); strcat(newString, text);  } else newString = XtNewString(text); XtVaSetValues(w, XtNstring, newString, NULL); XtFree(newString);}

/* 
 * Boolean
 * XawAsciiSave
 * 	in: XawTextGetSource(Widget)	# ascii text wiget
 */

int 
com_asciiSave(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("asciiSave");  

     if (argc != 2) 
	 {
	 argcError("asciiSave","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("asciiSave","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawAsciiSave(XawTextGetSource(localVar1));

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int 
 * XawAsciiSaveAsFile
 *         in: XawTextGetSource(Widget)	# ascii text wiget
 *         in: String			# file name
 */

int 
com_asciiSaveAsFile(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String localVar2;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("asciiSaveAsFile");  

     if (argc != 3) 
	 {
	 argcError("asciiSaveAsFile","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("asciiSaveAsFile","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     returnVar = XawAsciiSaveAsFile(XawTextGetSource(localVar1),argv[2]);

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Boolean
 * XawAsciiSourceChanged 
 * 	in: XawTextGetSource(Widget)	# ascii text wiget
 */

int 
com_asciiSourceChanged(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("asciiSourceChanged");  

     if (argc != 2) 
	 {
	 argcError("asciiSourceChanged","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("asciiSourceChanged","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawAsciiSourceChanged(XawTextGetSource(localVar1));

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawAsciiSourceFreeString
 * 	in: XawTextGetSource(Widget)	# ascii text wiget
 */

int 
com_asciiSourceFreeString(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("asciiSourceFreeString");  

     if (argc != 2) 
	 {
	 argcError("asciiSourceFreeString","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("asciiSourceFreeString","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawAsciiSourceFreeString(XawTextGetSource(localVar1));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * asciiTextAppend
 * 	in: Widget			# ascii text widget
 * 	in: String			# string to append
 */

int 
com_asciiTextAppend(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String localVar2;

     DBUG_ENTER("asciiTextAppend");  

     if (argc != 3) 
	 {
	 argcError("asciiTextAppend","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("asciiTextAppend","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     asciiTextAppend(localVar1,argv[2]);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/Box.h>
#include <X11/Xaw/Clock.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
/* 
 * String
 * XawDialogGetValueString
 * 	in: Widget			# dialog widget
 */

int 
com_dialogGetValueString(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER("dialogGetValueString");  

     if (argc != 2) 
	 {
	 argcError("dialogGetValueString","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("dialogGetValueString","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawDialogGetValueString(localVar1);

     
     Tcl_SetResult(comInterpreter, returnVar, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/Form.h>
#ifdef XEDW

#include "Xedw/XedwList.h"

/*
 * Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser
 *
 *      Wirtschaftsuniversitaet Wien,
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6,
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.
 *
 * Date: Mon, Apr 13 1992
 * Author: Stefan Nusser
 * Version: 0.9
 */

/* 
 *            Code fuer List -  Widget
 *
 */


#define EDW_MAX_ITEM_LENGTH 200

int edwchanged = 0;

void
edwListChange(w, widgetName, nitems, longest, resize, argc, argv)
Widget     w;
String     widgetName;
int        nitems;
int        longest;
int        resize;
int           argc;
char        **argv;
     {
     int      index;
     short    i = 0;
     FILE    *fp;
     XedwList   **list, **count, **oldList;
     char     buffer [EDW_MAX_ITEM_LENGTH] ;         

     if (!strcmp(argv[0], "Arg"))
          {                      
          list = count = (XedwList **)XtMalloc(argc*sizeof(XedwList*)); 

          for (index = 1; index < argc; index+=2)
	      {
	      Pixmap icon = NULL;
	      list[i] = (XedwList*)XtMalloc(sizeof(XedwList));
              list[i]->string = XtNewString(argv[index]);
	      if (argv[index+1][0]) 
                  {
     		  XrmValue          input;
     	  	  XrmValue          output;
                  input.addr =   argv[index+1];
                  input.size =   strlen(input.addr)+1;
                  output.addr =  NULL;


                  if (CONVERTANDSTORE(w, "String", &input,"Pixmap", &output))
		      {
		      icon = (Pixmap) *(long *)output.addr;
		      /* fprintf(stderr,"i did convert, len=%d, val=%d\n",output.size,icon); */
		      }
		  else 
		      fprintf(stderr, "cound not convert <%s> to Pixmap\n",
			      argv[index+1]);
		  }
	      list[i]->icon = icon;
              i++;
	      }
	  
          list[i] = NULL;
	  }

     XtVaGetValues(w, XtNxedwList, &oldList, NULL);
     XedwListChange(w, list, nitems, longest, resize);

     if (edwchanged)   /* will NOT work for more than 1 edwlist item -gustaf */
	 {
	 i=0;
	 while (oldList[i])
	     {
	     XtFree(oldList[i]->string);
	     XtFree((char*)oldList[i]);
	     i++;
	     }

	 XtFree((char*)(oldList));
	 }

     edwchanged = 1;
     return;
     }
  
void
edwListCallbackProc(w, clientData, callData)
Widget     w;
XtPointer  clientData, callData;
     {
     char     command[MESSAGE_COMMAND_LENGTH];       
     char     buffer[INT_AS_STRING];  
     char    *input = (char *) clientData;
     char    *output = command;

     DBUG_ENTER("listCallbackProc");

     while (*input != '\0')
          {
          if (*input == '%')
               {
               input++;
               if (*input == 'w')
                    {
                    strcpy (output, XtName(w));
                    output += strlen(XtName(w));
                    }
               else
               if (*input == 's')
                    {
                    strcpy (output, ((XedwListReturnStruct *)callData)->string);
                    output += strlen(((XedwListReturnStruct *)callData)->string);
                    }
               else
               if (*input == 'i')
                    {
                    sprintf(buffer, "%d", 
                          ((XedwListReturnStruct *)callData)->xedwList_index);
                    strcpy(output, buffer);
                    output += strlen(buffer);                    
                    }
               else
		    {
                    *output = '%';
                    output++;
                    input--;
		    }
	       }
          else 
               {
               *output = *input;
               output++;
	       }
          input++;
	  }

     *output = '\0';
  
     DBUG_PRINT("list", (">%s<", command));
             
     if (Tcl_Eval(interpreter, command, 0, NULL) == TCL_ERROR)
          fprintf(stderr, "%s\n", interpreter->result);

     DBUG_VOID_RETURN;
     }



/* 
 * hint: XEDW,noDoc
 * void
 * edwListChange
 * 	in: Widget			# list widget
 * 	const: argv[1]
 * 	in: int				# number of items
 * 	in: int				# longest
 * 	in: int				# resize
 * 	in: [args odd]			# Arg items
 */
#ifdef XEDW

int 
com_edwListChange(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;
     int localVar4;

     DBUG_ENTER("edwListChange");  

     if (argc < 6 && !(argc-5) % 2) 
	 {
	 argcError("edwListChange","odd number of arguments and at least ",5,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("edwListChange","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("edwListChange","3",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%d", &localVar3)))
          {
          convError("edwListChange","4",argv[3],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[4], "%d", &localVar4)))
          {
          convError("edwListChange","5",argv[4],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     argc -= 5;
     edwListChange(localVar1,argv[1],localVar2,localVar3,localVar4,argc,&argv[5]);

     DBUG_RETURN (TCL_OK);
     }     

#endif

/* 
 * hint: XEDW,noDoc
 * XedwListReturnStruct *
 * XedwListShowCurrent
 * 	in: Widget			# edw list widget
 */
#ifdef XEDW

int 
com_edwListShowCurrent(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XedwListReturnStruct * returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("edwListShowCurrent");  

     if (argc != 2) 
	 {
	 argcError("edwListShowCurrent","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("edwListShowCurrent","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XedwListShowCurrent(localVar1);

          
     Tcl_SetVar2(interpreter,"returnVar","string", returnVar->string,0);
     sprintf(conversionBuffer, "%d", returnVar->xedwList_index);
     Tcl_SetVar2(interpreter,"returnVar","xedwList_index", conversionBuffer,0);

     Tcl_SetResult(comInterpreter, "returnVar", TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     

#endif

#endif

/* 
 * void
 * XawFormDoLayout
 * 	in: Widget			# form widget
 * 	in: Boolean			# boolean
 */

int 
com_formDoLayout(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER("formDoLayout");  

     if (argc != 3) 
	 {
	 argcError("formDoLayout","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("formDoLayout","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("formDoLayout","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XawFormDoLayout(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/Grip.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/List.h>
/* treat me like a -*- c -*- program */

#define MAX_ITEM_LENGTH 200

int
listChange(w, widgetName, nitems, longest, resize, argc, argv)
Widget     w;
String     widgetName;
int        nitems;
int        longest;
int        resize;
int           argc;
char        **argv;
    {
    FILE    *fp;
    int      index, size=0;
    char   **list, **count, **oldList,  *offset;
    char     buffer [MAX_ITEM_LENGTH] ;         

    DBUG_ENTER("listChange");
    
    if (!strcmp(argv[0], "Arg"))
	{
        for (index = 1; index < argc; index ++) 
	    {
	    size += strlen(argv[index])+1;
	    }
	
	list = count = (char **)XtMalloc((argc)*sizeof(char *)+size); 
	offset = (char *)list + (argc)*sizeof(char *);

	for (index = 1; index < argc; index++)
	    {
	    *count = offset;
	    strcpy(offset,argv[index]);
	    offset += strlen(argv[index])+1;
	    count++;
	    }

	*count = NULL;
	}

    if (!strcmp(argv[0], "File"))
	{
	char **tmpList, **saveStart;

	if (argc != 2)
	    {
	    fprintf(stderr, "Wafe(listChange): Wrong # of Args");
	    DBUG_RETURN(TCL_ERROR);
	    }

	if (!(fp = fopen(argv[1], "r")))
	    {
	    fprintf(stderr, "Wafe(listChange): Couldn't open File %s",
		    argv[1]);
	    DBUG_RETURN(TCL_ERROR);
	    }

	saveStart = tmpList = count = (char **)XtMalloc(10*sizeof(char *));
	index = 0;

	while (fgets(buffer, 200, fp))
	    {
	    *count = XtNewString(buffer);
	    size += strlen(buffer)+1;
	    *(*count + strlen(buffer)-1) = '\0';
	    count++; index++;
	    if (!(index % 10))
		{
		DBUG_PRINT("list", ("Realloc"));
		saveStart = tmpList = (char**)XtRealloc((char *)tmpList,
						(index + 10)* sizeof(char *));
		count = tmpList + index;
		}
	    }
	*count = NULL;

	/* make it the list a single memory chunk to be 
         * compatible with the rest 
         */
	list = count = (char **)XtMalloc((index+1)*sizeof(char *)+size); 
	offset = (char *)list + (index+1)*sizeof(char *);

	while (*tmpList)
	    {
	    *count = offset;
	    strcpy(offset,*tmpList);
	    offset += strlen(*tmpList)+1;
	    XtFree(*tmpList);
	    tmpList++;
	    count++;
	    }
	*count = NULL;

        XtFree((char*)saveStart);
	}

    XawListChange(w, list, nitems, longest, resize);
    MMreplace(MMgetAttribList(w), qPointer, (char *)list,XtFree);

    DBUG_RETURN(TCL_OK);
    }

  
void
listAppend(list, argc, argv)
Widget        list;
int           argc;
char        **argv;
    {
    char   **srcPtr, **trgtPtr;
    char   **newArray, **oldArray;
    int      nitems = 0;
    int      count;
    Boolean  resize;
    DBUG_ENTER("listAppend");
 
    XtVaGetValues(list, XtNlist, &oldArray, NULL);
    XtVaGetValues(list, XtNresize, &resize, NULL);
     
    for (srcPtr = oldArray; *srcPtr != NULL; srcPtr++)
	{
	nitems++;
	DBUG_PRINT("list", ("Checking %d", nitems));
	}

    newArray = (char **)XtMalloc((nitems * sizeof(char*)) + argc + 1);

    for(srcPtr = oldArray, trgtPtr = newArray; 
	*srcPtr != NULL; 
	srcPtr++, trgtPtr++)
	{          
	*trgtPtr = XtNewString(*srcPtr);
	DBUG_PRINT("list", ("Copied: >%s<\n", *trgtPtr));
	XtFree(*srcPtr);
	}

    XtFree((char *)oldArray);

    for (count = 0; count < argc; count++)
	{
	*trgtPtr = XtNewString(argv[count]);
	DBUG_PRINT("list", ("Added: >%s<", *trgtPtr));
	trgtPtr++;
	}

    *trgtPtr = NULL;

    XawListChange(list, newArray, 0, 0, resize);
    }


/* 
 * void
 * listAppend
 * 	in: Widget			# list widget
 * 	in: [args]			# items
 */

int 
com_listAppend(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("listAppend");  

     if (argc < 3) 
	 {
	 argcError("listAppend","at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("listAppend","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     argc -= 2;
     listAppend(localVar1,argc,&argv[2]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * listChange
 * 	in: Widget			# list widget
 * 	const: argv[1]
 * 	in: int				# number of items
 * 	in: int				# longest
 * 	in: int				# resize
 * 	in: [args]			# Arg items | File filename
 */

int 
com_listChange(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;
     int localVar4;

     DBUG_ENTER("listChange");  

     if (argc < 6) 
	 {
	 argcError("listChange","at least ",5,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("listChange","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("listChange","3",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%d", &localVar3)))
          {
          convError("listChange","4",argv[3],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[4], "%d", &localVar4)))
          {
          convError("listChange","5",argv[4],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     argc -= 5;
     listChange(localVar1,argv[1],localVar2,localVar3,localVar4,argc,&argv[5]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawListHighlight
 * 	in: Widget			# list widget
 * 	in: int				# item number
 */

int 
com_listHighlight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER("listHighlight");  

     if (argc != 3) 
	 {
	 argcError("listHighlight","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("listHighlight","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("listHighlight","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XawListHighlight(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XawListReturnStruct *
 * XawListShowCurrent
 * 	in: Widget			# list widget
 */

int 
com_listShowCurrent(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawListReturnStruct * returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("listShowCurrent");  

     if (argc != 2) 
	 {
	 argcError("listShowCurrent","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("listShowCurrent","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawListShowCurrent(localVar1);

          
     Tcl_SetVar2(interpreter,"returnVar","string", returnVar->string,0);
     sprintf(conversionBuffer, "%d", returnVar->list_index);
     Tcl_SetVar2(interpreter,"returnVar","list_index", conversionBuffer,0);

     Tcl_SetResult(comInterpreter, "returnVar", TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawListUnhighlight
 * 	in: Widget			# list widget
 */

int 
com_listUnhighlight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("listUnhighlight");  

     if (argc != 2) 
	 {
	 argcError("listUnhighlight","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("listUnhighlight","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawListUnhighlight(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/Logo.h>
#include <X11/Xaw/Mailbox.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Paned.h>
/* 
 * void
 * XawPanedAllowResize
 * 	in: Widget			# paned widget
 * 	in: Boolean			# boolean
 */

int 
com_panedAllowResize(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER("panedAllowResize");  

     if (argc != 3) 
	 {
	 argcError("panedAllowResize","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("panedAllowResize","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("panedAllowResize","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XawPanedAllowResize(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawPanedGetMinMax
 * 	in: Widget			# paned widget
 * 	out: int			# min
 * 	out: int			# max
 */

int 
com_panedGetMinMax(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;
     char conversionBuffer[100];

     DBUG_ENTER("panedGetMinMax");  

     if (argc != 4) 
	 {
	 argcError("panedGetMinMax","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("panedGetMinMax","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawPanedGetMinMax(localVar1,&localVar2,&localVar3);

     sprintf(conversionBuffer, "%d", localVar2);
     Tcl_SetVar(interpreter, argv[2], conversionBuffer, 0);

     sprintf(conversionBuffer, "%d", localVar3);
     Tcl_SetVar(interpreter, argv[3], conversionBuffer, 0);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int
 * XawPanedGetNumSub
 * 	in: Widget			# paned widget
 */

int 
com_panedGetNumSub(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("panedGetNumSub");  

     if (argc != 2) 
	 {
	 argcError("panedGetNumSub","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("panedGetNumSub","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawPanedGetNumSub(localVar1);

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawPanedSetMinMax
 * 	in: Widget			# paned widget
 * 	in: int				# min
 * 	in: int				# max
 */

int 
com_panedSetMinMax(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;

     DBUG_ENTER("panedSetMinMax");  

     if (argc != 4) 
	 {
	 argcError("panedSetMinMax","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("panedSetMinMax","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("panedSetMinMax","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%d", &localVar3)))
          {
          convError("panedSetMinMax","3",argv[3],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     XawPanedSetMinMax(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void 
 * XawPanedSetRefigureMode
 * 	in: Widget			# paned widget
 * 	in: Boolean			# boolean
 */

int 
com_panedSetRefigureMode(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER("panedSetRefigureMode");  

     if (argc != 3) 
	 {
	 argcError("panedSetRefigureMode","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("panedSetRefigureMode","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("panedSetRefigureMode","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XawPanedSetRefigureMode(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/Scrollbar.h>
/* 
 * void
 * XawScrollbarSetThumb
 * 	in: Widget			# scrollbar widget
 * 	in: float			# top
 * 	in: float			# shown
 */

int 
com_scrollbarSetThumb(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     float localVar2;
     float localVar3;

     DBUG_ENTER("scrollbarSetThumb");  

     if (argc != 4) 
	 {
	 argcError("scrollbarSetThumb","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("scrollbarSetThumb","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%f", &localVar2)))
          {
          convError("scrollbarSetThumb","2",argv[2],"float");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%f", &localVar3)))
          {
          convError("scrollbarSetThumb","3",argv[3],"float");
          DBUG_RETURN (TCL_ERROR);
          }

     XawScrollbarSetThumb(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/Simple.h>
#include <X11/Xaw/SimpleMenu.h>
/* 
 * void 
 * XawSimpleMenuClearActiveEntry
 * 	in: Widget			# widget
 */

int 
com_simpleMenuClearActiveEntry(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("simpleMenuClearActiveEntry");  

     if (argc != 2) 
	 {
	 argcError("simpleMenuClearActiveEntry","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("simpleMenuClearActiveEntry","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawSimpleMenuClearActiveEntry(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * Widget
 * XawSimpleMenuGetActiveEntry
 * 	in: Widget			# widget
 */

int 
com_simpleMenuGetActiveEntry(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("simpleMenuGetActiveEntry");  

     if (argc != 2) 
	 {
	 argcError("simpleMenuGetActiveEntry","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("simpleMenuGetActiveEntry","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawSimpleMenuGetActiveEntry(localVar1);

     
     Tcl_SetResult(comInterpreter, XtName(returnVar), TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/StripChart.h>
/*  Hi emacs! Use  -*-C-*- mode  */

typedef struct _scInfo
     {
     double            value;
     Widget            widget;
     struct _scInfo   *next;
     } scInfo, *scInfoPtr;

scInfoPtr  scBegin = NULL;

void 
stripChartSet(sCWidget, value)
Widget  sCWidget;
double  value;
     {
     scInfoPtr   countPtr;

     if (!scBegin)         /* No Stripchart widgets exists yet*/
          {
          fprintf(stderr, "Wafe(scSet): No stripChart widget exists yet!\n");
          return;
          }

     for (countPtr = scBegin; 
          countPtr->widget != sCWidget && countPtr->next != NULL;
          countPtr = countPtr->next);

     if ((countPtr->next == NULL) && countPtr->widget != sCWidget)
          {
          fprintf(stderr, "Wafe(scSet): stripChart widget %s unknown\n", 
		  XtName(sCWidget));
          return;
          }

     DBUG_PRINT("sc",("Setting = %s to %f\n", 
		      XtName(countPtr->widget),value));

     countPtr->value = value;
     }


void
scQueryProc(w, clientData, value)
Widget    w;
XtPointer clientData;
XtPointer value;
     {
     scInfoPtr   countPtr;

     DBUG_ENTER("Query");

     for (countPtr = scBegin; countPtr->widget != w;
          countPtr = countPtr->next);

     DBUG_PRINT("sc",("Name = %s, value = %f", 
		      XtName(countPtr->widget), countPtr->value));
/*
      fprintf(stderr,"float = %f\n",countPtr->value);
 */
     *((double*)value) = countPtr->value;

     DBUG_VOID_RETURN;
     }

Widget
stripChartCreate(father, name, args, numArgs)
Widget   father;
char     *name;
ArgList  args;
Cardinal numArgs;
    {
    Widget new;
    
    scInfoPtr  countPtr = (scInfoPtr)XtNew(scInfo);
    countPtr->next   = scBegin;
    countPtr->value  = 0.0;  /* default value */
    countPtr->widget = new = XtCreateWidget(name, stripChartWidgetClass, 
					    father, args, numArgs);
    scBegin = countPtr;
    XtAddCallback(new, "getValue", scQueryProc, NULL);  

    return(new);
    }


/* 
 * void
 * stripChartSet
 * 	in: Widget			# strip chart widget
 * 	in: double			# value
 */

int 
com_stripChartSet(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     double localVar2;

     DBUG_ENTER("stripChartSet");  

     if (argc != 3) 
	 {
	 argcError("stripChartSet","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("stripChartSet","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%lf", &localVar2)))
          {
          convError("stripChartSet","2",argv[2],"double");
          DBUG_RETURN (TCL_ERROR);
          }

     stripChartSet(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTextDisableRedisplay
 * 	in: Widget			# ascii text wiget
 */

int 
com_textDisableRedisplay(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("textDisableRedisplay");  

     if (argc != 2) 
	 {
	 argcError("textDisableRedisplay","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("textDisableRedisplay","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawTextDisableRedisplay(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTextDisplay
 * 	in: Widget			# ascii text wiget
 */

int 
com_textDisplay(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("textDisplay");  

     if (argc != 2) 
	 {
	 argcError("textDisplay","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("textDisplay","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawTextDisplay(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTextDisplayCaret
 * 	in: Widget			# ascii text wiget
 * 	in: Boolean			# boolean
 */

int 
com_textDisplayCaret(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER("textDisplayCaret");  

     if (argc != 3) 
	 {
	 argcError("textDisplayCaret","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("textDisplayCaret","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("textDisplayCaret","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XawTextDisplayCaret(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTextEnableRedisplay
 * 	in: Widget			# ascii text wiget
 */

int 
com_textEnableRedisplay(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("textEnableRedisplay");  

     if (argc != 2) 
	 {
	 argcError("textEnableRedisplay","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("textEnableRedisplay","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawTextEnableRedisplay(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XawTextPosition
 * XawTextGetInsertionPoint
 * 	in: Widget			# ascii text wiget
 */

int 
com_textGetInsertionPoint(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("textGetInsertionPoint");  

     if (argc != 2) 
	 {
	 argcError("textGetInsertionPoint","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("textGetInsertionPoint","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawTextGetInsertionPoint(localVar1);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void 
 * XawTextGetSelectionPos
 *         in: Widget 			# ascii text wiget
 *         out: XawTextPosition		# varname for from position
 *         out: XawTextPosition 		# varname for to position
 */

int 
com_textGetSelectionPos(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;
     XawTextPosition localVar3;
     char conversionBuffer[100];

     DBUG_ENTER("textGetSelectionPos");  

     if (argc != 4) 
	 {
	 argcError("textGetSelectionPos","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("textGetSelectionPos","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawTextGetSelectionPos(localVar1,&localVar2,&localVar3);

     sprintf(conversionBuffer, "%ld", localVar2);
     Tcl_SetVar(interpreter, argv[2], conversionBuffer, 0);

     sprintf(conversionBuffer, "%ld", localVar3);
     Tcl_SetVar(interpreter, argv[3], conversionBuffer, 0);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTextInvalidate
 * 	in: Widget			# ascii text wiget
 * 	in: XawTextPosition		# from postion
 * 	in: XawTextPosition		# to postion
 */

int 
com_textInvalidate(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;
     XawTextPosition localVar3;

     DBUG_ENTER("textInvalidate");  

     if (argc != 4) 
	 {
	 argcError("textInvalidate","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("textInvalidate","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("textInvalidate","2",argv[2],"XawTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
          {
          convError("textInvalidate","3",argv[3],"XawTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     XawTextInvalidate(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XawTextPosition
 * XawTextSearch
 * 	in: Widget			# ascii text wiget
 * 	in: XawTextScanDirection	# scan direction
 * 	in: XawTextBlock		# text block
 */

int 
com_textSearch(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextScanDirection localVar2;
     XawTextBlock localVar3;
     XawTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("textSearch");  

     if (argc != 4) 
	 {
	 argcError("textSearch","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("textSearch","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "left")) 
         localVar2 = XawsdLeft;
     else
     if (!strcmp(argv[2], "right")) 
         localVar2 = XawsdRight;
     else
     if (!strcmp(argv[2], "Left")) 
         localVar2 = XawsdLeft;
     else
     if (!strcmp(argv[2], "Right")) 
         localVar2 = XawsdRight;
     else
         {
         convError("textSearch","2",argv[2],"XawTextScanDirection");
         DBUG_RETURN (TCL_ERROR);
        }


     { char *charp;
         if (!(charp=Tcl_GetVar2(interpreter,argv[3],"firstPos", 0)))
               {
               noVarCompError("textSearch",argv[3],"firstPos");
               DBUG_RETURN (TCL_ERROR);
               }
         if (!(sscanf(charp, "%d", &localVar3.firstPos)))
              {
              convError("textSearch","3.firstPos",charp,"int");
              DBUG_RETURN (TCL_ERROR);
              }

         if (!(charp=Tcl_GetVar2(interpreter,argv[3],"length", 0)))
               {
               noVarCompError("textSearch",argv[3],"length");
               DBUG_RETURN (TCL_ERROR);
               }
         if (!(sscanf(charp, "%d", &localVar3.length)))
              {
              convError("textSearch","3.length",charp,"int");
              DBUG_RETURN (TCL_ERROR);
              }

         if (!(charp=Tcl_GetVar2(interpreter,argv[3],"ptr", 0)))
               {
               noVarCompError("textSearch",argv[3],"ptr");
               DBUG_RETURN (TCL_ERROR);
               }
         localVar3.ptr = charp;
     }

     returnVar = XawTextSearch(localVar1,localVar2,&localVar3);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTextSetInsertionPoint
 * 	in: Widget			# ascii text wiget
 * 	in: XawTextPosition		# position
 */

int 
com_textSetInsertionPoint(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;

     DBUG_ENTER("textSetInsertionPoint");  

     if (argc != 3) 
	 {
	 argcError("textSetInsertionPoint","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("textSetInsertionPoint","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("textSetInsertionPoint","2",argv[2],"XawTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     XawTextSetInsertionPoint(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void 
 * XawTextSetSelection
 *         in: Widget 			# ascii text wiget
 *         in: XawTextPosition		# from position
 *         in: XawTextPosition 		# to position
 */

int 
com_textSetSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;
     XawTextPosition localVar3;

     DBUG_ENTER("textSetSelection");  

     if (argc != 4) 
	 {
	 argcError("textSetSelection","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("textSetSelection","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("textSetSelection","2",argv[2],"XawTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
          {
          convError("textSetSelection","3",argv[3],"XawTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     XawTextSetSelection(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTextSetSelectionArray
 * 	in: Widget			# ascii text wiget
 * 	in: [XawTextSelectType]		# selction array
 */

int 
com_textSetSelectionArray(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextSelectType * localVar2;

     DBUG_ENTER("textSetSelectionArray");  

     if (argc < 3) 
	 {
	 argcError("textSetSelectionArray","at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("textSetSelectionArray","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     {    XawTextSelectType *ptr;
          argv += 2;
          localVar2 = ptr =
             (XawTextSelectType *)XtMalloc((argc-2)*sizeof(XawTextSelectType));

          while (*argv)
             {
             if (!strcmp(*argv, "selectAll")) 
                 *ptr = XawselectAll;
             else
             if (!strcmp(*argv, "selectChar")) 
                 *ptr = XawselectChar;
             else
             if (!strcmp(*argv, "selectLine")) 
                 *ptr = XawselectLine;
             else
             if (!strcmp(*argv, "selectNull")) 
                 *ptr = XawselectNull;
             else
             if (!strcmp(*argv, "selectParagraph")) 
                 *ptr = XawselectParagraph;
             else
             if (!strcmp(*argv, "selectPosition")) 
                 *ptr = XawselectPosition;
             else
             if (!strcmp(*argv, "selectWord")) 
                 *ptr = XawselectWord;
             else
                 {
                 convError("textSetSelectionArray","2",*argv,"XawTextSelectType");
                 DBUG_RETURN (TCL_ERROR);
                }


          ptr ++; argv++;
          }
     }
     XawTextSetSelectionArray(localVar1,localVar2);
     MMreplace(MMgetAttribList(localVar1),XrmStringToQuark("textSetSelectionArray"),(char*)localVar2,XtFree);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int
 * XawTextSinkMaxHeight
 * 	in: (Widget)TextSink 		# ascii text wiget
 * 	in: int				# height
 */

int 
com_textSinkMaxHeight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("textSinkMaxHeight");  

     if (argc != 3) 
	 {
	 argcError("textSinkMaxHeight","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Sink(argv[1])))
          {
          convError("textSinkMaxHeight","1",argv[1],"TextSink");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%d", &localVar2)))
          {
          convError("textSinkMaxHeight","2",argv[2],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawTextSinkMaxHeight(localVar1,localVar2);

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * int
 * XawTextSinkMaxLines
 * 	in: (Widget)TextSink		# ascii text wiget
 * 	in: Dimension			# height
 */

int 
com_textSinkMaxLines(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Dimension localVar2;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("textSinkMaxLines");  

     if (argc != 3) 
	 {
	 argcError("textSinkMaxLines","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Sink(argv[1])))
          {
          convError("textSinkMaxLines","1",argv[1],"TextSink");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%hu", &localVar2)))
          {
          convError("textSinkMaxLines","2",argv[2],"Dimension");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawTextSinkMaxLines(localVar1,localVar2);

     sprintf(conversionBuffer, "%d", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawTextSinkSetTabs
 * 	in: (Widget)TextSink		# ascii text wiget
 * 	const: argc-2
 * 	in: [int]			# tabs
 */

int 
com_textSinkSetTabs(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int * localVar2;

     DBUG_ENTER("textSinkSetTabs");  

     if (argc < 3) 
	 {
	 argcError("textSinkSetTabs","at least ",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Sink(argv[1])))
          {
          convError("textSinkSetTabs","1",argv[1],"TextSink");
          DBUG_RETURN (TCL_ERROR);
          }

     {    int *ptr;
          argv += 2;
          localVar2 = ptr =
             (int *)XtMalloc((argc-2)*sizeof(int));

          while (*argv)
             {
             if (!(sscanf(*argv, "%d", &*ptr)))
                  {
                  convError("textSinkSetTabs","2",*argv,"int");
                  DBUG_RETURN (TCL_ERROR);
                  }

          ptr ++; argv++;
          }
     }
     XawTextSinkSetTabs(localVar1,argc-2,localVar2);
     MMreplace(MMgetAttribList(localVar1),XrmStringToQuark("textSinkSetTabs"),(char*)localVar2,XtFree);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XawTextPosition
 * XawTextSourceRead 
 * 	in: (Widget)TextSource		# ascii text wiget
 * 	in: XawTextPosition		# position
 * 	out: XawTextBlock		# varname for text block
 * 	in: int				# length
 */

int 
com_textSourceRead(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;
     XawTextBlock localVar3;
     int localVar4;
     XawTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("textSourceRead");  

     if (argc != 5) 
	 {
	 argcError("textSourceRead","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Source(argv[1])))
          {
          convError("textSourceRead","1",argv[1],"TextSource");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("textSourceRead","2",argv[2],"XawTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[4], "%d", &localVar4)))
          {
          convError("textSourceRead","4",argv[4],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawTextSourceRead(localVar1,localVar2,&localVar3,localVar4);

          sprintf(conversionBuffer, "%d", localVar3.firstPos);
     Tcl_SetVar2(interpreter,argv[3],"firstPos", conversionBuffer,0);
     sprintf(conversionBuffer, "%d", localVar3.length);
     Tcl_SetVar2(interpreter,argv[3],"length", conversionBuffer,0);
     
     Tcl_SetVar2(interpreter,argv[3],"ptr", localVar3.ptr,0);


     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XawTextPosition
 * XawTextSourceScan
 * 	in: (Widget)TextSource		# ascii text wiget
 * 	in: XawTextPosition		# position
 * 	in: XawTextScanType		# scan type
 * 	in: XawTextScanDirection	# scan direction
 * 	in: int				# count
 * 	in: Boolean			# include (boolean)
 */

int 
com_textSourceScan(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;
     XawTextScanType localVar3;
     XawTextScanDirection localVar4;
     int localVar5;
     Boolean localVar6;
     XawTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("textSourceScan");  

     if (argc != 7) 
	 {
	 argcError("textSourceScan","",6,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Source(argv[1])))
          {
          convError("textSourceScan","1",argv[1],"TextSource");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("textSourceScan","2",argv[2],"XawTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[3], "position")) 
         localVar3 = XawstPositions;
     else
     if (!strcmp(argv[3], "whiteSpace")) 
         localVar3 = XawstWhiteSpace;
     else
     if (!strcmp(argv[3], "EOL")) 
         localVar3 = XawstEOL;
     else
     if (!strcmp(argv[3], "paragraph")) 
         localVar3 = XawstParagraph;
     else
     if (!strcmp(argv[3], "all")) 
         localVar3 = XawstAll;
     else
         {
         convError("textSourceScan","3",argv[3],"XawTextScanType");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!strcmp(argv[4], "left")) 
         localVar4 = XawsdLeft;
     else
     if (!strcmp(argv[4], "right")) 
         localVar4 = XawsdRight;
     else
     if (!strcmp(argv[4], "Left")) 
         localVar4 = XawsdLeft;
     else
     if (!strcmp(argv[4], "Right")) 
         localVar4 = XawsdRight;
     else
         {
         convError("textSourceScan","4",argv[4],"XawTextScanDirection");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!(sscanf(argv[5], "%d", &localVar5)))
          {
          convError("textSourceScan","5",argv[5],"int");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[6], "true")) 
         localVar6 = 1;
     else
     if (!strcmp(argv[6], "false")) 
         localVar6 = 0;
     else
         {
         convError("textSourceScan","6",argv[6],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     returnVar = XawTextSourceScan(localVar1,localVar2,localVar3,localVar4,localVar5,localVar6);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * XawTextPosition
 * XawTextTopPosition
 * 	in: Widget			# ascii text wiget
 */

int 
com_textTopPosition(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("textTopPosition");  

     if (argc != 2) 
	 {
	 argcError("textTopPosition","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("textTopPosition","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawTextTopPosition(localVar1);

     sprintf(conversionBuffer, "%ld", returnVar);
     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * (int) ReplaceVal 
 * XawTextReplace
 *         in: Widget			# ascii text wiget
 *         in: XawTextPosition 		# from position
 *         in: XawTextPosition 		# to position
 *         in: XawTextBlock		# text block
 */

int 
com_textReplace(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XawTextPosition localVar2;
     XawTextPosition localVar3;
     XawTextBlock localVar4;
     int returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("textReplace");  

     if (argc != 5) 
	 {
	 argcError("textReplace","",4,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("textReplace","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
          {
          convError("textReplace","2",argv[2],"XawTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
          {
          convError("textReplace","3",argv[3],"XawTextPosition");
          DBUG_RETURN (TCL_ERROR);
          }

     { char *charp;
         if (!(charp=Tcl_GetVar2(interpreter,argv[4],"firstPos", 0)))
               {
               noVarCompError("textReplace",argv[4],"firstPos");
               DBUG_RETURN (TCL_ERROR);
               }
         if (!(sscanf(charp, "%d", &localVar4.firstPos)))
              {
              convError("textReplace","4.firstPos",charp,"int");
              DBUG_RETURN (TCL_ERROR);
              }

         if (!(charp=Tcl_GetVar2(interpreter,argv[4],"length", 0)))
               {
               noVarCompError("textReplace",argv[4],"length");
               DBUG_RETURN (TCL_ERROR);
               }
         if (!(sscanf(charp, "%d", &localVar4.length)))
              {
              convError("textReplace","4.length",charp,"int");
              DBUG_RETURN (TCL_ERROR);
              }

         if (!(charp=Tcl_GetVar2(interpreter,argv[4],"ptr", 0)))
               {
               noVarCompError("textReplace",argv[4],"ptr");
               DBUG_RETURN (TCL_ERROR);
               }
         localVar4.ptr = charp;
     }

     returnVar = XawTextReplace(localVar1,localVar2,localVar3,&localVar4);

          if (returnVar == XawEditDone) 
          strcpy(conversionBuffer, "editDone");
     else
     if (returnVar == XawPositionError) 
          strcpy(conversionBuffer, "positionError");
     else
     if (returnVar == XawEditError) 
          strcpy(conversionBuffer, "editError");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void 
 * XawTextUnsetSelection
 *         in: Widget 			# ascii text wiget
 */

int 
com_textUnsetSelection(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("textUnsetSelection");  

     if (argc != 2) 
	 {
	 argcError("textUnsetSelection","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("textUnsetSelection","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawTextUnsetSelection(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/Toggle.h>
/* 
 * void
 * XawToggleChangeRadioGroup
 * 	in: Widget			# toggle widget
 * 	in: NULL | Widget		# NULL | toggle widget
 */

int 
com_toggleChangeRadioGroup(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;

     DBUG_ENTER("toggleChangeRadioGroup");  

     if (argc != 3) 
	 {
	 argcError("toggleChangeRadioGroup","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("toggleChangeRadioGroup","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "NULL")) 
         localVar2 = NULL;
     else
         if (!(localVar2 = (Widget) name2Widget(argv[2])))
          {
          convError("toggleChangeRadioGroup","2",argv[2],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawToggleChangeRadioGroup(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * String
 * XawToggleGetCurrent
 * 	in: Widget			# toggle widget
 */

int 
com_toggleGetCurrent(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String returnVar;

     DBUG_ENTER("toggleGetCurrent");  

     if (argc != 2) 
	 {
	 argcError("toggleGetCurrent","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("toggleGetCurrent","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XawToggleGetCurrent(localVar1);

     
     Tcl_SetResult(comInterpreter, returnVar, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawToggleSetCurrent
 * 	in: Widget			# toggle widget
 * 	in: String			# radio data
 */

int 
com_toggleSetCurrent(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String localVar2;

     DBUG_ENTER("toggleSetCurrent");  

     if (argc != 3) 
	 {
	 argcError("toggleSetCurrent","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("toggleSetCurrent","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     XawToggleSetCurrent(localVar1,argv[2]);

     DBUG_RETURN (TCL_OK);
     }     


#define toggleSetRadioData(w, string) XtVaSetValues(w, XtNradioData, string, NULL)

/* 
 * void
 * toggleSetRadioData
 * 	in: Widget			# toggle widget
 *         in: XtNewString(String)		# radio data
 */

int 
com_toggleSetRadioData(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String localVar2;

     DBUG_ENTER("toggleSetRadioData");  

     if (argc != 3) 
	 {
	 argcError("toggleSetRadioData","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("toggleSetRadioData","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     toggleSetRadioData(localVar1,XtNewString(argv[2]));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XawToggleUnsetCurrent
 * 	in: Widget			# toggle widget
 */

int 
com_toggleUnsetCurrent(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("toggleUnsetCurrent");  

     if (argc != 2) 
	 {
	 argcError("toggleUnsetCurrent","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("toggleUnsetCurrent","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XawToggleUnsetCurrent(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


#include <X11/Xaw/Viewport.h>
/* 
 * hint: R5
 * void
 * XawViewportSetCoordinates
 * 	in: Widget			# viewport Widget
 * 	in: Position			# x position
 * 	in: Position			# y position
 */
#ifndef PRER5

int 
com_viewportSetCoordinates(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Position localVar2;
     Position localVar3;

     DBUG_ENTER("viewportSetCoordinates");  

     if (argc != 4) 
	 {
	 argcError("viewportSetCoordinates","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("viewportSetCoordinates","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%hd", &localVar2)))
          {
          convError("viewportSetCoordinates","2",argv[2],"Position");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%hd", &localVar3)))
          {
          convError("viewportSetCoordinates","3",argv[3],"Position");
          DBUG_RETURN (TCL_ERROR);
          }

     XawViewportSetCoordinates(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     

#endif

/* 
 * hint: R5
 * void
 * XawViewportSetLocation
 * 	in: Widget			# viewport Widget
 * 	in: double			# xoffset 
 * 	in: double			# yoffset

 */
#ifndef PRER5

int 
com_viewportSetLocation(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     double localVar2;
     double localVar3;

     DBUG_ENTER("viewportSetLocation");  

     if (argc != 4) 
	 {
	 argcError("viewportSetLocation","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("viewportSetLocation","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[2], "%lf", &localVar2)))
          {
          convError("viewportSetLocation","2",argv[2],"double");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(sscanf(argv[3], "%lf", &localVar3)))
          {
          convError("viewportSetLocation","3",argv[3],"double");
          DBUG_RETURN (TCL_ERROR);
          }

     XawViewportSetLocation(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     

#endif

#else
#include <string.h>
#endif

void
Initialize_XawGen()
{
#ifdef ATHENA
 createWidgetCommand("asciiText",asciiTextWidgetClass,NULL);
 createWidgetCommand("box",boxWidgetClass,NULL);
 createWidgetCommand("clock",clockWidgetClass,NULL);
 createWidgetCommand("command",commandWidgetClass,NULL);
 createWidgetCommand("dialog",dialogWidgetClass,NULL);
 createWidgetCommand("form",formWidgetClass,NULL);
#ifdef XEDW
 createWidgetCommand("edwList",xedwListWidgetClass,NULL);
#endif
 createWidgetCommand("grip",gripWidgetClass,NULL);
 createWidgetCommand("label",labelWidgetClass,NULL);
 createWidgetCommand("list",listWidgetClass,NULL);
 createWidgetCommand("logo",logoWidgetClass,NULL);
 createWidgetCommand("mailbox",mailboxWidgetClass,NULL);
 createWidgetCommand("menuButton",menuButtonWidgetClass,NULL);
 createWidgetCommand("paned",panedWidgetClass,NULL);
 createWidgetCommand("scrollbar",scrollbarWidgetClass,NULL);
 createWidgetCommand("simple",simpleWidgetClass,NULL);
 createWidgetCommand("simpleMenu",simpleMenuWidgetClass,XtCreatePopupShell);
 createWidgetCommand("sme",smeObjectClass,NULL);
 createWidgetCommand("smeBSB",smeBSBObjectClass,NULL);
 createWidgetCommand("smeLine",smeLineObjectClass,NULL);
 createWidgetCommand("stripChart",stripChartWidgetClass,stripChartCreate);
 createWidgetCommand("toggle",toggleWidgetClass,NULL);
 createWidgetCommand("viewport",viewportWidgetClass,NULL);
#ifdef ATHENA
 strcat(packages,"ATHENA ");
#endif
#ifdef XAW3D
 strcat(packages,"XAW3D ");
#endif
#ifdef XEDW
 strcat(packages,"XEDW ");
#endif
 Tcl_CreateCommand(interpreter, "asciiSave", com_asciiSave, NULL, NULL);
 Tcl_CreateCommand(interpreter, "asciiSaveAsFile", com_asciiSaveAsFile, NULL, NULL);
 Tcl_CreateCommand(interpreter, "asciiSourceChanged", com_asciiSourceChanged, NULL, NULL);
 Tcl_CreateCommand(interpreter, "asciiSourceFreeString", com_asciiSourceFreeString, NULL, NULL);
 Tcl_CreateCommand(interpreter, "asciiTextAppend", com_asciiTextAppend, NULL, NULL);
 Tcl_CreateCommand(interpreter, "dialogGetValueString", com_dialogGetValueString, NULL, NULL);
#ifdef XEDW
 Tcl_CreateCommand(interpreter, "edwListChange", com_edwListChange, NULL, NULL);
#endif
#ifdef XEDW
 Tcl_CreateCommand(interpreter, "edwListShowCurrent", com_edwListShowCurrent, NULL, NULL);
#endif
 Tcl_CreateCommand(interpreter, "formDoLayout", com_formDoLayout, NULL, NULL);
 Tcl_CreateCommand(interpreter, "listAppend", com_listAppend, NULL, NULL);
 Tcl_CreateCommand(interpreter, "listChange", com_listChange, NULL, NULL);
 Tcl_CreateCommand(interpreter, "listHighlight", com_listHighlight, NULL, NULL);
 Tcl_CreateCommand(interpreter, "listShowCurrent", com_listShowCurrent, NULL, NULL);
 Tcl_CreateCommand(interpreter, "listUnhighlight", com_listUnhighlight, NULL, NULL);
 Tcl_CreateCommand(interpreter, "panedAllowResize", com_panedAllowResize, NULL, NULL);
 Tcl_CreateCommand(interpreter, "panedGetMinMax", com_panedGetMinMax, NULL, NULL);
 Tcl_CreateCommand(interpreter, "panedGetNumSub", com_panedGetNumSub, NULL, NULL);
 Tcl_CreateCommand(interpreter, "panedSetMinMax", com_panedSetMinMax, NULL, NULL);
 Tcl_CreateCommand(interpreter, "panedSetRefigureMode", com_panedSetRefigureMode, NULL, NULL);
 Tcl_CreateCommand(interpreter, "scrollbarSetThumb", com_scrollbarSetThumb, NULL, NULL);
 /* alias */  Tcl_CreateCommand(interpreter,"scSet",com_stripChartSet, NULL,NULL);
 Tcl_CreateCommand(interpreter, "simpleMenuClearActiveEntry", com_simpleMenuClearActiveEntry, NULL, NULL);
 Tcl_CreateCommand(interpreter, "simpleMenuGetActiveEntry", com_simpleMenuGetActiveEntry, NULL, NULL);
 Tcl_CreateCommand(interpreter, "stripChartSet", com_stripChartSet, NULL, NULL);
 Tcl_CreateCommand(interpreter, "textDisableRedisplay", com_textDisableRedisplay, NULL, NULL);
 Tcl_CreateCommand(interpreter, "textDisplay", com_textDisplay, NULL, NULL);
 Tcl_CreateCommand(interpreter, "textDisplayCaret", com_textDisplayCaret, NULL, NULL);
 Tcl_CreateCommand(interpreter, "textEnableRedisplay", com_textEnableRedisplay, NULL, NULL);
 Tcl_CreateCommand(interpreter, "textGetInsertionPoint", com_textGetInsertionPoint, NULL, NULL);
 Tcl_CreateCommand(interpreter, "textGetSelectionPos", com_textGetSelectionPos, NULL, NULL);
 Tcl_CreateCommand(interpreter, "textInvalidate", com_textInvalidate, NULL, NULL);
 Tcl_CreateCommand(interpreter, "textSearch", com_textSearch, NULL, NULL);
 Tcl_CreateCommand(interpreter, "textSetInsertionPoint", com_textSetInsertionPoint, NULL, NULL);
 Tcl_CreateCommand(interpreter, "textSetSelection", com_textSetSelection, NULL, NULL);
 Tcl_CreateCommand(interpreter, "textSetSelectionArray", com_textSetSelectionArray, NULL, NULL);
 Tcl_CreateCommand(interpreter, "textSinkMaxHeight", com_textSinkMaxHeight, NULL, NULL);
 Tcl_CreateCommand(interpreter, "textSinkMaxLines", com_textSinkMaxLines, NULL, NULL);
 Tcl_CreateCommand(interpreter, "textSinkSetTabs", com_textSinkSetTabs, NULL, NULL);
 Tcl_CreateCommand(interpreter, "textSourceRead", com_textSourceRead, NULL, NULL);
 Tcl_CreateCommand(interpreter, "textSourceScan", com_textSourceScan, NULL, NULL);
 Tcl_CreateCommand(interpreter, "textTopPosition", com_textTopPosition, NULL, NULL);
 Tcl_CreateCommand(interpreter, "textReplace", com_textReplace, NULL, NULL);
 Tcl_CreateCommand(interpreter, "textUnsetSelection", com_textUnsetSelection, NULL, NULL);
 Tcl_CreateCommand(interpreter, "toggleChangeRadioGroup", com_toggleChangeRadioGroup, NULL, NULL);
 Tcl_CreateCommand(interpreter, "toggleGetCurrent", com_toggleGetCurrent, NULL, NULL);
 Tcl_CreateCommand(interpreter, "toggleSetCurrent", com_toggleSetCurrent, NULL, NULL);
 Tcl_CreateCommand(interpreter, "toggleSetRadioData", com_toggleSetRadioData, NULL, NULL);
 Tcl_CreateCommand(interpreter, "toggleUnsetCurrent", com_toggleUnsetCurrent, NULL, NULL);
#ifndef PRER5
 Tcl_CreateCommand(interpreter, "viewportSetCoordinates", com_viewportSetCoordinates, NULL, NULL);
#endif
#ifndef PRER5
 Tcl_CreateCommand(interpreter, "viewportSetLocation", com_viewportSetLocation, NULL, NULL);
#endif

#else
#endif
}
