/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Sun Jun 27 23:42:24 MET DST 1993 on dec4.wu-wien.ac.at
 * Author: genc
 * Version: 0.92
 */
#ifdef MOTIF11
#include <stdio.h>

#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Shell.h>

#include "wafe.h"

/* make emcas happy -*-C-*-  make emacs happy */

#include <ctype.h>

#define MAX_STRING_SEGMENT 4096
#define MAX_FORMAT_LEN 50


XmStringCharSet    defaultCharSet;


/*
 * Initialize the default character Set variable!
 */

void
compStringInit()
    {
    XmString          dummy;
    XmStringContext   strContext;
    char              *text;
    XmStringDirection dummyDir;
    Boolean           dummySep;    
    
    dummy = XmStringCreateSimple("dummy");

    if (!XmStringInitContext(&strContext, dummy))
	{
	fprintf(stderr, "Wafe(motif): Couldn't create string Context\n");
	exit(-1);
	}

    XmStringGetNextSegment(strContext, &text, &defaultCharSet, 
			   &dummyDir, &dummySep);
    XtFree(text);
    XmStringFree(dummy);
/*
    fprintf(stderr, "Setting defaultCharSet to %s\n", defaultCharSet);
 */
    }



/*
 * Utility function: Creates a new compound string segment, appends it to an existing
 * XmString. Does NOT create a segement if the string is empty!
 */

XmString
compStringAppend(oldCompStr, text, charSet, dir, sep)
XmString           oldCompStr;
char              *text;
XmStringCharSet    charSet;
XmStringDirection  dir;
Boolean            sep;
    {
    XmString  addSeg, newString;
    
    if (*text == '\0' && sep)
	return(oldCompStr);

/*
    fprintf(stderr, "Generated segment with <%s>\n", text);
 */

    if (!oldCompStr)
	return(XmStringSegmentCreate(text, charSet, dir, sep));
    else
	{
	addSeg = XmStringSegmentCreate(text, charSet, dir, sep);
	newString = XmStringConcat(oldCompStr, addSeg);
	XmStringFree(addSeg);
	XmStringFree(oldCompStr);
	return(newString);
	}
    }

XmString    
stringToXmString(inString)
char  *inString;
    {
    char               segBuf[MAX_STRING_SEGMENT];
    char               formatBuf[MAX_FORMAT_LEN];
    XmStringCharSet    charSet = XmSTRING_DEFAULT_CHARSET; 
    XmStringDirection  dir = XmSTRING_DIRECTION_L_TO_R;
    XmString           result = NULL;
    char              *segPtr = segBuf;
    char              *ptr = inString;
    char              *top;
    
/*
    fprintf(stderr, "Converting string <%s>\n", inString);
*/
    top = ptr + strlen(inString);
    *segPtr = '\0';
    while (ptr < top)
	{
	switch (*ptr)
	    {
	    case '\n':
	    /* NewLine: Finish current segment */

	    *segPtr = '\0';
            result = compStringAppend(result, segBuf, charSet, dir, True);
	    segPtr = segBuf;
	    ptr++;
	    break;
	    
	    case '^':
            /* Enter command mode */
	    ptr++;

	    if (ptr == top)
		{
		fprintf(stderr, 
		    "Wafe(XmString Conversion): Cannot handle trailing '^'\n");
		return NULL;
		}

	    if (*ptr == '^')
		{
		/* Two ^ => leave command mode, insert one ^ */
		*segPtr++ = '^';
		ptr++;
		}
	    else
		if (!isalpha(*ptr))
		    {
                    /* ^ + whatever not alphabetic => ignore ^ */
		    *segPtr++ = *ptr++;
		    }
		else
		    {
		    char   *comPtr = formatBuf;
		    
		    /* Terminate current segment */
		    *segPtr = '\0';
		    result = compStringAppend(result, segBuf, 
					      charSet, dir, True);
		    segPtr = segBuf;
				
		    /* Extract command */
		    while ((isalnum(*ptr) 
			    || (*ptr == '-') 
			    || (*ptr == '_')) 
			   && (ptr <= top))
			*comPtr++ = *ptr++;

		    *comPtr = '\0';
/*
		    fprintf(stderr, "Parsed command <%s>\n", formatBuf);
 */
		    if (!strcmp(formatBuf, "lr"))
			dir = XmSTRING_DIRECTION_L_TO_R;		    
		    else
			if (!strcmp(formatBuf, "rl"))
			    dir = XmSTRING_DIRECTION_R_TO_L;
			else
			    charSet = XtNewString(formatBuf);

		    if (*ptr == ' ')
			ptr++;
		    }
	    break;
	    	    
	    default:
	    *segPtr++ = *ptr++;
	    break;

	    } /* switch */	    
	} /* while */

    *segPtr = '\0';
    result = compStringAppend(result, segBuf, charSet, dir, False);

    return result;
    }

/* Queries a XmString Value and translates it to a valid input string */

char *
xmString2String(buffer,compStr)
char          * buffer;
XmString      compStr;
    {
    XmStringContext    strContext;
    char               *text;
    XmStringCharSet    charSet, 
                       lastCharSet = defaultCharSet;
    XmStringDirection  dir, 
                       lastDir = XmSTRING_DIRECTION_L_TO_R;
    Boolean            sep;
    char               *returnString, *ptr;
    
    if (!XmStringInitContext(&strContext, compStr))
	{
	fprintf(stderr, "Wafe(motif): Couldn't create string Context\n");
	return(NULL);
	}

    if (!buffer) 
	{
	ptr = returnString = XtMalloc(XmStringLength(compStr)); /* ??? */
/*	fprintf(stderr, "buffer new allocated %p\n", ptr);*/
	}
    else
	{
/*	fprintf(stderr, "using provided buffer %p\n", buffer);*/
	ptr = returnString = buffer;	
	}


    while (XmStringGetNextSegment(strContext, &text, &charSet, &dir, &sep))
	{
	char *textPtr = text;

	/* This means: If there are no changes in charSet or direction, just make a newline
	 * but don't do it, if this is the first segment 
	 */
	if ((!strcmp(charSet, lastCharSet)) 
	    && (dir == lastDir) 
	    && (returnString != ptr))
	    *ptr++ = '\n'; 
	
	if (strcmp(charSet, lastCharSet)) 
	    {
            *ptr++ = '^';
	    strcpy(ptr, charSet);
	    ptr+= strlen(charSet);
	    *ptr++ = ' ';
	    lastCharSet = charSet;
	    }

	if (dir != lastDir) 
	    {
	    if (dir == XmSTRING_DIRECTION_L_TO_R)
		strcpy(ptr, "^lr ");
	    else
		strcpy(ptr, "^rl ");		
	    ptr+=4;
	    lastDir = dir;
	    }	    

	while (*textPtr != '\0')
	    {
	    if (*textPtr == '^')
		{
		strcpy(ptr, "^^");
		ptr +=2;
		textPtr++;
		}
	    else
		*ptr++ = *textPtr++;
	    }
	}
    *ptr = '\0';
    XmStringFreeContext(strContext);
    return(returnString);
    }

void
exmString2String(buffer,compStr)
char          * buffer;
XmString      compStr;
    {
    char *p = xmString2String(NULL,compStr);
    estrcpy(buffer,p);
    XtFree(p);
    }



char *
xmStringTable2String(count,strTable)
int           count;
XmStringTable strTable;
    {
    char    **temp, **cPtr;
    XmString  *ptr = strTable;
    char      *result;
    int        i;

/*    fprintf(stderr, "string table to string: count = %d, stringTable = %p \n",count,strTable);
 */
/*
    if (!count && strTable) 
	{
        fprintf(stderr, "counting...\n");
	while(*ptr++)
	    {
	    fprintf(stderr, "count = %d\n",count);
	    count++;
	    }
	}
  */  
    
    temp = (char **)XtMalloc(count*sizeof(char *));
    for (ptr=strTable, cPtr=temp, i=count; i>0; ptr++, cPtr++, i--) 
	{
/*	fprintf(stderr, "calling xmString2String\n"); */
	*cPtr = xmString2String(NULL,*ptr);
/*	fprintf(stderr, "it returned %p <%s>, ptr placed to %p\n",*cPtr,*cPtr, cPtr); */
	}
    

    result = Tcl_Merge(count, temp);
    
/*    for (ptr = strTable, i=count; i>0; ptr++, i--)
	{
	fprintf(stderr, "freeing %p, pointer at %p\n",*ptr, ptr);
	XtFree(*ptr);
	}
*/  

    for (cPtr = temp, i=count; i>0; cPtr++, i--)
	{
/*	fprintf(stderr, "freeing %p, pointer at %p\n",*cPtr, cPtr);*/
	XtFree(*cPtr);
	}
  
    XtFree(temp);
    return(result); 
    }

/*
 * Two converter function wrappers for the *2String functions, which are 
 * called by getValues
 */

Boolean
CvtXmStringToString(dpy, args, num_args, fromVal, toVal, converterData)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converterData;
    {
    static char *result;

    result = xmString2String(NULL,(XmString)(fromVal->addr));
    toVal->addr = result;
    toVal->size = 1; /* if nobody else uses this converter it shouldn't matter anyway */
    return(True);
    }


Boolean
CvtXmStringTableToString(dpy, args, num_args, fromVal, toVal, converter_data)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converter_data;
    {
    static char *result;
    
    result = xmStringTable2String(0,(XmStringTable)(fromVal->addr));
    fprintf(stderr, "Conversion done, res:%s\n", result);
    toVal->addr = result;
    toVal->size = 1; /* it should not matter either */
    return(True);
    }


void
freeStringTab(table)
XmStringTable  table;
    {
    while (*table != NULL)
	XmStringFree(*table++);
    }	    
    


Boolean
CvtStringToXmStrings(dpy, args, num_args, fromVal, toVal, converter_data)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converter_data;
    {
    int               argc, count;
    char            **argv;
    XmString         *ptr;
    static XmString  *result;

    if (Tcl_SplitList(interpreter,(char*)fromVal->addr, &argc, &argv) 
	!= TCL_OK)
	{
	fprintf(stderr, "Wafe(XmStringTableConversion): %s\n", 
		interpreter->result);
	XtDisplayStringConversionWarning(dpy, (char *)fromVal->addr, 
					 "XmString");
	return False;
	}
	
    result = (XmString *)XtMalloc(argc*sizeof(XmString));
    for(count = 0, ptr = result; count < argc; count++, ptr++) 
	if ((*ptr = stringToXmString(argv[count])) == NULL)
	    {
	    XtDisplayStringConversionWarning(dpy, (char *)fromVal->addr, 
					     "XmString");
	    return False;
	    }
    toVal->size = sizeof(XmString **);
    toVal->addr = (caddr_t)&result;

    MMreplace(currentAttribList, currentAttrib, (char *)&result, freeStringTab);

    return True;
    }


Boolean
CvtStringToXmString(dpy, args, num_args, fromVal, toVal,
                                converter_data)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converter_data;
    {
    static XmString  result;
    
    if ((result =  stringToXmString((char *)fromVal->addr)) == NULL)
	{
	XtDisplayStringConversionWarning(dpy, (char *)fromVal->addr, 
					 "XmString");
	return False;
	}
    
    toVal->size = sizeof(XmString *);
    toVal->addr = (caddr_t)&result;

    MMreplace(currentAttribList, currentAttrib, (char *)&result, XmStringFree);
    return True;
    }









#include <Xm/ArrowB.h>
#include <Xm/ArrowBG.h>
#include <Xm/BulletinB.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
/* 
 * void 
 * XmCascadeButtonGadgetHighlight
 * 	in: Widget           # cascadeButtonGadget to be highlighted
 * 	in: Boolean          # highlight (bool)
 */

int 
com_mCascadeButtonGadgetHighlight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER("mCascadeButtonGadgetHighlight");  

     if (argc != 3) 
	 {
	 argcError("mCascadeButtonGadgetHighlight","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("mCascadeButtonGadgetHighlight","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("mCascadeButtonGadgetHighlight","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmCascadeButtonGadgetHighlight(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void 
 * XmCascadeButtonHighlight
 * 	in: Widget           # widget to be highlighted
 * 	in: Boolean          # highlight (bool)
 */

int 
com_mCascadeButtonHighlight(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER("mCascadeButtonHighlight");  

     if (argc != 3) 
	 {
	 argcError("mCascadeButtonHighlight","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("mCascadeButtonHighlight","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("mCascadeButtonHighlight","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmCascadeButtonHighlight(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/Command.h>
/* 
 * void
 * XmCommandAppendValue
 * 	in: Widget           # command widget 
 * 	in: XmString         # command string
 * 	post: XmStringFree(localVar2);
 */

int 
com_mCommandAppendValue(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER("mCommandAppendValue");  

     if (argc != 3) 
	 {
	 argcError("mCommandAppendValue","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("mCommandAppendValue","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) stringToXmString(argv[2])))
          {
          convError("mCommandAppendValue","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     XmCommandAppendValue(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmCommandError
 * 	in: Widget           # command widget 
 * 	in: XmString         # error message
 * 	post: XmStringFree(localVar2);
 */

int 
com_mCommandError(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER("mCommandError");  

     if (argc != 3) 
	 {
	 argcError("mCommandError","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("mCommandError","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) stringToXmString(argv[2])))
          {
          convError("mCommandError","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     XmCommandError(localVar1,localVar2);
     XmStringFree(localVar2);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/DialogS.h>
#include <Xm/DrawingA.h>
#include <Xm/DrawnB.h>
#include <Xm/FileSB.h>
/* 
 * Widget
 * XmFileSelectionBoxGetChild
 * 	in: Widget			# message box widget
 * 	in: (unsigned char)XmChild 	# child reference
 */

int 
com_mFileSelectionBoxGetChild(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     unsigned char localVar2;
     Widget returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("mFileSelectionBoxGetChild");  

     if (argc != 3) 
	 {
	 argcError("mFileSelectionBoxGetChild","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("mFileSelectionBoxGetChild","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "DIALOG_CANCEL_BUTTON")) 
         localVar2 = XmDIALOG_CANCEL_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_DEFAULT_BUTTON")) 
         localVar2 = XmDIALOG_DEFAULT_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_HELP_BUTTON")) 
         localVar2 = XmDIALOG_HELP_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_OK_BUTTON")) 
         localVar2 = XmDIALOG_OK_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_SEPARATOR")) 
         localVar2 = XmDIALOG_SEPARATOR;
     else
     if (!strcmp(argv[2], "DIALOG_SYMBOL_LABEL")) 
         localVar2 = XmDIALOG_SYMBOL_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_MESSAGE_LABEL")) 
         localVar2 = XmDIALOG_MESSAGE_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_APPLY_BUTTON")) 
         localVar2 = XmDIALOG_APPLY_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_DIR_LIST")) 
         localVar2 = XmDIALOG_DIR_LIST;
     else
     if (!strcmp(argv[2], "DIALOG_DIR_LIST_LABEL")) 
         localVar2 = XmDIALOG_DIR_LIST_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_FILTER_LABEL")) 
         localVar2 = XmDIALOG_FILTER_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_FILTER_TEXT")) 
         localVar2 = XmDIALOG_FILTER_TEXT;
     else
     if (!strcmp(argv[2], "DIALOG_LIST")) 
         localVar2 = XmDIALOG_LIST;
     else
     if (!strcmp(argv[2], "DIALOG_LIST_LABEL")) 
         localVar2 = XmDIALOG_LIST_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_SELECTION_LABEL")) 
         localVar2 = XmDIALOG_SELECTION_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_TEXT")) 
         localVar2 = XmDIALOG_TEXT;
     else
     if (!strcmp(argv[2], "DIALOG_WORK_AREA")) 
         localVar2 = XmDIALOG_WORK_AREA;
     else
         {
         convError("mFileSelectionBoxGetChild","2",argv[2],"XmChild");
         DBUG_RETURN (TCL_ERROR);
        }


     returnVar = XmFileSelectionBoxGetChild(localVar1,localVar2);

     
     Tcl_SetResult(comInterpreter, XtName(returnVar), TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmFileSelectionDoSearch
 * 	in: Widget			# file selection box
 * 	in: XmString			# directory mask
 */

int 
com_mFileSelectionDoSearch(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     XmString localVar2;

     DBUG_ENTER("mFileSelectionDoSearch");  

     if (argc != 3) 
	 {
	 argcError("mFileSelectionDoSearch","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("mFileSelectionDoSearch","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!(localVar2 = (XmString) stringToXmString(argv[2])))
          {
          convError("mFileSelectionDoSearch","2",argv[2],"XmString");
          DBUG_RETURN (TCL_ERROR);
          }

     XmFileSelectionDoSearch(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/List.h>
#include <Xm/MainW.h>
/* 
 * void
 * XmMainWindowSetAreas
 * 	in: NULL | Widget	# main window widget
 * 	in: NULL | Widget	# menu bar widget
 * 	in: NULL | Widget	# command window widget
 * 	in: NULL | Widget	# horizontal scrollbar widget
 * 	in: NULL | Widget	# vertical scrollbar widget
 * 	in: NULL | Widget	# work region widget
 */

int 
com_mMainWindowSetAreas(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Widget localVar2;
     Widget localVar3;
     Widget localVar4;
     Widget localVar5;
     Widget localVar6;

     DBUG_ENTER("mMainWindowSetAreas");  

     if (argc != 7) 
	 {
	 argcError("mMainWindowSetAreas","",6,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!strcmp(argv[1], "NULL")) 
         localVar1 = NULL;
     else
         if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("mMainWindowSetAreas","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "NULL")) 
         localVar2 = NULL;
     else
         if (!(localVar2 = (Widget) name2Widget(argv[2])))
          {
          convError("mMainWindowSetAreas","2",argv[2],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[3], "NULL")) 
         localVar3 = NULL;
     else
         if (!(localVar3 = (Widget) name2Widget(argv[3])))
          {
          convError("mMainWindowSetAreas","3",argv[3],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[4], "NULL")) 
         localVar4 = NULL;
     else
         if (!(localVar4 = (Widget) name2Widget(argv[4])))
          {
          convError("mMainWindowSetAreas","4",argv[4],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[5], "NULL")) 
         localVar5 = NULL;
     else
         if (!(localVar5 = (Widget) name2Widget(argv[5])))
          {
          convError("mMainWindowSetAreas","5",argv[5],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[6], "NULL")) 
         localVar6 = NULL;
     else
         if (!(localVar6 = (Widget) name2Widget(argv[6])))
          {
          convError("mMainWindowSetAreas","6",argv[6],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmMainWindowSetAreas(localVar1,localVar2,localVar3,localVar4,localVar5,localVar6);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/MenuShell.h>
#include <Xm/MessageB.h>
/* 
 * Widget
 * XmMessageBoxGetChild
 * 	in: Widget			# message box widget
 * 	in: (unsigned char)XmChild 	# child reference
 */

int 
com_mMessageBoxGetChild(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     unsigned char localVar2;
     Widget returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("mMessageBoxGetChild");  

     if (argc != 3) 
	 {
	 argcError("mMessageBoxGetChild","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("mMessageBoxGetChild","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "DIALOG_CANCEL_BUTTON")) 
         localVar2 = XmDIALOG_CANCEL_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_DEFAULT_BUTTON")) 
         localVar2 = XmDIALOG_DEFAULT_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_HELP_BUTTON")) 
         localVar2 = XmDIALOG_HELP_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_OK_BUTTON")) 
         localVar2 = XmDIALOG_OK_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_SEPARATOR")) 
         localVar2 = XmDIALOG_SEPARATOR;
     else
     if (!strcmp(argv[2], "DIALOG_SYMBOL_LABEL")) 
         localVar2 = XmDIALOG_SYMBOL_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_MESSAGE_LABEL")) 
         localVar2 = XmDIALOG_MESSAGE_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_APPLY_BUTTON")) 
         localVar2 = XmDIALOG_APPLY_BUTTON;
     else
     if (!strcmp(argv[2], "DIALOG_DIR_LIST")) 
         localVar2 = XmDIALOG_DIR_LIST;
     else
     if (!strcmp(argv[2], "DIALOG_DIR_LIST_LABEL")) 
         localVar2 = XmDIALOG_DIR_LIST_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_FILTER_LABEL")) 
         localVar2 = XmDIALOG_FILTER_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_FILTER_TEXT")) 
         localVar2 = XmDIALOG_FILTER_TEXT;
     else
     if (!strcmp(argv[2], "DIALOG_LIST")) 
         localVar2 = XmDIALOG_LIST;
     else
     if (!strcmp(argv[2], "DIALOG_LIST_LABEL")) 
         localVar2 = XmDIALOG_LIST_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_SELECTION_LABEL")) 
         localVar2 = XmDIALOG_SELECTION_LABEL;
     else
     if (!strcmp(argv[2], "DIALOG_TEXT")) 
         localVar2 = XmDIALOG_TEXT;
     else
     if (!strcmp(argv[2], "DIALOG_WORK_AREA")) 
         localVar2 = XmDIALOG_WORK_AREA;
     else
         {
         convError("mMessageBoxGetChild","2",argv[2],"XmChild");
         DBUG_RETURN (TCL_ERROR);
        }


     returnVar = XmMessageBoxGetChild(localVar1,localVar2);

     
     Tcl_SetResult(comInterpreter, XtName(returnVar), TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/PanedW.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/Scale.h>
#include <Xm/ScrollBar.h>
#include <Xm/ScrolledW.h>
#include <Xm/SelectioB.h>
#include <Xm/Separator.h>
#include <Xm/SeparatoG.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/ToggleB.h>
/* 
 * Boolean
 * XmToggleButtonGetState
 * 	in: Widget		# toggle button widget
 */

int 
com_mToggleButtonGetState(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("mToggleButtonGetState");  

     if (argc != 2) 
	 {
	 argcError("mToggleButtonGetState","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("mToggleButtonGetState","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmToggleButtonGetState(localVar1);

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmToggleButtonSetState
 * 	in: Widget		# toggle button widget
 * 	in: Boolean		# state (bool)
 * 	in: Boolean             # notify (bool)
 */

int 
com_mToggleButtonSetState(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;
     Boolean localVar3;

     DBUG_ENTER("mToggleButtonSetState");  

     if (argc != 4) 
	 {
	 argcError("mToggleButtonSetState","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("mToggleButtonSetState","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("mToggleButtonSetState","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!strcmp(argv[3], "true")) 
         localVar3 = 1;
     else
     if (!strcmp(argv[3], "false")) 
         localVar3 = 0;
     else
         {
         convError("mToggleButtonSetState","3",argv[3],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmToggleButtonSetState(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


#include <Xm/ToggleBG.h>
/* 
 * Boolean
 * XmToggleButtonGadgetGetState
 * 	in: Widget		# toggle button widget
 */

int 
com_mToggleButtonGadgetGetState(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;
     char conversionBuffer[100];

     DBUG_ENTER("mToggleButtonGadgetGetState");  

     if (argc != 2) 
	 {
	 argcError("mToggleButtonGadgetGetState","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("mToggleButtonGadgetGetState","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     returnVar = XmToggleButtonGadgetGetState(localVar1);

          if (returnVar == 1) 
          strcpy(conversionBuffer, "true");
     else
     if (returnVar == 0) 
          strcpy(conversionBuffer, "false");


     Tcl_SetResult(comInterpreter, conversionBuffer, TCL_VOLATILE);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmToggleButtonGadgetSetState
 * 	in: Widget		# toggle button gadget
 * 	in: Boolean		# state (bool)
 * 	in: Boolean             # notify (bool)
 */

int 
com_mToggleButtonGadgetSetState(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;
     Boolean localVar3;

     DBUG_ENTER("mToggleButtonGadgetSetState");  

     if (argc != 4) 
	 {
	 argcError("mToggleButtonGadgetSetState","",3,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("mToggleButtonGadgetSetState","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     if (!strcmp(argv[2], "true")) 
         localVar2 = 1;
     else
     if (!strcmp(argv[2], "false")) 
         localVar2 = 0;
     else
         {
         convError("mToggleButtonGadgetSetState","2",argv[2],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     if (!strcmp(argv[3], "true")) 
         localVar3 = 1;
     else
     if (!strcmp(argv[3], "false")) 
         localVar3 = 0;
     else
         {
         convError("mToggleButtonGadgetSetState","3",argv[3],"Boolean");
         DBUG_RETURN (TCL_ERROR);
        }


     XmToggleButtonGadgetSetState(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XmAddTabGroup
 * 	in: Widget        # widget to be added
 */

int 
com_mAddTabGroup(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER("mAddTabGroup");  

     if (argc != 2) 
	 {
	 argcError("mAddTabGroup","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("mAddTabGroup","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

     XmAddTabGroup(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


#else
#include <string.h>
#endif

void
Initialize_XmGen()
{
#ifdef MOTIF11
 createWidgetCommand("mArrowButton",xmArrowButtonWidgetClass,NULL);
 createWidgetCommand("mArrowButtonGadget",xmArrowButtonGadgetClass,NULL);
 createWidgetCommand("mBulletinBoard",xmBulletinBoardWidgetClass,NULL);
 createWidgetCommand("mBulletinBoardDialog",xmDialogShellWidgetClass,XmCreateBulletinBoardDialog);
 createWidgetCommand("mCascadeButton",xmCascadeButtonWidgetClass,NULL);
 createWidgetCommand("mCascadeButtonGadget",xmCascadeButtonGadgetClass,NULL);
 createWidgetCommand("mCommand",xmCommandWidgetClass,NULL);
 createWidgetCommand("mDialogShell",xmDialogShellWidgetClass,NULL);
 createWidgetCommand("mDrawingArea",xmDrawingAreaWidgetClass,NULL);
 createWidgetCommand("mDrawnButton",xmDrawnButtonWidgetClass,NULL);
 createWidgetCommand("mFileSelectionBox",xmFileSelectionBoxWidgetClass,NULL);
 createWidgetCommand("mFileSelectionDialog",xmDialogShellWidgetClass,XmCreateFileSelectionDialog);
 createWidgetCommand("mForm",xmFormWidgetClass,NULL);
 createWidgetCommand("mFormDialog",xmDialogShellWidgetClass,XmCreateFormDialog);
 createWidgetCommand("mFrame",xmFrameWidgetClass,NULL);
 createWidgetCommand("mInformationDialog",xmDialogShellWidgetClass,XmCreateInformationDialog);
 createWidgetCommand("mLabel",xmLabelWidgetClass,NULL);
 createWidgetCommand("mLabelGadget",xmLabelGadgetClass,NULL);
 createWidgetCommand("mList",xmListWidgetClass,NULL);
 createWidgetCommand("mMainWindow",xmMainWindowWidgetClass,NULL);
 createWidgetCommand("mMenuBar",xmRowColumnWidgetClass,XmCreateMenuBar);
 createWidgetCommand("mMenuShell",xmMenuShellWidgetClass,NULL);
 createWidgetCommand("mMessageBox",xmMessageBoxWidgetClass,NULL);
 createWidgetCommand("mMessageDialog",xmMessageBoxWidgetClass,XmCreateMessageDialog);
 createWidgetCommand("mOptionMenu",xmRowColumnWidgetClass,XmCreateOptionMenu);
 createWidgetCommand("mPanedWindow",xmPanedWindowWidgetClass,NULL);
 createWidgetCommand("mPopupMenu",xmRowColumnWidgetClass,XmCreatePopupMenu);
 createWidgetCommand("mPromptDialog",xmDialogShellWidgetClass,XmCreatePromptDialog);
 createWidgetCommand("mPulldownMenu",xmRowColumnWidgetClass,XmCreatePulldownMenu);
 createWidgetCommand("mPushButton",xmPushButtonWidgetClass,NULL);
 createWidgetCommand("mPushButtonGadget",xmPushButtonGadgetClass,NULL);
 createWidgetCommand("mQuestionDialog",xmDialogShellWidgetClass,XmCreateQuestionDialog);
 createWidgetCommand("mRadioBox",xmRowColumnWidgetClass,XmCreateRadioBox);
 createWidgetCommand("mRowColumn",xmRowColumnWidgetClass,NULL);
 createWidgetCommand("mScale",xmScaleWidgetClass,NULL);
 createWidgetCommand("mScrollBar",xmScrollBarWidgetClass,NULL);
 createWidgetCommand("mScrolledList",xmListWidgetClass,XmCreateScrolledList);
 createWidgetCommand("mScrolledText",xmTextWidgetClass,XmCreateScrolledText);
 createWidgetCommand("mScrolledWindow",xmScrolledWindowWidgetClass,NULL);
 createWidgetCommand("mSelectionBox",xmSelectionBoxWidgetClass,NULL);
 createWidgetCommand("mSelectionDialog",xmDialogShellWidgetClass,XmCreateSelectionDialog);
 createWidgetCommand("mSeparator",xmSeparatorWidgetClass,NULL);
 createWidgetCommand("mSeparatorGadget",xmSeparatorGadgetClass,NULL);
 createWidgetCommand("mSimpleCheckBox",xmRowColumnWidgetClass,XmCreateSimpleCheckBox);
 createWidgetCommand("mSimpleMenuBar",xmRowColumnWidgetClass,XmCreateSimpleMenuBar);
 createWidgetCommand("mSimpleOptionMenu",xmRowColumnWidgetClass,XmCreateSimpleOptionMenu);
 createWidgetCommand("mSimplePopupMenu",xmRowColumnWidgetClass,XmCreateSimplePopupMenu);
 createWidgetCommand("mSimplePulldownMenu",xmRowColumnWidgetClass,XmCreateSimplePulldownMenu);
 createWidgetCommand("mSimpleRadioBox",xmRowColumnWidgetClass,XmCreateSimpleRadioBox);
 createWidgetCommand("mText",xmTextWidgetClass,NULL);
 createWidgetCommand("mTextField",xmTextFieldWidgetClass,NULL);
 createWidgetCommand("mToggleButton",xmToggleButtonWidgetClass,NULL);
 createWidgetCommand("mToggleButtonGadget",xmToggleButtonGadgetClass,NULL);
 createWidgetCommand("mWarningDialog",xmDialogShellWidgetClass,XmCreateWarningDialog);
 createWidgetCommand("mWorkingDialog",xmDialogShellWidgetClass,XmCreateWorkingDialog);
#ifdef MOTIF11
 strcat(packages,"MOTIF11 ");
#endif
 XtSetTypeConverter(XtRString, "XmString",
	(XtTypeConverter)CvtStringToXmString, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, "XmStringTable",
	(XtTypeConverter)CvtStringToXmStrings, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, "Window",
	(XtTypeConverter)CvtStringToWidget, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter(XtRString, "MenuWidget",
	(XtTypeConverter)CvtStringToWidget, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter("XmString", XtRString,
	(XtTypeConverter)CvtXmStringToString, 
	NULL, 0, XtCacheNone, NULL);
 XtSetTypeConverter("XmStringTable", XtRString,
	(XtTypeConverter)CvtXmStringTableToString, 
	NULL, 0, XtCacheNone, NULL);
 compStringInit();
 XtAddConverter (XmRString, XmRUnitType, XmCvtStringToUnitType, NULL, 0);;
 Tcl_CreateCommand(interpreter, "mCascadeButtonGadgetHighlight", com_mCascadeButtonGadgetHighlight, NULL, NULL);
 Tcl_CreateCommand(interpreter, "mCascadeButtonHighlight", com_mCascadeButtonHighlight, NULL, NULL);
 Tcl_CreateCommand(interpreter, "mCommandAppendValue", com_mCommandAppendValue, NULL, NULL);
 Tcl_CreateCommand(interpreter, "mCommandError", com_mCommandError, NULL, NULL);
 Tcl_CreateCommand(interpreter, "mFileSelectionBoxGetChild", com_mFileSelectionBoxGetChild, NULL, NULL);
 Tcl_CreateCommand(interpreter, "mFileSelectionDoSearch", com_mFileSelectionDoSearch, NULL, NULL);
 Tcl_CreateCommand(interpreter, "mMainWindowSetAreas", com_mMainWindowSetAreas, NULL, NULL);
 Tcl_CreateCommand(interpreter, "mMessageBoxGetChild", com_mMessageBoxGetChild, NULL, NULL);
 Tcl_CreateCommand(interpreter, "mToggleButtonGetState", com_mToggleButtonGetState, NULL, NULL);
 Tcl_CreateCommand(interpreter, "mToggleButtonSetState", com_mToggleButtonSetState, NULL, NULL);
 Tcl_CreateCommand(interpreter, "mToggleButtonGadgetGetState", com_mToggleButtonGadgetGetState, NULL, NULL);
 Tcl_CreateCommand(interpreter, "mToggleButtonGadgetSetState", com_mToggleButtonGadgetSetState, NULL, NULL);
 Tcl_CreateCommand(interpreter, "mAddTabGroup", com_mAddTabGroup, NULL, NULL);

#else
#endif
}
