/*                               -*- Mode: C -*- 
 * rdd.h
 * 
 * Description     : Header file for rdd, plus a few other things
 * 					 that rdd needs declared.
 * 
 * Author          : Roger Reynolds
 * Created On      : Wed Jun 17 12:05:55 1992
 * 
 * Configuration Management
 * 
 * @(#)rdd.h	1.7	10/5/92
 * 
 * VERSION   SPR   MODIFIER   DATE AND TIME
 * 1.7       0     rogerr     Mon Oct  5 14:34:36 1992
 *           more gcc stuff. 
 * 1.6       0     rogerr     Tue Sep 29 11:41:27 1992
 *           GCC2.2.2 clean up. Can now be cleanly compiled without 
 *           -traditional. 
 * 1.5       0     rogerr     Thu Aug 27 15:20:08 1992
 *           clean up for C++ part 1 
 * 1.4       0     rogerr     Wed Jul 15 14:49:27 1992
 *           send keymask in RddCallbackStruct so dropee knows what was 
 *           going on 
 * 1.3       0     rogerr     Tue Jun 23 17:08:58 1992
 *           now dragging pixmaps around 
 * 
 */

#ifndef RDD_LIB_H
#define RDD_LIB_H

#include <stdio.h>
#include <errno.h>

#ifdef MAIN
/*
 * The only thing that needs Xm is rddDragCallback, you can lose or modify
 * it if you are not using Motif.
 */
#include <Xm/Xm.h>
#endif

#undef _PROTO_ARGS_
#undef const
#if ((defined(__STDC__) || defined(SABER)) && !defined(NO_PROTOTYPE)) || defined(__cplusplus)
#   define _PROTO_ARGS_(x)	x
#   define CONST const
#   ifdef __cplusplus
#       define VARARGS (...)
#   else
#       define VARARGS ()
#   endif
#else
#   define _PROTO_ARGS_(x)	()
#   define CONST
#endif

#ifdef __cplusplus
#   define EXTERN extern "C"
#else
#   define EXTERN extern
#endif


/*
 *  Execute the code in the DEBUG macro if defined 
 */
#ifdef DEBUG_ON
#define DEBUG(x) {x}
#else
#define DEBUG(x)
#endif

/*
 *  Print the (string) message given, along with file and line number 
 */
#ifdef TRACE_ON
#define TRACE(x) fprintf(stderr, "TRACE %s %s,%d\n", (x), __FILE__, __LINE__)
#else
#define TRACE(x)
#endif

/*
 * This will make free go alot slower, but should trap cases where 
 * the pointer being deallocated is not within the allocated memory area,
 * like if it was the address of a variable on the stack.
 */
#ifdef DEBUG_FREE_ON
#define XtFree(x) \
	(((unsigned long)x == 0) ? fprintf(stderr, "Attempt to free NULL at %s %d\n", __FILE__, __LINE__) : \
	 (((unsigned long)x > sbrk(0)) ? fprintf(stderr, "Attempt to free non allocated address at %s %d\n", __FILE__, __LINE__) : free(x)))

#endif

/* A few predefined data types */
#define RDD_NO_DATA_TYPE	0		/* unspecified drop data type		*/
#define RDD_FILENAME_TYPE	1		/* filename in drop data			*/

typedef struct _rddCallbackStruct
{
	caddr_t data;						/* pointer to dropped data	*/
	int  len;							/* length of data			*/
	int  type;							/* type of data dropped		*/
	Window from;						/* Window message is from	*/
	u_int keymask;						/* keybord modifier mask	*/
	XClientMessageEvent *event;			/* the ClientMessage event	*/
} RddCallbackStruct;	

EXTERN	void	rddInit 	
	_PROTO_ARGS_((Widget shell, XtAppContext appContext));

EXTERN	void	rddAppMainLoop 
	_PROTO_ARGS_((XtAppContext appContext));

EXTERN	void	rddAddDropHandler
	_PROTO_ARGS_((Widget w, XtCallbackProc proc, caddr_t call));

EXTERN	void	rddSendDropEvent
	_PROTO_ARGS_((Widget w, XEvent *event));

EXTERN	void	 rddSetDropData
	_PROTO_ARGS_((caddr_t data, int size));

EXTERN	void	 rddStartAction
	_PROTO_ARGS_((Widget w, XButtonEvent *event, String *args, Cardinal *nargs));

EXTERN	void	 rddDragAction
	_PROTO_ARGS_((Widget w, XButtonEvent *event, String *args, Cardinal *nargs));

EXTERN	void	 rddDropAction
	_PROTO_ARGS_((Widget w, XButtonEvent *event, String *args, Cardinal *nargs));

#ifdef MOTIF11
EXTERN	void	 rddDragCallback
	_PROTO_ARGS_((Widget w, XtPointer call, XmAnyCallbackStruct *cbs));
#endif

#endif /*RDD_LIB_H*/


