/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Tue Jun 15 04:25:56 MET DST 1993 on dec4.wu-wien.ac.at
 * Author: genc
 * Version: 0.92
 */
#ifdef RDD
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "wafe.h"

/* -*- c -*- */
#include "rdd.h"

/* RDD myStartAction */
void myStartAction (w, event, args, nargs)
	Widget w;
	XButtonEvent *event;
	String *args;
	int *nargs;
{
	static Pixmap pixmap = (Pixmap) NULL;
	Display *dpy = XtDisplay(w);
	Dimension width, height;
	Position  x,y, xRoot, yRoot;
	static GC gc = NULL;

	XtVaGetValues(w, 
		      XtNx,&x, 
		      XtNy,&y,
		      XtNwidth, &width,
		      XtNheight, &height,
		      NULL);
	XtTranslateCoords(w,x,y,&xRoot,&yRoot);
	
	if (!gc) /* probleme mit multiscreen un diff depth */
	    {
	    XGCValues gcv;
	    gcv.subwindow_mode = IncludeInferiors;
	    gc = XCreateGC (dpy, XtWindow(w), GCSubwindowMode, &gcv);
	    }
	
	
	if (pixmap)
	    XFreePixmap(XtDisplay(w), pixmap);

	pixmap = XCreatePixmap (dpy, RootWindow(dpy,0), 
				width, height, XDefaultDepth(dpy,0));

	/* Create a pixmap of the widget */
	
	XCopyArea(dpy, XtWindow(w), pixmap, gc, 0,0, width, height, 0,0);
/*	XCopyArea(dpy, RootWindow(dpy,0), pixmap, gc, x,y, width, height, 0,0);*/
	
	rddSetDragPixmap (pixmap, width, height);
	rddSetDragCursorOffset(event->x, event->y);

	rddStartAction (w, event, args, nargs);		/* then use default action */
}

void
rddWafeInit()
    {
    static XtActionsRec actions[] = 
	{
	"rddDropAction", (XtActionProc) rddDropAction,
	"wStartAction", myStartAction,
	"rddStartAction", (XtActionProc) rddStartAction,
	NULL, NULL,
	};
    XtAppAddActions (appContext, actions, XtNumber(actions));
    rddInit(topLevel, appContext);
    }


/* 
 * void
 * rddSetDropData
 * 	in: XtNewString(String)   	# message string
 * 	const: strlen(argv[1])
 */

int 
com_rddSetDropData(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     String localVar1;

     DBUG_ENTER("rddSetDropData");  

     if (argc != 2) 
	 {
	 argcError("rddSetDropData","",1,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar1 = argv[1] >>  */ 

     rddSetDropData(XtNewString(argv[1]),strlen(argv[1]));

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * rddAddDropHandler
 * 	in: Widget		 	# widget	
 * 	const: (XtCallbackProc)rddDropCallbackProc
 * 	in: XtNewString(String)   	# message

 */

int 
com_rddAddDropHandler(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     String localVar2;

     DBUG_ENTER("rddAddDropHandler");  

     if (argc != 3) 
	 {
	 argcError("rddAddDropHandler","",2,argc);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
          {
          convError("rddAddDropHandler","1",argv[1],"Widget");
          DBUG_RETURN (TCL_ERROR);
          }

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     rddAddDropHandler(localVar1,(XtCallbackProc)rddDropCallbackProc,XtNewString(argv[2]));

     DBUG_RETURN (TCL_OK);
     }     


#else
#include <string.h>
#endif

void
Initialize_rddGen()
{
#ifdef RDD
#ifdef RDD
 strcat(packages,"RDD ");
#endif
 rddWafeInit();
 Tcl_CreateCommand(interpreter, "rddSetDropData", com_rddSetDropData, NULL, NULL);
 Tcl_CreateCommand(interpreter, "rddAddDropHandler", com_rddAddDropHandler, NULL, NULL);

#else
#endif
}
