.TH wafe 1
.SH NAME
.PP
wafe \- A frontend for Xt and the Athena widget applications
.ad
.SH SYNOPSIS
.PP
\f3wafe\f1 [\f3--c\f2character\f1] 
[\f3--e\f2 command\f1] 
[\f3--f\f2 filename\f1] 
[\f3--p\f2 program\f1] 
[\f3--D\f2DBUG-Option\f1] 
[\f3--i\f1] 
[\f3--v\f1] 
[\f3--n\f1] 
[\f3--d\f1] 
.PP
.SH DESCRIPTION 
.PP
Wafe stands for \fIwidget (Athena) front end\fP. Wafe can be used as
an interpretative scripting language or as tool to build graphical 
interfaces for programs in arbitrary programming languages.
The only prerequisite for an application program which want to
use Wafe as a frontend is that it must be able to write line buffered 
to its output (or at least to flush its output buffer). 

When Wafe is used as a frontend two separate processes are started \-
one of them the application, the other responsible for the user
interface. The application program (backend) communicates with the
frontend (Wafe) via standard using UNIX interprocess communication
facilities (streams or sockets). The application process can use the
graphical functionalities of \fIWafe\fP by writing the defined
commands to its output channel (stdout) and reading the information
sent back the front end via its standard input channel (stdin).  Since
\fIWafe\fP was developed using the extensible \fItcl\fP interpreter
language, an application program can dynamically submit requests to
the front end to build up the graphical user interface; the
application can also down-load application specific procedures into
the front end, which can be executed without interaction with the
backend application program.

.SH OPTIONS
.PP
The following are Wafe's own command line options, they won't be passed to
the application process.
.TP
\f3--c\f2character\f1
This option simply allows the user to specify the prompt character,
which is not used if \fI--n\fP is specified. The default prompt
character is "--".

.TP
\f3--f \f2filename\f1
Run Wafe in \fIfile mode\fP. The argument after \fI--f\fP
must be the name of a file containing valid Wafe commands. The
file will be executed by the tcl source command. Note that in this
mode no subprocess is started.

.TP
\f3--e \f2command\f1
Evaluate given command immediately after startup (can be used together 
with --p) 

.TP
\f3--p \f2program\f1
Wafe calls \fIprogram\fP as client process (alternative to link magic below)

.TP
\f3--D\f2DBUG option\f1 
This option can be combined with any mode. It passes the
specified option to Fred Fish's DBUG library.

.TP
\f3--i\f1
Switches to \fIinput mode\fP, which means that Wafe reads
from stdin (which it normally doesn't) and forwards the commands
to the client-application. Be aware that programs using \fIinput mode\fP
can't be executed in the background! This mode can be combined with
both \fIfile mode\fP and the two process standard mode.

.TP
\f3--v\f1
Prints the current version number of Wafe and exits immediately.

.TP
\f3--n\f1
Turn of the prompt character mechanism. This causes Wafe to
regard every message it receives from the application as a
Wafe command.

.TP
\f3--d\f1
Enter \fIdirect mode\fP; this is a special mode, which we use mostly
for devolping purposes. In direct mode, you can start Wafe itself
without a link, just by typing

.EX 0
   wafe --d --n
.EE

Commands are now read from  stdin, output is sent to
stdout.  Additionally, the option \fI --n\fP is recommended so that it
is unnecessary to prefix every command with the prompt character.




.SH STARTING A WAFE APPLICATION

The way, Wafe communicates with the application process is controlled
by various command line arguments. If Wafe is used as a frontend (none
of the options \fI--d\fP, \fI--f\fP or \fI--v\fP is specified), an
application program is started as a subprocess of Wafe.  The name of
the application program is obtained either from the \fI--p myprog\fP
option or from the name of the calling program: If the Wafe
application is called \fImyprog\fP and a link from Wafe to the name
\fIx\fPmyprog is made (note the leading x), executing \fIx\fPmyprog
starts Wafe with myprog as a subprocess.

Example:
.EX 0
   ln -s /bin/X11/wafe xmyprog 
   xmyprog
.EE 

If your local Unix variant does not support symbolic links, a hard
link may be used instead of the symbolic link in the example above.
Wafe searches all directories in the path for the specified program
and spawns the child-process \fImyprog\fP.

The application \fImyprog\fP looses it's standard input and output
streams, it's diagnostic output will be merged with Wafe's stderr.
Wafe communicates with the application by reading it's stdout and
writing to stdin.  Commands to Wafe must be prefixed by a so called
prompt character, defaulting to "%", otherwise they are just echoed to
Wafe's standard output. The prompt character can be changed with the
\fI--c\fP command line option.  Furthermore, if you want Wafe to
accept commands without prompt character, use the \fI--n\fP command
line option (This means that the application completely looses its
output stream).

For the full set of Wafe commands refer to the Wafe documentation, which
is included in the distribution.

The application class is derivated from the \fI--p\fP option or from
the link's name by capitalizing the "x" and the first letter of the
executable; any dots will be substituted by dashes. This is the name,
under which \fIX\fP searches the application's defaults file. So, in
our example, the class is \fIXMyprog\fP and the corresponding
app-defaults file will be searched. The application instance name is
the link's name with any dots substituted by dashes.

Command line arguments are passed to the client provided that they do
not begin with the characters "--", which is reserved for Wafe's
arguments. Thus the command line

.EX 0
   xmyprog -r filename --n -display friendly.host:0
.EE 

will cause Wafe to spawn the process \fImyprog\fP as follows:

.EX 0
   myprog -r filename
.EE 

The "--n" option is one of Wafe's command line arguments, which are
described above. The arguments "-display friendly.host:0" are
processed as standard X toolkit options.

.SH "EARLY BEGINNINGS"

Save the following lines in a file named "hello":
.EX 0
   #!/usr/bin/X11/wafe --f
   command c topLevel label "Wafe new World" callback {echo Goodbye; quit}
   realize
.EE

Assuming your system supports the #! notation, you might invoke the
little demo program (after setting it executable) by typing "hello".
Otherwise you might issue the command "wafe --f hello".


.SH "SEE ALSO"
.PP
Tcl(3)
dbug(3)
wafeapp(n),
X(1),
xwafemail(n),
xwafenews(n),
xwafeftp(n),
xwafeora(n),
xwafetel(n),
xdirtree(n),
xdirtree(n),
xprojektor(n),
xbm(n),
xwafemc(n),
xruptimes(n),
xnetstats(n),
xiostats(n),
xvmstats(n),
xwafeping(n),
xwafecf(n)

.SH COPYRIGHT
.PP
 Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser
.EX 0
    Wirtschaftsuniversitaet Wien, 
    Abteilung fuer Wirtschaftsinformatik
    Augasse 2-6, 
    A-1090 Vienna, Austria
    neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
.EE
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appears in all copies and that both that
copyright notice and this permission notice appear in all supporting
documentation.  This software is provided "as is" without expressed or
implied warranty.
.PP
.SH AUTHORS
.PP
Gustaf Neumann, Stefan Nusser

