create sequence dokumentnr start with 1000;

create table ordner (
		     o_kurz char(10) primary key,
		     o_lang char(30),
		     o_typ char(10),                            /* ein- oder ausgangsordner */
		     abt_nummer number(5),             /* o_kurz u.u. nur pro abt eindeutig */
		     ben_nummer number(5)              /* nummer des erfassers */
		     ) pctfree 20
       ;

create table dokument (
		       d_nummer number(6) not null primary key,
		       o_kurz char(10) not null references ordner(o_kurz),
		       dok_datum date check (dok_datum <= ein_datum),
		       ein_datum date check (ein_datum <= erf_datum),
		       erf_datum date not null check (erf_datum >= ein_datum),
		       betreff char(255),                       
		       organisation char(50),
		       ort char(50),
		       name_absender char(50),
		       name_empfaenger char(50),
		       abt_nummer number(5),             /* ben_nummer u.u. nur pro abt eindeutig */
		       ben_nummer number(5)              /* nummer des erfassers */
		       ) pctfree 20
       ;

 create unique index i_ordner on ordner  (o_kurz);
create unique index i_dokument on dokument (d_nummer,o_kurz);


grant select on dokumentnr to neumann;
grant select on ordner to neumann;
grant select on dokument to neumann;

insert into ordner values ( 'Ein88', 'Eingangskorrespondenz 1988', 'ein', 1000, 1);
insert into ordner values ( 'Aus88', 'Ausgangskorrespondenz 1988', 'aus', 1000, 1);
insert into ordner values ( 'Ein89', 'Eingangskorrespondenz 1989', 'ein', 1000, 1);
insert into ordner values ( 'Aus89', 'Ausgangskorrespondenz 1989', 'aus', 1000, 1);
insert into ordner values ( 'Ein90', 'Eingangskorrespondenz 1990', 'ein', 1000, 1);
insert into ordner values ( 'Aus90', 'Ausgangskorrespondenz 1990', 'aus', 1000, 1);
insert into ordner values ( 'Ein91', 'Eingangskorrespondenz 1991', 'ein', 1000, 1);
insert into ordner values ( 'Aus91', 'Ausgangskorrespondenz 1991','aus', 1000, 1);
insert into ordner values ( 'R-Ein', 'Eingangskorrespondenz Rektorat', 'ein', 1000, 1);
insert into ordner values ( 'R-Aus', 'Ausgangskorrespondenz Rektorat','aus', 1000, 1);
insert into ordner values ( 'Stud', 'Ausgangskorrespondenz Rektorat', '', 20000, 1);
insert into ordner values ( 'Personal', 'Personal', '', 10, 1);

insert into dokument values ( 
			     dokumentnr.nextval, 'Ein', 
			     to_date('13-JAN-90'), to_date('14-JAN-90'), to_date('15-JAN-90'), 
			     'geht\ndas\neigentlich?',
			     'Angewandte Informatik', 'WU', 'Janko', 'Hansen', 10, 1);
 
insert into dokument values ( 
			     dokumentnr.nextval, 'Aus', 
			     to_date('14-JAN-90'), to_date('15-JAN-90'), to_date('16-JAN-90'), 
			     'eine zeile',
			     'bumiwuf', 'Freyung', 'Hansen', 'Axmann', 10, 2);
 








