/* das ist ein -*- C -*- Programm */
#include <X11/cursorfont.h>

#ifdef MOTIF11
#include <Xm/Xm.h>
#endif

extern Boolean ownSelection(
#if NeedFunctionPrototypes
     String, String, String
#endif
);

extern void action(
#if NeedFunctionPrototypes
     Widget, int, XtTranslations
#endif
);

extern void callback (
#if NeedFunctionPrototypes
     Widget, char *, XtCallbackProc, char *
#endif
);

extern Cardinal getResOfClass(
#if NeedFunctionPrototypes
     WidgetClass, QTypeList *
#endif
);

extern Cardinal getConOfClass(
#if NeedFunctionPrototypes
     WidgetClass, QTypeList *
#endif
);



static void
realizeWidgets()
    {
    WidgetListPtr ptr = wafeWidgetTrees;
    while(ptr) 
	{
	XtRealizeWidget(ptr->widget);
	ptr = ptr->next;
	}
    }

static void
callCallbacks(w, callback, argc,argv)
Widget   w;
String   callback;
int      argc;
char   **argv;
    {
    float   f;
    if (argc == 0)
	XtCallCallbacks(w, callback, NULL);
    else
	{
	if (!strcmp(argv[0], "float"))
	    {
	    sscanf(argv[1], "%f", &f);
	    XtCallCallbacks(w, callback, (XtPointer)&f);
	    }
	else
	    {
	    fprintf(stderr, "Wafe(callCallbacks): Wrong type: %s\n", argv[1]);
	    }
	}
    }


static void
callActionProc(w, eventType, action, argc, argv)
Widget         w;
String         eventType;
String         action;
int            argc;
char         **argv;
    {
    char          *token;
    XEvent         event;
    Display       *display;
    Window         win, root, child;
    int            x, y, xR, yR;
    unsigned int   state, button, keycode;

    display = XtDisplay(wafeTopLevel);
    win = XtWindow(w);

    if (!strcmp(eventType, ""))
	{
	event.type = 0;
	event.xany.display = display;
	event.xany.window = win;
	}
    else
	{
	token = strtok(eventType, " ");
	if (strcmp(token, "type"))
	    {
	    fprintf(stderr, 
		    "Wafe(callActionProc): Missing type, aborting\n");
	    return;
	    }

	XQueryPointer(display, win, &root, &child, &xR, &yR, &x, &y, &state);

	token = strtok(NULL, " ");
	if (!strcmp(token, "buttonEvent"))
	    {
	    token = strtok(NULL, " ");
	    if (!strcmp(token, "button"))
		{
		token = strtok(NULL, " ");
		if (!strcmp(token, "button1"))
		    button = Button1;
		else
                if (!strcmp(token, "button2"))
		    button = Button2;
                else
                if (!strcmp(token, "button3"))
		    button = Button3;
		else
                if (!strcmp(token, "button4"))
		    button = Button4;
		else
                if (!strcmp(token, "button5"))
		    button = Button5;
		else
		    {
		    fprintf(stderr, 
			    "Wafe(callActionProc): Unknown Button, %s\n", 
			    token);
		    return;
		    }
		}
	    else
		{
		fprintf(stderr, 
			"Wafe(callActionProc): This event field (%s) can't be specified", token);
		return;
		}

	    event.type = ButtonPress;
	    event.xbutton.display = display;
	    event.xbutton.window = win;
	    event.xbutton.root = root;
	    event.xbutton.subwindow = child;
	    event.xbutton.x = x;
	    event.xbutton.y = y;
	    event.xbutton.x_root = xR;
	    event.xbutton.y_root = yR;
	    event.xbutton.state = state;
	    event.xbutton.button = button;
	    }
	else if(!strcmp(token, "keyEvent"))
	    {
	    token = strtok(NULL, " ");
	    if (!strcmp(token, "key"))
		{                   
		token = strtok(NULL, " ");
		keycode = XKeysymToKeycode(display, XStringToKeysym(token));
		}
	    else
		{
		fprintf(stderr, "Wafe(callActionProc): This event field (%s) can't be specified", token);
		return;
		}

	    event.type = KeyPress;
	    event.xkey.display = display;
	    event.xkey.window = win;
	    event.xkey.root = root;
	    event.xkey.subwindow = child;
	    event.xkey.x = x;
	    event.xkey.y = y;
	    event.xkey.x_root = xR;
	    event.xkey.y_root = yR;
	    event.xkey.state = state;
	    event.xkey.keycode = keycode;
	    }
	else
	    {
	    fprintf(stderr, 
		    "Wafe(callActionProc): This event type can't be specified\n");
	    return;
	    }                    
	}

    XtCallActionProc(w, action, &event, argv, argc);
    return;
    }

/* used by addTimeOut */

static void
timerProc(command, junk)
XtPointer        command;
XtIntervalId     *junk;
    {
    DBUG_ENTER("timerProc");
    (void) wafeEval(wafeInterpreter, (char *)command, "timerProc");
    XtFree((char *)command);
    DBUG_VOID_RETURN;
    }


static char *
cvtToString(clientData, quarkOfType, freeProcPtr)
XtPointer     clientData;
XrmQuark      quarkOfType;
freeProc      *freeProcPtr;
    {
    XrmValue   input,output;
    
    DBUG_PRINT("cvtToString", ("Converting to <%s>", 
			       XrmQuarkToString(quarkOfType)));

    input.addr  =  clientData;            /* ??? */
    input.size  =  sizeof(XtPointer);     /* ??? */
    output.addr =  NULL;

    IFCONVERTANDSTORE(wafeTopLevel, 
		      XrmQuarkToString(quarkOfType),input, 
		      "String", output)
	{
	*freeProcPtr = XtFree;
	return output.addr;
	}
    else
	return NULL;
    }



static String
getValue(w, Qname, freeProcPtr)
Widget        w;
XrmQuark      Qname;
freeProc     *freeProcPtr;
    {
    char      *result;
    XrmQuark   Qtype;
    XtPointer  value;
    Arg        arg;

    DBUG_PRINT("getValue", ("widget is %p resource is <%s>",
			    w,XrmQuarkToString(Qname))); 

    if (!(Qtype = getQTypeOfAttribute(XtClass(w), ParentWidget(w), Qname)))
	{
	fprintf(stderr, "Wafe(getValues): Unknown Attribute %s\n",
		XrmQuarkToString(Qname));
	*freeProcPtr = TCL_STATIC;
	return NULL;
	}

    if (Qtype == qString)
	{
	String    valueString;
	*freeProcPtr = TCL_VOLATILE;
	XtVaGetValues(w, XrmQuarkToString(Qname), &valueString, NULL);
	return valueString;
	}

    /* this is the Default value for the following types 
     * assuming that dense code is better than one instruction more
     */ 
    *freeProcPtr = XtFree;
	
    if (Qtype == qInt) 
	{
	int valueInt;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, XrmQuarkToString(Qname), &valueInt, NULL);
	sprintf(result, "%d", (int)valueInt);
	return result;
	}

    if (Qtype == qPosition) 
	{
	Position    valuePosition;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, XrmQuarkToString(Qname), &valuePosition, NULL);
	sprintf(result, "%hd", valuePosition);
	return result;
        }
#ifdef MOTIF11
    if (Qtype == qTextPosition) 
	{
	XmTextPosition    valuePosition;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, XrmQuarkToString(Qname), &valuePosition, NULL);
	sprintf(result, "%ld", valuePosition);
	return result;
        }
#endif

    if (Qtype == qDimension
#ifdef MOTIF11
	|| Qtype == qVerticalDimension
	|| Qtype == qHorizontalDimension
#endif
	) 
	{
	Dimension    valueDimension;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, XrmQuarkToString(Qname), &valueDimension, NULL);
	sprintf(result, "%hu", valueDimension);
	return result;
        }

    if (Qtype == qCardinal)
	{
	Cardinal    valueCardinal;
	result = XtMalloc(INT_AS_STRING);
	XtVaGetValues(w, XrmQuarkToString(Qname), &valueCardinal, NULL);
	sprintf(result, "%u", valueCardinal);	
	return result;
	}

    if (Qtype == qBoolean)
	{
	Boolean    valueBoolean;
	*freeProcPtr = TCL_STATIC;
	XtVaGetValues(w, XrmQuarkToString(Qname), &valueBoolean, NULL);
	return valueBoolean ? "true" : "false";   
	}


    if (Qtype == qFloat) 
	{
	float    valueFloat;
	result = XtMalloc(FLOAT_AS_STRING);
	XtVaGetValues(w, XrmQuarkToString(Qname), &valueFloat, NULL);
	sprintf(result, "%f", valueFloat);
	return result;
	}

    if (Qtype == qDouble) 
	{
	double    valueDouble;
	result = XtMalloc(FLOAT_AS_STRING);
	XtVaGetValues(w, XrmQuarkToString(Qname), &valueDouble, NULL);
	sprintf(result, "%f", valueDouble);
	return result;
	}

    if (Qtype == qPixel) 
	{
	XColor  c;
	Display *dsp = XtDisplay(w);
	result = XtMalloc(8); /* "#RRGGBB" */
	XtVaGetValues(w, XrmQuarkToString(Qname), &(c.pixel), NULL);
	XQueryColor(dsp,DefaultColormap(dsp, DefaultScreen(dsp)),&c);
	sprintf(result, "#%02X%02X%02X", 
		(int)(c.red>>8), (int)(c.green>>8), (int)(c.blue>>8));
	return result;
	}

     /* Callbacks sind ... anders: die String-Information 
	kommt aus wafe's privatem Memory-Management und nicht 
	ber getValues!
      */
    if (Qtype == qCallback) 
	{
	MMattribListPtr ptr = *MMgetAttribList(w);
	
	*freeProcPtr = TCL_STATIC;
	result = "";
	while(ptr) 
	    {
	    if (ptr->attribute == Qname) 
		{
		result = ((char*)ptr->value) +
		    sizeof(XtCallbackList)*2 +
		    sizeof(XtCallbackRec[2]) +
		    sizeof(XrmQuark);
		break;
		}
	    ptr = ptr->next;
	    }
	return result;
	}

    if (Qtype == qWidget
#ifdef MOTIF11
	|| Qtype == qWindow
#endif
	)
	{
	Widget valueWidget;
	*freeProcPtr = TCL_STATIC;
	XtVaGetValues(w, XrmQuarkToString(Qname), &valueWidget, NULL);
	return widget2Name(valueWidget);
	}

    if (Qtype == qWidgetList) 
        {
	Widget  *children, *wPtr;
        int      numChildren;
        int      i, length=0;

        XtVaGetValues(w, XtNnumChildren, &numChildren,
                            XtNchildren,    &children,    NULL);
        for (i=0, wPtr=children; i<numChildren; i++, wPtr++)
	   {
	   length += strlen(XtName(*wPtr)) + 2;
	   }
	result = XtMalloc(length);
	*result = '\0';
        for (i=0, wPtr=children; i<numChildren; i++, wPtr++)
	    {
            strcat(result,XtName(*wPtr));
            strcat(result," ");
            }
	return result;
        }

    else 
	{
	  /*
	   * warning: cvtToString assumes, you can free the result 
	   * using XtFree
	   */
	XtSetArg(arg, XrmQuarkToString(Qname), &value);
	XtGetValues(w, &arg, (Cardinal)1);

	if (!(result = cvtToString(value, Qtype, freeProcPtr)))
	  {
	    fprintf(stderr, "Wafe(getValues): Couldn't convert value\n");
	    return NULL;
	  }
	return result;
      }
    }

static int
getResourceList(w, resultPtr)
char    ***resultPtr; 
Widget   w;
    {
    int numTotal, count;
    char **result;
    int rNum = 0;
    int cNum = 0;
    QTypeList rList, cList;

    rNum = getResOfClass(XtClass(w), &rList);

    if (XtIsConstraint(ParentWidget(w)))   /* If parentWidget is constrain widget => fetch constraints */
	cNum =  getConOfClass(XtClass(ParentWidget(w)), &cList);

    numTotal = rNum + cNum;

    *resultPtr = result = (char **)XtMalloc(numTotal *sizeof(char *));       

    for ( count = 0; count < rNum; count++)
	*result++ = XrmQuarkToString(rList[count].qName);

    for ( count = 0; count < cNum; count++)
	*result++ = XrmQuarkToString(cList[count].qName);

    return(numTotal);
    }



typedef struct _busyStruct
    {
    Window                busyWindow;
    Boolean               state;
    } busyStruct, *busyStructPtr;


static void
setBusy(w,sensitive)
Widget w;
Boolean sensitive;
    {
    unsigned long valuemask;
    XSetWindowAttributes attributes;
    MMattribListPtr *al = MMgetAttribList(w);
    busyStructPtr bs = (busyStructPtr) MMgetValue(al, qbusyWindow);
    
    if (sensitive)
	{
	if (!bs)
	    {
	    bs = (busyStructPtr) XtMalloc(sizeof(busyStruct));
	    MMreplace(al,qbusyWindow,(char*)bs,XtFree);
            bs->state = False;

	    /* Ignore device events while the busy cursor is displayed. */
	    valuemask = CWDontPropagate | CWCursor;
	    attributes.do_not_propagate_mask =  (KeyPressMask | KeyReleaseMask |
						 ButtonPressMask | ButtonReleaseMask | 
						 PointerMotionMask);
	    attributes.cursor = XCreateFontCursor(XtDisplay(w), XC_watch);

	    /* The window will be as big as the display screen, and clipped by
	       its own parent window, so we never have to worry about resizing */
	    bs->busyWindow = XCreateWindow(XtDisplay(w), XtWindow(w), 0, 0,
					   HeightOfScreen(XtScreen(w)), 
					   WidthOfScreen(XtScreen(w)), 
					   (unsigned int) 0, 0, InputOnly,
					   CopyFromParent, valuemask, 
					   &attributes);
	    }
	if (!bs->state) 
	     {
	     XMapRaised(XtDisplay(w), bs->busyWindow);
	     bs->state = True;
	     }
        }
    else
	{
	if (bs && bs->state)
	    {
	    XUnmapWindow(XtDisplay(w), bs->busyWindow);
	    bs->state = False;
	    }
	}
    }


