set n 0

proc data {count} {
    if {$count<1} {return}

    global n
    for {set i 1} {$i<11} {incr i} {
	append data1 "$i/[expr 10+sin($i+$n)*$i] "
	append data2 "$i/[expr 10+cos($i-$n)*$i] "
	append data3 "[expr 10+sin($i+$n)*$i] "
	append data4 "[expr 10+cos($i-$n)*$i] "
    }
    eval xyLinePlotAttachData lp1 $data1
    eval xyLinePlotAttachData lp2 $data2
    eval barPlotAttachData    b1 $data3
    eval barPlotAttachData    b2 $data4
    set n [expr $n+0.5]
    addTimeOut 100 "data [expr $count-1]"
}

if ![isWidget f] {
    mergeResources topLevel *Command.background gray80
    form f topLevel background gray50

    # first graph    
    plotter p1 f {
	height 200 width 300 title "XY Line Plot Example" usePixmap true
	background gray70 plotAreaColor gray90 showLegend false
    }
    xyAxis x p1               autoScale false min 0.5 max 10  drawGrid false
    xyAxis y p1 vertical true autoScale false min 0 max 19    drawGrid false
    sV p1 xAxis x yAxis y
    xyLinePlot lp1 p1 plotLineType lineimpulses
    xyLinePlot lp2 p1 plotLineType lineimpulses foreground red

    # buttons
    command quit   f fromVert p1 callback %w
    command go     f fromVert p1 fromHoriz quit callback "data 200"
    command source f fromVert p1 fromHoriz go callback "source xy.tcl"

    # second graph    
    plotter p2 f {
	height 200 width 300 title "faked demo" usePixmap true
	background gray70 plotAreaColor gray90 showLegend false
	fromHoriz p1
    }
    axis x2 p2 \
        drawSubgrid false numbersOutside true autoScale false min 0 max 13 
    axis y2 p2 vertical true drawSubgrid false drawFrame true
    sV p2 xAxis x2 yAxis y2

    barPlot b1 p2 fillColor yellow cellOffset -0.4 cellWidth 0.5 shading gray5
    barPlot b2 p2 fillColor green  cellOffset -0.15 cellWidth 0.5 shading gray3
    
    data 1
    realize
}
