#> The Plotter Widget can be compiled with Athena or Motif versions of Wafe.

$PACKAGE = "PLOTTER";

~handles
	PLOTTER

#include <X11/At/Axis.h>
#include <X11/At/BarPlot.h>
#include <X11/At/LabelAxis.h>
#include <X11/At/LinePlot.h>
#include <X11/At/Plot.h>
#include <X11/At/Plotter.h>
#include <X11/At/TextPlot.h>
#include <X11/At/XYAxis.h>
#include <X11/At/XYLinePlot.h>
#define castXtPointer(x) (XtPointer)(x)

~require
At.inc
	privateQuark "LinePlotXData"
	privateQuark "LinePlotYData"
        privateQuark "BarPlotData"
        privateQuark "LinePlotData"

#> The 'AtAxis' widget class is designed for numeric axes as part of
#> the AtPlotter widget.  It provides simple linear spacing of tics
#> and subtics and simple printf()-like tic labeling.  This class is
#> only concerned with the user-space details of tic positions and tic
#> labels.  

~widgetClass 
AtAxis
	createCmd WafeDontManage

#> The AtBarPlot class provides simple bar plots. The X values of the
#> bars are successive integers, and the Y values are given by
#> application data.  Each bar on the plot can be outlined and/or
#> filled.  The outlining is done using the resources inherited from
#> the AtPlot class.  The filling can be in the same or a different
#> colour, using one of 11 stipple patterns if required.

~widgetClass 
AtBarPlot
	createCmd WafeDontManage

#> The command 'AtBarPlotAttachData' is used to specify the data
#> points of an 'AtBarPlot' widget. Each data point is given as a
#> single floating point value.

TCL_RETURN_CODE
plotAttachData vulgo AtBarPlotAttachData
        in: AtBarPlotWidget		# bar plot widget
        in: [args]	                # floats
        const: qBarPlotData

#> The command 'AtBarPlotExtendData' is used to add additional data
#> points to an existing 'AtBarPlot' widget. Each data point is given
#> as a single floating point value.

TCL_RETURN_CODE
plotExtendData vulgo AtBarPlotExtendData
        in: AtBarPlotWidget		# bar plot widget
        in: [args]	                # floats
        const: qBarPlotData

#> The 'AtLabelAxis' widget class provides facilities for the
#> application programmer to specify which integral values in the axis
#> should have tics, and attach arbitrary labels to those tics.  The
#> XtNticInterval resource will be set to 0, and no subtics will be
#> generated.

~widgetClass 
AtLabelAxis
	createCmd WafeDontManage

#> The command 'AtLabelAxisAttachData' us used to specify the labels
#> of an 'AtLabelAxis' widget.

void
AtLabelAxisAttachData
        in: AtLabelAxisWidget		# label axis wiget
	in: [char *]			# strings
	const: sizeof(String)
	const: 1
	const: argc-2

#> The 'AtLinePlot' class is the simplest of the plotting classes in the
#> AtPlotter widget set.  It's data points are drawn by connecting it
#> with straight lines.

~widgetClass 
AtLinePlot
	createCmd WafeDontManage

#> The command 'AtLinePlotAttachData' can be used to specify the data
#> points of an AtLinePlot widget. Each data point is specified as a
#> single floating point number.
 
TCL_RETURN_CODE
plotAttachData vulgo AtLinePlotAttachData
        in: AtLinePlotWidget		# line plot widget
        in: [args]	                # floats
        const: qLinePlotData

#> The command 'AtLinePlotExtendData' is used to add additional data
#> points to an existing 'AtLinePlot' widget. Each data point is given
#> as a single floating point value.

TCL_RETURN_CODE
plotExtendData vulgo AtLinePlotExtendData
        in: AtLinePlotWidget		# bar plot widget
        in: [args]	                # floats
        const: qLinePlotData

#> The 'AtPlotter' widget class displays various plot types on a set
#> of x-y axes.  Currently supported plots are line and bar plots.
#> The axes are optionally labeled, the widget displays an optional
#> title, and plots can be annotated with text.  There is an optional
#> legend at the right or left hand side of the plot.  Two x axes and
#> two y axes can be displayed each with a different range, and plots
#> can be plotted against either x axis and either y axis.  The X axis
#> is along the bottom, the X2 axis along the top.  The Y axis is
#> along the left edge, the Y2 axis is along the right edge.

~widgetClass 
AtPlotter
	include <Plotter.h>
	click|motion x Position: \
		((AtPointCallbackData *)callData)->pixelx # pixel x coordinate
	click|motion y Position: \
		((AtPointCallbackData *)callData)->pixely # pixel y coordinate
	click|motion a double: \
		((AtPointCallbackData *)callData)->x1 # 1st axis x coordinate
	click|motion b double: \
		((AtPointCallbackData *)callData)->y1 # 1st axis y coordinate
 	click|motion c double: \
		((AtPointCallbackData *)callData)->x2 # 2nd axis x coordinate
	click|motion d double: \
		((AtPointCallbackData *)callData)->y2 # 2nd axis y coordinate
	drag|slide x Position: \
		((AtRectangleCallbackData *)callData)->pixelx1 \
			# pixel x lower left
	drag|slide y Position: \
		((AtRectangleCallbackData *)callData)->pixely1 \
			# pixel y lower left
	drag|slide a double: \
		((AtRectangleCallbackData *)callData)->x11 \
			# 1st axis x lower left
	drag|slide b double: \
		((AtRectangleCallbackData *)callData)->y11 \
			# 1st axis y lower left
	drag|slide c double: \
		((AtRectangleCallbackData *)callData)->x21 \
			# 2nd axis x lower left
	drag|slide d double: \
		((AtRectangleCallbackData *)callData)->y21 \
			# 2nd axis y lower left
	drag|slide X Position: \
		((AtRectangleCallbackData *)callData)->pixelx2 \
			# pixel x upper right
	drag|slide Y Position: \
		((AtRectangleCallbackData *)callData)->pixely2 \
			# pixel y upper right
	drag|slide A double: \
		((AtRectangleCallbackData *)callData)->x12 \
			# 1st axis x upper right
	drag|slide B double: \
		((AtRectangleCallbackData *)callData)->y12 \
			# 1st axis y upper right
	drag|slide C double: \
		((AtRectangleCallbackData *)callData)->x22 \
			# 2nd axis x upper right
	drag|slide D double: \
		((AtRectangleCallbackData *)callData)->y22 \
			# 2nd axis y upper right


#> The command 'AtPlotterGeneratePostscript' opens filename and writes
#> the PostScript representation of plotter (2nd arguemnt) to the
#> file.  The plotter will have a title as specified as the 3rd
#> argument.  The representation will be drawn inside the bounding box
#> described by (x1, y1) and (x2, y2).  If landscape is True, the
#> plotter representation will be rotated and drawn in landscape mode.

void
AtPlotterGeneratePostscript
        in: String            		       # file name
        in: (AtPlotterWidget)AtPlotterWidget   # plotter widget
	in: String            		       # title
	in: int               		       # bounding box: x1
	in: int              		       # bounding box: y1
	in: int               		       # bounding box: x2
	in: int               		       # bounding box: y2
	in: Boolean           		       # landscape

#> The 'AtTextPlot' widget class displays formatted text in an
#> AtPlotter widget.  The text can be placed in the plotter widget in
#> two ways: attached to a pair of real coordinates or attached to a
#> pair of pixel coordinates.  When attached to a real point, the plot
#> will "float" (i.e. if the coordinate scale changes, the plot will
#> be drawn at the real points new location; this is controlled by the
#> resource 'floatingPosition').  When attached to a pixel point, the
#> plot will be drawn in that position even if the coordinate scale
#> changes.  If the physical size of the plotter changes, the plot
#> will be drawn such that it remains in the same relative position
#> (percentage-wise).


~widgetClass 
AtTextPlot
	createCmd WafeDontManage

#> The 'AtXYAxis' widget class is designed for numeric axes as part of
#> the AtPlotter widget.  It provides linear and logarithmic spacing
#> of tics and subtics and simple printf()-like tic labeling.  

~widgetClass 
AtXYAxis
	createCmd WafeDontManage

#> The 'AtXYLinePlot' widget class can be used to display an list of
#> coordinate pairs in form of a line plot. 7 different line types, 12
#> different line styles and 9 different marker types for the data
#> points are supported.

~widgetClass 
AtXYLinePlot
	createCmd WafeDontManage


~bcAlias
AtXYLinePlotAttachData xyLinePlotAttachData 

#> The command 'AtXYLinePlotAttachData' can be used to set the plot
#> data if the specified line plot widget. The specified coordinate
#> pairs are of the form x-value/y-value. See also:
#> 'AtXYLinePlotExtendData'.

TCL_RETURN_CODE
xyLinePlotAttachData vulgo AtXYLinePlotAttachData
        in: AtXYLinePlotWidget		# AtXYLine plot widget
	in: [args]			# pairs of floats (xfloat/yfloat)

#> The command 'AtXYLinePlotExtendData' can be used to append the
#> specified coordinate pairs (of the form x-value/y-value) to the
#> plot data of the specified line plot widget and to update the
#> plot. See also: AtXYLinePlotAttachData'.

TCL_RETURN_CODE
xyLinePlotExtendData vulgo AtXYLinePlotExtendData
        in: AtXYLinePlotWidget		# AtXYLine plot widget
	in: [args]			# pairs of floats (xfloat/yfloat)

