proc ctime-type {} { return {function {String} {in: ref(time_t)} ## {clock value}}}
set wafeHelp(ctime) { The function 'ctime' returns a ASCII string representing the time of
 the clock value, which is passed as the argument in the form of an
 integer value.}

proc echo-type {} { return {function {void} {callmultiple} {in: String} {post: write(wafeToClient, wafe_NL,1);} ## {strings}}}
set wafeHelp(echo) { If Wafe is used in frontend mode, the command 'echo' sends its
 arguments to the application program. Otherwise (if Wafe is used as
 a scripting language) the arguments are printed to standard output.}

proc getChannel-type {} { return {function {int} {} ## {}}}
set wafeHelp(getChannel) { The function 'getChannel' returns the file descriptor to be used by
 the application as additional communication channel. The returned
 value is a small integer value. When this command is issued not in
 frontend mode, 0 is returned. This function is intended to be used
 by a backend application to determine the additional, already
 option communication channel.}

proc quit-type {} { return {function {void} {const: wafeClientPid} {const: SIGTERM} {pre: if (wafeClientPid)} {post: wafeExit(0);} ## {None}}}
set wafeHelp(quit) { The procedure 'quit' is used to terminate Wafe. If there exists a
 spawned application process Wafe will send to it the SIGTERM
 signal. When a Tcl procedure with the name 'onExit' (without
 arguments) is defined it  will be executed on exit.}

proc kill-type {} { return {function {void} {pre: localVar2 -= HANDLERMAX;} {in: int} {in: (int) signalType} ## {process id} {signalType}}}
set wafeHelp(kill) { The procedure 'kill' can be used to send a signal to the specified
 process id. The following signals are currently defined: "term",
 "quit", "int",  "hup", "pipe", "usr1", "usr2".}

proc register-type {} { return {function {void} {in: (int)handlerType} {in: String} ## {stdin | stdout | stderr | xioerr | ..signal..} {tcl-command}}}
set wafeHelp(register) { The command 'register' is used to install handler procedures, which
 are invoked under different conditions, as specified by the 1st
 argument 'source'; this command can be 'stdin', 'stdout', 'stderr',
 'xioer', 'term', 'quit', 'int', 'hup', 'pipe', 'usr1' or 'usr2'.
 
 By specifying 'stdin', 'stdout' or 'stderr' as first argument,
 'command' will be executed whenever data is pending on the
 corresponding stream. Before executing the command, Wafe will
 update a global Tcl variable called 'STDIN', 'STDOUT' or 'STDERR'
 according to the handler registered, which will contain the pending
 data. Note that 'stdout' and 'stderr' are named as they are seen in
 frontend mode from an application running as an subprocess of
 Wafe. If the application writes to 'stdout' or 'stderr' the
 corresponding handler will be activated. If the frontend accepts an
 additional input from the terminal, a 'stdin' handler can be registered. 
 
 Wafe allows XIO errors to be caught by using the constant 'xioerr'
 as first argument to the 'register' command. Note that this is a
 fatal error condition and that Wafe will anyway try to kill the
 application program before exiting afterwards. This type of handler
 procedure facilitates therefore cleanup operations.
 
 The remaining handler types refer to signal for which handler can
 be specified as Tcl commands. For signal handlers it is also
 possible to specify 'IGNORE' or 'DEFAULT' in the 'command' string
 which cause either to ignore a signal completely or to default to
 the standard system action (i.e. not using any Wafe specific signal
 handler).}

proc setCommunicationVariable-type {} { return {function {void} {in: XtNewString(String)} {in: int} {in: XtNewString(String)} ## {variable name} {length} {tcl command to be executed}}}
set wafeHelp(setCommunicationVariable) { The command 'setCommunicationVariable' is used to make the
 transferred data available for the user interface (this makes only
 sense in frontend-mode) . As soon as the data with 'length' number
 of bytes is received (2nd argument), Wafe will create (or
 overwrite) the Tcl variable named in the 1st argument. This
 variable will contain the transferred data. As a next step, the
 specified command (3rd argument) will be executed. If the specified
 number of bytes are not yet received via the extra communication
 channel, the execution is delayed until the transfer is complete.}

proc unregister-type {} { return {function {void} {in: (int)handlerType} ## {stdin | stdout | stderr | xioerr}}}
set wafeHelp(unregister) { The command 'unregister' used to unregister the corresponding
 handler, which means that the default handler will be reinstalled
 (see also command 'register')}

proc addInput-type {} { return {function {XtInputId} {in: int} {in: (XtPointer)SourceInputMask} {in: String} {in: String} ## {fileno} {read | write | except | none} {TclVariable} {TclCommand}}}
set wafeHelp(addInput) {.The function 'addInput' can be used to add additional input
 handlers or exception handlers. If 'read' is specified as 2nd
 argument, each time when data is ready the data is read and
 APPENDED to the specified Tcl Variable (3rd argument) and the given
 command (4th argument) is executed. 'addInput' returns an
 inputId. which can be used in the command 'removeInput'.
 
 Note that the amount of data read might depend on the buffering of
 the operating system. If only the newly read data should be kept in
 the Tcl Variable, the Tcl Command should set it empty after
 processing its contents.
 
 If fileno (1st argument) corresponds to an open file, a busy loop
 is likely to occur (see wafe/src/tcl/addInput.tcl for an example).
 
 As shipped, 16 additional input handlers can be added by the
 application program. Increasing this number needs recompilation.}

proc removeInput-type {} { return {function {void} {in: XtInputId} ## {input id}}}
set wafeHelp(removeInput) { The command 'removeInput' removes an input added by
 addInput. The inputId is returned from addInput.}

proc fileno-type {} { return {function {int} {pre: \{ FILE* f;} {in: String} {in: (int)FileNoReadWrite} {post: \}} ## {string identifying file} {read | write}}}
set wafeHelp(fileno) { The function 'fileno' returns for the file opened by using Tcl's
 'open' command the file descriptor.  The second argument is either
 'read' or 'write'. For pipes the file descriptor might be different
 for reading or writing.}

proc alias-type {} { return {function {int} {in: String} {in: String} ## {new command} {old command}}}
set wafeHelp(alias) { The command 'alias' can be used to register an alternate name
 (newCommand) for an already existing command (oldCommand). The
 already existing command can be either a builtin command or a Tcl
 procedure.}

proc DBUG_PUSH-type {} { return {function {void} {in: String} ## {new debug options}}}
set wafeHelp(DBUG_PUSH) { The command 'DBUG_PUSH' can be used to modify the current debugging
 options. The new debugging options are placed on a stack. DBUG_PUSH
 accepts the same arguments as the --D command line option.  For
 example command "DBUG_PUSH d:t" turns on debug and trace messages.
 For details concerning the valid argument strings (profiling, etc),
 consult the manual page in wafe/lib/dbug/dbug.man.}

proc DBUG_POP-type {} { return {function {void} {} ## {}}}
set wafeHelp(DBUG_POP) { The command 'DBUG_POP' switches to the debugging options before the
 last DBUG_PUSH was issued.}

