#include "EXTERN.h"
#define MAIN
#include <wafe.h>
#include "perl.h"
#include "XSUB.h"

/* 
   In order to load this file dynamically with perl, i had to
   add the following symbols to perl5.00/global.sym

      origargc
      origargv
      tmps_floor
      tmps_ix

   one has to regenerate perl5.00/perl.exp via Configure 
   and reinstall perl. One can avoid the need for origargc by
   compiling this file with NO_ORIGARGC defined

   #define NO_ORIGARGC 1
 */
#undef NO_ORIGARGC
 

static int
com_perl(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     dSP ;
     int i,count;

     DBUG_ENTER("perl");  
 
     if (argc < 2) 
	 DBUG_RETURN( wafeArgcError(argc,argv,"at least ",1));
     /*
     fprintf(stderr,"perl subroutine &%s will be called with %d args, sp=%d\n",
	     argv[1],argc-2,sp);
      */

     ENTER;
     SAVETMPS;
     PUSHMARK(sp);
     
     for (i=2; i < argc; i++) 
       {
	 /* fprintf(stderr,"pushing argument %d <%s>\n", i,argv[i]); */
	 XPUSHs(sv_2mortal(newSVpv(argv[i],0)));
       }
		
     PUTBACK;
     
     /*fprintf(stderr,"calling funcname=&%s\n", argv[1]);*/
     count = perl_call_pv(argv[1], G_SCALAR);

     SPAGAIN;
		
     /*fprintf(stderr,"funcname=&%s, results=<%d>\n", argv[1], count);*/

     if (count == 1) 
	 {
	 SV *retval = POPs;
	 char *result = SvPV(retval,na);
	 if (!result) result = "";
	 /* fprintf(stderr, "Return value from perl: <%s>\n",result); */
	 Tcl_SetResult(comInterpreter, result, TCL_VOLATILE);	 
	 }
     else
     if (count != 0) 
	 { 
	 croak("perl %s ubroutine should not return more than one scalar value\n", argv[1]) ;
	 }
     
     DBUG_RETURN (TCL_OK);
     }

void
init_wafe()
{
    int    argc;
    char **argv;
    char  *filename = "wafesub.c";
    int    i;
    char  *p;

    wafeScriptName = "perl"; 
    argc = origargc-1;
    argv = (char**) XtMalloc(sizeof(char*)*origargc);
    for(i=0; i <= argc; i++) 
	{
	/* fprintf(stderr,"i=%d: <%s>\n",i,origargv[i]);*/
	if (i>0) argv[i-1] = origargv[i];
	}

    wafeAppClass = XtNewString(argv[0]);
    if ((p = strrchr(wafeAppClass, '/')))
	wafeAppClass = ++p;
    while((p = strrchr(wafeAppClass, '.')))
	*p = '-';
    *wafeAppClass = toupper(*wafeAppClass);

    /* setup Xt and Wafe */
    wafeTopLevel = XtVaAppInitialize(&wafeAppContext, wafeAppClass, NULL, 0, 
				 &argc, argv, NULL, NULL); 
    MOTIF_EDITRES_HANDLER(wafeTopLevel);

    wafeInit(argc,argv, 
	     False /* inputMode */,  
	     False /* promptMode */
	     );

    Tcl_CreateCommand(wafeInterpreter, "perl", com_perl, NULL, NULL);
  }


