#include "wafe.h"
#define LISTRES_C

#define MAX_NS  20

typedef struct 
    {
    XrmQuark     resQuark;
    String       secondaryName;
    XrmQuark     secondaryQuark;
    XrmQuark     tertiaryQuark;
    WidgetClass  wClass;
    int          size;
    String       (*toStringProc)();
    freeProc     freeString;
    XtPointer    (*fromStringProc)();
    freeProc     freeGarbage;
    } ns_convStruct, *ns_conv;

static ns_convStruct ns[MAX_NS];
static int ns_count = -1;

void
wafeAddNsConv(resQuark,secondaryName,tertiaryName,wClass,size,
	      toStringProc,freeString,
	      fromStringProc,freeGarbage)
XrmQuark resQuark;
String secondaryName;
String tertiaryName;
WidgetClass wClass;
int size;
String (*toStringProc)();
freeProc freeString;
XtPointer (*fromStringProc)();
freeProc freeGarbage;
    {
    static _Xconst String proc = "wafeAddNSconv";

    if (ns_count<MAX_NS)
	{
	int i = ++ns_count;
	DBUG_PRINT("conv",("adding nsconv for '%s' on pos %d",
			  XrmQuarkToString(resQuark),i));
	ns[i].resQuark       = resQuark;
	ns[i].secondaryName  = secondaryName;
	ns[i].secondaryQuark = secondaryName ? 
	    WafePermStringToQuark(secondaryName) : 0;
	ns[i].tertiaryQuark  = tertiaryName ? 
	    WafePermStringToQuark(tertiaryName) : 0;
	ns[i].wClass         = wClass;
	ns[i].size           = size;
	ns[i].toStringProc   = toStringProc;
	ns[i].freeString     = freeString;
	ns[i].fromStringProc = fromStringProc;
	ns[i].freeGarbage    = freeGarbage;
	}
    else
	wafeWarn(proc,"cannot add list converter, max number exceeded",
		 NULL,NULL,NULL);
    }

String
wafeCvtNsToString(w, resQuark, freeString)
Widget   w;
XrmQuark resQuark;
freeProc *freeString;
    {
    int i;
    WidgetClass wClass = XtClass(w);

    /* fprintf(stderr,"searching for %s.%s, count = %d\n",
	    XtName(w),XrmQuarkToString(resQuark),ntsCount);*/
    for (i=ns_count; i>=0; i--) 
	{
	/* fprintf(stderr,"comparing %s-%s %p-%p\n",
	   XrmQuarkToString(resQuark),XrmQuarkToString(nts[i].resQuark),
	   wClass,  nts[i].wClass);
	   */
	
	if (resQuark == ns[i].resQuark
	    && (ns[i].wClass == NULL || wClass == ns[i].wClass)
	    && ns[i].toStringProc
	    )
	    {
	    *freeString = ns[i].freeString;
	    if (ns[i].secondaryName) 
		{
		XtPointer array;
		Cardinal  num = 0;
		XtVaGetValues(w, 
			      ns[i].secondaryName, &num,
			      XrmQuarkToString(ns[i].resQuark),&array,
			      NULL);
		return (ns[i].toStringProc)(num, array);
		}
	    else 
		{
		XtPointer value;
		XtVaGetValues(w, 
			      XrmQuarkToString(ns[i].resQuark),&value,
			      NULL);
		return (ns[i].toStringProc)(value);
		}
	    }
	}
    return NULL;
    }


Boolean
wafeCvtNsFromString(string, resQuark, wClass, value,freeGarbage,size)
String      string;
XrmQuark    resQuark;
WidgetClass wClass;
XtPointer   *value;
freeProc    *freeGarbage;
int         *size;
    {
    int i;
    /* fprintf(stderr,"searching for %s, count = %d\n",
	     XrmQuarkToString(resQuark),ns_count);
	     */
    for (i=ns_count; i>=0; i--) 
	{
	  /*
	    fprintf(stderr,"comparing %s-%s %p-%p fromString %p\n",
	    XrmQuarkToString(resQuark),XrmQuarkToString(ns[i].resQuark),
	    wClass,  ns[i].wClass, ns[i].fromStringProc);	 */
	if (resQuark == ns[i].resQuark
	    && wClass == ns[i].wClass
	    && ns[i].fromStringProc
	    )
	    {
	    *size = ns[i].size;
	    *freeGarbage = ns[i].freeGarbage;
	    *value = (ns[i].fromStringProc)(string);
	    return True;
	    }
	}
      /* fprintf(stderr,"not found\n");*/
    return False;
    }

Boolean
wafeIsNsResource(resQuark, wClass)
XrmQuark    resQuark;
WidgetClass wClass;
    {
    int i;
    for (i=ns_count; i>=0; i--) 
	if (wClass == ns[i].wClass &&
	      (resQuark == ns[i].resQuark 
	       || resQuark == ns[i].secondaryQuark
	       || resQuark == ns[i].tertiaryQuark
	       )
	    )
	    return True;
    return False;
    }

static rs_convRecPtr convRecs = NULL;

rs_convRecPtr 
wafeAddRConv(typeString,size,strings,values)
String typeString;
Cardinal size;
_Xconst String *strings;
int *values;
    {
    rs_convRecPtr p = convRecs;
    convRecs = (rs_convRecPtr)XtMalloc(sizeof(rs_convRec));
    convRecs->next = p;

    DBUG_PRINT("conv",("adding rconv for '%s'", typeString));
    convRecs->typeString = typeString;
    convRecs->size       = size;
    convRecs->strings    = strings;
    convRecs->values     = values;
    return convRecs;
    }

String*
wafeGetRdomain(typeString)
String typeString;
    {
    rs_convRecPtr p;
    for (p=convRecs; p; p = p->next) 
	if (!strcmp(p->typeString,typeString)) 
	    return (String *)p->strings;
    return NULL;
    }

Cardinal
wafeGetRsize(typeString)
String typeString;
    {
    rs_convRecPtr p;
    for (p=convRecs; p; p = p->next) 
	if (!strcmp(p->typeString,typeString)) 
	    return p->size;
    return 0;
    }


    
Boolean
wafeCvtRToString(dpy, args, num_args, fromVal, toVal, converterData)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converterData;
    {
    rs_convRecPtr p = (rs_convRecPtr)args[0].addr;
    int i, count, value;

    WAFE_UNUSED(dpy||converterData);

    /* fprintf(stderr,"num = %d, type='%p'\n", *num_args, args[0].addr);*/
    
    if (*num_args != 1) 
	return False;

    /* fprintf(stderr,"size = %d\n", p->size);*/
    value = (int)fromVal->addr;

    /* fprintf(stderr,"fromVal=%d, val=%d\n", (int)fromVal->addr,value); */

    count = 0;
    while (p->strings[count]) count++;
    
    /* fprintf(stderr,"count = %d\n", count);    */
    for(i=0; i<count; i++)
	{
	if (p->values[i] == value)
	    {
	    /* fprintf(stderr, "got it on pos %d, val='%s'\n",
		    i, p->strings[i]);*/
	    toVal->addr = p->strings[i];
	    return True;
	    }
	}
    /*fprintf(stderr, "not found\n\n"); */
   
    return False;
    }

