/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.
 * 
 */

/*
 * This file was generated by genc.
 * Be aware that modifications of this file will be lost,
 * when genc is executed!

Creation: Thu Jul 13 23:08:21 EDT 1995 on mohegan
Author: genc
Version: 1.0.13

 */

#define PIXMAP_C
#include <wafe.h>
 static XrmQuark qbusyWindow;
 static XrmQuark qiconPixmap;
 static XrmQuark qxpmList;
 extern XrmQuark qPixmap;
 extern XrmQuark qBitmap;

/* -*- C -*- */
/*
 * Copyright (C) 1992-94 by Gustaf Neumann, Stefan Nusser
 *
 *      Wirtschaftsuniversitaet Wien,
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6,
 *      A-1090 Vienna, Austria
 *      neumann@@wu-wien.ac.at, nusser@@wu-wien.ac.at
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.
 *
 * Date: Dec 24 1994
 * Author: Gustaf Neumann
 * Version: 1.0.8
 */


#include <X11/IntrinsicP.h>
#include <X11/cursorfont.h>
#include "wafe_quarks.h"

extern Boolean wafeMWMrunning(
#if NeedFunctionPrototypes
    Widget
#endif
);


#undef PIXMAPCACHETRACE

#define busyWindowFallbackCursorName "watch"
#define cursorCacheMaxSize       10 

typedef struct
    {
    Window     busyWindow;
    Boolean    state;
    } busyStruct, *busyStructPtr;

typedef struct
    {
    String       name;
    Display     *dpy;
    String       foreground;
    String       background;
    Cursor       cursor;
    Cardinal     count;
    } cursorCacheStruct;


typedef struct
    {
    _Xconst String  name;
    unsigned int    shape;
    } cursorStruct;

static String busyWindowDefaultCursorName;
static cursorCacheStruct cursorCache[cursorCacheMaxSize];
static int cursorCacheSize;


static _Xconst cursorStruct cursor_names[] = {
    {"X_cursor",            XC_X_cursor},
    {"arrow",               XC_arrow},
    {"based_arrow_down",    XC_based_arrow_down},
    {"based_arrow_up",      XC_based_arrow_up},
    {"boat",                XC_boat},
    {"bogosity",            XC_bogosity},
    {"bottom_left_corner",  XC_bottom_left_corner},
    {"bottom_right_corner", XC_bottom_right_corner},
    {"bottom_side",         XC_bottom_side},
    {"bottom_tee",          XC_bottom_tee},
    {"box_spiral",          XC_box_spiral},
    {"center_ptr",          XC_center_ptr},
    {"circle",              XC_circle},
    {"clock",               XC_clock},
    {"coffee_mug",          XC_coffee_mug},
    {"cross",               XC_cross},
    {"cross_reverse",       XC_cross_reverse},
    {"crosshair",           XC_crosshair},
    {"diamond_cross",       XC_diamond_cross},
    {"dot",                 XC_dot},
    {"dotbox",              XC_dotbox},
    {"double_arrow",        XC_double_arrow},
    {"draft_large",         XC_draft_large},
    {"draft_small",         XC_draft_small},
    {"draped_box",          XC_draped_box},
    {"exchange",            XC_exchange},
    {"fleur",               XC_fleur},
    {"gobbler",             XC_gobbler},
    {"gumby",               XC_gumby},
    {"hand1",               XC_hand1},
    {"hand2",               XC_hand2},
    {"heart",               XC_heart},
    {"icon",                XC_icon},
    {"iron_cross",          XC_iron_cross},
    {"left_ptr",            XC_left_ptr},
    {"left_side",           XC_left_side},
    {"left_tee",            XC_left_tee},
    {"leftbutton",          XC_leftbutton},
    {"ll_angle",            XC_ll_angle},
    {"lr_angle",            XC_lr_angle},
    {"man",                 XC_man},
    {"middlebutton",        XC_middlebutton},
    {"mouse",               XC_mouse},
    {"pencil",              XC_pencil},
    {"pirate",              XC_pirate},
    {"plus",                XC_plus},
    {"question_arrow",      XC_question_arrow},
    {"right_ptr",           XC_right_ptr},
    {"right_side",          XC_right_side},
    {"right_tee",           XC_right_tee},
    {"rightbutton",         XC_rightbutton},
    {"rtl_logo",            XC_rtl_logo},
    {"sailboat",            XC_sailboat},
    {"sb_down_arrow",       XC_sb_down_arrow},
    {"sb_h_double_arrow",   XC_sb_h_double_arrow},
    {"sb_left_arrow",       XC_sb_left_arrow},
    {"sb_right_arrow",      XC_sb_right_arrow},
    {"sb_up_arrow",         XC_sb_up_arrow},
    {"sb_v_double_arrow",   XC_sb_v_double_arrow},
    {"shuttle",             XC_shuttle},
    {"sizing",              XC_sizing},
    {"spider",              XC_spider},
    {"spraycan",            XC_spraycan},
    {"star",                XC_star},
    {"target",              XC_target},
    {"tcross",              XC_tcross},
    {"top_left_arrow",      XC_top_left_arrow},
    {"top_left_corner",     XC_top_left_corner},
    {"top_right_corner",    XC_top_right_corner},
    {"top_side",            XC_top_side},
    {"top_tee",             XC_top_tee},
    {"trek",                XC_trek},
    {"ul_angle",            XC_ul_angle},
    {"umbrella",            XC_umbrella},
    {"ur_angle",            XC_ur_angle},
    {"watch",               XC_watch},
    {"xterm",               XC_xterm},
};


#ifdef XPM
#include <xpm.h>
#include <X11/extensions/shape.h>
#endif
#include <X11/Xos.h>
#include <X11/Xmu/Xmu.h>


#ifdef XPM
 /* Create a linked list, which keeps track of all created pixmaps,
  * so that we can destroy Colorcells, if they are not longer needed.
  * Only the changePixmap command will use this feature, so pixmaps which
  * are set with setValues are still cached as usual by Xt!
  * Note that setting a pixmap with setValues therefore implies proctically
  * loosing these colorcells for the application's lifetime since Xt does
  * not see to free these!
  */
typedef struct _pixmapCache
     {
     Pixmap                pm;              /* Pixmap                */
     Pixmap                mask;            /* shape mask            */
     XpmAttributes        *attribPtr;       /* Colorcells, etc       */
     XrmQuark              fileName;        /* The filename..        */
     Cardinal              count;           /* references            */
     struct _pixmapCache  *next;
     }  pixmapCache, *pixmapCachePtr;

static pixmapCachePtr pixmapCacheRoot = NULL;


 /* this is the per widget information about used pixmaps */
typedef struct _xpmList
     {
     XrmQuark         resName;  
     XrmQuark         fileName;
     Display         *dpy;
     Colormap         cmap;
     struct _xpmList *next;
     } xpmList, *xpmListPtr;
#endif /* XPM */

typedef struct 
     {
     Pixmap pixmap;
     Widget w;
     } pixrec;
  

/* try hard to locate bitmap or pixmap file */
static char *
locateBitmap(dpy, name, toPixmap)
Display *dpy;
char * name;
Boolean toPixmap;
    {
    
    /* is the name enough? */
    if (access(name, R_OK) == 0)
	return name;
    else
	{
	char *fn;
	if (!(fn = XtResolvePathname(dpy, "bitmaps", name, wafe_EMPTY, 
				     wafeFileSearchPath, NULL, 0, NULL)))
	    {
	    Boolean success = False;
	    if (toPixmap) 
		{
		success = (NULL != (fn = XtResolvePathname(dpy, "bitmaps",
							   name,".gz", 
							   wafeFileSearchPath, 
							   NULL, 0, NULL)));
		}
	    
	    if (!success)
		{
		XtStringConversionWarning(name,toPixmap ? XtRPixmap:XtRBitmap);
		wafeWarn("convert", "Wafe's current FILESEARCHPATH is <%s>", 
			 wafeFileSearchPath,NULL,NULL);  
		}
	    }
	return fn;
	}
    }


#ifdef XPM
static void 
setPixmap(widget, resource, qResName, pm, mask, width, height)
Widget        widget;
String        resource;
XrmQuark      qResName;
Pixmap        pm, mask;
unsigned int  width, height;
    {
    Display      *dpy = XtDisplay(widget);
    Window        window, root;
    Pixel         bpix;
    int           x,y;
    unsigned int  w,h,b,d;

#ifdef ATHENA
    /* XtVaSetValues fails nowadays on Label bitmaps with XtUnspecifiedPixmap*/
    if (pm == XtUnspecifiedPixmap) 
	return;
#endif /* ATHENA */
#ifdef MOTIF
    if (!pm) 
	pm = XmUNSPECIFIED_PIXMAP;
#endif /* MOTIF */

    if (qResName != qiconPixmap)
	{
	XtVaSetValues(widget, resource, pm, NULL);

/*	if ((pm != XtUnspecifiedPixmap) && (window = XtWindow(widget))) */
	if ((window = XtWindow(widget)))
	    if (mask)
		{
		int xOff=0, yOff=0;
		XGetGeometry(dpy,window,&root,&x,&y,&w,&h,&b,&d);
		if (w<width || h<height)
		    {
		    wafeWarn("changePixmap",
			"Shape mask for %s of %s larger than window; ignored", 
			resource, wafeWidgetToName(widget), NULL);
		    mask = None;
		    } 
		else 
		    {
#ifdef MOTIF
		    unsigned char alignment = 0;
		    Dimension margin_left,margin_right,margin_width,
		       margin_height,margin_top,
		       highlight_thickness, shadow_thickness,
		       wOffset, hOffset;
		
		    XtVaGetValues(widget,
				  XmNalignment,          &alignment,
				  XmNmarginLeft,         &margin_left,
				  XmNmarginRight,        &margin_right,
				  XmNmarginWidth,        &margin_width,
				  XmNmarginHeight,       &margin_height,
				  XmNmarginTop,          &margin_top,
				  XmNhighlightThickness, &highlight_thickness,
				  XmNshadowThickness,    &shadow_thickness,
				  NULL);

		    wOffset = margin_width  +
			highlight_thickness + shadow_thickness;
		    hOffset = margin_height +
			highlight_thickness + shadow_thickness;
		    
		    if (alignment == XmALIGNMENT_BEGINNING)
			{
			xOff = wOffset + margin_left;
			yOff = hOffset + margin_top;
			}
		    else if (alignment == XmALIGNMENT_END)
			{
			if (w>width)  xOff = (w - width ) - 
			    (wOffset + margin_right);
			if (h>height) yOff = (h - height) -
			    (hOffset + margin_top);
			}
		    else /* (alignment == XmALIGNMENT_CENTER) */
			{
			if (w>width)  xOff = (w - width ) / 2;
			if (h>height) yOff = (h - height) / 2;
			}
#else
		    if (w>width)  xOff = (w - width ) / 2;
		    if (h>height) yOff = (h - height) / 2;
#endif /* MOTIF */
		    }
		XShapeCombineMask(dpy, window, ShapeBounding, xOff,yOff, 
				  mask, ShapeSet);
		XClearWindow(dpy,window);
		}
	    else
		{
		XShapeCombineMask(dpy, window, ShapeBounding, 0,0, 
				  mask, ShapeSet);
		}
	else
	    if (mask)
		wafeWarn("changePixmap",
			 "Cannot set shape mask for unrealized widget %s", 
			 wafeWidgetToName(widget), NULL, NULL);

	return;
	}

    /* icon pixmaps are more complicate to handle:
       0) ignore calls to Unspecified Pixmaps
       1) get or create the icon window
       2) reconfigure it.
       3) under mwm and friends the rules for handling icons
          are different, since the icons are created withing a 
          surrounding frame
     */

    if (   pm == None
	|| pm == ParentRelative
	|| pm == XtUnspecifiedPixmap
#ifdef MOTIF
	|| pm == XmUNSPECIFIED_PIXMAP
#endif
	) return;

    root = RootWindow(dpy, DefaultScreen(dpy));
    bpix = XBlackPixelOfScreen(DefaultScreenOfDisplay(dpy));

    XtVaGetValues(widget, XtNiconWindow, &window, NULL);
    if (!window)
	{
	window = XCreateSimpleWindow(dpy, root, 0, 0, 
				     width, height, 1, 
				     bpix, bpix);
	XtVaSetValues(widget, XtNiconWindow, window, NULL);
	}
    else 
	{
	XWindowChanges values;
	
	values.width  = width;
	values.height = height;

	/* reconfigure uglifies icon under MWM */
	if (wafeMWMrunning(widget))
	    {
	    XIconSize *size_list;
	    int count = 0;

	    XGetGeometry(dpy,window,&root,&x,&y,&w,&h,&b,&d);
	    XGetIconSizes(dpy, root, &size_list, &count);
	    if (count>0) 
		{
		if (values.width  > size_list->max_width)
		    values.width  = size_list->max_width;
		if (values.height > size_list->max_height)
		    values.height = size_list->max_height;

		values.x = (size_list->max_width  - values.width ) / 2 + 6;
		values.y = (size_list->max_height - values.height) / 2 + 6;

		XFree((char *)size_list);
		XReconfigureWMWindow(dpy,window, DefaultScreen(dpy),
				     CWX|CWY|CWWidth|CWHeight, &values);
		}
	    }
	else
	    XReconfigureWMWindow(dpy,window, DefaultScreen(dpy),
				 CWWidth|CWHeight, &values);
	}

    XSetWindowBackgroundPixmap(dpy, window, pm);
    XShapeCombineMask(dpy, window, ShapeBounding, 0, 0, mask, ShapeSet);
    XClearWindow(dpy,window);
    }



#ifdef PIXMAPCACHETRACE 
static void showPixmapCache(string)
String string;
    {
    pixmapCachePtr   pptr;
    fprintf(stderr,"Pixmap cache: %s\n",string);
    for (pptr=pixmapCacheRoot;  pptr != NULL; pptr=pptr->next)
	fprintf(stderr,"   %s (%x): count=%d\n",
		XrmQuarkToString(pptr->fileName),
		(int)pptr->pm,
		pptr->count
		);
    fprintf(stderr,"------------\n");
    }
#endif


/* Cleanup last settings:
 * Search the list of pixmaps to find out whether the specified pixmap's 
 * resources are to be freed - which is the case when it was created by
 * changePixmap
 */
static Pixmap 
freeInPixmapCache(dpy,cmap,qFileName)
Display    *dpy;
Colormap    cmap;
XrmQuark    qFileName;
    {
    pixmapCachePtr  pptr, lastPtr = NULL;
    Pixmap          toDestroy = None;

    DBUG_ENTER("freeInPixmapCache");

#ifdef PIXMAPCACHETRACE 
    showPixmapCache("before Free");
#endif

    for (pptr=pixmapCacheRoot;  pptr != NULL; lastPtr=pptr, pptr=pptr->next)
	if (pptr->fileName == qFileName)
	    {
	    pptr->count--;
	    if (pptr->count < 1)
		{

		/* destroy Pixmap and deallocate resources */
		DBUG_PRINT("xpm",
			   ("deallocating pixmap %s (%x), %d colors", 
			    XrmQuarkToString(pptr->fileName), 
			    pptr->pm,
			    pptr->attribPtr->npixels));

		toDestroy = pptr->pm;
		if (pptr->attribPtr->depth > 1) 
		    XFreeColors(dpy, cmap, 
				pptr->attribPtr->pixels, 
				pptr->attribPtr->npixels, 0);
		if (pptr->mask) 
		    XFreePixmap(dpy,pptr->mask);

		XpmFreeAttributes(pptr->attribPtr);

		if (pptr == pixmapCacheRoot)
		    pixmapCacheRoot = pptr->next;
		else
		    lastPtr->next = pptr->next;
		XtFree((char *)pptr);
		}
	    break;
	    }
    
#ifdef PIXMAPCACHETRACE 
    showPixmapCache("after Free");
#endif
    DBUG_RETURN(toDestroy);
    }


static String
xpmErrorReason(xpmReturnCode)
int            xpmReturnCode;
    {
    char *reason;
    
    switch (xpmReturnCode) 
	{
    case XpmColorError: 
	reason = "Color Error"; break;
    case XpmOpenFailed: 
	reason = "Open Failed"; break;
    case XpmFileInvalid: 
	reason = "File Invalid"; break;
    case XpmNoMemory: 
	reason = "No Memory"; break;
    case XpmColorFailed: 
	reason = "Color Failed"; break;
    default:
	reason = "Unknown Reason";
	}
    return reason;
    }


static void
explainXpmError(immediateData, string, xpmReturnCode)
Boolean immediateData;
String string;
int xpmReturnCode;
    {
    wafeWarn("convertPixmap", 
	     "Couldn't convert '%s' to pixmap (%s)", 
	     immediateData ? "data" : string, 
	     xpmErrorReason(xpmReturnCode), NULL);
    }



static int
xpmToPixmap(immediateData, dpy, d, string, pixmap, mask, attribPtr)
Boolean        immediateData;
Display       *dpy;
Window         d;
Pixmap        *pixmap;
Pixmap        *mask;
String         string;
XpmAttributes *attribPtr;
    {
    int    retcode;

    retcode = (immediateData ? XpmCreatePixmapFromBuffer : XpmReadFileToPixmap)
	(dpy, d, string, pixmap, mask, attribPtr);
    return retcode;
    }

#ifdef MOTIF
static int
xpmToImage(immediateData, dpy, string, image, mask, attribPtr)
Boolean        immediateData;
Display       *dpy;
XImage       **image;
XImage       **mask;
String         string;
XpmAttributes *attribPtr;
    {
    int    retcode;

    retcode = (immediateData ? XpmCreateImageFromBuffer : XpmReadFileToImage)
	(dpy, string, image, mask, attribPtr);
    return retcode;
    }
#endif


static Boolean 
xpmImmediateData(fname,fn)
String  fname;
String *fn;
    {
    char *p = fname;
    
    while( *p == '\n' || *p == ' ' || *p == '\t') p++;
    if (strncmp(p,"/* XPM */",9) == 0)
	{
	*fn = p;
	return True;
	}
    else
	return False;
    }


static pixmapCachePtr
getThroughPixmapCache(immediateData,dpy,fname,qFileName,pixmapReturn)
Boolean       immediateData;
Display      *dpy;
String        fname;
XrmQuark      qFileName;
Pixmap       *pixmapReturn;
    {
    pixmapCachePtr  pptr;
    char           *fn;
    int             xpmReturnCode,
                    screenNum  = DefaultScreen(dpy);
    unsigned int    depth      = DefaultDepth(dpy, screenNum);
    XpmAttributes  *attribPtr; 
    Pixmap          pixmap,mask;

    DBUG_ENTER("getThroughPixmapCache");

    /* is the pixmap already in the cache? */
    for (pptr = pixmapCacheRoot; pptr != NULL; pptr = pptr->next)
	{
	if (qFileName == pptr->fileName)
	    {
	    DBUG_PRINT("xpm", ("Pixmap %s (%x) found in cache",
			       fname, pptr->pm));
	    pptr->count ++;
	    DBUG_RETURN(pptr);
	    }
	}

    /* If the new pixmap's filename is None etc, 
     * don't create new entry, ut use shortcut
     */
    if (!strcmp(fname, wafe_NONE))
	{
	*pixmapReturn = None;
	DBUG_RETURN((pixmapCachePtr)NULL);
	}
    else 
    if (!strcmp(fname, "Unspecified"))
	{
	*pixmapReturn = XtUnspecifiedPixmap;
	DBUG_RETURN((pixmapCachePtr)NULL);
	}
    else
    if (!strcmp(fname, "ParentRelative"))
	{
	*pixmapReturn = ParentRelative;
	DBUG_RETURN((pixmapCachePtr)NULL);
	}

    if (immediateData)
	fn = fname;
    else /* we have to look for the file */ if
	(!(fn = locateBitmap(dpy, fname, True)))
	{ 
	*pixmapReturn = XtUnspecifiedPixmap;
	DBUG_RETURN((pixmapCachePtr)NULL);
	}

    /* Now convert the new Pixmap-File, create a new element of the list 
     * and fill it with information.
     */
    attribPtr = (XpmAttributes *)XtCalloc(sizeof(XpmAttributes), sizeof(char));
    attribPtr->valuemask = XpmReturnPixels | XpmDepth | XpmReturnInfos | 
      XpmCloseness;
    attribPtr->depth     = depth;
    attribPtr->closeness = wafeColorCloseness;
    /* fprintf(stderr, "changePixmap: calling xpmreadfile\n"); */

    xpmReturnCode = xpmToPixmap(immediateData, 
				dpy, RootWindow(dpy, screenNum), 
				fn, &pixmap, &mask, attribPtr);

    /* fprintf(stderr, "changePixmap: xpmreadfile returned %d\n",
       xpmReturnCode); */
    if (fn != fname) 
	XtFree(fn);

    if (xpmReturnCode == XpmSuccess)
	{
	pptr = (pixmapCachePtr)XtMalloc(sizeof(pixmapCache));
	pptr->next      = pixmapCacheRoot;
	pptr->pm        = pixmap;
	pptr->mask      = mask;
	pptr->count     = 1;
	pptr->fileName  = qFileName;
	pptr->attribPtr = attribPtr;
	pixmapCacheRoot = pptr;
	DBUG_PRINT("xpm", ("%d colorcells are used for new pixmap %s (%x)", 
			   pptr->attribPtr->npixels, fname, pixmap));
	DBUG_RETURN(pptr);
	}
    else
	{
	wafeSetError("Couldn't convert %s to pixmap (%s)",
		     immediateData ? "immediate data" : fname,
		     xpmErrorReason(xpmReturnCode), NULL);

	XpmFreeAttributes(attribPtr);
	*pixmapReturn = XtUnspecifiedPixmap;
	DBUG_RETURN((pixmapCachePtr)NULL);
	}
    }     


static void
freeXpmList(ptr)
char *ptr;
    {
    xpmListPtr p = (xpmListPtr)ptr, nextPtr;
    Pixmap     toDestroy;

    while (p) 
	{
	nextPtr = p->next;
	if ((toDestroy = freeInPixmapCache(p->dpy,p->cmap,p->fileName)))
	    XFreePixmap(p->dpy, toDestroy); 
	XtFree((char *)p);
	p = nextPtr;
	}
    }


int
wafeChangePixmap(w,resource,fname)
Widget     w;
String     resource;
String     fname;
    {
    Colormap         cmap;
    Pixmap           toDestroy = None,
                     pixmapReturn;
    Display         *dpy       = XtDisplay(w);
    XrmQuark         qResName  = XrmStringToQuark(resource), 
                     qFileName;
    MMattribListPtr *al        = NULL;
    xpmListPtr       pixPtr    = 
	(xpmListPtr)wafeMMgetValue(w, qxpmList, &al, True);
    xpmListPtr       tpixPtr;
    pixmapCachePtr   pptr;    
    Boolean          immediateData = xpmImmediateData(fname,&fname);

    qFileName = XrmStringToQuark(fname);
    
    if (!wafeGetQTypeOfAttribute(XtClass(w),ParentWidget(w),qResName,NULL))
	return wafeSetError("widget %s has no resource %s",
			    wafeWidgetToName(w), resource, NULL);

    for (tpixPtr = pixPtr; tpixPtr != NULL; tpixPtr = tpixPtr->next)
	if (qResName == tpixPtr->resName) /* it has already a xpm */
	    break;
    
    XtVaGetValues(w, XtNcolormap, &cmap, NULL);

    if (tpixPtr)
	{
	/* we have already a xpm for this widget & resource */
	if (qFileName == tpixPtr->fileName)
	    {
	    DBUG_PRINT("xpm", ("You are about to set the same pixmap!"));
	    return TCL_OK;
	    }
	else
	    toDestroy = freeInPixmapCache(dpy,cmap,tpixPtr->fileName);
	}
    else
	{
	/* we have no xpm for this widget & resource */
	tpixPtr = (xpmListPtr) XtMalloc(sizeof(xpmList));
	tpixPtr->next     = pixPtr;
	tpixPtr->resName  = qResName;
	tpixPtr->dpy      = dpy;
	tpixPtr->cmap     = cmap;
	if (!pixPtr) 
	    wafeMMreplace(NULL, al, qxpmList, (char *)tpixPtr, freeXpmList);
	}
    tpixPtr->fileName = qFileName;    

#ifdef PIXMAPCACHETRACE 
    showPixmapCache("Before");
#endif
    /* now try to obtain the pixmap by using the pixmap cache */
    if ((pptr = getThroughPixmapCache(immediateData, 
				      dpy,fname,qFileName,&pixmapReturn))) 
	setPixmap(w, resource, qResName, pptr->pm, pptr->mask, 
		  pptr->attribPtr->width, pptr->attribPtr->height);
    else 
	setPixmap(w, resource, qResName, pixmapReturn, None, 0, 0);

    if (toDestroy) 
	{
	DBUG_PRINT("xpm", ("old pixmap (%x) will be destroyed now", 
			   (int)toDestroy));
	XFreePixmap(dpy, toDestroy); 
	}

#ifdef PIXMAPCACHETRACE 
    showPixmapCache("After");
#endif
    if (wafeInterpreter->result && *(wafeInterpreter->result)) 
      return TCL_ERROR;
    else 
      return TCL_OK;
    }     

# ifdef MOTIF
static String 
getMaskName(immediateData,name)
Boolean immediateData;
String name;
    {
    char *dot = NULL;
    int oldLength = strlen(name);
    char *mask_name = XtMalloc(oldLength+3);
    
    if (!immediateData)
	dot = (char*)strrchr(name,'.');

    if (dot)
	{
	char *ext = XtNewString(dot);
	int dotOffset = dot-name;
	strncpy(mask_name,name,dotOffset);
	strcpy(mask_name+dotOffset,"_m");
	strcpy(mask_name+dotOffset+2,ext);
	XtFree(ext);
	}
    else
	{
	strncpy(mask_name,name,oldLength);
	strcpy(mask_name+oldLength,"_m");
	}
    /* fprintf(stderr,"mask_name = <%s>\n",mask_name);*/
    return mask_name;
    }
# endif /* MOTIF */
#endif /* XPM */


#ifdef MOTIF
Boolean
wafeInstallImage(w,string,name,quiet,xpmErrorCode,background)
Widget w;
String string;
String name;
Boolean quiet;
int *xpmErrorCode;
Pixel background;
    {
    Display *dpy  = XtDisplay(w);
    XImage *image = NULL;
    XImage *mask  = NULL;
    Boolean  result;
    char buffer[LONG_AS_STRING];
#ifdef XPM
    int xpmReturnCode;
    Boolean immediateData = xpmImmediateData(string,&string);
    XpmAttributes  attrib;
#else
    Boolean immediateData = False;
#endif /* XPM */
    String fn;

    DBUG_ENTER("wafeInstallImage");

    /* if no name is given, use the file name or immediate data */
    if (!name)
	name = string;

    if (Tcl_GetVar2(wafeInterpreter,"_imageCache",name, TCL_GLOBAL_ONLY))
	DBUG_RETURN(False);       /* the image is already installed */

    fn = string;
    if (!immediateData)
	{
	/* we have to look for the file */
	if (!(fn = locateBitmap(dpy, string, True)))
	    DBUG_RETURN(False);     /* the file was not found */
	}

    if (!immediateData)   
	/* we have currently no program to process xbm immediate */
	{
	unsigned int     width, height;
	int              xhot, yhot;
	unsigned char    *data;

	if (XmuReadBitmapDataFromFile(fn, &width, &height, &data,
				      &xhot, &yhot) == BitmapSuccess)
	    {
	    image = (XImage *)XtMalloc(sizeof(XImage));
	    image->height           = height;
	    image->width            = width;
	    image->depth            = 1;
	    image->bits_per_pixel   = 1;
	    image->xoffset          = 0;
	    image->format           = XYBitmap;
	    image->data             = (char*)data;
	    image->byte_order       = LSBFirst;
	    image->bitmap_unit      = 8;
	    image->bitmap_bit_order = LSBFirst;
	    image->bitmap_pad       = 8;
	    image->bytes_per_line   = (width+7)/8;
	    }
	}
    
# ifdef XPM    
    if (!image)
	{
	XpmColorSymbol cs;
	cs.name = "None";
	cs.value = NULL;
	cs.pixel = XWhitePixelOfScreen(DefaultScreenOfDisplay(dpy));

	if (background) 
	    cs.pixel = background;
	else 
	if (w)
	    XtVaGetValues(w,XtNbackground,&cs.pixel,NULL);

	attrib.valuemask = 
	    XpmDepth | XpmReturnInfos | XpmCloseness | XpmColorSymbols;
	attrib.numsymbols = 1;
	attrib.colorsymbols = &cs;
	attrib.depth = DefaultDepthOfScreen(DefaultScreenOfDisplay(dpy));
        attrib.closeness = wafeColorCloseness;
	
	xpmReturnCode = xpmToImage(immediateData, 
				   dpy, fn, &image, &mask, &attrib); 
	  /* fprintf(stderr,"image %s returns image=%p mask=%p\n",
		fn, image, mask); */
	
	if (!image)
	    {
	    if (quiet && xpmErrorCode) 
		*xpmErrorCode = xpmReturnCode;
	    else 
		explainXpmError(immediateData,fn,xpmReturnCode);
	    }
	}
# endif /* XPM */

    if (image) 
	{
	if (!(result = XmInstallImage(image, name)))
	    {
	    /* fprintf(stderr, "   destroying image\n"); */
	    XDestroyImage(image);
	    }
	else 
	    {
	    sprintf(buffer,"%ld",(long)image);
	      /* fprintf(stderr,"Image '%s' installed, imagePtr='%s'\n",  
		    name, buffer); */
	    Tcl_SetVar2(wafeInterpreter,"_imageCache",name,
			buffer, TCL_GLOBAL_ONLY);

	    if (mask)
		{
# ifdef XPM
		char *mask_name = getMaskName(immediateData,name);
		if (XmInstallImage(mask, mask_name))
		    {
		    sprintf(buffer,"%ld",(long)mask);
		    Tcl_SetVar2(wafeInterpreter,"_imageCache",mask_name,
				buffer, TCL_GLOBAL_ONLY);
		      /* fprintf(stderr,"Mask '%s' installed, imagePtr='%s'\n",
			    mask_name, buffer); */
		    }
		else
		    XDestroyImage(mask);

		XtFree(mask_name);
# else 
		XDestroyImage(mask);
# endif /* XPM */
		}
    	    }
	}
    else
	result = False;

    if (fn != string) 
	XtFree(fn);

    DBUG_RETURN(result);
    }
#endif /* MOTIF */



#ifdef MOTIF
static Pixmap
getPixmapViaXmImageCache(w,name,depth,xpmErrorCode)
Widget  w;
char   *name;
int     depth;
int    *xpmErrorCode;
    {
    Pixmap  pixmap;
    Pixel   foreground = 0;
    Pixel   background = 0;
#ifdef MOTIF12    
    char   *imagePointerString;
    int     iDepth;
#endif
    Display *dpy = XtDisplay(w);
    Screen  *screen = DefaultScreenOfDisplay(dpy);

# ifdef XPM
    (void) xpmImmediateData(name,&name);
# endif

    if (w)
	{
	/*
	fprintf(stderr,
		"getting foreground and background from currentwidget %s\n",
		XtName(w));
		*/
	XtVaGetValues(w,
		      XtNforeground,&foreground,
		      XtNbackground,&background,
		      NULL);
	}
    else
	{
	foreground = XBlackPixelOfScreen(screen);
	background = XWhitePixelOfScreen(screen);
	}

      /* fprintf(stderr,"foreground=%ld, background=%ld black=%ld white=%ld\n",
	    foreground, background, 
	    XBlackPixelOfScreen(screen), XWhitePixelOfScreen(screen)); */
  
# ifdef MOTIF12
#  ifdef MOTIF20
    imagePointerString = Tcl_GetVar2(wafeInterpreter,"_imageCache",
				     name, TCL_GLOBAL_ONLY);
    if (imagePointerString) 
	{
	char *end;
	XImage *i = (XImage *)strtol(imagePointerString,&end,10);
	  /*
	    fprintf(stderr,"getting %s's pointerString = '%s', depth = %d\n", 
	            name,imagePointerString,i->depth); */
	iDepth = i->depth;
	}
    else
	{
	iDepth = 1;
	}
#  else
    iDepth = depth;
#  endif /* MOTIF20 */
    
    pixmap = XmGetPixmapByDepth(screen, name, foreground, background, iDepth);
# else
    pixmap = XmGetPixmap(screen, name, foreground, background);
# endif /* MOTIF12 */
    if (pixmap == XmUNSPECIFIED_PIXMAP && 
	wafeInstallImage(w,name,NULL,True,xpmErrorCode,background))
	{
# ifdef MOTIF12
	pixmap = XmGetPixmapByDepth(screen, name, foreground, background, depth);
# else
	pixmap = XmGetPixmap(screen, name, foreground, background);
# endif
	}

# ifdef NEVER
# ifdef XPM
	{
	char *mask_name = getMaskName(immediateData,name);
	Pixmap mask = XmGetPixmapByDepth(screen, mask_name, 
					 foreground, background, depth);
	
	XtFree(mask_name);
	}
# endif /* XPM */
# endif /* NEVER */
    return pixmap;
    }
#endif /* MOTIF */


static void
destroyPixrec(pr)
pixrec *pr;
    {          
#ifdef MOTIF
    XmDestroyPixmap(XtScreen(pr->w),pr->pixmap);
#else
    fprintf(stderr, "destroyPixrec %ld widget=%p\n", 
	    pr->pixmap, pr->w);
    XFreePixmap(XtDisplay(pr->w), pr->pixmap);
#endif
    XtFree((char*)pr);
    }

static void
recordPixmapInfo(w,pixmap)
Widget w;
Pixmap pixmap;
    {
    pixrec *pr = (pixrec *)XtMalloc(sizeof(pixrec));
    pr->pixmap = pixmap;
    pr->w = w;
    wafeMMreplace(w, wafeCurrentAttribList, 
		  wafeCurrentAttrib, 
		  (char *)pr, destroyPixrec);
    }



#ifdef MOTIF
static Boolean
CvtStringToPixmapOrBitmap(dpy, args, num_args, fromVal, toVal,
			  converter_data)
Display *dpy;
XrmValuePtr args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer *converter_data;
    {
    Pixmap           pixmap;               /* static for cvt magic */
    String           fname;
    int              screenNum = DefaultScreen(dpy);
    int              depth     = DefaultDepth(dpy, screenNum);
    String           fn = NULL;
    Boolean          toPixmap = *num_args>1;
    Boolean          needPixmap;
    int              xpmErrorCode = 0;
    Widget w = *((Widget *) args[0].addr);

    WAFE_UNUSED(args||converter_data);

    fn = fname = (String) fromVal->addr;

    DBUG_PRINT("xpm",("Trying to convert '%s' to %s",
		      fname,toPixmap ? XtRPixmap : XtRBitmap));

    if (strcmp(fname, wafe_NONE) == 0) 
	{
        pixmap = None;
	needPixmap = False;
	}
    else
    if (strcmp(fname, "ParentRelative") == 0 && toPixmap) 
	{
        pixmap = ParentRelative;
	needPixmap = False;
	}
    else
    if (strcmp(fname, "Unspecified") == 0 && toPixmap) 
	{
        pixmap = XtUnspecifiedPixmap;
	needPixmap = False;
	}
    if (strcmp(fname, "unspecified_pixmap") == 0) 
	{
	pixmap = XmUNSPECIFIED_PIXMAP;
	needPixmap = False;
	}
# ifdef MOTIF12
    else
    if ((pixmap = getPixmapViaXmImageCache(w, fname, 
					   toPixmap? depth : 1, 
					   /* depth,*/
					   &xpmErrorCode))
	!= XmUNSPECIFIED_PIXMAP)
	{
	needPixmap = False;
	}
    else
	{
	pixmap = None;
	needPixmap = True;
	}
#else
    else
	{
	pixmap = None;
	needPixmap = True;
	}
# endif /* MOTIF12 */
    
    if (needPixmap) 
	{
	XtStringConversionWarning(fname, toPixmap ? XtRPixmap : XtRBitmap);
	if (xpmErrorCode)
	    wafeWarn("convertPixmap", "Reason: %s", 
		     xpmErrorReason(xpmErrorCode), NULL, NULL);
	pixmap = XmUNSPECIFIED_PIXMAP;
	}
    else 
	{
	recordPixmapInfo(w,pixmap);
	}
    
    if (fname != fn) 
	XtFree(fn);
   
    WAFE_CONVERSION_DONE(Pixmap,pixmap);
    }

#else /* ------------------------ no MOTIF --------------------------- */

#define UNKNOWN 0xffffffff

static Boolean
CvtStringToPixmapOrBitmap(dpy, args, num_args, fromVal, toVal,
			  converter_data)
Display *dpy;
XrmValuePtr args;
Cardinal *num_args;
XrmValuePtr fromVal;
XrmValuePtr toVal;
XtPointer *converter_data;
    {
    Pixmap           pixmap;               /* static for cvt magic */
    String           fname;
    int              screenNum = DefaultScreen(dpy);
    int              depth     = DefaultDepth(dpy, screenNum);
    String           fn = NULL;
    Boolean          toPixmap = *num_args>1;
    Boolean          needPixmap;
    Window           rootWindow = RootWindow(dpy, screenNum);
    unsigned char   *data;
    unsigned int     width, height;
    int              xhot, yhot;
    Boolean          immediateData = False;
    Widget           w = *((Widget *) args[0].addr);

    WAFE_UNUSED(args||converter_data);

    fn = fname = (String) fromVal->addr;

    DBUG_PRINT("xpm",("Trying to convert '%s' to %s",
		      fname,toPixmap ? XtRPixmap : XtRBitmap));

    if (strcmp(fname, wafe_NONE) == 0) 
	{
        pixmap = None;
	needPixmap = False;
	}
    else
    if (strcmp(fname, "ParentRelative") == 0 && toPixmap) 
	{
        pixmap = ParentRelative;
	needPixmap = False;
	}
    else
    if (strcmp(fname, "Unspecified") == 0 && toPixmap) 
	{
        pixmap = XtUnspecifiedPixmap;
	needPixmap = False;
	}
    else
	{
        pixmap = None;
	needPixmap = True;
# ifdef XPM
	immediateData = xpmImmediateData(fname,&fname);
	if (immediateData) 
	    fn = fname;
# endif
	}
    
    if (needPixmap && !immediateData)
	{
	/* we have to locate the image */
	fn = locateBitmap(dpy, fname, toPixmap);
	}


      /* the .xbm converter */
    if (needPixmap && fn && !immediateData)
	{
	/* try to read file as bitmap file... */
	if (XmuReadBitmapDataFromFile(fn, &width, &height, &data,
				      &xhot, &yhot) == BitmapSuccess)
	    {
	    Pixel foreground, background;

	    if (toPixmap) 
		{
		foreground = background = UNKNOWN;
		XtVaGetValues(w,
			      XtNbackground,&background,
			      XtNforeground,&foreground,
			      NULL);
		if (foreground == UNKNOWN)
		    foreground = 
			XWhitePixelOfScreen(DefaultScreenOfDisplay(dpy));
		if (background == UNKNOWN)
		    background =
			XBlackPixelOfScreen(DefaultScreenOfDisplay(dpy));
		    
		if (foreground == background)
		    {
		    if (foreground == 0)
			foreground = 1;
		    else if (background == 1)
			background = 0;
		    }
		}
	    else 
		{
		foreground = 1;
		background = 0;
		}
	    
	    pixmap = XCreatePixmapFromBitmapData(dpy,rootWindow,
			(char *) data, width, height, foreground, background, 
		        toPixmap?depth:1);

	    XFree((char *)data);
	    needPixmap = False;
	    recordPixmapInfo(w,pixmap);
	    }
	}

#ifdef XPM
    if (needPixmap && fn)
	{
	int              returnValue;
	Pixmap          *maskPtr = NULL;
	XpmAttributes    attrib;
	XpmColorSymbol   cs;
#ifdef SETMASK_IN_CONVERTER	
	Window           coreWin;
	Pixmap           mask = 0;
#endif
	cs.name = "None";
	cs.value = NULL;

	/* initalize for the case that get values fails */
	cs.pixel = XWhitePixelOfScreen(DefaultScreenOfDisplay(dpy));
	XtVaGetValues(w,XtNbackground,&cs.pixel,NULL);

	attrib.valuemask  = (XpmReturnPixels | XpmDepth | 
			     XpmCloseness | XpmColorSymbols);
	attrib.depth      = depth;
	attrib.closeness  = wafeColorCloseness;
	attrib.numsymbols = 1;
	attrib.colorsymbols = &cs;

#ifdef SETMASK_IN_CONVERTER	
	coreWin = w ? XtWindow(w) : 0;
	maskPtr = coreWin ? &mask : NULL;
#endif

	if ((returnValue = xpmToPixmap(immediateData,
				      dpy, rootWindow, fn, &pixmap, maskPtr, 
				      &attrib) ) != XpmSuccess)
	    {
            explainXpmError(immediateData,fn,returnValue);
	    XtStringConversionWarning(fname, toPixmap ? XtRPixmap : XtRBitmap);
	    }
	else 
	    {
	      /*
		fprintf(stderr,"pixmap=%p, width=%d, height=%d, addr=%p\n",
		pixmap, attrib.width,attrib.height,toVal->addr);
		*/
	    needPixmap = False;
	    recordPixmapInfo(w,pixmap);
#ifdef SETMASK_IN_CONVERTER
	    if (wafeCurrentAttrib != qiconPixmap)
		{
		  /* if toVal->addr is set we assume that the value comes
		     from a resource file, in which case we can't assume that
		     the core fields of the widget are already initialized; 
		     coreWin will be wrong; Wafe never sets toVal->addr */
		
		if (coreWin && !toVal->addr) 
		    {
		      /* fprintf(stderr,"converter will set mask\n"); */
		    XShapeCombineMask(dpy, coreWin, ShapeBounding,
				      0, 0, mask, ShapeSet);
		      /* fprintf(stderr,"converter has set mask\n"); */
		    }
		}
	    else if (w)
		XtVaSetValues(w,XtNiconMask,mask,NULL);
#endif
	    }
	}
#endif /* XPM */

    if (fname != fn) 
	XtFree(fn);

    if (needPixmap) 
	{
	XtStringConversionWarning(fname, toPixmap ? XtRPixmap : XtRBitmap);
	return False;    
	}
    else 
	WAFE_CONVERSION_DONE(Pixmap,pixmap)
    }
#endif /* no MOTIF */


/* to keep knowledge about xpmConvertArgsPixmap etc local ...
 */
void
wafeRegisterXpmTypeConverter(resourceType, toPixmap)
_Xconst String resourceType;
Boolean toPixmap;
    { 
    /* provide additional arguments for the pixmap converter: 
     */
    static XtConvertArgRec xpmConvertArgsPixmap[] = {
	{XtWidgetBaseOffset, (XtPointer)0, sizeof(XtPointer)},
	{XtImmediate, (XtPointer)True, sizeof(Boolean)}
    };
    static XtConvertArgRec xpmConvertArgsBitmap[] = {
	{XtWidgetBaseOffset, (XtPointer)0, sizeof(XtPointer)}
    };

    if (toPixmap)
	XtSetTypeConverter(XtRString, 
			   resourceType, 
			   (XtTypeConverter)CvtStringToPixmapOrBitmap, 
			   xpmConvertArgsPixmap, 
			   XtNumber(xpmConvertArgsPixmap),
			   XtCacheNone,
			   NULL);
    else
	XtSetTypeConverter(XtRString, 
			   resourceType, 
			   (XtTypeConverter)CvtStringToPixmapOrBitmap, 
			   xpmConvertArgsBitmap, 
			   XtNumber(xpmConvertArgsBitmap), 
			   XtCacheNone|XtCacheRefCount, 
			   NULL);
    }


static void
recolorCursor(w, c, foreground, background)
Widget w;
Cursor c;
String background;
String foreground;
    {
    Display *dpy = XtDisplay(w);
    XColor bgColor, fgColor;

    /* 
       fprintf(stderr,"background=%p, foreground=%p\n", background,foreground);
       if (background) 
          fprintf(stderr,"background = %p <%s>\n", background, background);
     */

    if (foreground == wafe_EMPTY)  /* using wafe_EMPTY like an atom */
	{
	fgColor.pixel = 0;
	fgColor.red   = 0;
	fgColor.green = 0;
	fgColor.blue  = 0;
	}	
    else
	{
	fgColor.pixel = wafeCvtStringToPixel(w,foreground);
	XQueryColor(dpy,DefaultColormap(dpy, DefaultScreen(dpy)),&fgColor);
	}
    
    if (background == wafe_EMPTY)   /* using wafe_EMPTY like an atom */
	{
	bgColor.pixel = 0;
	bgColor.red   = 0xffff;
	bgColor.green = 0xffff;
	bgColor.blue  = 0xffff;
	}
    else
	{
	bgColor.pixel = wafeCvtStringToPixel(w,background);
	XQueryColor(dpy,DefaultColormap(dpy, DefaultScreen(dpy)),&bgColor);
	}

    XRecolorCursor(dpy,c,&fgColor,&bgColor);
    }


static Cursor
stringToCursor(w,name, foreground, background)
Widget w;
_Xconst String name;
String foreground;
String background;
    {
    int i, width, height, xhot, yhot;
    Cursor         cursor = None;
    String         fn;
    unsigned char *data;
    Cardinal j,worstHitRate = cursorCache[0].count;
    int worstCursorIndex = 0;
    Display *dpy = XtDisplay(w);
    
    /*fprintf(stderr,"searching for '%s'\n", name);*/

    for (i=0; i <= cursorCacheSize; i++)
	{
	if (strcmp(name, cursorCache[i].name) == 0
	    && cursorCache[i].dpy == dpy 
	    && strcmp(foreground, cursorCache[i].foreground) == 0
	    && strcmp(background, cursorCache[i].background) == 0
	    )
	    {
	    cursorCache[i].count++;
	    /*fprintf(stderr,"cursor '%s' found in cache(%d) pos =%d\n",
		    name,cursorCache[i].count, i);*/
	    return cursorCache[i].cursor;
	    }
	else 
	if (cursorCache[i].count < worstHitRate)
	    {
	    worstHitRate = cursorCache[i].count;
	    worstCursorIndex = i;
	    }
	}
    /*fprintf(stderr,"not found in cache '%s'\n", name);*/
    
    for (j=0; j<XtNumber(cursor_names); j++)
	if (strcmp(name, cursor_names[j].name) == 0) 
	    {
	    cursor = XCreateFontCursor(dpy, cursor_names[j].shape);
	    break;
	    }
    
    if (cursor == None)
	{
	
	if ((fn = locateBitmap(dpy, name, False)))
	    {
	    /* we have now a valid filename fn */
	    /* try to read file as bitmap file... */
	    if (XmuReadBitmapDataFromFile(fn, &width, &height, &data,
					  &xhot, &yhot) == BitmapSuccess)
		{
		static XColor bgColor = {0, 0xffff, 0xffff, 0xffff};
		static XColor fgColor = {0, 0, 0, 0};
		Window rootWindow = RootWindow(dpy,DefaultScreen(dpy));
		int rwidth, rheight;
		
		if (XQueryBestCursor(dpy, rootWindow,  width, height,
				     &rwidth, &rheight))
		    {
		    Pixmap source, mask = None;
		    int fnLength;
		    Boolean maskFound = True;
		    wafeStringStruct mn_s, *mn=&mn_s;

		    /* xhot & yhot might be negative */
		    if (xhot<0) xhot = width/2;
		    if (yhot<0) yhot = height/2;		
		    source = XCreatePixmapFromBitmapData(dpy,rootWindow,
							 (char *)data, 
							 width, height, 
							 1, 0, 1);
		    XFree((char *)data);
		    
		    /* now we search for the mask */
		    wafeStringInit(mn);
		    fnLength = strlen(fn);
		    wafeStringAppendN(mn,fn,fnLength),
		    wafeStringAppend(mn,"Mask");
		    if (access(wafeStringValue(mn), R_OK) != 0) 
			{
			strcpy(mn->buffer+fnLength,"msk");
			if (access(wafeStringValue(mn), R_OK) != 0)
			    maskFound = False;
			}
		    /*
		     fprintf(stderr,"width=%d, height=%d maskFound=%d <%s>\n",
		     width, height,maskFound,wafeStringValue(mn));
		     */
		
		    /* load the mask */
		    if (maskFound)
			{
			int mwidth, mheight, mxhot, myhot;
			
			if (XmuReadBitmapDataFromFile(wafeStringValue(mn), 
						      &mwidth, &mheight, &data,
						      &mxhot, &myhot) 
			    == BitmapSuccess)
			    {
			    if (mwidth == width && mheight == height)
				mask = XCreatePixmapFromBitmapData(dpy,
						   rootWindow,
						   (char *)data, 
						    width, height, 
						    1, 0, 1);
			    XtFree(data);
			    }
			}

		    wafeStringClear(mn);
		    /* fprintf(stderr,
		       "createPixCurs pix=%ld, mask=%ld, xhot=%d, yhot=%d\n",
		       source, mask, xhot, yhot);
		       */
		    cursor = XCreatePixmapCursor(dpy, source, mask,
						 &fgColor, &bgColor, 
						 xhot, yhot);

		    XFreePixmap(dpy, source);
		    if (mask) 
			XFreePixmap(dpy, mask);		    
		    }
		}
	    if (fn != name) XtFree(fn);
	    }
	}

    if (cursor != None)
	{
	int cc;

	if (cursorCacheSize < (cursorCacheMaxSize-1))
	    cc = ++cursorCacheSize;
	else 
	    {
	    cc = worstCursorIndex;
	    /* fprintf(stderr,"cursor cache pos %d cleared (%s)\n",
		    cc,cursorCache[cc].name);*/
	    XFreeCursor(dpy,cursorCache[cc].cursor);
	    XtFree(cursorCache[cc].name);
	    XtFree(cursorCache[cc].foreground);
	    XtFree(cursorCache[cc].background);
	    }

	/*fprintf(stderr,"cursor cache pos %d used for '%s'\n",cc,name);*/
	cursorCache[cc].name       = XtNewString(name);
	cursorCache[cc].foreground = XtNewString(foreground);
	cursorCache[cc].background = XtNewString(background);
	cursorCache[cc].dpy        = dpy;
	cursorCache[cc].cursor     = cursor;
	cursorCache[cc].count      = 1;
	recolorCursor(w, cursor, foreground, background);
	}

    return cursor;
    }



static Cursor
busyWindowBusyCursor(w)
Widget w;
    {
    String cursorName = 
	wafeGetApplicationResource(w, "busyCursor", XtRString);
    String fg = 
	wafeGetApplicationResource(w, "busyCursorForeground", XtRString);
    String bg = 
	wafeGetApplicationResource(w, "busyCursorBackground", XtRString);
    Cursor c;

    /*
       fprintf(stderr,"cursorName = %p, empty=%p\n", cursorName, wafe_EMPTY);
       if (cursorName) 
	   fprintf(stderr,"cursorName = <%s>\n", cursorName);
    */
    
    if (cursorName == wafe_EMPTY)  /* using wafe_EMPTY like an atom */
	cursorName = busyWindowDefaultCursorName;
        
    if ((c = stringToCursor(w, cursorName, fg,bg)) == None)
	c = stringToCursor(w, busyWindowFallbackCursorName, fg,bg);

    return c;
    }

static Window
cursorWindow(w,fromBusyWindow)
Widget w;
Boolean *fromBusyWindow;
    {
    MMattribListPtr *al = NULL;
    busyStructPtr bs = (busyStructPtr)wafeMMgetValue(w,qbusyWindow,&al,False);

    if (bs && bs->state)
	{
	*fromBusyWindow = True;
	return bs->busyWindow;
	}
    else 
	return  XtWindow(w);
    }


static void
setCursor(w,name,argc,argv)
    Widget w;
    String name;
    int argc;
    char **argv;
    {
    Cursor cursor = None;
    Display *dpy = XtDisplay(w);
    Boolean cursorFromBusyWindow = False;
    Window win = cursorWindow(w,&cursorFromBusyWindow);
    String foreground = wafe_EMPTY, background = wafe_EMPTY;

    switch (argc)
	{
    default:
	wafeWarn("setCursor","too many arguments specified!", NULL,NULL,NULL);
	/* fall through */
    case 2:
	if (*argv[1]) background = argv[1];
	/* fall through */	
    case 1:
	if (*argv[0]) foreground = argv[0];
	break;
    case 0:
	break;
	}

    if (strcmp(name,wafe_EMPTY) != 0 && strcmp(name,wafe_NONE) != 0) 
	cursor = stringToCursor(w,name, foreground,background);
    
    if (cursorFromBusyWindow && cursor == None)
	cursor = busyWindowBusyCursor(w); /* use default busy cursor */

    XDefineCursor(dpy, win, cursor);
    }


static Boolean
isBusy(w)
Widget w;
    {
    MMattribListPtr *al = NULL;
    busyStructPtr bs = (busyStructPtr)wafeMMgetValue(w,qbusyWindow,&al,False);
    return (bs && bs->state);
    }


static void
setBusy(w,sensitive)
Widget w;
Boolean sensitive;
    {
    unsigned long valuemask;
    XSetWindowAttributes attributes;
    MMattribListPtr *al = NULL;
    busyStructPtr bs = (busyStructPtr)wafeMMgetValue(w, qbusyWindow, &al,True);
    Display *dpy = XtDisplay(w);

    if (sensitive)
	{
	if (!bs)
	    {
	    Screen *scr = XtScreen(w);
	    
	    bs = (busyStructPtr) XtMalloc(sizeof(busyStruct));
	    wafeMMreplace(NULL, al,qbusyWindow,(char*)bs,XtFree);
            bs->state = False;

	    /* Ignore device events while the busy cursor is displayed. */
	    valuemask = CWDontPropagate | CWCursor;
	    attributes.do_not_propagate_mask =  
		(KeyPressMask | KeyReleaseMask |
		 ButtonPressMask | ButtonReleaseMask | PointerMotionMask);
	    attributes.cursor = busyWindowBusyCursor(w);

	    /* The window will be as big as the display screen, and clipped by
	     * its own parent window, so we never have to worry about resizing
	     */

	    bs->busyWindow = 
		XCreateWindow(dpy, XtWindow(w), 0, 0,
			      HeightOfScreen(scr)*2, WidthOfScreen(scr)*2, 
			      0, 0, InputOnly, CopyFromParent, 
			      valuemask, &attributes);
	    }
	if (!bs->state) 
	     {
	     XMapRaised(dpy, bs->busyWindow);
	     bs->state = True;
	     }
        }
    else
	{
	if (bs && bs->state)
	    {
	    XUnmapWindow(dpy, bs->busyWindow);
	    bs->state = False;
	    }
	}
    }


#ifdef XPM
static int cmd_changePixmap();
#else
#define cmd_changePixmap NULL
#endif
static int cmd_setBusy();
static int cmd_isBusy();
static int cmd_setCursor();





static _Xconst Proc_signature cmds[] = {
     { "changePixmap", cmd_changePixmap },
     { "setBusy", cmd_setBusy },
     { "isBusy", cmd_isBusy },
     { "setCursor", cmd_setCursor },
    { NULL, NULL }
    };

static WidgetCreate_signature wccs[] = {
    { NULL,NULL,NULL,False,False,NULL }
    };

static _Xconst String pkgs[] = {
#ifdef XPM
     "XPM",
#endif
    NULL
     };



/* 
 * hint: XPM
 * TCL_RETURN_CODE
 * wafeChangePixmap vulgo changePixmap
 * 	in: Widget{Display}		# widget
 * 	in: String			# resource
 * 	in: String			# pixmap file
 */
#ifdef XPM

static int 
cmd_changePixmap(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     TCL_RETURN_CODE returnVar;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 4) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],3));

     if (!(localVar1 =  name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));
     if (!(XtIsWidget(localVar1)))
         wafeReturnTclError(argv[0],"Widget (arg 1) must have a display");

    /* no need to assign  << localVar2 = argv[2] >>  */ 

    /* no need to assign  << localVar3 = argv[3] >>  */ 

     returnVar = wafeChangePixmap(localVar1,argv[2],argv[3]);

     DBUG_RETURN (returnVar);
     }

#endif

/* 
 * void
 * setBusy
 * 	in: Widget{Display}		# shell widget 
 * 	in: Boolean			# sensitive true | false
 */

static int 
cmd_setBusy(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],2));

     if (!(localVar1 =  name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));
     if (!(XtIsWidget(localVar1)))
         wafeReturnTclError(argv[0],"Widget (arg 1) must have a display");

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         DBUG_RETURN(wafeConvError(argc, argv, 2, NULL, XtRBoolean));

     setBusy(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * Boolean
 * isBusy
 * 	in: Widget			# Widget to test
 */

static int 
cmd_isBusy(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean returnVar;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc != 2) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[2],1));

     if (!(localVar1 = (Widget) name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));

     returnVar = isBusy(localVar1);

     Tcl_SetResult(comInterpreter, wafeStrings[returnVar?1:0], TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }


/* 
 * void
 * setCursor
 * 	in: Widget{Display}		# widget
 * 	in: String			# cursor name
 * 	in: [args opt]			# optional foreground, optional background

 */

static int 
cmd_setCursor(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  
     WAFE_UNUSED(clientData);
     WAFE_UNUSED(comInterpreter);

     if (argc < 3) 
	 DBUG_RETURN(wafeArgcError(argc,argv,wafeStrings[31],2));

     if (!(localVar1 =  name2Widget(argv[1])))
         DBUG_RETURN(wafeConvError(argc, argv, 1, NULL, XtRWidget));
     if (!(XtIsWidget(localVar1)))
         wafeReturnTclError(argv[0],"Widget (arg 1) must have a display");

    /* no need to assign  << localVar2 = argv[2] >>  */ 

     argc -= 3;
     setCursor(localVar1,argv[2],argc,&argv[3]);

     DBUG_RETURN (TCL_OK);
     }



void
wafeInitialize_PIXMAP()
{
 qbusyWindow = WafePermStringToQuark("busyWindow");
 qiconPixmap = WafePermStringToQuark("iconPixmap");
 qxpmList = WafePermStringToQuark("xpmList");
 qPixmap = WafePermStringToQuark(XtRPixmap);
 qBitmap = WafePermStringToQuark(XtRBitmap);
 busyWindowDefaultCursorName = XtNewString("watch");
 cursorCacheSize = -1;
 wafeCreateTclCmds(pkgs,wccs,cmds);
}
