/* Copyright (C) 1992 by Gustaf Neumann, Stefan Nusser

 *      Wirtschaftsuniversitaet Wien, 
 *      Abteilung fuer Wirtschaftsinformatik
 *      Augasse 2-6, 
 *      A-1090 Vienna, Austria
 *      neumann@wu-wien.ac.at, nusser@wu-wien.ac.at

 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in all supporting
 * documentation.  This software is provided "as is" without expressed or
 * implied warranty.

 * Creation: Sun Dec 18 22:17:05 EST 1994 on mohegan
 * Author: genc
 * Version: 1.0.6


 */
#define XBAE_C
#include <wafe.h>
#ifdef XBAE
/* 
 * ******* begin required file <Xbae.inc> *******
 */

/* make emcas happy -*-C-*-  make emacs happy */
#include <Xbae/Matrix.h>

extern int wafeModifyVerifyCBset(
#if NeedFunctionPrototypes
   Boolean, int, int, int, String
#endif
);

static int
wafeMatrixEnterCellCBset(doit)
Boolean doit;
    {
    XbaeMatrixEnterCellCallbackStruct *cbs = 
	(XbaeMatrixEnterCellCallbackStruct *)wafeCurrentCallData;
    DBUG_ENTER("wafeMatrixEnterCellCBset");
    if (!cbs || cbs->reason !=  XbaeEnterCellReason) 
	DBUG_RETURN(wafeSetError("calling wafeMatrixEnterCellCBset is only valid from a enterCellCallback",NULL,NULL,NULL));
    cbs->doit = doit;
    DBUG_RETURN(TCL_OK);
    }

static int
wafeMatrixLeaveCellCBset(doit)
Boolean doit;
    {
    XbaeMatrixLeaveCellCallbackStruct *cbs = 
	(XbaeMatrixLeaveCellCallbackStruct *)wafeCurrentCallData;
    DBUG_ENTER("wafeMatrixLeaveCellCBset");
    if (!cbs || cbs->reason !=  XbaeLeaveCellReason) 
	DBUG_RETURN(wafeSetError("calling wafeMatrixLeaveCellCBset is only valid from a LeaveCellCallback",NULL,NULL,NULL));
    cbs->doit = doit;
    DBUG_RETURN(TCL_OK);
    }

static int
wafeMatrixTraverseCellCBset(nextRow,nextCol)
int nextRow;
int nextCol;
    {
    XbaeMatrixTraverseCellCallbackStruct *cbs = 
	(XbaeMatrixTraverseCellCallbackStruct *)wafeCurrentCallData;
    DBUG_ENTER("wafeMatrixTraverseCellCBset");
    if (!cbs || cbs->reason !=  XbaeTraverseCellReason) 
	DBUG_RETURN(wafeSetError("calling wafeMatrixTraverseCellCBset is only valid from a traverseCellCallback",NULL,NULL,NULL));
    cbs->next_row    = nextRow;
    cbs->next_column = nextCol;
    DBUG_RETURN(TCL_OK);
    }

static int
wafeMatrixModifyVerifyCBset(doit, currInsert, startPos, endPos, string)
Boolean doit;
long currInsert, startPos, endPos;
String string;
    {
    XbaeMatrixModifyVerifyCallbackStruct *cbs = 
	(XbaeMatrixModifyVerifyCallbackStruct *)wafeCurrentCallData;
    XtPointer saveCallData;
    
    DBUG_ENTER("wafeModifyVerifyCBset");
    if (!cbs || cbs->reason !=  XbaeModifyVerifyReason) 
	DBUG_RETURN(wafeSetError("calling wafeModifyVerifyCBset is only valid from a ModifyVerifyCallback",NULL,NULL,NULL));

    saveCallData = wafeCurrentCallData;
    wafeCurrentCallData = (XtPointer) cbs->verify;
    wafeModifyVerifyCBset(doit, currInsert, startPos, endPos, string);
    wafeCurrentCallData = saveCallData;

    DBUG_RETURN(TCL_OK);
    }



/* 
 * ******* end required file <Xbae.inc> *******
 */
#include <Xbae/Caption.h>
#include <Xbae/Matrix.h>
/* 
 * void
 * XbaeMatrixAddColumns vulgo XbaeMatrixAddEmptyColumns
 *         in: XbaeMatrixWidget          # Xbae Matrix Widget
 *         in: int                       # position
 *         const: NULL                   # columns
 *         const: NULL                   # labels
 *         const: NULL                   # widths
 *         const: NULL                   # max_lengths
 *         const: NULL                   # alignments
 *         const: NULL                   # label alignments
 *         const: NULL                   # colors
 *         in: int                       # number of columns to be insterted
 */

static int 
cmd_XbaeMatrixAddEmptyColumns(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xbaeMatrixWidgetClass,"XbaeMatrix")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XbaeMatrixWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%d", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%d", &localVar3)))
         {
         wafeConvError(argc, argv, 10 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     XbaeMatrixAddColumns(localVar1,localVar2,NULL,NULL,NULL,NULL,NULL,NULL,NULL,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XbaeMatrixAddRows vulgo XbaeMatrixAddEmptyRows
 *         in: XbaeMatrixWidget          # Xbae Matrix Widget
 *         in: int                       # position
 *         const: NULL                   # rows
 *         const: NULL                   # labels
 *         const: NULL                   # pixels
 *         in: int                       # number of rows to be insterted
 */

static int 
cmd_XbaeMatrixAddEmptyRows(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xbaeMatrixWidgetClass,"XbaeMatrix")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XbaeMatrixWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%d", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%d", &localVar3)))
         {
         wafeConvError(argc, argv, 6 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     XbaeMatrixAddRows(localVar1,localVar2,NULL,NULL,NULL,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XbaeMatrixCancelEdit
 *         in: XbaeMatrixWidget          # Xbae Matrix Widget
 *         in: Boolean                   # umap after canel?
 */

static int 
cmd_XbaeMatrixCancelEdit(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xbaeMatrixWidgetClass,"XbaeMatrix")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XbaeMatrixWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "Boolean");
         DBUG_RETURN (TCL_ERROR);
         }

     XbaeMatrixCancelEdit(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XbaeMatrixCommitEdit
 *         in: XbaeMatrixWidget          # Xbae Matrix Widget
 *         in: Boolean                   # umap after canel?
 */

static int 
cmd_XbaeMatrixCommitEdit(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     Boolean localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xbaeMatrixWidgetClass,"XbaeMatrix")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XbaeMatrixWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(wafeGetBoolean(argv[2],&localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "Boolean");
         DBUG_RETURN (TCL_ERROR);
         }

     XbaeMatrixCommitEdit(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XbaeMatrixDeleteColumns
 *         in: XbaeMatrixWidget          # Xbae Matrix Widget
 *         in: int                       # position
 *         in: int                       # number of columns to be deleted
 */

static int 
cmd_XbaeMatrixDeleteColumns(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xbaeMatrixWidgetClass,"XbaeMatrix")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XbaeMatrixWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%d", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%d", &localVar3)))
         {
         wafeConvError(argc, argv, 3 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     XbaeMatrixDeleteColumns(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XbaeMatrixDeleteRows
 *         in: XbaeMatrixWidget          # Xbae Matrix Widget
 *         in: int                       # position
 *         in: int                       # number of rows to be deleted
 */

static int 
cmd_XbaeMatrixDeleteRows(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xbaeMatrixWidgetClass,"XbaeMatrix")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XbaeMatrixWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%d", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%d", &localVar3)))
         {
         wafeConvError(argc, argv, 3 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     XbaeMatrixDeleteRows(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XbaeMatrixDeselectAll
 *         in: XbaeMatrixWidget          # Xbae Matrix Widget
 */

static int 
cmd_XbaeMatrixDeselectAll(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xbaeMatrixWidgetClass,"XbaeMatrix")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XbaeMatrixWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     XbaeMatrixDeselectAll(localVar1);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XbaeMatrixDeselectColumn
 *         in: XbaeMatrixWidget          # Xbae Matrix Widget
 *         in: int                       # column
 */

static int 
cmd_XbaeMatrixDeselectColumn(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xbaeMatrixWidgetClass,"XbaeMatrix")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XbaeMatrixWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%d", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     XbaeMatrixDeselectColumn(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XbaeMatrixDeselectCell
 *         in: XbaeMatrixWidget          # Xbae Matrix Widget
 *         in: int                       # row
 *         in: int                       # column
 */

static int 
cmd_XbaeMatrixDeselectCell(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xbaeMatrixWidgetClass,"XbaeMatrix")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XbaeMatrixWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%d", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%d", &localVar3)))
         {
         wafeConvError(argc, argv, 3 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     XbaeMatrixDeselectCell(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XbaeMatrixDeselectRow
 *         in: XbaeMatrixWidget          # Xbae Matrix Widget
 *         in: int                       # row
 */

static int 
cmd_XbaeMatrixDeselectRow(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xbaeMatrixWidgetClass,"XbaeMatrix")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XbaeMatrixWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%d", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     XbaeMatrixDeselectRow(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XbaeMatrixEditCell
 *         in: XbaeMatrixWidget          # Xbae Matrix Widget
 *         in: int                       # row
 *         in: int                       # column
 */

static int 
cmd_XbaeMatrixEditCell(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xbaeMatrixWidgetClass,"XbaeMatrix")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XbaeMatrixWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%d", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%d", &localVar3)))
         {
         wafeConvError(argc, argv, 3 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     XbaeMatrixEditCell(localVar1,localVar2,localVar3);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * String
 * XbaeMatrixGetCell
 *         in: XbaeMatrixWidget          # Xbae Matrix Widget
 *         in: int                       # row
 *         in: int                       # column
 */

static int 
cmd_XbaeMatrixGetCell(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;
     String returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 4) 
	 {
	 wafeArgcError(argc,argv,"",3);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xbaeMatrixWidgetClass,"XbaeMatrix")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XbaeMatrixWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%d", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%d", &localVar3)))
         {
         wafeConvError(argc, argv, 3 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = XbaeMatrixGetCell(localVar1,localVar2,localVar3);

     Tcl_SetResult(comInterpreter, returnVar, TCL_STATIC);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XbaeMatrixSelectRow
 *         in: XbaeMatrixWidget          # Xbae Matrix Widget
 *         in: int                       # row
 */

static int 
cmd_XbaeMatrixSelectRow(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xbaeMatrixWidgetClass,"XbaeMatrix")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XbaeMatrixWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%d", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     XbaeMatrixSelectRow(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XbaeMatrixSelectColumn
 *         in: XbaeMatrixWidget          # Xbae Matrix Widget
 *         in: int                       # column
 */

static int 
cmd_XbaeMatrixSelectColumn(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xbaeMatrixWidgetClass,"XbaeMatrix")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XbaeMatrixWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%d", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     XbaeMatrixSelectColumn(localVar1,localVar2);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XbaeMatrixSetCell
 *         in: XbaeMatrixWidget          # Xbae Matrix Widget
 *         in: int                       # row
 *         in: int                       # column
 *         in: String                    # value
 */

static int 
cmd_XbaeMatrixSetCell(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;

     DBUG_ENTER(argv[0]);  

     if (argc != 5) 
	 {
	 wafeArgcError(argc,argv,"",4);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xbaeMatrixWidgetClass,"XbaeMatrix")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XbaeMatrixWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%d", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%d", &localVar3)))
         {
         wafeConvError(argc, argv, 3 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar4 = argv[4] >>  */ 

     XbaeMatrixSetCell(localVar1,localVar2,localVar3,argv[4]);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * void
 * XbaeMatrixSetCellColor
 *         in: XbaeMatrixWidget          # Xbae Matrix Widget
 *         in: int                       # row
 *         in: int                       # column
 *         in: Pixel                     # value
 */

static int 
cmd_XbaeMatrixSetCellColor(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Widget localVar1;
     int localVar2;
     int localVar3;
     Pixel localVar4;

     DBUG_ENTER(argv[0]);  

     if (argc != 5) 
	 {
	 wafeArgcError(argc,argv,"",4);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar1 =  name2WidgetOfClass(argv[1],xbaeMatrixWidgetClass,"XbaeMatrix")))
         {
         wafeConvError(argc, argv, 1 ,NULL, "XbaeMatrixWidget");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%d", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%d", &localVar3)))
         {
         wafeConvError(argc, argv, 3 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(localVar4 = (Pixel) wafeCvtStringToPixel(localVar1,argv[4])))
         {
         wafeConvError(argc, argv, 4 ,NULL, "Pixel");
         DBUG_RETURN (TCL_ERROR);
         }

     XbaeMatrixSetCellColor(localVar1,localVar2,localVar3,localVar4);

     DBUG_RETURN (TCL_OK);
     }     


/* 
 * TCL_RETURN_CODE
 * wafeMatrixEnterCellCBset vulgo XbaeEnterCellCBset
 *         in: Boolean     	      # doit
 */

static int 
cmd_XbaeEnterCellCBset(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Boolean localVar1;
     TCL_RETURN_CODE returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(wafeGetBoolean(argv[1],&localVar1)))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Boolean");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = wafeMatrixEnterCellCBset(localVar1);

     DBUG_RETURN (returnVar);
     }     


/* 
 * TCL_RETURN_CODE
 * wafeMatrixLeaveCellCBset vulgo XbaeLeaveCellCBset
 *         in: Boolean     	      # doit
 */

static int 
cmd_XbaeLeaveCellCBset(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Boolean localVar1;
     TCL_RETURN_CODE returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 2) 
	 {
	 wafeArgcError(argc,argv,"",1);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(wafeGetBoolean(argv[1],&localVar1)))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Boolean");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = wafeMatrixLeaveCellCBset(localVar1);

     DBUG_RETURN (returnVar);
     }     


/* 
 * TCL_RETURN_CODE
 * wafeMatrixTraverseCellCBset vulgo XbaeTraverseCellCBset
 *         in: int     		      # next row
 *         in: int     		      # next column
 */

static int 
cmd_XbaeTraverseCellCBset(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     int localVar1;
     int localVar2;
     TCL_RETURN_CODE returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 3) 
	 {
	 wafeArgcError(argc,argv,"",2);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[1], "%d", &localVar1)))
         {
         wafeConvError(argc, argv, 1 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%d", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "int");
         DBUG_RETURN (TCL_ERROR);
         }

     returnVar = wafeMatrixTraverseCellCBset(localVar1,localVar2);

     DBUG_RETURN (returnVar);
     }     


/* 
 * TCL_RETURN_CODE
 * wafeMatrixModifyVerifyCBset vulgo XbaeModifyVerifyCBset
 *         in: Boolean     		# doit
 *         in: long        		# currInsert or -1
 *         in: long        		# startPos or -1
 *         in: long        		# endPos or -1
 *         in: String        		# String

 */

static int 
cmd_XbaeModifyVerifyCBset(clientData, comInterpreter, argc, argv)
ClientData    clientData;
Tcl_Interp   *comInterpreter;
int           argc;
char        **argv;
     {
     Boolean localVar1;
     long localVar2;
     long localVar3;
     long localVar4;
     TCL_RETURN_CODE returnVar;

     DBUG_ENTER(argv[0]);  

     if (argc != 6) 
	 {
	 wafeArgcError(argc,argv,"",5);
	 DBUG_RETURN (TCL_ERROR);
         }

     if (!(wafeGetBoolean(argv[1],&localVar1)))
         {
         wafeConvError(argc, argv, 1 ,NULL, "Boolean");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[2], "%ld", &localVar2)))
         {
         wafeConvError(argc, argv, 2 ,NULL, "long");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[3], "%ld", &localVar3)))
         {
         wafeConvError(argc, argv, 3 ,NULL, "long");
         DBUG_RETURN (TCL_ERROR);
         }

     if (!(sscanf(argv[4], "%ld", &localVar4)))
         {
         wafeConvError(argc, argv, 4 ,NULL, "long");
         DBUG_RETURN (TCL_ERROR);
         }

    /* no need to assign  << localVar5 = argv[5] >>  */ 

     returnVar = wafeMatrixModifyVerifyCBset(localVar1,localVar2,localVar3,localVar4,argv[5]);

     DBUG_RETURN (returnVar);
     }     


#endif  /* of ifdef XBAE */

void
wafeInitialize_XBAE()
{
#ifdef XBAE
 wafeCreateWidgetCommand("XbaeCaption",xbaeCaptionWidgetClass,NULL,False);
 wafeCreateWidgetCommand("XbaeMatrix",xbaeMatrixWidgetClass,NULL,False);
#ifdef XBAE
 Tcl_SetVar(wafeInterpreter,"PACKAGES","XBAE",TCL_GLOBAL_ONLY|TCL_APPEND_VALUE|TCL_LIST_ELEMENT);
#endif
 Tcl_CreateCommand(wafeInterpreter, "XbaeMatrixAddEmptyColumns", cmd_XbaeMatrixAddEmptyColumns, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XbaeMatrixAddEmptyRows", cmd_XbaeMatrixAddEmptyRows, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XbaeMatrixCancelEdit", cmd_XbaeMatrixCancelEdit, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XbaeMatrixCommitEdit", cmd_XbaeMatrixCommitEdit, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XbaeMatrixDeleteColumns", cmd_XbaeMatrixDeleteColumns, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XbaeMatrixDeleteRows", cmd_XbaeMatrixDeleteRows, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XbaeMatrixDeselectAll", cmd_XbaeMatrixDeselectAll, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XbaeMatrixDeselectColumn", cmd_XbaeMatrixDeselectColumn, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XbaeMatrixDeselectCell", cmd_XbaeMatrixDeselectCell, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XbaeMatrixDeselectRow", cmd_XbaeMatrixDeselectRow, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XbaeMatrixEditCell", cmd_XbaeMatrixEditCell, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XbaeMatrixGetCell", cmd_XbaeMatrixGetCell, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XbaeMatrixSelectRow", cmd_XbaeMatrixSelectRow, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XbaeMatrixSelectColumn", cmd_XbaeMatrixSelectColumn, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XbaeMatrixSetCell", cmd_XbaeMatrixSetCell, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XbaeMatrixSetCellColor", cmd_XbaeMatrixSetCellColor, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XbaeEnterCellCBset", cmd_XbaeEnterCellCBset, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XbaeLeaveCellCBset", cmd_XbaeLeaveCellCBset, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XbaeTraverseCellCBset", cmd_XbaeTraverseCellCBset, NULL, NULL);
 Tcl_CreateCommand(wafeInterpreter, "XbaeModifyVerifyCBset", cmd_XbaeModifyVerifyCBset, NULL, NULL);

#else
#endif /* of ifdef XBAE */
}
