#> The XmGraph Widget requires Motif 1.1 or newer.

$PACKAGE = "XMGRAPH";

~handles 
	XMGRAPH

#include <stdio.h>
#include <X11/StringDefs.h>
#define ARC(w) (XmArcWidget)(w)

~widgetClass
XmArc
	include <Graph.h>
	include <Arc.h>
	arcEdited f WidgetID: \
	    (WidgetID)((XmGraphCallbackStruct *)callData)->old_from # old from
	arcEdited t WidgetID: \
	    (WidgetID)((XmGraphCallbackStruct *)callData)->old_to # old to
	arcEdited F WidgetID: \
	    (WidgetID)((XmGraphCallbackStruct *)callData)->new_from # new from
	arcEdited T WidgetID: \
	    (WidgetID)((XmGraphCallbackStruct *)callData)->new_to # new to

void
XmArcGetPos
	in: ARC(XmArcWidget)			# name of arc Widget
	out: Position				# out: x1
	out: Position				# out: y1
	out: Position				# out: x2
	out: Position				# out: y2

~widgetClass
XmGraph
	include <Graph.h>
	newArc|newNode|arcMoved|nodeMoved|defaultAction|selectNode|selectArc|deselect|selectSubgraph N WidgetList: \
		((XmGraphCallbackStruct *)callData)->num_selected_widgets, \
		((XmGraphCallbackStruct *)callData)->selected_widgets \
			 # selected Nodes
	newArc|newNode|arcMoved|nodeMoved|defaultAction|selectNode|selectArc|deselect|selectSubgraph A WidgetList: \
		((XmGraphCallbackStruct *)callData)->num_selected_arcs, \
		((XmGraphCallbackStruct *)callData)->selected_arcs \
			 # selected Arcs
	newArc|newNode|arcMoved|defaultAction|selectNode|selectArc|deselect|selectSubgraph I WidgetID: \
		(WidgetID)((XmGraphCallbackStruct *)callData)->widget \
			 # child widgetID
	arcMoved f WidgetID: \
		(WidgetID)((XmGraphCallbackStruct *)callData)->old_from # old from
	arcMoved t WidgetID: \
		(WidgetID)((XmGraphCallbackStruct *)callData)->old_to # old to
	arcMoved F WidgetID: \
		(WidgetID)((XmGraphCallbackStruct *)callData)->new_from # new from
	arcMoved T WidgetID: \
		(WidgetID)((XmGraphCallbackStruct *)callData)->new_to # new to


~pseudoWidgetClass
XmScrolledGraph
	className XmGraph
	createCmd XmCreateScrolledGraph

void
XmGraphInsertRoots
	in: XmGraphWidget   # XmGraphWidget
	in: [Widget]        # List of Widgets
        const: argc-2