/* treat me like a -*- c -*- program */

#include "wafe_quarks.h"

#define MAX_ITEM_LENGTH 200
/* KLUDGE KLUDGE KLUDGE for callbacks provided via resource mechanisms */
#define setQuark(resName,quark) \
    XtVaGetValues(newWidget, (resName), &callbackList, NULL); \
    if (callbackList && \
	callbackList->callback == (XtCallbackProc)wafeExecCallbackProc) \
	*(XrmQuark *)callbackList->closure = (quark)

/****************************************************************************
 *    FUNCTION:  name2Sink, name2Source
 *                                                                          
 *    Arguments: string containing an instance's name
 *    Returns:   source/sink widget of named text widget
 *                                                                          
 *****************************************************************************/

static Widget 
name2Sink(string)
char * string;
    {
    Widget localVar1, sink = NULL;

    if (!(localVar1 = name2Widget(string)))
	{
	wafeConvWarn("name2Sink",string,"Widget");
	return(NULL);
	}

    XtVaGetValues(localVar1, XtNtextSink, &sink, NULL);
    return(sink);
    }

/************** list widget support routines ******/
#include <X11/Xaw/List.h>

static int
listChange(w, nitems, longest, resize, argc, argv)
Widget     w;
int        nitems;
int        longest;
int        resize;
int           argc;
char        **argv;
    {
    FILE    *fp;
    int      i, size=0;
    char   **list, **count, *offset;
    char     buffer [MAX_ITEM_LENGTH];
    char    *procName = "listChange";
    
    DBUG_ENTER(procName);
    
    if (!strcmp(argv[0], "List"))
	{
	  if (argc != 2)
	      {
	      wafeWarn(procName, "wrong number of arguments",
		       NULL,NULL,NULL);
	      DBUG_RETURN(TCL_ERROR);
	      }

	  if (Tcl_SplitList(wafeInterpreter,argv[1], &nitems, &list) != TCL_OK)
	      {
	      wafeWarn(procName, wafeInterpreter->result,
		       NULL,NULL,NULL);
	      DBUG_RETURN(TCL_ERROR);
	      }
	  }
    else 
    if (!strcmp(argv[0], "Arg"))
	{
        for (i = 1; i < argc; i++) 
	    size += strlen(argv[i])+1;
	
	list = count = (char **)XtMalloc((argc)*sizeof(char *)+size); 
	offset = (char *)list + (argc)*sizeof(char *);

	for (i = 1; i < argc; i++)
	    {
	    *count = offset;
	    strcpy(offset,argv[i]);
	    offset += strlen(argv[i])+1;
	    count++;
	    }

	*count = NULL;
	}
    else
    if (!strcmp(argv[0], "File"))
	{
	char **tmpList, **saveStart;

	if (argc != 2)
	    {
	    wafeWarn(procName, "wrong number of arguments",
		       NULL,NULL,NULL);
	    DBUG_RETURN(TCL_ERROR);
	    }

	if (!(fp = fopen(argv[1], "r")))
	    {
	    wafeWarn(procName, "Couldn't open File %s",
		       argv[1],NULL,NULL);
	    DBUG_RETURN(TCL_ERROR);
	    }

	saveStart = tmpList = count = (char **)XtMalloc(10*sizeof(char *));
	i = 0;

	while (fgets(buffer, 200, fp))
	    {
	    *count = XtNewString(buffer);
	    size += strlen(buffer)+1;
	    *(*count + strlen(buffer)-1) = '\0';
	    count++; i++;
	    if (!(i % 10))
		{
		DBUG_PRINT("list", ("Realloc"));
		saveStart = tmpList = (char**)XtRealloc((char *)tmpList,
						(i + 10)* sizeof(char *));
		count = tmpList + i;
		}
	    }
	*count = NULL;

	/* make it the list a single memory chunk to be 
         * compatible with the rest 
         */
	list = count = (char **)XtMalloc((i+1)*sizeof(char *)+size); 
	offset = (char *)list + (i+1)*sizeof(char *);

	while (*tmpList)
	    {
	    *count = offset;
	    strcpy(offset,*tmpList);
	    offset += strlen(*tmpList)+1;
	    XtFree(*tmpList);
	    tmpList++;
	    count++;
	    }
	*count = NULL;

        XtFree((char*)saveStart);
	}

    XawListChange(w, list, nitems, longest, resize);
    wafeMMreplace(wafeMMgetAttribList(w,True), qPointer, (char *)list,XtFree);

    DBUG_RETURN(TCL_OK);
    }

  
static void
listAppend(list, argc, argv)
Widget        list;
int           argc;
char        **argv;
    {
    char   **srcPtr, **trgtPtr;
    char   **newArray, **oldArray;
    int      nitems = 0;
    int      count;
    Boolean  resize;
    DBUG_ENTER("listAppend");
 
    XtVaGetValues(list, XtNlist, &oldArray, NULL);
    XtVaGetValues(list, XtNresize, &resize, NULL);
     
    for (srcPtr = oldArray; *srcPtr != NULL; srcPtr++)
	{
	nitems++;
	DBUG_PRINT("list", ("Checking %d", nitems));
	}

    newArray = (char **)XtMalloc((nitems * sizeof(char*)) + argc + 1);

    for(srcPtr = oldArray, trgtPtr = newArray; 
	*srcPtr != NULL; 
	srcPtr++, trgtPtr++)
	{          
	*trgtPtr = XtNewString(*srcPtr);
	DBUG_PRINT("list", ("Copied: <%s>", *trgtPtr));
	XtFree(*srcPtr);
	}

    XtFree((char *)oldArray);

    for (count = 0; count < argc; count++)
	{
	*trgtPtr = XtNewString(argv[count]);
	DBUG_PRINT("list", ("Added: <%s>", *trgtPtr));
	trgtPtr++;
	}

    *trgtPtr = NULL;

    XawListChange(list, newArray, 0, 0, resize);
    }


static Widget
listCreate(parent, name, args, numArgs)
Widget   parent;
char     *name;
ArgList  args;
Cardinal numArgs;
    {
    XtCallbackList callbackList = NULL;
    Widget newWidget = XtCreateWidget(name, listWidgetClass, 
				      parent, args, numArgs);
    setQuark("callback",qcallback);
    return(newWidget);
    }

/******************** strip chart specific code ***************/
#include <X11/Xaw/StripChart.h>

typedef struct _scInfo
     {
     double            value;
     Widget            widget;
     struct _scInfo   *next;
     } scInfo, *scInfoPtr;

static scInfoPtr scBegin = NULL;

static void 
stripChartSet(sCWidget, value)
Widget  sCWidget;
double  value;
     {
     scInfoPtr   countPtr;

     if (!scBegin)         /* No Stripchart widgets exists yet*/
          {
	  wafeWarn("scSet", "No stripChart widget exists yet",
		   NULL,NULL,NULL);
          return;
          }

     for (countPtr = scBegin; 
          countPtr->widget != sCWidget && countPtr->next != NULL;
          countPtr = countPtr->next);

     if ((countPtr->next == NULL) && countPtr->widget != sCWidget)
          {
	  wafeWarn("scSet", "stripChart widget %s unknown", 
		   XtName(sCWidget),NULL,NULL);
          return;
          }

     DBUG_PRINT("sc",("Setting = '%s' to %f", XtName(countPtr->widget),value));

     countPtr->value = value;
     }


static void
scQueryProc(w, clientData, value)
Widget    w;
XtPointer clientData;
XtPointer value;
     {
     scInfoPtr   countPtr;

     DBUG_ENTER("Query");

     for (countPtr = scBegin; countPtr->widget != w;
          countPtr = countPtr->next);

     DBUG_PRINT("sc",("Name = '%s', value = %f", 
		      XtName(countPtr->widget), countPtr->value));
/*
      fprintf(stderr,"float = %f\n",countPtr->value);
 */
     *((double*)value) = countPtr->value;

     DBUG_VOID_RETURN;
     }

static Widget
stripChartCreate(parent, name, args, numArgs)
Widget   parent;
char     *name;
ArgList  args;
Cardinal numArgs;
    {
    Widget newWidget;
    
    scInfoPtr  countPtr = (scInfoPtr)XtNew(scInfo);
    countPtr->next   = scBegin;
    countPtr->value  = 0.0;  /* default value */
    countPtr->widget = 
      newWidget = 
	XtCreateWidget(name, stripChartWidgetClass, parent, args, numArgs);
    scBegin = countPtr;
    XtAddCallback(newWidget, "getValue", scQueryProc, NULL);  

    return(newWidget);
    }


/************** scrollbar widget support routines ******/
#include <X11/Xaw/Scrollbar.h>

static Widget
scrollbarCreate(parent, name, args, numArgs)
Widget   parent;
char     *name;
ArgList  args;
Cardinal numArgs;
    {
    XtCallbackList callbackList = NULL;
    Widget newWidget = XtCreateWidget(name, scrollbarWidgetClass, 
				      parent, args, numArgs);
    setQuark("jumpProc",qjumpProc);
    setQuark("scrollProc",qscrollProc);
    return(newWidget);
    }

#include <X11/Xaw/AsciiText.h>

static Boolean
CvtEditTypeToString(dpy, args, num_args, fromVal, toVal, converterData)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converterData;
    {
    if ((XawTextEditType)fromVal->addr == XawtextEdit) 
	{
	toVal->addr = XtNewString("edit");
	toVal->size = 5;
	} 
    else if ((XawTextEditType)fromVal->addr == XawtextRead) 
	{
	toVal->addr = XtNewString("read");
	toVal->size = 5;
	} 
    else if ((XawTextEditType)fromVal->addr == XawtextAppend) 
	{
	toVal->addr = XtNewString("append");
	toVal->size = 7;
	}
    else 
	return False;
    
    return True;
    }

static Boolean
CvtAsciiTypeToString(dpy, args, num_args, fromVal, toVal, converterData)
Display   *dpy;
XrmValue  *args;
Cardinal  *num_args;
XrmValue  *fromVal;
XrmValue  *toVal;
XtPointer *converterData;
    {
    if ((XawAsciiType)fromVal->addr == XawAsciiFile) 
	{
	toVal->addr = XtNewString("file");
	toVal->size = 5;
	} 
    else if ((XawAsciiType)fromVal->addr == XawAsciiString) 
	{
	toVal->addr = XtNewString("string");
	toVal->size = 7;
	} 
    else 
	return False;
    
    return True;
    }



