# emulation of commands available in motif 1.2 but not available in 
# motif 1.1.

proc XmTextFindString {w start string direction pos} {
  upvar $pos returnPos
  switch $direction {
    TEXT_FORWARD {
      set content [string range [gV $w value] $start end]
      set returnPos [string first $string $content]
    }
    TEXT_BACKWARD {
      set content [string range [gV $w value] 0 $start]
      set returnPos [string last $string $content]
    }
  }
  if {$returnPos != -1} {
    incr returnPos $start
    return 1
  } else {
    return 0
  }
}
