#! ../mofe --f
set n 0
scriptNeeds AtPlotter "This Script needs the Plotter Widget Set!"

proc data {count} {
    if {$count<1} {return}

    global n
    for {set i 1} {$i<11} {incr i} {
	append data1 "$i/[expr 10+sin($i+$n)*$i] "
	append data2 "$i/[expr 10+cos($i-$n)*$i] "
	append data3 "[expr 10+sin($i+$n)*$i] "
	append data4 "[expr 10+cos($i-$n)*$i] "
    }
    eval AtXYLinePlotAttachData lp1 $data1
    eval AtXYLinePlotAttachData lp2 $data2
    eval AtBarPlotAttachData    b1 $data3
    eval AtBarPlotAttachData    b2 $data4
    set n [expr $n+0.5]
    addTimeOut 100 "data [expr $count-1]"
}

if ![isWidget f] {
  mergeResources topLevel {
    *XmPushButton.background gray80
    *leftAttachment ATTACH_WIDGET 
    *topAttachment ATTACH_WIDGET 
  }
  XmForm f topLevel background gray50

  # first graph    
  AtPlotter p1 f {
    height 200 width 300 title "XY Line Plot Example" usePixmap true
    background gray70 plotAreaColor gray90 showLegend false
  }
  AtXYAxis x p1               autoScale false min 0.5 max 10  drawGrid false
  AtXYAxis y p1 vertical true autoScale false min 0 max 19    drawGrid false
  sV p1 xAxis x yAxis y
  AtXYLinePlot lp1 p1 plotLineType lineimpulses
  AtXYLinePlot lp2 p1 plotLineType lineimpulses foreground red

  # buttons
  XmPushButton quit f topWidget p1 activateCallback %w
  XmPushButton go   f topWidget p1 leftWidget quit activateCallback "data 200"
#  XmPushButton source f topWidget p1 leftWidget go activateCallback "source m-xy.tcl"

  # second graph    
  AtPlotter p2 f {
    height 200 width 300 title "Some Demo" usePixmap true
    background gray70 plotAreaColor gray90 showLegend false
    leftWidget p1
  }
  AtAxis x2 p2 \
    drawSubgrid false numbersOutside true autoScale false min 0 max 13 
  AtAxis y2 p2 vertical true drawSubgrid false drawFrame true
  sV p2 xAxis x2 yAxis y2
  
  AtBarPlot b1 p2 fillColor yellow cellOffset -0.4 cellWidth 0.5 shading gray5
  AtBarPlot b2 p2 fillColor green  cellOffset -0.15 cellWidth 0.5 shading gray3
    
  data 1
  realize
}
