# ./mofe --f

set buildingBlocks {
    labeledField
    title
    personEntry
}


set labeledField {
    {glue 5}
    {widget label label}
    {glue 5}
    {widget asciiText text stretch}
    {glue 5}
}

set title {
    {glue 5}
    {widget label title}
    {glue 5 stretch}

}

set personEntry {
    {box title head}
    {glue 5}
    {box labeledField ssn}
    {glue 5}
    {box labeledField familyName}
    {glue 5}
}


proc makeLayout {
    layoutWidget
    buildingBlock 
    {prefix ""} 
    {direction "vertical"}
} {
    global nextDirection treeOrientation
    set layout ""
    set widgets {}
    set struct  {}
    foreach unit $buildingBlock {
	set type [lindex $unit 0]
	case $type in {
	    box {
		upvar #0 [lindex $unit 1] boxType
		set boxName $prefix[lindex $unit 2]_ 
		set boxParent [expr {$prefix=={} ? "root" : $prefix}]
		set treeParent [expr {$prefix=={} ? "" : "treeParent L$boxParent"}]
		append struct "tree $boxName $boxParent $treeParent $treeOrientation($direction)\n"
		append struct "label L$boxName $boxName label {[lindex $unit 1]: [lindex $unit 2]}\n"
		set result [makeLayout $layoutWidget $boxType $boxName \
			    $nextDirection($direction)]
		append layout "$direction{ [lindex $result 0] } "
		set w [lindex $result 1] 
		if {$w!={}} {
		    set widgets [concat $widgets $w] 
		    append struct [lindex $result 2]
		}
	    }
	    glue {
		set glueValue [lindex $unit 1]
		append layout "$glueValue "
		appendStretch $type layout [lrange $unit 2 end]
		append struct "command glue $prefix treeParent L$prefix label $glueValue\n"
	    }
	    widget {
		set widgetName $prefix[lindex $unit 2]
		set widgetClass [lindex $unit 1]
		append layout "$widgetName "
		appendStretch $type layout [lrange $unit 3 end]
		lappend widgets "$widgetName $widgetClass $layoutWidget"
		append struct "command widget $prefix label $widgetClass treeParent L$prefix\n"
	    }
	}
    }
#    puts stderr $layout
    return [llist $layout $widgets $struct]
}

proc showStruct {
    parent
    buildingBlock 
    {prefix ""} 
    {direction "vertical"}
} {
    global nextDirection treeOrientation
    foreach unit $buildingBlock {
	set type [lindex $unit 0]
	case $type in {
	    box {
		upvar #0 [lindex $unit 1] boxType
		set boxName $prefix[lindex $unit 2]_ 
		set boxParent [expr {$prefix=={} ? "root" : $prefix}]
		set treeParent [expr {$prefix=={} ? "" : "treeParent L$boxParent"}]
		tree $boxName $boxParent {
		    treeParent L$prefix
		    gravity $treeOrientation($direction)
		}
		puts stderr "showStruct $boxName \$[lindex $unit 1] $boxName $nextDirection($direction)"
		command L$boxName $boxName {
		    label "[lindex $unit 1]: [lindex $unit 2]" 
		    callback "showStruct $boxName \$[lindex $unit 1] $boxName $nextDirection($direction);treeForceLayout personEntry_"
		}
	    }
	    glue {
		set glueValue [lindex $unit 1]
		command glue $prefix {
		    treeParent L$prefix 
		    label $glueValue
		}
	    }
	    widget {
		set widgetClass [lindex $unit 1]
		command widget $prefix {
		    label $widgetClass 
		    treeParent L$prefix
		}
	    }
	}
    }
}


set stretchValue(glue,stretch)   "<+inf -100%>"
set stretchValue(widget,stretch) "<+inf -100% * +inf -100%>"

set nextDirection(vertical)      "horizontal"
set nextDirection(horizontal)    "vertical"

set boxOrientation(vertical)      "orientation VERTICAL"
set boxOrientation(horizontal)    "orientation HORIZONTAL"

set treeOrientation(vertical)      "west"
set treeOrientation(horizontal)    "north"

proc appendStretch {type varName varList} {
    global stretchValue
    upvar $varName name
    if {$varList=={}} { return }
    append name "$stretchValue($type,$varList) "
}

proc doLayout {name} {
    global layout widgets struct
    set result [makeLayout $name "{box $name $name}" ]
    set layout  [lindex $result 0]
    set widgets [lindex $result 1]
    set struct  [lindex $result 2]
    puts stderr "layout  = $layout\n\n"
    puts stderr "widgets = $widgets\n\n"
    puts stderr "struct  = $struct\n\n"
}


if ![isWidget commander] {
#    mergeResources topLevel "*XmRowColumn.borderWidth 9"
#    mBulletinBoard layoutStructure topLevel
    transientShell commander topLevel
    box b commander
    command c1 b label source callback {source aform2.tcl}
    command c2 b label doLayout callback {doLayout personEntry}
#    command c3 b label eval callback {eval $struct;popup t none}
    command c3 b label eval callback {showStruct root "{box personEntry personEntry}";popup t none}
    command c4 b label destroy callback {popdown t;destroyWidget personEntry_ }
    popup commander none
    transientShell t topLevel allowShellResize true
    box root t
}

