/***********************************************************
*
*  %W% %G%
*
*  BSBMnBt Widget ( Bitmap-String-Bitmap Menu Button )
*
*  Author(s):       Kevin J. Brock
*                   Symbolic Systems Resources Group
*		    Knowledge Systems Laboratory
*		    Departments of Computer Science and Medicine
*		    Stanford University
*		    Stanford, CA 94305
*
*  Date:            28 March, 1991
*
*  Copyright () 1991 by the Leland Stanford Junior University
*  
*  "This program may be distributed without restriction for non-commercial
*  use. Any sale or use of this program or adaptations thereof for commercial
*  purposes is prohibited except under license from the Stanford Office of
*  Technology Licensing."
*
***********************************************************/

/***********************************************************
 *
 * Bitmap-String-Bitmap MenuButton Widget
 *
 ***********************************************************/

/*
 * BSBMnBtP.h - Private Header file for Bitmap-String-Bitmap MenuButton
 *
 * This is the private header file for the Bitmap-String-Bitmap MenuButton.
 * It is a subclass of the Athena Widgets MenuButton which can display 
 * both left and right bitmaps with a string.
 */

#ifndef _XbBSBMnBtP_h
#define _XbBSBMnBtP_h

#include <X11/Xaw/MenuButtoP.h>
#include "BSBMnBt.h"

typedef struct _BSBMnBtClass 
{
    int empty;
} BSBMnBtClassPart;

/* Full class record declaration */

typedef struct _BSBMnBtClassRec 
{
    CoreClassPart	    core_class;
    SimpleClassPart	    simple_class;
    LabelClassPart	    label_class;
    CommandClassPart	    command_class;
    MenuButtonClassPart     menuButton_class;
    BSBMnBtClassPart        bsbMnBt_class;
} BSBMnBtClassRec;

extern BSBMnBtClassRec bsbMnBtClassRec;

typedef struct 
{
    /* private */
    int        inited;
    int        numParts;

    Dimension  lfWidth;
    Dimension  lfHeight;
    Dimension  lfDepth;

    Dimension  rtWidth;
    Dimension  rtHeight;
    Dimension  rtDepth;

    Dimension  lbWidth;
    Dimension  lbHeight;
    Dimension  lbLength;

    Dimension  totWidth;
    Dimension  totHeight;

    /* resources */
    Pixmap     rtBitmap;
    Pixmap     lfBitmap;

} BSBMnBtPart;

/* Full widget declaration */
typedef struct _BSBMnBtRec 
{
    CorePart         core;
    SimplePart	     simple;
    LabelPart	     label;
    CommandPart	     command;
    MenuButtonPart   menu_button;
    BSBMnBtPart      bsbMnBt;
} BSBMnBtRec;

#endif /* _XbBSBMnBtP_h */



