/***********************************************************
*
*
*  Author(s):       Kevin J. Brock
*                   Symbolic Systems Resources Group
*		    Knowledge Systems Laboratory
*		    Departments of Computer Science and Medicine
*		    Stanford University
*		    Stanford, CA 94305
*                   brock@sumex-aim.stanford.edu
*
*  Copyright () 1991 by the Leland Stanford Junior University
*  
*  "This program may be distributed without restriction for non-commercial
*  use. Any sale or use of this program or adaptations thereof for commercial
*  purposes is prohibited except under license from the Stanford Office of
*  Technology Licensing."
*
***********************************************************/
#include <stdio.h>
#include <string.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#include <X11/Xmu/Drawing.h>

#include <X11/Xaw/XawInit.h>
#include <X11/Xaw/SimpleMenu.h>
#include "SmeCascP.h"
#include <X11/Xaw/Cardinals.h>


#define ONE_HUNDRED 100

#define offset(field) XtOffset(SmeCascObject, field)
static XtResource resources[] = {
  {XtNmenuName, XtCMenuName, XtRString, sizeof(String), 
     offset(sme_casc.menu_name), XtRString, (caddr_t)"cascade_menu"},
  {XtNmenu, XtCMenu, XtRWidget, sizeof(Widget), 
     offset(sme_casc.menu), XtRWidget, (caddr_t) NULL},
};
#undef offset

/*
 * Semi Public function definitions. 
 */

static void Initialize();
static void ClassInitialize();
static Boolean SetValues();

/*  Classs methods */

static void Flip();
static void Notify();

/* 
 * Private Function Definitions.
 */

    
#define superclass (&smeBSBClassRec)
SmeCascClassRec smeCascClassRec = {
  {
    /* superclass         */    (WidgetClass) superclass,
    /* class_name         */    "SmeCasc",
    /* size               */    sizeof(SmeCascRec),
    /* class_initializer  */	ClassInitialize,
    /* class_part_initialize*/	NULL,
    /* Class init'ed      */	FALSE,
    /* initialize         */    Initialize,
    /* initialize_hook    */	NULL,
    /* realize            */    NULL,
    /* actions            */    NULL,
    /* num_actions        */    ZERO,
    /* resources          */    resources,
    /* resource_count     */	XtNumber(resources),
    /* xrm_class          */    NULLQUARK,
    /* compress_motion    */    FALSE, 
    /* compress_exposure  */    FALSE,
    /* compress_enterleave*/ 	FALSE,
    /* visible_interest   */    FALSE,
    /* destroy            */    NULL,
    /* resize             */    NULL,
    /* expose             */    XtInheritExpose,
    /* set_values         */    SetValues,
    /* set_values_hook    */	NULL,
    /* set_values_almost  */	XtInheritSetValuesAlmost,  
    /* get_values_hook    */	NULL,			
    /* accept_focus       */    NULL,
    /* intrinsics version */	XtVersion,
    /* callback offsets   */    NULL,
    /* tm_table		  */    NULL,
    /* query_geometry	  */    XtInheritQueryGeometry,
    /* display_accelerator*/    NULL,
    /* extension	  */    NULL
  },{
    /* Menu Entry Fields */
      
    /* highlight */             Flip,
    /* unhighlight */           Flip,
    /* notify */		Notify,		
    /* extension	  */    NULL
  }, {
    /* BSB Menu entry Fields */  

    /* extension	  */    NULL
  }
};

WidgetClass smeCascObjectClass = (WidgetClass) &smeCascClassRec;

/************************************************************
 *
 * Semi-Public Functions.
 *
 ************************************************************/

static void 
ClassInitialize()
{
    XawInitializeWidgetSet();

}

/*      Function Name: Initialize
 *      Description: Initializes the cascade menu widget
 *      Arguments: request - the widget requested by the argument list.
 *                 new     - the new widget with both resource and non
 *                           resource values.
 *      Returns: none.
 */

/* ARGSUSED */
static void
Initialize(request, new)
Widget request, new;
{
    SmeCascObject entry = (SmeCascObject) new;
    entry->sme_casc.popped = FALSE;
}

/*      Function Name: SetValues
 *      Description: Relayout the menu when one of the resources is changed.
 *      Arguments: current - current state of the widget.
 *                 request - what was requested.
 *                 new - what the widget will become.
 *      Returns: none
 */

/* ARGSUSED */
static Boolean
SetValues(current, request, new)
     Widget current, request, new;
{
 
  Boolean ret_val = TRUE;

  return(ret_val);
}

static void
Flip( w )
     Widget w;
{
  (*superclass->sme_class.highlight)(w);
}

static void
Notify(w)
     Widget w;
{
  SmeCascObject cascade = (SmeCascObject) w;
  Widget menu = cascade->sme_casc.menu;
  Arg arglist[2];
  Cardinal num_args;
  int menu_x, menu_y, menu_width, menu_height, button_width, button_height;
  Position button_x, button_y;

  if ( cascade->sme_casc.popped == FALSE )
    {
      if(menu == NULL)
	{
	  char error_buf[BUFSIZ];
	  sprintf(error_buf, "SmeCasc: %s.",
		  "No menu assigned to this widget...");
	  XtAppWarning(XtWidgetToApplicationContext(w), error_buf);
	  return;
	}
      menu_width = menu->core.width + 2 * menu->core.border_width;
      button_width = w->core.width + 2 * w->core.border_width;
      button_height = w->core.height + 2 * w->core.border_width;
      
      menu_height = menu->core.height + 2 * menu->core.border_width;
      
      XtTranslateCoords(w, 0, 0, &button_x, &button_y);
      menu_x = button_x + button_width*4/5;
      menu_y = button_y + button_height/2;
      
      if (menu_x < 0) 
	menu_x = 0;
      else {
	int scr_width = WidthOfScreen(XtScreen(menu));
	if (menu_x + menu_width > scr_width)
	  menu_x = scr_width - menu_width;
      }
      
      if (menu_y < 0)
	menu_y = 0;
      else {
	int scr_height = HeightOfScreen(XtScreen(menu));
	if (menu_y + menu_height > scr_height)
	  menu_y = scr_height - menu_height;
      }
      
      num_args = 0;
      XtSetArg(arglist[num_args], XtNx, menu_x); num_args++;
      XtSetArg(arglist[num_args], XtNy, menu_y); num_args++;
      XtSetValues(menu, arglist, num_args);
      
      if (!XtIsRealized(menu))
	XtRealizeWidget(menu);
      
      cascade->sme_casc.popped = TRUE;
      XtPopup(menu, XtGrabNone);
    }
  else
    {
      if (XtIsRealized( menu ))
	XtPopdown(menu);
      cascade->sme_casc.popped = FALSE;
    }
}
