; -*-Emacs-Lisp-*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; File:         mh-db.el
; RCS:          $Header: /users/darrylo/.repository/mh-e/mh-db.el,v 1.1 1998/05/11 19:47:11 darrylo Exp $
; Description:  Trivial database routines for mh-e.
;		This is used to save/restore certain mh-e variables without
;		having to parse/modify the user's .emacs file.
; Author:       Darryl Okahata
; Created:      Wed Jan 13 10:50:11 1993
; Modified:     Tue Jul 18 11:01:59 1995 (Darryl Okahata) darrylo@sr.hp.com
; Language:     Emacs-Lisp
; Package:      N/A
; Status:       Experimental (Do Not Distribute)
;
; (C) Copyright 1993, Hewlett-Packard, all rights reserved.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(provide 'mh-db)


(defvar y-mh-e-var-database "~/.mh-e-database"
  "The name of the file containing the mh-e variable database.")


(defvar y-mh-e-vars-to-save nil
  "List of variable names to save/restore.
Note that this variable is dynamically modified as Emacs-Lisp files are
loaded.")


(defvar y-mh-e-variables-loaded nil
  "This is a file used to tell if the mh-e variable database has been loaded.
It can be set to non-nil before mh-e.el is loaded to disable the automatic
loading of the mh-e variable database.")


(defvar y-mh-e-vars-buffer " *y-mh-vars*"
  "Temporary working buffer to use when saving/restoring mh-e variables.")


(defun y-mh-load-variables ()
  "Load mh-e variables from the mh-e variable database."
  (let ( (filename (expand-file-name (substitute-in-file-name
				      y-mh-e-var-database)))
	 (tmp-buffer (get-buffer-create y-mh-e-vars-buffer))
	 )
    (save-excursion
      (buffer-disable-undo (set-buffer tmp-buffer))
      (erase-buffer)
      (if (file-exists-p filename)
	  (progn
	    (insert-file-contents (expand-file-name
				   (substitute-in-file-name filename)))
	    (goto-char (point-min))
	    (if (condition-case nil
		    (progn
		      (eval-current-buffer)
		      nil
		      )
		  (error t))
		(progn
		  (message (format "Error occurred while reading \"%s\" (press a key)"
				   filename))
		  (ding)
		  (sit-for 60)
		  ))
	    ))
      (kill-buffer tmp-buffer)
      )))


(defun y-mh-load-variables-if-necessary ()
  "Load the mh-e variable database if it has not yet been loaded."
  (let ()
    (if (not y-mh-e-variables-loaded)
	(progn
	  (y-mh-load-variables)
	  (setq y-mh-e-variables-loaded t)
	  ))
    ))


(defun y-mh-save-variables ()
  "Save the mh-e variable database."
  (let ( (filename (expand-file-name (substitute-in-file-name
				      y-mh-e-var-database)))
	 (tmp-buffer (get-buffer-create y-mh-e-vars-buffer))
	 vars-to-save var
	 )
    (save-excursion
      (buffer-disable-undo (set-buffer tmp-buffer))
      (erase-buffer)
      (insert
";;
;; DO NOT ADD VARIABLES TO THIS FILE.  ONLY SPECIFIC VARIABLES DEFINED BY
;; EMACS-LISP CODE CAN BE STORED IN THIS FILE.  IF YOU ADD VARIABLES, THEY
;; WILL BE DELETED WHEN THIS FILE IS OVERWRITTEN BY EMACS.
;;
;; You can change the value of existing variables, but only if mh-e is not
;; currently running.  If an mh-e session is currently active in Emacs, you
;; must first quit mh-e, before editing this file, as quitting mh-e causes
;; this file to be overwritten.
;;

")
      (setq vars-to-save y-mh-e-vars-to-save)
      (while vars-to-save
	(setq var (car vars-to-save))
	(if (boundp var)
	    (progn
	      (insert (format "(setq %s '%S)\n" var (eval var)))
	      ))
	(setq vars-to-save (cdr vars-to-save))
	)
      (condition-case nil
	  (write-file filename)
	(progn
	  (message "Unable to save y-mh-e variable database -- perhaps the disk is full?")
	  (ding)
	  ))
      (kill-buffer tmp-buffer)
      )))


(add-hook 'mh-quit-hook 'y-mh-save-variables)
