#! /bin/sh
#
# mhn.defaults.sh -- create the defaults file for mhn
#
# $Id$
#

# If a search path is passed to script, we use
# that, else we use a default search path.
if [ -n "$1" ]; then
    SEARCHPATH=$1
else
    SEARCHPATH="$PATH:/usr/demo/SOUND"
fi

# command used to search for other programs
FIND="./mhn.find.sh"

# put output into a temporary file, so we
# can sort it before output.
TMP=/tmp/nmh_temp.$$
trap "rm -f $TMP" 0 1 2 3 13 15

echo "mhn-store-text: %m%P.txt" >> $TMP
echo "mhn-store-text/richtext: %m%P.rt" >> $TMP
echo "mhn-store-video/mpeg: %m%P.mpg" >> $TMP
echo "mhn-store-application/PostScript: %m%P.ps" >> $TMP

PGM="`$FIND $SEARCHPATH xwud`"
if [ ! -z "$PGM" ]; then
    XWUD="$PGM" X11DIR="`echo $PGM | awk -F/ '{ for(i=2;i<NF;i++)printf "/%s", $i;}'`"/
else
    XWUD= X11DIR=
fi

PGM="`$FIND $SEARCHPATH pbmtoxwd`"
if [ ! -z "$PGM" ]; then
    PBM="$PGM" PBMDIR="`echo $PGM | awk -F/ '{ for(i=2;i<NF;i++)printf "/%s", $i;}'`"/
else
    PBM= PBMDIR=
fi

PGM="`$FIND $SEARCHPATH xv`"
if [ ! -z "$PGM" ]; then
    echo "mhn-show-image: %p$PGM -geometry =-0+0 '%f'" >> $TMP
elif [ ! -z $"PBM" -a ! -z "$XWUD" ]; then
    echo "mhn-show-image/gif: %p${PBMDIR}giftoppm | ${PBMDIR}ppmtopgm | ${PBMDIR}pgmtopbm | ${PBMDIR}pbmtoxwd | $XWUD -geometry =-0+0" >> $TMP
    echo "mhn-show-image/x-pbm: %p${PBMDIR}pbmtoxwd | $XWUD -geometry =-0+0" >> $TMP
    echo "mhn-show-image/x-pgm: %p${PBMDIR}pgmtopbm | ${PBMDIR}pbmtoxwd | $XWUD -geometry =-0+0" >> $TMP
    echo "mhn-show-image/x-ppm: %p${PBMDIR}ppmtopgm | ${PBMDIR}pgmtopbm | ${PBMDIR}pbmtoxwd | $XWUD -geometry =-0+0" >> $TMP
    echo "mhn-show-image/x-xwd: %p$XWUD -geometry =-0+0" >> $TMP

    PGM="`$FIND $SEARCHPATH djpeg`"
    if [ ! -z "$PGM" ]; then
	echo "mhn-show-image/jpeg: %p$PGM -Pg | ${PBMDIR}ppmtopgm | ${PBMDIR}pgmtopbm | ${PBMDIR}pbmtoxwd | $XWUD -geometry =-0+0" >> $TMP
    fi
fi

if [ -f "/dev/audioIU" ]; then
    PGM="`$FIND $SEARCHPATH recorder`"
    if [ ! -z "$PGM" ]; then
	echo "mhn-store-audio/basic: %m%P.au" >> $TMP
        echo "mhn-compose-audio/basic: ${AUDIODIR}recorder '%f' -au -pause > /dev/tty" >> $TMP
        echo "mhn-show-audio/basic: %p${AUDIODIR}splayer -au" >> $TMP
    fi
elif [ -f "/dev/audio" ]; then
    PGM="`$FIND $SEARCHPATH raw2audio`"
    if [ ! -z "$PGM" ]; then
	AUDIODIR="`echo $PGM | awk -F/ '{ for(i=2;i<NF;i++)printf "/%s", $i;}'`"/
	echo "mhn-store-audio/basic: | ${AUDIODIR}raw2audio -e ulaw -s 8000 -c 1 > %m%P.au" >> $TMP
        echo "mhn-store-audio/x-next: %m%P.au" >> $TMP
	AUDIOTOOL="`$FIND $SEARCHPATH audiotool`"
	if [ ! -z "$AUDIOTOOL" ]; then
	    echo "mhn-compose-audio/basic: $AUDIOTOOL %f && ${AUDIODIR}raw2audio -F < %f" >> $TMP
	else
	    echo "mhn-compose-audio/basic: trap \"exit 0\" 2 && ${AUDIODIR}record | ${AUDIODIR}raw2audio -F" >> $TMP
	fi
	echo "mhn-show-audio/basic: %p${AUDIODIR}raw2audio 2>/dev/null | ${AUDIODIR}play" >> $TMP

	PGM="`$FIND $SEARCHPATH adpcm_enc`"
	if [ ! -z "$PGM" ]; then
	    DIR="`echo $PGM | awk -F/ '{ for(i=2;i<NF;i++)printf "/%s", $i;}'`"/
	    if [ ! -z "$AUDIOTOOL" ]; then
		echo "mhn-compose-audio/x-next: $AUDIOTOOL %f && ${DIR}adpcm_enc < %f" >> $TMP
	    else
		echo "mhn-compose-audio/x-next: ${AUDIODIR}record | ${DIR}adpcm_enc" >> $TMP
	    fi
	    echo "mhn-show-audio/x-next: %p${DIR}adpcm_dec | ${AUDIODIR}play" >> $TMP
	else
	    if [ ! -z "$AUDIOTOOL" ]; then
		echo "mhn-compose-audio/x-next: $AUDIOTOOL %f" >> $TMP
	    else
		echo "mhn-compose-audio/x-next: ${AUDIODIR}record" >> $TMP
	    fi
	    echo "mhn-show-audio/x-next: %p${AUDIODIR}play" >> $TMP
	fi
    else
	echo "mhn-compose-audio/basic: cat < /dev/audio" >> $TMP
        echo "mhn-show-audio/basic: %pcat > /dev/audio" >> $TMP
    fi
fi

PGM="`$FIND $SEARCHPATH mpeg_play`"
if [ ! -z "$PGM" ]; then
	echo "mhn-show-video/mpeg: %p$PGM '%f'" >> $TMP
fi

PGM="`$FIND $SEARCHPATH lpr`"
if [ ! -z "$PGM" ]; then
	echo "mhn-show-application/PostScript: %plpr -Pps" >> $TMP
else
    PGM="`$FIND $SEARCHPATH lp`"
    if [ ! -z "$PGM" ]; then    
	echo "mhn-show-application/PostScript: %plp -dps" >> $TMP
    fi
fi

PGM="`$FIND $SEARCHPATH ivs_replay`"
if [ ! -z "$PGM" ]; then
	echo "mhn-show-application/x-ivs: %p$PGM -o '%F'" >> $TMP
fi

PGM="`$FIND $SEARCHPATH richtext`"
if [ ! -z "$PGM" ]; then
	echo "mhn-show-text/richtext: %p$PGM -p '%F'" >> $TMP
else
    PGM="`$FIND $SEARCHPATH rt2raw`"
    if [ ! -z "$PGM" ]; then
	echo "mhn-show-text/richtext: %p$PGM < '%f' | fmt -78 | more" >> $TMP
    fi
fi

PGM="`$FIND $SEARCHPATH xterm`"
if [ ! -z "$PGM" ]; then
	echo "mhn-charset-iso-8859-1: xterm -fn '-*-*-medium-r-normal-*-*-120-*-*-c-*-iso8859-*' -e %s" >> $TMP
fi

# output a sorted version of the file
sort < $TMP

exit 0

: not until we get a "safe" postscript environment...

PGM="`$FIND $SEARCHPATH pageview`"
if [ "$DISPLAY" = "unix:0.0" -a ! -z "$PGM" ]; then
    echo "mhn-show-application/PostScript: %p$PGM -" >> $TMP
else
    PGM="`$FIND $SEARCHPATH gs`"
    if [ ! -z "$PGM" ]; then
	echo "mhn-show-application/PostScript: %p$PGM -- '%F'" >> $TMP
    fi
fi

: have to experiment more with this

PGM="`$FIND $SEARCHPATH ivs_record`"
if [ ! -z "$PGM" ]; then
	echo "mhn-compose-application/x-ivs: $PGM -u localhost '%F'" >> $TMP
fi
