
/*
 * rmail.c -- replacement for /bin/rmail
 *
 * $Id$
 */

/* This program has a long, long history.  It started as UCB's rmail, and
   was then modified by OBrien@Rand-Unix to run with MMDF.  Then DpK@Brl
   re-wrote it, and SmB@Unc hacked it up a bit.  After that
   MRose.UCI@Rand-Relay upgraded it to use the nifty MF (mail filtering)
   system.  Finally, the latter stripped it down to work with MH.

   This program should be used ONLY if you have both "mts mh" and "uucp on"
   set in your MH configuration.
 */

#include <h/mh.h>
#include <h/addrsbr.h>
#include <zotnet/mf.h>
#include <zotnet/tws.h>
#include <zotnet/mts.h>
#include <signal.h>

#define	ADDROK	0		/* okay to use post to deliver message */
#define	UUCP	1		/* okay to use uux to deliver message */
#define	RETURN	2		/* message loses */

int     pbroke;			/* broken-pipe flag */
int     rtnflag;		/* note was sent back */

char    date[BUFSIZ];		/* date of origination from uucp header */
char    from[BUFSIZ];		/* accumulated path of sender */
char    origsys[BUFSIZ];	/* originating system */
char    origpath[BUFSIZ];	/* path from us to originating system */
char    usrfrm[BUFSIZ];		/* the 822 version of from[] */
char    Mailsys[BUFSIZ];	/* address of the mail agent */
char    overseer[BUFSIZ];	/* address of the watchdog */

char    mmdf[BUFSIZ];		/* filtered mail file */

char   *rtnmessage[] = {
    "	Your message has been intercepted trying to access\n",
    "a restricted access host (e.g. an ARPANET host).  A copy\n",
    "of your message has been sent to the system administrators.\n",
    "The text of your message follows.\n\n",
    NULL
};

char    rtnbegin[] =
        " ---------------- Returned Mail Follows --------------\n";
char    rtnend[] =
        "  --------------- End of Returned Mail ---------------\n";

char   *oopsmessage[] = {
    "\n\n\tThe system administrators (%s) have been informed of\n",
    "the problem, but have not been given a copy of your message.\n\n",
    NULL
};

FILE * fromf;			/* UUCP "From lines */
FILE * msgf;			/* message text */
FILE * pipef;			/* output for "post" or "uux" */

int pipeser();
off_t lseek();


main (int argc, char **argv)
{
    int     cpyback;
    char   *cp,
           *fromptr,
            fromwhom[BUFSIZ],
            linebuf[BUFSIZ],
            sys[BUFSIZ];

#ifdef LOCALE
	setlocale(LC_ALL, "");
#endif
    invo_name = r1bindex (*argv, '/');
    m_foil (NULL);
    mts_init (invo_name);

    if (argc < 2)
	adios (NULL, "usage: %s user [user ...]", invo_name);
    umask (0);
    setgid (1);
    setuid (1);

    sprintf (Mailsys, "%s@%s", Mailer, LocalName ());
    if (Overseer == NULL)
	Overseer = Mailsys;
    if (strchr(Overseer, '@') == NULL) {
	sprintf (overseer, "%s@%s", Overseer, LocalName ());
	Overseer = overseer;
    }

    mktemp (Errtmp);
    if (freopen (Errtmp, "w", stderr) == NULL)
	adios (Errtmp, "unable to create");
    dup2 (fileno (stderr), fileno (stdout));

    mktemp (Msgtmp);
    if ((msgf = fdopen (creat (Msgtmp, Tmpmode), "w")) == NULL)
	adios (Msgtmp, "unable to create");

    mktemp (Fromtmp);
    if ((fromf = fdopen (creat (Fromtmp, Tmpmode), "w")) == NULL)
	adios (Fromtmp, "unable to create");

/*  */

    for (;;) {
	if (fgets (linebuf, sizeof linebuf, stdin) == NULL)
	    break;
	if (strncmp (linebuf, "From ", 5)
		&& strncmp (linebuf, ">From ", 6))
	    break;

	if (linebuf[0] != '>')
	    fputs (">", fromf);
	fputs (linebuf, fromf);
	cp = strchr(linebuf, ' ');
	fromptr = ++cp;
	cp = strchr(cp, ' ');
	*cp++ = NULL;
	strcpy (fromwhom, fromptr);
	strncpy (date, cp, 24);

	for (;;) {
	    if ((cp = strchr(cp + 1, 'r')) == NULL) {
		if ((cp = strrchr(fromwhom, '!')) != NULL) {
		    char   *p;
		    *cp = NULL;
		    if ((p = strrchr(fromwhom, '!')) != NULL)
			strcpy (origsys, p + 1);
		    else
			strcpy (origsys, fromwhom);
		    strcat (from, fromwhom);
		    strcat (from, "!");
		    strcpy (fromwhom, cp + 1);
		    goto out;
		}
		strcpy (sys, SystemName ());
		strcat (from, sys);
		strcpy (origsys, sys);
		strcat (from, "!");
		goto out;
	    }
	    if (strncmp (cp, "remote from ", 12) == 0)
		break;
	}

	sscanf (cp, "remote from %s", sys);
	strcat (from, sys);
	strcpy (origsys, sys);
	strcat (from, "!");
out: 	;
    }
    if (fromwhom[0] == NULL)
	adios (NULL, "no from line");

/*  */

    strcpy (origpath, from);
    strcat (from, fromwhom);
    get_mmdf_addr (from, usrfrm);
    if ((cp = strrchr(usrfrm, '<')) != NULL) {
	strcpy (usrfrm, ++cp);	/* sigh */
	if ((cp = strrchr(usrfrm, '>')) != NULL)
	    *cp = NULL;
    }
    if (usrfrm[0] == NULL)
	sprintf (usrfrm, "%s!%s%%%s@%s%c",
		SystemName (), from, UucpChan (), LocalName (), NULL);

    fputs (linebuf, msgf);
    if (txtcpy (stdin, msgf) == NOTOK)
	fputs ("\n  *** Problem during receipt from UUCP ***\n", msgf);

    freopen (Msgtmp, "r", msgf);
    freopen (Fromtmp, "r", fromf);
    unlink (Fromtmp);
    mmdf[0] = NULL;

    cpyback = 0;
    for (argv++; --argc > 0;) {
	rewind (fromf);
	rewind (msgf);
	rtnflag = 0;
	if (deliver (*argv++) == NOTOK && !rtnflag)
	    cpyback++;
    }

    fflush (stderr);
    fflush (stdout);

    if (cpyback) {
	rcpy ();
	zcpy ();
    }

    unlink (Msgtmp);
    if (mmdf[0])
	unlink (mmdf);
    unlink (Errtmp);

    exit (0);
}

/*  */

deliver (to)
char   *to;
{
    int     i,
            replyval;
    char    tmpfil[BUFSIZ];

    switch (adrcheck (to)) {
	case ADDROK: 
	    if (mmdf[0] == NULL && filter () == NOTOK)
		strcpy (mmdf, Msgtmp);
	    replyval = xpost (to, mmdf);
	    break;

	case UUCP: 
	    if ((replyval = xuucp (to)) == NOTOK)
		break;

	    if ((replyval = txtcpy (fromf, pipef)) != NOTOK)
		replyval = txtcpy (msgf, pipef);
	    i = (pclose (pipef) >> 8) & 0xff;
	    if (replyval != NOTOK)
		replyval = (i != 0 ? NOTOK : OK);
	    break;

/*  */

	case RETURN: 
	    rtnflag++;
	    switch (adrcheck (from)) {
		case ADDROK: 
		case RETURN: 
		    strcpy (tmpfil, "/tmp/rmailXXXXXX");
		    unlink (mktemp (tmpfil));
		    if ((pipef = fdopen (creat (tmpfil, Tmpmode), "w")) == NULL)
			return NOTOK;

		    fprintf (pipef, "Date: %s\nFrom: %s\n",
			    dtimenow (), Mailsys);
		    fprintf (pipef, "To: %s\ncc: %s\n", from, Overseer);
		    rtnmesg (to);
		    fclose (pipef);

		    replyval = xpost (from, tmpfil);
		    unlink (tmpfil);
		    break;

		case UUCP: 
		    if ((replyval = xuucp (from)) == NOTOK)
			break;

		    fprintf (pipef, "To: %s\ncc: %s\n", from, Overseer);
		    rtnmesg (to);
		    i = (pclose (pipef) >> 8) & 0xff;
		    if (replyval != NOTOK)
			replyval = (i != 0 ? NOTOK : OK);
		    break;
	    }
	    if (Syscpy) {
		strcpy (tmpfil, "/tmp/rmailXXXXXX");
		unlink (mktemp (tmpfil));
		if ((pipef = fdopen (creat (tmpfil, Tmpmode), "w")) == NULL)
		    return NOTOK;

		fprintf (pipef, "Date: %s\nFrom: %s\n",
			dtimenow (), Mailsys);
		fprintf (pipef, "To: %s\ncc: %s\n", usrfrm, Overseer);
		rtnmesg (to);
		fclose (pipef);

		replyval = xpost (Overseer, tmpfil);
		unlink (tmpfil);
	    }
	    break;
    }

    return replyval;
}

/*  */

adrcheck (adr)
char   *adr;
{
    int     type;
    char   *cp,
            host[BUFSIZ];
    struct mailname *mp;

    if ((cp = getname (adr)) == NULL)
	return RETURN;
    mp = getm (cp, NULL, 0, AD_HOST, NULL);
    while (getname (""))
	continue;
    if (mp == NULL)
	return RETURN;

    type = mp->m_type;
    strcpy (host, mp->m_host);
    mnfree (mp);
    if (mp->m_mbox == NULL)
	return RETURN;

    switch (type) {
	case LOCALHOST: 
	    return ADDROK;

	case UUCPHOST: 
	    return (strcmp (host, SystemName ()) ? UUCP : ADDROK);

	default: 
	    if (lookup (origsys, Okhosts) == OK)
		return ADDROK;
	    return (okhost (host) == NOTOK ? RETURN : ADDROK);
    }
}

/*  */

okhost (host)
char   *host;
{
    return (lookup (origsys, Okhosts) == OK
	    || lookup (host, Okhosts) == OK
	    || lookup (host, Okdests) == OK ? OK : NOTOK);
}


lookup (what, where)
char   *what,
       *where;
{
    char   *cp,
            entry[BUFSIZ];
    FILE * lookf;

    if ((lookf = fopen (where, "r")) == NULL)
	return NOTOK;
    while (fgets (entry, sizeof entry, lookf) != NULL) {
	cp = entry;
	while (*cp != '\n' && *cp != ' ' && *cp != '\t')
	    cp++;
	*cp = NULL;
	if (uleq (what, entry)) {
	    fclose (lookf);
	    return OK;
	}
    }
    fclose (lookf);

    return NOTOK;
}


/*  */

rtnmesg (badadr)
char   *badadr;
{
    int     i;

    fprintf (pipef, "Subject: Illegal Address (%s)\n\n", badadr);
    for (i = 0; rtnmessage[i]; i++)
	fputs (rtnmessage[i], pipef);
    fputs (rtnbegin, pipef);

    rewind (fromf);
    txtcpy (fromf, pipef);
    rewind (msgf);
    txtcpy (msgf, pipef);

    fputs (rtnend, pipef);
}


txtcpy (frm, to)
FILE * frm, *to;
{
    int     nread;
    char    buffer[BUFSIZ];

    while (!pbroke
	    && (nread = fread (buffer, sizeof (*buffer), BUFSIZ, frm)) > 0)
	fwrite (buffer, sizeof (*buffer), nread, to);

    return (ferror (frm) ? NOTOK : OK);
}


xpost (addr, file)
char   *addr,
       *file;
{
    pid_t child_id;
    int i;

    for (i = 0; (child_id = fork()) == NOTOK && i < 5; i++)
	sleep (5);
    switch (child_id) {
	case NOTOK: 
	    return NOTOK;

	case OK: 
	    execlp (postproc, r1bindex (postproc, '/'),
		    "-deliver", addr, file, NULL);
	    fprintf (stderr, "unable to exec ");
	    perror (postproc);
	    _exit (1);

	default: 
	    return (pidwait(child_id, OK) ? NOTOK : OK);
    }
}

/*  */

xuucp (to)
char   *to;
{
    char   *cp,
            buffer[BUFSIZ],
            cmdstr[BUFSIZ];

    strcpy (buffer, to);
    if (cp = strchr(buffer, '!'))
	*cp++ = NULL;
    else {
	fprintf (stderr, "internal error -- %s has no host\n", to);
	return NOTOK;
    }
    sprintf (cmdstr, "uux -p %s!rmail \\(%s\\)", buffer, cp);

    if ((pipef = popen (cmdstr, "w")) == NULL)
	return NOTOK;

    signal (SIGPIPE, pipeser);
    pbroke = 0;

    return OK;
}

/*  */

#ifdef	BSD42
/* ARGSUSED */
#endif	BSD42

static int  pipeser (i)
int     i;
{
#ifndef	BSD42
    signal (i, SIG_IGN);
#endif	BSD42

    pbroke = 1;
}

/*  */

rcpy () {
    int     i;
    char    buffer[BUFSIZ],
            tmpfil[BUFSIZ];
    FILE * fp;

    strcpy (tmpfil, "/tmp/rmailXXXXXX");
    unlink (mktemp (tmpfil));
    if ((pipef = fdopen (creat (tmpfil, Tmpmode), "w")) == NULL)
	return;

    fprintf (pipef, "Date: %s\nFrom: %s\n", dtimenow (), Mailsys);
    fprintf (pipef, "To: %s\n", usrfrm);
    fprintf (pipef, "\nProblems sending mail:\n\n");
    i = 0;
    if ((fp = fopen (Errtmp, "r")) != NULL) {
	while (fgets (buffer, sizeof buffer, fp) != NULL) {
	    if (ferror (pipef))
		break;
	    fputs (buffer, pipef);
	    i++;
	}
    }
    if (i == 0)
	fprintf (pipef, "\tunknown problem\n");
    for (i = 0; oopsmessage[i]; i++)
	fprintf (pipef, oopsmessage[i], Overseer);
    fputs (rtnbegin, pipef);

    rewind (fromf);
    txtcpy (fromf, pipef);
    rewind (msgf);
    txtcpy (msgf, pipef);

    fputs (rtnend, pipef);
    fclose (pipef);

    xpost (usrfrm, tmpfil);
    unlink (tmpfil);
}

/*  */

zcpy () {
    int     i;
    char    buffer[BUFSIZ],
            tmpfil[BUFSIZ];
    FILE * fp;

    strcpy (tmpfil, "/tmp/rmailXXXXXX");
    unlink (mktemp (tmpfil));
    if ((pipef = fdopen (creat (tmpfil, Tmpmode), "w")) == NULL)
	return;

    fprintf (pipef, "Date: %s\nFrom: %s\n", dtimenow (), Mailsys);
    fprintf (pipef, "To: %s\n", Mailsys);
    fprintf (pipef, "\nProblems sending mail for %s (aka %s):\n\n",
	    from, usrfrm);

    i = 0;
    if ((fp = fopen (Errtmp, "r")) != NULL) {
	while (fgets (buffer, sizeof buffer, fp) != NULL) {
	    if (ferror (pipef))
		break;
	    fputs (buffer, pipef);
	    i = 1;
	}
	fclose (fp);
	if (i == 0)
	    fprintf (pipef, "\tunknown problem\n");
    }
    else
	fprintf (pipef, "\tunable to open %s\n", Errtmp);
    fclose (pipef);

    xpost (Mailsys, tmpfil);
    unlink (tmpfil);
}

/*  */

filter () {
    int     i,
            fd,
            td;
    char    tmpfil[BUFSIZ],
            mmdfil[BUFSIZ];
    FILE * out;

    strcpy (tmpfil, "/tmp/rmailXXXXXX");
    unlink (mktemp (tmpfil));
    if ((fd = creat (tmpfil, Tmpmode)) == NOTOK)
	return NOTOK;
    close (fd);
    if ((fd = open (tmpfil, 2)) == NOTOK)
	return NOTOK;
    if ((out = fdopen (fd, "w")) == NULL) {
	close (fd);
	return NOTOK;
    }
    if ((td = dup (fd)) == NOTOK) {
	close (fd);
	return NOTOK;
    }

    fprintf (out, "From %s %s\n", from, date);
    if (txtcpy (msgf, out) == NOTOK) {
	close (fd);
	close (td);
	return NOTOK;
    }
    fclose (out);
    lseek (td, (off_t)0, 0);

    strcpy (mmdfil, "/tmp/mmdfXXXXXX");
    unlink (mktemp (mmdfil));
    if ((fd = creat (mmdfil, Tmpmode)) == NOTOK) {
	close (td);
	unlink (tmpfil);
	return NOTOK;
    }
    if ((fd = open (mmdfil, 2)) == NOTOK) {
	close (td);
	unlink (tmpfil);
	return NOTOK;
    }

/*  */

    switch (i = uucp2mmdf (td, fd, TRUE)) {
	case OK: 
	    strcpy (mmdf, mmdfil);
	    break;

	default: 
	    mmdf[0] = NULL;
	    break;
    }
    close (td);
    unlink (tmpfil);
    close (fd);

    return (i != OK ? NOTOK : OK);
}

/*  */

get_mmdf_addr (addr, to)
char   *addr,
       *to;
{
    struct adrx *adrxp;

    *to = NULL;
    if ((adrxp = seekadrx (addr)) == NULL)
	return;

    addr_convert (adrxp, to, TRUE);
    while (seekadrx (NULL))
	continue;
}
