
/*
 * hosts.c -- find out the official name of a host
 *
 * $Id$
 */

#include "../h/strings.h"
#include <stdio.h>
#include "../zotnet/mts.h"
#include <ctype.h>
#include <netdb.h>

#define	NOTOK	(-1)

char *OfficialName (char *name)
{
    register char *p;
    char *q, site[BUFSIZ];
    static char buffer[BUFSIZ];
    register struct hostent *hp;

    for (p = name, q = site; *p; p++, q++)
	*q = isupper (*p) ? tolower (*p) : *p;
    *q = 0;
    q = site;

    if (uleq (LocalName (), site))
	return LocalName ();

    if (hp = gethostbyname (q)) {
	strcpy (buffer, hp -> h_name);
	return buffer;
    }
    return NULL;
}
