
/*
 * mark.c -- mark messages
 *
 * $Id$
 */

#include <h/mh.h>

static struct swit switches[] = {
#define	ADDSW               0
    { "add", 0 },
#define	DELSW               1
    { "delete", 0 },
#define	LSTSW               2
    { "list", 0 },
#define	SEQSW               3
    { "sequence name", 0 },
#define	PUBLSW              4
    { "public", 0 },
#define	NPUBLSW             5
    { "nopublic", 0 },
#define	ZEROSW              6
    { "zero", 0 },
#define	NZEROSW             7
    { "nozero", 0 },
#define VERSIONSW           8
    { "version", 0 },
#define	HELPSW              9
    { "help", 4 },
#define	DEBUGSW            10
    { "debug", -5 },
    { NULL, 0 }
};


main (int argc, char **argv)
{
    int addsw = 0, deletesw = 0, debugsw = 0;
    int listsw = 0, publicsw = -1, zerosw = 0;
    int seqp = 0, msgp = 0, i, msgnum;
    char *cp, *maildir, *folder = NULL, buf[100];
    char **ap, **argp, *arguments[MAXARGS];
    char *seqs[NUMATTRS + 1], *msgs[MAXARGS];
    struct msgs *mp;

#ifdef LOCALE
    setlocale(LC_ALL, "");
#endif
    invo_name = r1bindex (argv[0], '/');
    if ((cp = m_find (invo_name)) != NULL) {
	ap = brkstring (cp = getcpy (cp), " ", "\n");
	ap = copyip (ap, arguments);
    }
    else
	ap = arguments;
    copyip (argv + 1, ap);
    argp = arguments;

    while ((cp = *argp++)) {
	if (*cp == '-')
	    switch (smatch (++cp, switches)) {
		case AMBIGSW: 
		    ambigsw (cp, switches);
		    done (1);
		case UNKWNSW: 
		    adios (NULL, "-%s unknown\n", cp);

		case HELPSW: 
		    sprintf (buf, "%s [+folder] [msgs] [switches]", invo_name);
		    print_help (buf, switches);
		    done (1);
		case VERSIONSW:
		    print_version(invo_name);
		    done (1);

		case ADDSW: 
		    addsw++;
		    deletesw = listsw = 0;
		    continue;
		case DELSW: 
		    deletesw++;
		    addsw = listsw = 0;
		    continue;
		case LSTSW: 
		    listsw++;
		    addsw = deletesw = 0;
		    continue;

		case SEQSW: 
		    if (!(cp = *argp++) || *cp == '-')
			adios (NULL, "missing argument to %s", argp[-2]);
		    if (seqp < NUMATTRS)
			seqs[seqp++] = cp;
		    else
			adios (NULL, "only %d sequences allowed!", NUMATTRS);
		    continue;

		case PUBLSW: 
		    publicsw = 1;
		    continue;
		case NPUBLSW: 
		    publicsw = 0;
		    continue;

		case DEBUGSW: 
		    debugsw++;
		    continue;

		case ZEROSW: 
		    zerosw++;
		    continue;
		case NZEROSW: 
		    zerosw = 0;
		    continue;
	    }
	if (*cp == '+' || *cp == '@') {
	    if (folder)
		adios (NULL, "only one folder at a time!");
	    else
		folder = path (cp + 1, *cp == '+' ? TFOLDER : TSUBCWF);
	}
	else
	    msgs[msgp++] = cp;
    }

    if (!addsw && !deletesw && !listsw)
	if (seqp)
	    addsw++;
	else
	    listsw++;

    if (!m_find ("path"))
	free (path ("./", TFOLDER));
    if (!msgp)
	msgs[msgp++] = listsw ? "all" :"cur";
    if (!folder)
	folder = m_getfolder ();
    maildir = m_maildir (folder);

    if (chdir (maildir) == NOTOK)
	adios (maildir, "unable to change directory to");
    if (!(mp = m_gmsg (folder)))
	adios (NULL, "unable to read folder %s", folder);
    if (mp->hghmsg == 0)
	adios (NULL, "no messages in %s", folder);

    for (msgnum = 0; msgnum < msgp; msgnum++)
	if (!m_convert (mp, msgs[msgnum]))
	    done (1);

    if (publicsw == -1)
	publicsw = mp->msgflags & READONLY ? 0 : 1;
    if (publicsw && (mp->msgflags & READONLY))
	adios (NULL, "folder %s is read-only, so -public not allowed",
		folder);

    if (debugsw) {
	printf ("invo_name     = %s\n", invo_name);
	printf ("mypath        = %s\n", mypath);
	printf ("defpath       = %s\n", defpath);
	printf ("ctxpath       = %s\n", ctxpath);
	printf ("context flags = %s\n", sprintb (buf, (unsigned) ctxflags, DBITS));
	printf ("foldpath      = %s\n", mp->foldpath);
	printf ("folder flags  = %s\n\n", sprintb(buf, (unsigned) mp->msgflags, FBITS));
	printf ("lowmsg=%d hghmsg=%d nummsg=%d curmsg=%d\n",
		mp->lowmsg, mp->hghmsg, mp->nummsg, mp->curmsg);
	printf ("lowsel=%d hghsel=%d numsel=%d\n",
		mp->lowsel, mp->hghsel, mp->numsel);
#ifndef	MTR
	printf ("lowoff=%d hghoff=%d\n", mp->lowoff, mp->hghoff);
#else
	printf ("lowoff=%d hghoff=%d msgbase=0x%x msgstats=0x%x\n",
		mp->lowoff, mp->hghoff, mp->msgbase, mp->msgstats);
#endif
    }

    if (seqp == 0 && (addsw || deletesw))
	adios (NULL, "-%s requires at least one -sequence argument",
		addsw ? "add" : "delete");
    seqs[seqp] = NULL;

    if (addsw)
	for (seqp = 0; seqs[seqp]; seqp++) {
	    if (zerosw && !m_seqnew (mp, seqs[seqp], publicsw))
		done (1);
	    for (msgnum = mp->lowsel; msgnum <= mp->hghsel; msgnum++)
		if (mp->msgstats[msgnum] & SELECTED)
		    if (!m_seqadd (mp, seqs[seqp], msgnum, publicsw))
			done (1);
	}

    if (deletesw)
	for (seqp = 0; seqs[seqp]; seqp++) {
	    if (zerosw)
		for (msgnum = mp->lowmsg; msgnum <= mp->hghmsg; msgnum++)
		    if (mp->msgstats[msgnum] & EXISTS)
			if (!m_seqadd (mp, seqs[seqp], msgnum, publicsw))
			    done (1);
	    for (msgnum = mp->lowsel; msgnum <= mp->hghsel; msgnum++)
		if (mp->msgstats[msgnum] & SELECTED)
		    if (!m_seqdel (mp, seqs[seqp], msgnum))
			done (1);
	}

    if (listsw) {
	int bits = FFATTRSLOT;

#define empty(s) ((s) ? (s) : "")

	if (!seqp) {
	    for (i = 0; mp->msgattrs[i]; i++)
		printf ("%s%s: %s\n", mp->msgattrs[i],
			mp->attrstats & (1 << (bits + i)) ? " (private)" : "",
			empty(m_seq(mp, mp->msgattrs[i])));
	} else {
	    for (seqp = 0; seqs[seqp]; seqp++)
		printf ("%s: %s\n", seqs[seqp], empty(m_seq(mp, seqs[seqp])));
	}

#undef empty

	if (debugsw)
	    for (msgnum = mp->lowsel; msgnum <= mp->hghsel; msgnum++)
		if (mp->msgstats[msgnum] & SELECTED)
		    printf ("%*d: %s\n", DMAXFOLDER, msgnum,
			sprintb (buf, (unsigned) mp->msgstats[msgnum],
			    m_seqbits (mp)));
    }

    m_replace (pfolder, folder);
    m_sync (mp);
    m_update ();

    done (0);
}
