.\"
.\" %nmhwarning%
.\" $Id$
.\"
.\" include the -mh macro file
.so %etcdir%/tmac.h
.\"
.TH PROMPTER %manext1% MH.6.8 [%nmhversion%]
.SH NAME
prompter \- prompting editor front-end for nmh
.SH SYNOPSIS
.in +.5i
.ti -.5i
prompter
\%[\-erase\ chr]
\%[\-kill\ chr]
\%[\-prepend] \%[\-noprepend]
\%[\-rapid] \%[\-norapid]
\%[\-doteof] \%[\-nodoteof]
file
\%[\-version]
\%[\-help]
.in -.5i
.SH DESCRIPTION
\fIPrompter\fR is an editor front\-end for \fInmh\fR which allows rapid
composition of messages.  This program is not normally invoked directly by
users but takes the place of an editor and acts as an editor front\-end.
It operates on an RFC\-822 style message draft skeleton specified by
file, normally provided by the nmh commands \fIcomp\fR, \fIdist\fR,
\fIforw\fR, or \fIrepl\fR.

\fIPrompter\fR is particularly useful when composing messages over slow
network or modem lines.  It is an \fInmh\fR program in that it can have
its own profile entry with switches, but it is not invoked directly by
the user.  The commands \fIcomp\fR, \fIdist\fR, \fIforw\fR, and \fIrepl\fR
invoke \fIprompter\fR as an editor, either when invoked with
`\-editor\ prompter', or by the profile entry \*(lqEditor:\ prompter\*(rq,
or when given the command `edit\ prompter' at the \*(lqWhat now?\*(rq prompt.

For each empty component \fIprompter\fR finds in the draft, the user
is prompted for a response; A <RETURN> will cause the whole component
to be left out.  Otherwise, a `\\' preceding a <RETURN> will continue
the response on the next line, allowing for multiline components.
Continuation lines \fBmust\fR begin with a space or tab.

Each non\-empty component is copied to the draft and displayed on the
terminal.

The start of the message body is denoted by a blank line or a line
of dashes.  If the body is non\-empty, the prompt, which isn't written
to the file, is

    \*(lq--------Enter additional text\*(rq,

or (if `\-prepend' was given)

    \*(lq--------Enter initial text\*(rq.

Message\-body typing is terminated with an end\-of\-file (usually
CTRL\-D).  With the `\-doteof' switch, a period on a line all by itself
also signifies end\-of\-file.  At this point control is returned to
the calling program, where the user is asked \*(lqWhat now?\*(rq.
See \fIwhatnow\fR for the valid options to this query.

By using the `\-prepend' switch, the user can add type\-in to the
beginning of the message body and have the rest of the body follow.
This is useful for the \fIforw\fR command.

By using the `\-rapid' switch, if the draft already contains text in
the message\-body, it is not displayed on the user's terminal.  This is
useful for low\-speed terminals.

The line editing characters for kill and erase may be specified by the
user via the arguments `\-kill\ chr' and `\-erase\ chr', where chr may
be a character; or `\\nnn', where \*(lqnnn\*(rq is the octal value for
the character.

An interrupt (usually CTRL\-C) during component typing will abort
\fIprompter\fR and the \fInmh\fR command that invoked it.  An interrupt
during message\-body typing is equivalent to CTRL\-D, for historical
reasons.  This means that \fIprompter\fR should finish up and exit.

The first non\-flag argument to \fIprompter\fR is taken as the name of
the draft file, and subsequent non\-flag arguments are ignored.
.\" (\fIRepl\fR invokes editors with two file arguments:
.\" the draft file name and the replied\-to message file name.)
.Fi
^$HOME/\&.mh\(ruprofile~^The user profile
^/tmp/prompter*~^Temporary copy of message
.Pr
prompter\-next:	To name the editor to be used on exit from \fIprompter\fR
.Ps
^Msg\-Protect:~^To set mode when creating a new draft
.Sa
comp(1), dist(1), forw(1), repl(1), whatnow(1)
.De
`\-prepend'
.Ds
`\-norapid'
.Ds
`\-nodoteof'
.Co
None
.Hh
The `\-rapid' option is particularly useful with \fIforw\fP, and
`\-noprepend' is useful with \fIcomp\ \-use\fP.

The user may wish to link \fIprompter\fR under several names (e.g.,
\*(lqrapid\*(rq) and give appropriate switches in the profile entries
under these names (e.g., \*(lqrapid: -rapid\*(rq).  This facilitates
invoking prompter differently for different \fInmh\fP commands (e.g.,
\*(lqforw: -editor rapid\*(rq).
.Bu
\fIPrompter\fR uses \fIstdio\fR\0(3), so it will lose if you edit files
with nulls in them.
.En
