#!/usr/local/bin/perl
# makeindex.pl -- make index for mail server
# SCCS Status     : @(#)@ makeindex	1.11
# Author          : Johan Vromans
# Created On      : Tue Apr 21 20:36:56 1992
# Last Modified By: Johan Vromans
# Last Modified On: Wed Dec 23 23:02:37 1992
# Update Count    : 38
# Status          : Going steady

# makeindex.pl, based on GNU find's updatedb.
$my_name = "makeindex";
$my_version = "1.11";
#
################ Common stuff ################

$libdir = $ENV{"MSERVLIB"} || "/usr/local/lib/mserv";
unshift (@INC, $libdir);

################ Options handling ################

&options if @ARGV > 0 && $ARGV[0] =~ /^-+[^-]+/;
require "ms_common.pl";
@ARGV = ("-") unless @ARGV > 0;
print STDERR "$my_package [$my_name $my_version]\n"
    if defined $opt_ident;

################ Setup ################

&die ("Index search not selected -- nothing to do")
    unless $doindexsearch;

# Work files.
$bigrams  = "$tmpdir/f.bigrams$$";
$filelist = "$tmpdir/f.list$$";
$errs     = "$tmpdir/f.errs$$";

$SIG{"INT"}  = "catch";
$SIG{"QUIT"} = "catch";
$SIG{"HUP"}  = "IGNORE";
$SIG{"TERM"} = "catch";

################ Go! ################

if ( $indexfile =~ m|^/| ) {
    # Create one single index file.
    &makeindex (defined $indexlib ? $indexlib : "@libdirs", $indexfile,
		shift(@libprunes));
}
else {
    # Create one index file per library dir.
    local (@prunes) = @libprunes;
    foreach $lib ( @libdirs ) {
	&makeindex ($lib, "$lib/$indexfile", shift(@prunes));
    }
}

exit (0);

################ Subroutines ################

sub makeindex {
    local ($list, $indexfile, $pruneregex) = @_;
    local ($cmd) = "-follow ! -type d -printf \"%P\\t%k\\t%Ty%Tm%Td\\n\"";

    $cmd = "\\( -type d -regex $pruneregex -prune \\) -o \\( $cmd \\)"
	if defined $pruneregex && $pruneregex ne "";

    # Make a file list.  Alphabetize '/' before any other char with 'tr'.
    &system ("$gfind $list " . $cmd . " " .
	     "| tr '/' '\\001' | sort -f 2> $errs " .
	     "| tr '\\001' '/' > $filelist");

    # Compute common bigrams.
    &system ("$locatelib/bigram < $filelist | sort 2>> $errs | uniq -c " .
	     "| sort -nr | awk '{ if (NR <= 128) print \$2 }' " .
	     "| tr -d '\\012' > $bigrams");

    printf STDERR ($my_name, ": Out of sort space\n")
	if -s $errs;

    # Code the file list.
    &system ("$locatelib/code $bigrams < $filelist > $indexfile~");
    &rename ("$indexfile~", $indexfile);
    chmod (0644, $indexfile);

    &cleanup;
}

sub system {
    local ($cmd) = (@_);
    local ($ret);
    print STDERR ("+ $cmd\n");
    $ret = system ($cmd);
    &die (sprintf ("Return 0x%x from \"$cmd\"", $ret))
	unless $ret == 0;
    $ret;
}

sub rename {
    local ($old, $new) = @_;
    print STDERR ("+ rename $old $new\n");
    rename ($old, $new) || &system ("mv $old $new");
}

sub die {
    local ($msg) = (@_);
    warn ($my_name . ": " . $msg . "\n");
    &cleanup;
    exit (1);
}

sub catch {
    print STDERR ("+ Ouch!\n");
    &cleanup;
    exit(1);
}

sub cleanup {
    unlink ($bigrams, $filelist, $errs);
}

sub options {
    require "newgetopt.pl";
    if ( !&NGetOpt ("config=s", "debug", "ident", "trace", "help")
	|| defined $opt_help ) {
	&usage;
    }
    $config_file = $opt_config if defined $opt_config;
}

sub usage {
    require "ms_common.pl";
    print STDERR <<EndOfUsage;
$my_package [$my_name $my_version]

Usage: $my_name [options]

Options:
    -config XX	use alternate config file
    -help	this message
    -trace	show commands
    -ident	show identification
    -debug	for debugging
EndOfUsage
    exit (!defined $opt_help);
}
