/*  ZMAILER extensions */

/*LINTLIBRARY*/

#include "defs.h"
#include "globals.h"
#include "trace.h"
#include "splay.h"
#undef MALLOC_TRACE
#include "../include/listutils.h"

#define MEM_MALLOC 1000

struct conscell *
__s_copy_tree(l, fname, linenum)
struct conscell *l;
const char *fname;
int linenum;
{
	extern int stickymem;
	extern struct conscell *sx_copy_tree();

	if (stickymem == 1000) {
		PRTRACE(sprintf(_malloc_statsbuf, "%s:%d:", fname, linenum));
	}
	l = sx_copy_tree(l);
	if (stickymem == 1000) {
		RECORD_FILE_AND_LINE((char *)l, fname, linenum);
	}
	return(l);
}

/*ARGSUSED*/
void
__s_free_tree(l, fname, linenum)
struct conscell *l;
const char *fname;
int linenum;
{
	PRTRACE(sprintf(_malloc_statsbuf, "%s:%d:", fname, linenum));
	DELETE_RECORD((char *)l);
	sx_free_tree(l);
}

struct spblk *
__sp_install(key, data, mark, q, fname, linenum)
spkey_t key;
unsigned char *data;
int mark;
struct sptree *q;
const char *fname;
int linenum;
{
	extern struct spblk *sp_install(), *sp_lookup();
	register struct spblk *n;
	
	if ((n = sp_lookup(key, q)) == NULL) {
		n = sp_install(key, data, mark, q);
		PRTRACE(sprintf(_malloc_statsbuf, "%s:%d:", fname, linenum));
		RECORD_FILE_AND_LINE((univptr_t)n, fname, linenum);
	}

	n->data = data;
	n->mark = mark;

	return n;
}

char *
__strnsave(s, n, fname, linenum)
char *s;
int n;
const char *fname;
int linenum;
{
	char *cp;
	extern int stickymem;
	extern char *strnsave();
	
	if (stickymem == MEM_MALLOC) {
		PRTRACE(sprintf(_malloc_statsbuf, "%s:%d:", fname, linenum));
	}
	cp = strnsave(s, n);
	if (stickymem == MEM_MALLOC) {
		RECORD_FILE_AND_LINE((univptr_t) cp, fname, linenum);
	}
	return(cp);
}

unsigned int
__symbol(s, fname, linenum)
char *s;
const char *fname;
int linenum;
{
	unsigned int u;
	extern unsigned int symbol();
	
	PRTRACE(sprintf(_malloc_statsbuf, "'%s' %s:%d:", s, fname, linenum));
	u = symbol(s);
	RECORD_FILE_AND_LINE((char *)u, fname, linenum);
	return(u);
}

univptr_t
__tmalloc(nbytes, fname, linenum)
size_t nbytes;
const char *fname;
int linenum;
{
	univptr_t cp;
	extern univptr_t tmalloc();
	extern int stickymem;
	
	if (stickymem == 1000) {
		PRTRACE(sprintf(_malloc_statsbuf, "%s:%d:", fname, linenum));
	}
	cp = tmalloc(nbytes);
	if (stickymem == 1000) {
		RECORD_FILE_AND_LINE(cp, fname, linenum);
	}
	return(cp);
}

univptr_t
__smalloc(nbytes, type, fname, linenum)
size_t nbytes;
int type;
const char *fname;
int linenum;
{
	univptr_t cp;
	extern univptr_t smalloc();
	
	if (type == 1000) {
		PRTRACE(sprintf(_malloc_statsbuf, "%s:%d:", fname, linenum));
	}
	cp = smalloc(nbytes, type);
	if (type == 1000) {
		RECORD_FILE_AND_LINE(cp, fname, linenum);
	}
	return(cp);
}
